/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.management.subsystems;

import java.io.IOException;
import java.util.Collections;
import java.util.Set;
import org.alfresco.repo.management.subsystems.AbstractPropertyBackedBean;
import org.alfresco.repo.management.subsystems.ApplicationContextFactory;
import org.alfresco.repo.management.subsystems.PropertyBackedBeanState;
import org.springframework.context.ApplicationContext;

public class SwitchableApplicationContextFactory
extends AbstractPropertyBackedBean
implements ApplicationContextFactory {
    private static final String SOURCE_BEAN_PROPERTY = "sourceBeanName";
    private String sourceBeanName;

    public void setSourceBeanName(String sourceBeanName) {
        this.sourceBeanName = sourceBeanName;
    }

    public String getCurrentSourceBeanName() {
        return this.getState(false).getProperty(SOURCE_BEAN_PROPERTY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ApplicationContext getApplicationContext() {
        this.lock.readLock().lock();
        try {
            ApplicationContext applicationContext = ((SwitchableState)this.getState(true)).getApplicationContext();
            return applicationContext;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    protected PropertyBackedBeanState createInitialState() throws IOException {
        return new SwitchableState(this.sourceBeanName);
    }

    protected class SwitchableState
    implements PropertyBackedBeanState {
        private ApplicationContextFactory sourceApplicationContextFactory;
        private String sourceBeanName;

        protected SwitchableState(String sourceBeanName) {
            this.sourceBeanName = sourceBeanName;
        }

        @Override
        public void start() {
            if (this.sourceApplicationContextFactory == null) {
                this.sourceApplicationContextFactory = (ApplicationContextFactory)SwitchableApplicationContextFactory.this.getParent().getBean(this.sourceBeanName);
                this.sourceApplicationContextFactory.start();
            }
        }

        @Override
        public void stop() {
            if (this.sourceApplicationContextFactory != null) {
                try {
                    this.sourceApplicationContextFactory.stop();
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            this.sourceApplicationContextFactory = null;
        }

        public ApplicationContext getApplicationContext() {
            if (this.sourceApplicationContextFactory == null) {
                this.start();
            }
            return this.sourceApplicationContextFactory.getApplicationContext();
        }

        @Override
        public String getProperty(String name) {
            if (!name.equals(SwitchableApplicationContextFactory.SOURCE_BEAN_PROPERTY)) {
                return null;
            }
            return this.sourceBeanName;
        }

        @Override
        public Set<String> getPropertyNames() {
            return Collections.singleton(SwitchableApplicationContextFactory.SOURCE_BEAN_PROPERTY);
        }

        @Override
        public void setProperty(String name, String value) {
            if (!name.equals(SwitchableApplicationContextFactory.SOURCE_BEAN_PROPERTY)) {
                throw new IllegalStateException("Illegal attempt to write to property \"" + name + "\"");
            }
            if (!SwitchableApplicationContextFactory.this.getParent().containsBean(value)) {
                throw new IllegalStateException("\"" + value + "\" is not a valid bean name");
            }
            if (this.sourceApplicationContextFactory != null) {
                this.stop();
                this.sourceBeanName = value;
                this.start();
            } else {
                this.sourceBeanName = value;
            }
        }

        @Override
        public void removeProperty(String name) {
            throw new UnsupportedOperationException();
        }
    }
}

