/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.archive;

import java.util.Collections;
import java.util.List;
import org.alfresco.model.ContentModel;
import org.alfresco.query.CannedQuery;
import org.alfresco.query.CannedQueryPageDetails;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.PagingRequest;
import org.alfresco.repo.node.archive.ArchivedNodeEntity;
import org.alfresco.repo.node.archive.GetArchivedNodesCannedQuery;
import org.alfresco.repo.node.archive.GetArchivedNodesCannedQueryParams;
import org.alfresco.repo.query.AbstractQNameAwareCannedQueryFactory;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;

public class GetArchivedNodesCannedQueryFactory
extends AbstractQNameAwareCannedQueryFactory<ArchivedNodeEntity> {
    private AuthorityService authorityService;
    protected NodeService nodeService;

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public CannedQuery<ArchivedNodeEntity> getCannedQuery(CannedQueryParameters parameters) {
        return new GetArchivedNodesCannedQuery(this.cannedQueryDAO, this.nodeDAO, this.methodSecurity, parameters);
    }

    public CannedQuery<ArchivedNodeEntity> getCannedQuery(NodeRef archiveStoreRootNodeRef, String filter, boolean filterIgnoreCase, PagingRequest pagingRequest, boolean sortOrderAscending) {
        ParameterCheck.mandatory((String)"archiveStoreRootNodeRef", (Object)archiveStoreRootNodeRef);
        ParameterCheck.mandatory((String)"pagingRequest", (Object)pagingRequest);
        int requestTotalCountMax = pagingRequest.getRequestTotalCountMax();
        Pair<Long, Long> nodeIdAssocTypeIdPair = this.getNodeIdAssocTypeIdPair(archiveStoreRootNodeRef);
        GetArchivedNodesCannedQueryParams paramBean = new GetArchivedNodesCannedQueryParams((Long)nodeIdAssocTypeIdPair.getFirst(), (Long)nodeIdAssocTypeIdPair.getSecond(), filter, filterIgnoreCase, this.getQNameId(ContentModel.PROP_NAME), (Boolean)sortOrderAscending);
        CannedQueryPageDetails cqpd = new CannedQueryPageDetails(pagingRequest.getSkipCount(), pagingRequest.getMaxItems(), 1, 1);
        CannedQueryParameters params = new CannedQueryParameters((Object)paramBean, cqpd, null, requestTotalCountMax, pagingRequest.getQueryExecutionId());
        return this.getCannedQuery(params);
    }

    private Pair<Long, Long> getNodeIdAssocTypeIdPair(NodeRef archiveStoreRootNodeRef) {
        String userID = AuthenticationUtil.getFullyAuthenticatedUser();
        if (userID == null) {
            throw new AuthenticationException("Failed to authenticate. Current user, ", new Object[]{userID});
        }
        if (archiveStoreRootNodeRef == null || !this.nodeService.exists(archiveStoreRootNodeRef)) {
            throw new InvalidNodeRefException("Invalid archive store root node Ref.", archiveStoreRootNodeRef);
        }
        if (this.authorityService.isAdminAuthority(userID)) {
            return new Pair((Object)this.getNodeId(archiveStoreRootNodeRef), (Object)this.getQNameId(ContentModel.ASSOC_CHILDREN));
        }
        List list = this.nodeService.getChildrenByName(archiveStoreRootNodeRef, ContentModel.ASSOC_ARCHIVE_USER_LINK, Collections.singletonList(userID));
        if (list.isEmpty()) {
            return new Pair((Object)-1L, (Object)-1L);
        }
        NodeRef userArchive = ((ChildAssociationRef)list.get(0)).getChildRef();
        return new Pair((Object)this.getNodeId(userArchive), (Object)this.getQNameId(ContentModel.ASSOC_ARCHIVED_LINK));
    }
}

