/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.node.db;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.ChildAssocEntity;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.node.NodeEntity;
import org.alfresco.repo.domain.node.NodeExistsException;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.node.AbstractNodeServiceImpl;
import org.alfresco.repo.node.StoreArchiveMap;
import org.alfresco.repo.node.archive.NodeArchiveService;
import org.alfresco.repo.node.db.NodeHierarchyWalker;
import org.alfresco.repo.node.index.NodeIndexer;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.repo.transaction.TransactionalResourceHelper;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.AssociationDefinition;
import org.alfresco.service.cmr.dictionary.ChildAssociationDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.InvalidAspectException;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.AssociationExistsException;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.InvalidChildAssociationRefException;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.InvalidStoreRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.PropertyMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.I18NUtil;

public class DbNodeServiceImpl
extends AbstractNodeServiceImpl {
    public static final String KEY_PENDING_DELETE_NODES = "DbNodeServiceImpl.pendingDeleteNodes";
    private static Log logger = LogFactory.getLog(DbNodeServiceImpl.class);
    private QNameDAO qnameDAO;
    private NodeDAO nodeDAO;
    private PermissionService permissionService;
    private StoreArchiveMap storeArchiveMap;
    private NodeService avmNodeService;
    private NodeIndexer nodeIndexer;
    private BehaviourFilter policyBehaviourFilter;
    private boolean enableTimestampPropagation;
    private static List<QName> getChildAssocsByPropertyValueBannedProps = new ArrayList<QName>();
    private static final String KEY_AUDITABLE_PROPAGATION_PRE = "node.auditable.propagation.pre";
    private static final String KEY_AUDITABLE_PROPAGATION_POST = "node.auditable.propagation.post";
    private AuditableTransactionListener auditableTransactionListener = new AuditableTransactionListener();

    public DbNodeServiceImpl() {
        this.storeArchiveMap = new StoreArchiveMap();
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setStoreArchiveMap(StoreArchiveMap storeArchiveMap) {
        this.storeArchiveMap = storeArchiveMap;
    }

    public void setAvmNodeService(NodeService avmNodeService) {
        this.avmNodeService = avmNodeService;
    }

    public void setNodeIndexer(NodeIndexer nodeIndexer) {
        this.nodeIndexer = nodeIndexer;
    }

    public void setPolicyBehaviourFilter(BehaviourFilter policyBehaviourFilter) {
        this.policyBehaviourFilter = policyBehaviourFilter;
    }

    public void setEnableTimestampPropagation(boolean enableTimestampPropagation) {
        this.enableTimestampPropagation = enableTimestampPropagation;
    }

    private Pair<Long, NodeRef> getNodePairNotNull(NodeRef nodeRef) throws InvalidNodeRefException {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        Pair<Long, NodeRef> unchecked = this.nodeDAO.getNodePair(nodeRef);
        if (unchecked == null) {
            NodeRef.Status nodeStatus = this.nodeDAO.getNodeRefStatus(nodeRef);
            throw new InvalidNodeRefException("Node does not exist: " + nodeRef + "(" + nodeStatus + ")", nodeRef);
        }
        return unchecked;
    }

    public boolean exists(StoreRef storeRef) {
        return this.nodeDAO.exists(storeRef);
    }

    public boolean exists(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        return this.nodeDAO.exists(nodeRef);
    }

    public NodeRef.Status getNodeStatus(NodeRef nodeRef) {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        NodeRef.Status status = this.nodeDAO.getNodeRefStatus(nodeRef);
        return status;
    }

    public NodeRef getNodeRef(Long nodeId) {
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(nodeId);
        return nodePair == null ? null : (NodeRef)nodePair.getSecond();
    }

    public List<StoreRef> getStores() {
        List<Pair<Long, StoreRef>> stores = this.nodeDAO.getStores();
        ArrayList<StoreRef> storeRefs = new ArrayList<StoreRef>(50);
        for (Pair<Long, StoreRef> pair : stores) {
            StoreRef storeRef = (StoreRef)pair.getSecond();
            if (storeRef.getProtocol().equals("deleted")) continue;
            storeRefs.add(storeRef);
        }
        List avmStores = this.avmNodeService.getStores();
        storeRefs.addAll(avmStores);
        return storeRefs;
    }

    public StoreRef createStore(String protocol, String identifier) {
        StoreRef storeRef = new StoreRef(protocol, identifier);
        this.invokeBeforeCreateStore(ContentModel.TYPE_STOREROOT, storeRef);
        Pair<Long, NodeRef> rootNodePair = this.nodeDAO.newStore(storeRef);
        NodeRef rootNodeRef = (NodeRef)rootNodePair.getSecond();
        this.invokeOnCreateStore(rootNodeRef);
        ChildAssociationRef assocRef = new ChildAssociationRef(null, null, null, rootNodeRef);
        this.nodeIndexer.indexCreateNode(assocRef);
        return storeRef;
    }

    public void deleteStore(StoreRef storeRef) throws InvalidStoreRefException {
        this.nodeIndexer.indexDeleteStore(storeRef);
        NodeRef rootNodeRef = (NodeRef)this.nodeDAO.getRootNode(storeRef).getSecond();
        List<ChildAssociationRef> childAssocRefs = this.getChildAssocs(rootNodeRef);
        for (ChildAssociationRef childAssocRef : childAssocRefs) {
            NodeRef childNodeRef = childAssocRef.getChildRef();
            this.deleteNode(childNodeRef, false);
        }
        StoreRef deletedStoreRef = new StoreRef("deleted", GUID.generate());
        this.nodeDAO.moveStore(storeRef, deletedStoreRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Marked store for deletion: " + storeRef + " --> " + deletedStoreRef));
        }
    }

    public NodeRef getRootNode(StoreRef storeRef) throws InvalidStoreRefException {
        Pair<Long, NodeRef> rootNodePair = this.nodeDAO.getRootNode(storeRef);
        if (rootNodePair == null) {
            throw new InvalidStoreRefException("Store does not exist: " + storeRef, storeRef);
        }
        return (NodeRef)rootNodePair.getSecond();
    }

    public Set<NodeRef> getAllRootNodes(StoreRef storeRef) {
        return this.nodeDAO.getAllRootNodes(storeRef);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        return this.createNode(parentRef, assocTypeQName, assocQName, nodeTypeQName, null);
    }

    public ChildAssociationRef createNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName, Map<QName, Serializable> properties) {
        this.checkPendingDelete(parentRef);
        ParameterCheck.mandatory((String)"parentRef", (Object)parentRef);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        ParameterCheck.mandatory((String)"assocQName", (Object)assocQName);
        ParameterCheck.mandatory((String)"nodeTypeQName", (Object)nodeTypeQName);
        if (assocQName.getLocalName().length() > 255) {
            throw new IllegalArgumentException("Localname is too long. Length of " + assocQName.getLocalName().length() + " exceeds the maximum of " + 255);
        }
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(parentRef);
        StoreRef parentStoreRef = parentRef.getStoreRef();
        if (properties == null) {
            properties = Collections.emptyMap();
        }
        String newUuid = this.generateGuid(properties);
        this.invokeBeforeCreateNode(parentRef, assocTypeQName, assocQName, nodeTypeQName);
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(nodeTypeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(nodeTypeQName);
        }
        String newName = this.extractNameProperty(properties);
        Locale locale = I18NUtil.getLocale();
        ChildAssocEntity assoc = this.nodeDAO.newNode((Long)parentNodePair.getFirst(), assocTypeQName, assocQName, parentStoreRef, newUuid, nodeTypeQName, locale, newName, properties);
        ChildAssociationRef childAssocRef = assoc.getRef(this.qnameDAO);
        Pair<Long, NodeRef> childNodePair = assoc.getChildNode().getNodePair();
        this.addAspectsAndProperties(childNodePair, nodeTypeQName, null, Collections.emptySet(), Collections.emptyMap(), Collections.emptySet(), properties, true, false);
        Map<QName, Serializable> propertiesAfter = this.nodeDAO.getNodeProperties((Long)childNodePair.getFirst());
        this.propagateTimeStamps(childAssocRef);
        this.invokeOnCreateNode(childAssocRef);
        this.invokeOnCreateChildAssociation(childAssocRef, true);
        Map<QName, Serializable> propertiesBefore = PropertyMap.EMPTY_MAP;
        this.invokeOnUpdateProperties(childAssocRef.getChildRef(), propertiesBefore, propertiesAfter);
        this.nodeIndexer.indexCreateNode(childAssocRef);
        this.addAspectsAndPropertiesAssoc(parentNodePair, assocTypeQName, null, null, null, null, false);
        return childAssocRef;
    }

    private boolean addAspectsAndProperties(Pair<Long, NodeRef> nodePair, QName classQName, Set<QName> existingAspects, Map<QName, Serializable> existingProperties, Set<QName> extraAspects, Map<QName, Serializable> extraProperties, boolean overwriteExistingProperties) {
        return this.addAspectsAndProperties(nodePair, classQName, null, existingAspects, existingProperties, extraAspects, extraProperties, overwriteExistingProperties, true);
    }

    private boolean addAspectsAndPropertiesAssoc(Pair<Long, NodeRef> nodePair, QName assocTypeQName, Set<QName> existingAspects, Map<QName, Serializable> existingProperties, Set<QName> extraAspects, Map<QName, Serializable> extraProperties, boolean overwriteExistingProperties) {
        return this.addAspectsAndProperties(nodePair, null, assocTypeQName, existingAspects, existingProperties, extraAspects, extraProperties, overwriteExistingProperties, true);
    }

    private boolean addAspectsAndProperties(Pair<Long, NodeRef> nodePair, QName classQName, QName assocTypeQName, Set<QName> existingAspects, Map<QName, Serializable> existingProperties, Set<QName> extraAspects, Map<QName, Serializable> extraProperties, boolean overwriteExistingProperties, boolean invokeOnUpdateProperties) {
        boolean changedAspects;
        ParameterCheck.mandatory((String)"nodePair", nodePair);
        Long nodeId = (Long)nodePair.getFirst();
        NodeRef nodeRef = (NodeRef)nodePair.getSecond();
        if (classQName == null) {
            classQName = ContentModel.TYPE_BASE;
        }
        if (extraAspects == null) {
            extraAspects = Collections.emptySet();
        }
        if (extraProperties == null) {
            extraProperties = Collections.emptyMap();
        }
        if (existingAspects == null) {
            existingAspects = this.nodeDAO.getNodeAspects(nodeId);
        }
        if (existingProperties == null) {
            existingProperties = this.nodeDAO.getNodeProperties(nodeId);
        }
        HashMap<QName, Serializable> allProperties = new HashMap<QName, Serializable>(37);
        allProperties.putAll(existingProperties);
        allProperties.putAll(extraProperties);
        existingAspects = new HashSet<QName>(existingAspects);
        Set<QName> missingAspects = this.getMissingAspects(existingAspects, allProperties, classQName);
        missingAspects.addAll(extraAspects);
        if (assocTypeQName != null) {
            missingAspects.addAll(this.getMissingAspectsAssoc(existingAspects, allProperties, assocTypeQName));
        }
        for (QName missingAspect : missingAspects) {
            this.invokeBeforeAddAspect(nodeRef, missingAspect);
        }
        HashSet<QName> allClassQNames = new HashSet<QName>(13);
        allClassQNames.add(classQName);
        allClassQNames.addAll(missingAspects);
        Map<QName, Serializable> missingProperties = this.getMissingProperties(existingProperties, allClassQNames);
        missingProperties.putAll(extraProperties);
        boolean changedProperties = false;
        changedProperties = overwriteExistingProperties ? this.nodeDAO.setNodeProperties(nodeId, missingProperties) : this.nodeDAO.addNodeProperties(nodeId, missingProperties);
        if (changedProperties && invokeOnUpdateProperties) {
            Map<QName, Serializable> propertiesAfter = this.nodeDAO.getNodeProperties(nodeId);
            this.invokeOnUpdateProperties(nodeRef, existingProperties, propertiesAfter);
        }
        if (changedAspects = this.nodeDAO.addNodeAspects(nodeId, missingAspects)) {
            for (QName missingAspect : missingAspects) {
                this.invokeOnAddAspect(nodeRef, missingAspect);
            }
        }
        return changedAspects || changedProperties;
    }

    private Set<QName> getMissingAspectsAssoc(Set<QName> existingAspects, Map<QName, Serializable> existingProperties, QName assocTypeQName) {
        AssociationDefinition assocDef = this.dictionaryService.getAssociation(assocTypeQName);
        if (assocDef == null) {
            return Collections.emptySet();
        }
        ClassDefinition classDefinition = assocDef.getSourceClass();
        return this.getMissingAspects(existingAspects, existingProperties, classDefinition.getName());
    }

    private Set<QName> getMissingAspects(Set<QName> existingAspects, Map<QName, Serializable> existingProperties, QName classQName) {
        existingAspects = new HashSet<QName>(existingAspects);
        ClassDefinition classDefinition = this.dictionaryService.getClass(classQName);
        if (classDefinition == null) {
            return Collections.emptySet();
        }
        HashSet<QName> missingAspects = new HashSet<QName>(7);
        if (classDefinition.isAspect() && !existingAspects.contains(classQName)) {
            missingAspects.add(classQName);
        }
        List defaultAspectDefs = classDefinition.getDefaultAspects();
        for (AspectDefinition defaultAspectDef : defaultAspectDefs) {
            QName defaultAspect = defaultAspectDef.getName();
            if (existingAspects.contains(defaultAspect)) continue;
            missingAspects.add(defaultAspect);
        }
        for (QName existingPropQName : existingProperties.keySet()) {
            QName existingPropDefiningType;
            PropertyDefinition existingPropDef = this.dictionaryService.getProperty(existingPropQName);
            if (existingPropDef == null || !existingPropDef.getContainerClass().isAspect() || existingAspects.contains(existingPropDefiningType = existingPropDef.getContainerClass().getName())) continue;
            missingAspects.add(existingPropDefiningType);
        }
        HashSet<QName> allTypesAndAspects = new HashSet<QName>(13);
        allTypesAndAspects.add(classQName);
        allTypesAndAspects.addAll(existingAspects);
        allTypesAndAspects.addAll(missingAspects);
        HashSet missingAspectsCopy = new HashSet(missingAspects);
        for (QName missingAspect : missingAspectsCopy) {
            Set<QName> furtherMissingAspects = this.getMissingAspects(allTypesAndAspects, Collections.emptyMap(), missingAspect);
            missingAspects.addAll(furtherMissingAspects);
            allTypesAndAspects.addAll(furtherMissingAspects);
        }
        return missingAspects;
    }

    private Map<QName, Serializable> getMissingProperties(Map<QName, Serializable> existingProperties, Set<QName> classQNames) {
        HashMap<QName, Serializable> allDefaultProperties = new HashMap<QName, Serializable>(17);
        for (QName classQName : classQNames) {
            Map<QName, Serializable> defaultProperties;
            ClassDefinition classDefinition = this.dictionaryService.getClass(classQName);
            if (classDefinition == null || (defaultProperties = this.getDefaultProperties(classQName)).size() <= 0) continue;
            allDefaultProperties.putAll(defaultProperties);
        }
        HashMap<QName, Serializable> missingProperties = new HashMap<QName, Serializable>(allDefaultProperties);
        missingProperties.keySet().removeAll(existingProperties.keySet());
        return missingProperties;
    }

    public void setChildAssociationIndex(ChildAssociationRef childAssocRef, int index) {
        QName assocQName;
        QName assocTypeQName;
        Long childNodeId;
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(childAssocRef.getParentRef());
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childAssocRef.getChildRef());
        Long parentNodeId = (Long)parentNodePair.getFirst();
        int updated = this.nodeDAO.setChildAssocIndex(parentNodeId, childNodeId = (Long)childNodePair.getFirst(), assocTypeQName = childAssocRef.getTypeQName(), assocQName = childAssocRef.getQName(), index);
        if (updated < 1) {
            throw new InvalidChildAssociationRefException("Unable to set child association index: \n   assoc: " + childAssocRef + "\n" + "   index: " + index, childAssocRef);
        }
    }

    public QName getType(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.getNodeType((Long)nodePair.getFirst());
    }

    public void setType(NodeRef nodeRef, QName typeQName) throws InvalidNodeRefException {
        this.checkPendingDelete(nodeRef);
        TypeDefinition nodeTypeDef = this.dictionaryService.getType(typeQName);
        if (nodeTypeDef == null) {
            throw new InvalidTypeException(typeQName);
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        QName oldType = this.nodeDAO.getNodeType((Long)nodePair.getFirst());
        this.invokeBeforeSetType(nodeRef, oldType, typeQName);
        boolean updatedNode = this.nodeDAO.updateNode((Long)nodePair.getFirst(), typeQName, null);
        boolean updatedProps = this.addAspectsAndProperties(nodePair, typeQName, null, null, null, null, false);
        if (updatedNode || updatedProps) {
            this.invokeOnUpdateNode(nodeRef);
            this.invokeOnSetType(nodeRef, oldType, typeQName);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void addAspect(NodeRef nodeRef, QName aspectTypeQName, Map<QName, Serializable> aspectProperties) throws InvalidNodeRefException, InvalidAspectException {
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        if (aspectDef == null) {
            throw new InvalidAspectException("The aspect is invalid: " + aspectTypeQName, aspectTypeQName);
        }
        if (aspectTypeQName.equals((Object)ContentModel.ASPECT_PENDING_DELETE)) {
            throw new IllegalArgumentException("The aspect is reserved for system use: " + aspectTypeQName);
        }
        if (aspectProperties == null) {
            aspectProperties = Collections.emptyMap();
        }
        aspectProperties = Collections.unmodifiableMap(aspectProperties);
        this.invokeBeforeUpdateNode(nodeRef);
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        boolean modified = this.addAspectsAndProperties(nodePair, aspectTypeQName, null, null, Collections.singleton(aspectTypeQName), aspectProperties, false);
        if (modified) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public int countChildAssocs(NodeRef nodeRef, boolean isPrimary) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        return this.nodeDAO.countChildAssocsByParent(nodeId, isPrimary);
    }

    public void removeAspect(NodeRef nodeRef, QName aspectTypeQName) throws InvalidNodeRefException, InvalidAspectException {
        if (aspectTypeQName.equals((Object)ContentModel.ASPECT_PENDING_DELETE)) {
            throw new IllegalArgumentException("The aspect is reserved for system use: " + aspectTypeQName);
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        boolean hadAspect = this.nodeDAO.hasNodeAspect(nodeId, aspectTypeQName);
        this.invokeBeforeUpdateNode(nodeRef);
        if (hadAspect) {
            this.invokeBeforeRemoveAspect(nodeRef, aspectTypeQName);
            this.nodeDAO.removeNodeAspects(nodeId, Collections.singleton(aspectTypeQName));
        }
        AspectDefinition aspectDef = this.dictionaryService.getAspect(aspectTypeQName);
        boolean updated = false;
        if (aspectDef != null) {
            Map propertyDefs = aspectDef.getProperties();
            Set<QName> propertyToRemoveQNames = propertyDefs.keySet();
            this.nodeDAO.removeNodeProperties(nodeId, propertyToRemoveQNames);
            final ArrayList assocsToDelete = new ArrayList(5);
            final ArrayList nodesToDelete = new ArrayList(5);
            NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

                @Override
                public boolean preLoadNodes() {
                    return true;
                }

                @Override
                public boolean orderResults() {
                    return false;
                }

                @Override
                public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                    if (DbNodeServiceImpl.this.isPendingDelete((NodeRef)parentNodePair.getSecond()) || DbNodeServiceImpl.this.isPendingDelete((NodeRef)childNodePair.getSecond())) {
                        if (logger.isTraceEnabled()) {
                            logger.trace((Object)("Aspect-triggered association removal: Ignoring child associations where one of the nodes is pending delete: " + childAssocPair));
                        }
                        return true;
                    }
                    if (((ChildAssociationRef)childAssocPair.getSecond()).isPrimary()) {
                        nodesToDelete.add(childNodePair);
                    } else {
                        assocsToDelete.add(childAssocPair);
                    }
                    return true;
                }

                @Override
                public void done() {
                }
            };
            HashSet<QName> assocTypeQNamesToRemove = new HashSet<QName>(aspectDef.getChildAssociations().keySet());
            this.nodeDAO.getChildAssocs(nodeId, assocTypeQNamesToRemove, callback);
            for (Pair assocPair : assocsToDelete) {
                updated = true;
                Long assocId = (Long)assocPair.getFirst();
                ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
                this.invokeBeforeDeleteChildAssociation(assocRef);
                this.nodeDAO.deleteChildAssoc(assocId);
                this.invokeOnDeleteChildAssociation(assocRef);
            }
            for (Pair childNodePair : nodesToDelete) {
                NodeRef childNodeRef = (NodeRef)childNodePair.getSecond();
                this.deleteNode(childNodeRef);
            }
            Map nodeAssocDefs = aspectDef.getAssociations();
            ArrayList<Long> nodeAssocIdsToRemove = new ArrayList<Long>(13);
            ArrayList<Object> assocRefsRemoved = new ArrayList<Object>(13);
            for (Map.Entry entry : nodeAssocDefs.entrySet()) {
                if (this.isPendingDelete(nodeRef)) {
                    if (!logger.isTraceEnabled()) continue;
                    logger.trace((Object)("Aspect-triggered association removal: Ignoring peer associations where one of the nodes is pending delete: " + nodeRef));
                    continue;
                }
                if (((AssociationDefinition)entry.getValue()).isChild()) continue;
                QName qName = (QName)entry.getKey();
                Collection<Pair<Long, AssociationRef>> targetAssocRefs = this.nodeDAO.getTargetNodeAssocs(nodeId, qName);
                for (Pair<Long, AssociationRef> assocPair : targetAssocRefs) {
                    if (this.isPendingDelete(((AssociationRef)assocPair.getSecond()).getTargetRef())) {
                        if (!logger.isTraceEnabled()) continue;
                        logger.trace((Object)("Aspect-triggered association removal: Ignoring peer associations where one of the nodes is pending delete: " + assocPair));
                        continue;
                    }
                    nodeAssocIdsToRemove.add((Long)assocPair.getFirst());
                    assocRefsRemoved.add(assocPair.getSecond());
                }
            }
            int assocsDeleted = this.nodeDAO.removeNodeAssocs(nodeAssocIdsToRemove);
            for (AssociationRef associationRef : assocRefsRemoved) {
                this.invokeOnDeleteAssociation(associationRef);
            }
            boolean bl = updated = updated || assocsDeleted > 0;
        }
        if (updated) {
            this.invokeOnUpdateNode(nodeRef);
        }
        if (hadAspect) {
            this.invokeOnRemoveAspect(nodeRef, aspectTypeQName);
        }
        this.nodeIndexer.indexUpdateNode(nodeRef);
    }

    public boolean hasAspect(NodeRef nodeRef, QName aspectQName) throws InvalidNodeRefException, InvalidAspectException {
        if (aspectQName.equals((Object)ContentModel.ASPECT_PENDING_DELETE)) {
            return this.isPendingDelete(nodeRef);
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.hasNodeAspect((Long)nodePair.getFirst(), aspectQName);
    }

    public Set<QName> getAspects(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Set<QName> aspectQNames = this.nodeDAO.getNodeAspects((Long)nodePair.getFirst());
        if (this.isPendingDelete(nodeRef)) {
            aspectQNames.add(ContentModel.ASPECT_PENDING_DELETE);
        }
        return aspectQNames;
    }

    private boolean isPendingDelete(NodeRef nodeRef) {
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            return false;
        }
        Set nodesPendingDelete = TransactionalResourceHelper.getSet(KEY_PENDING_DELETE_NODES);
        return nodesPendingDelete.contains(nodeRef);
    }

    private void checkPendingDelete(NodeRef nodeRef) {
        if (this.isPendingDelete(nodeRef)) {
            throw new IllegalStateException("Operation not allowed against node pending deletion.  Check the node for aspect " + ContentModel.ASPECT_PENDING_DELETE);
        }
    }

    public void deleteNode(NodeRef nodeRef) {
        this.deleteNode(nodeRef, true);
    }

    private void deleteNode(NodeRef nodeRef, boolean allowArchival) {
        this.checkPendingDelete(nodeRef);
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Boolean requiresDelete = null;
        QName nodeTypeQName = this.nodeDAO.getNodeType(nodeId);
        Set<QName> nodeAspectQNames = this.nodeDAO.getNodeAspects(nodeId);
        if (nodeTypeQName.equals((Object)ContentModel.TYPE_STOREROOT)) {
            throw new IllegalArgumentException("A store root node cannot be deleted: " + nodeRef);
        }
        Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
        ChildAssociationRef childAssocRef = (ChildAssociationRef)childAssocPair.getSecond();
        StoreRef storeRef = nodeRef.getStoreRef();
        StoreRef archiveStoreRef = this.storeArchiveMap.get(storeRef);
        NodeHierarchyWalker walker = new NodeHierarchyWalker(this.nodeDAO);
        walker.walkHierarchy(nodePair, childAssocPair);
        HashSet<NodeRef> nodesPendingDelete = new HashSet<NodeRef>(walker.getNodes(false).size());
        for (NodeHierarchyWalker.VisitedNode visitedNode : walker.getNodes(true)) {
            nodesPendingDelete.add(visitedNode.nodeRef);
        }
        Set nodesPendingDeleteTxn = TransactionalResourceHelper.getSet(KEY_PENDING_DELETE_NODES);
        nodesPendingDeleteTxn.addAll(nodesPendingDelete);
        if (!allowArchival) {
            requiresDelete = true;
        } else if (archiveStoreRef == null) {
            requiresDelete = true;
        } else {
            Boolean requiresArchive;
            TypeDefinition typeDef = this.dictionaryService.getType(nodeTypeQName);
            if (typeDef != null && (requiresArchive = typeDef.getArchive()) != null) {
                requiresDelete = requiresArchive == false;
            }
            Iterator<QName> i = nodeAspectQNames.iterator();
            while ((requiresDelete == null || !requiresDelete.booleanValue()) && i.hasNext()) {
                Boolean requiresArchive2;
                QName nodeAspectQName = i.next();
                AspectDefinition aspectDef = this.dictionaryService.getAspect(nodeAspectQName);
                if (aspectDef == null || (requiresArchive2 = aspectDef.getArchive()) == null) continue;
                requiresDelete = requiresArchive2 == false;
            }
        }
        this.propagateTimeStamps(childAssocRef);
        boolean archive = requiresDelete != null && requiresDelete == false;
        HashSet<Object> childAssocIds = new HashSet<Object>(23);
        HashSet<Object> peerAssocIds = new HashSet<Object>(23);
        List<NodeHierarchyWalker.VisitedNode> nodesToDelete = walker.getNodes(true);
        for (NodeHierarchyWalker.VisitedNode nodeToDelete : nodesToDelete) {
            for (Pair<Long, AssociationRef> pair : nodeToDelete.targetAssocs) {
                if (!peerAssocIds.add(pair.getFirst())) continue;
                this.invokeBeforeDeleteAssociation((AssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.sourceAssocs) {
                if (!peerAssocIds.add(pair.getFirst())) continue;
                this.invokeBeforeDeleteAssociation((AssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.secondaryChildAssocs) {
                if (!childAssocIds.add(pair.getFirst())) continue;
                this.invokeBeforeDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.secondaryParentAssocs) {
                if (!childAssocIds.add(pair.getFirst())) continue;
                this.invokeBeforeDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
            }
            if (archive) {
                this.invokeBeforeArchiveNode(nodeToDelete.nodeRef);
            }
            this.invokeBeforeDeleteNode(nodeToDelete.nodeRef);
        }
        if (archive) {
            this.archiveHierarchy(walker, archiveStoreRef);
        }
        childAssocIds.clear();
        peerAssocIds.clear();
        for (NodeHierarchyWalker.VisitedNode nodeToDelete : nodesToDelete) {
            for (Pair<Long, AssociationRef> pair : nodeToDelete.targetAssocs) {
                if (!peerAssocIds.add(pair.getFirst())) continue;
                this.nodeDAO.removeNodeAssocs(Collections.singletonList(pair.getFirst()));
                this.invokeOnDeleteAssociation((AssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.sourceAssocs) {
                if (!peerAssocIds.add(pair.getFirst())) continue;
                this.nodeDAO.removeNodeAssocs(Collections.singletonList(pair.getFirst()));
                this.invokeOnDeleteAssociation((AssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.secondaryChildAssocs) {
                if (!childAssocIds.add(pair.getFirst())) continue;
                this.nodeDAO.deleteChildAssoc((Long)pair.getFirst());
                this.invokeOnDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
                this.nodeIndexer.indexDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
            }
            for (Pair<Long, AssociationRef> pair : nodeToDelete.secondaryParentAssocs) {
                if (!childAssocIds.add(pair.getFirst())) continue;
                this.nodeDAO.deleteChildAssoc((Long)pair.getFirst());
                this.invokeOnDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
                this.nodeIndexer.indexDeleteChildAssociation((ChildAssociationRef)pair.getSecond());
            }
            QName childNodeTypeQName = this.nodeDAO.getNodeType(nodeToDelete.id);
            Set<QName> set = this.nodeDAO.getNodeAspects(nodeToDelete.id);
            this.nodeDAO.deleteChildAssoc((Long)nodeToDelete.primaryParentAssocPair.getFirst());
            this.nodeDAO.deleteNode(nodeToDelete.id);
            this.invokeOnDeleteNode((ChildAssociationRef)nodeToDelete.primaryParentAssocPair.getSecond(), childNodeTypeQName, set, archive);
            this.nodeIndexer.indexDeleteNode(childAssocRef);
        }
        nodesPendingDeleteTxn = TransactionalResourceHelper.getSet(KEY_PENDING_DELETE_NODES);
        nodesPendingDeleteTxn.removeAll(nodesPendingDelete);
    }

    public ChildAssociationRef addChild(NodeRef parentRef, NodeRef childRef, QName assocTypeQName, QName assocQName) {
        return this.addChild(Collections.singletonList(parentRef), childRef, assocTypeQName, assocQName).get(0);
    }

    public List<ChildAssociationRef> addChild(Collection<NodeRef> parentRefs, NodeRef childRef, QName assocTypeQName, QName assocQName) {
        this.checkPendingDelete(childRef);
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childRef);
        Long childNodeId = (Long)childNodePair.getFirst();
        Map<QName, Serializable> childNodeProperties = this.nodeDAO.getNodeProperties((Long)childNodePair.getFirst());
        String childNodeName = this.extractNameProperty(childNodeProperties);
        if (childNodeName == null) {
            childNodeName = childRef.getId();
        }
        ArrayList<ChildAssociationRef> childAssociationRefs = new ArrayList<ChildAssociationRef>(parentRefs.size());
        ArrayList<Pair<Long, NodeRef>> parentNodePairs = new ArrayList<Pair<Long, NodeRef>>(parentRefs.size());
        for (NodeRef nodeRef : parentRefs) {
            this.checkPendingDelete(nodeRef);
            Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(nodeRef);
            Long parentNodeId = (Long)parentNodePair.getFirst();
            parentNodePairs.add(parentNodePair);
            Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.newChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName, childNodeName);
            childAssociationRefs.add((ChildAssociationRef)childAssocPair.getSecond());
        }
        this.nodeDAO.cycleCheck(childNodeId);
        for (ChildAssociationRef childAssociationRef : childAssociationRefs) {
            this.invokeOnCreateChildAssociation(childAssociationRef, false);
        }
        for (Pair pair : parentNodePairs) {
            this.addAspectsAndPropertiesAssoc((Pair<Long, NodeRef>)pair, assocTypeQName, null, null, null, null, false);
        }
        for (ChildAssociationRef childAssociationRef : childAssociationRefs) {
            this.nodeIndexer.indexCreateChildAssociation(childAssociationRef);
        }
        return childAssociationRefs;
    }

    public void removeChild(NodeRef parentRef, NodeRef childRef) throws InvalidNodeRefException {
        NodeRef primaryParentNodeRef;
        this.checkPendingDelete(parentRef);
        this.checkPendingDelete(childRef);
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(parentRef);
        Long parentNodeId = (Long)parentNodePair.getFirst();
        Pair<Long, NodeRef> childNodePair = this.getNodePairNotNull(childRef);
        final Long childNodeId = (Long)childNodePair.getFirst();
        Pair<Long, ChildAssociationRef> primaryChildAssocPair = this.nodeDAO.getPrimaryParentAssoc(childNodeId);
        if (primaryChildAssocPair != null && (primaryParentNodeRef = ((ChildAssociationRef)primaryChildAssocPair.getSecond()).getParentRef()).equals((Object)parentRef)) {
            this.deleteNode(childRef);
            return;
        }
        final ArrayList assocsToDelete = new ArrayList(5);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (!((Long)childNodePair.getFirst()).equals(childNodeId)) {
                    return false;
                }
                assocsToDelete.add(childAssocPair);
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(parentNodeId, childNodeId, null, null, null, null, callback);
        for (Pair assocPair : assocsToDelete) {
            Long assocId = (Long)assocPair.getFirst();
            ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
            this.invokeBeforeDeleteChildAssociation(assocRef);
            this.nodeDAO.deleteChildAssoc(assocId);
            this.invokeOnDeleteChildAssociation(assocRef);
            this.nodeIndexer.indexDeleteChildAssociation(assocRef);
        }
    }

    public boolean removeChildAssociation(ChildAssociationRef childAssocRef) {
        this.checkPendingDelete(childAssocRef.getParentRef());
        this.checkPendingDelete(childAssocRef.getChildRef());
        Long parentNodeId = (Long)this.getNodePairNotNull(childAssocRef.getParentRef()).getFirst();
        Long childNodeId = (Long)this.getNodePairNotNull(childAssocRef.getChildRef()).getFirst();
        QName assocTypeQName = childAssocRef.getTypeQName();
        QName assocQName = childAssocRef.getQName();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName);
        if (assocPair == null) {
            return false;
        }
        Long assocId = (Long)assocPair.getFirst();
        ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
        if (assocRef.isPrimary()) {
            NodeRef childNodeRef = assocRef.getChildRef();
            this.deleteNode(childNodeRef);
            return true;
        }
        this.invokeBeforeDeleteChildAssociation(childAssocRef);
        this.nodeDAO.deleteChildAssoc(assocId);
        this.invokeOnDeleteChildAssociation(childAssocRef);
        this.nodeIndexer.indexDeleteChildAssociation(childAssocRef);
        return true;
    }

    public boolean removeSecondaryChildAssociation(ChildAssociationRef childAssocRef) {
        this.checkPendingDelete(childAssocRef.getParentRef());
        this.checkPendingDelete(childAssocRef.getChildRef());
        Long parentNodeId = (Long)this.getNodePairNotNull(childAssocRef.getParentRef()).getFirst();
        Long childNodeId = (Long)this.getNodePairNotNull(childAssocRef.getChildRef()).getFirst();
        QName assocTypeQName = childAssocRef.getTypeQName();
        QName assocQName = childAssocRef.getQName();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getChildAssoc(parentNodeId, childNodeId, assocTypeQName, assocQName);
        if (assocPair == null) {
            return false;
        }
        Long assocId = (Long)assocPair.getFirst();
        ChildAssociationRef assocRef = (ChildAssociationRef)assocPair.getSecond();
        if (assocRef.isPrimary()) {
            throw new IllegalArgumentException("removeSeconaryChildAssociation can not be applied to a primary association: \n   Child Assoc: " + assocRef);
        }
        this.nodeDAO.deleteChildAssoc(assocId);
        this.invokeOnDeleteChildAssociation(childAssocRef);
        this.nodeIndexer.indexDeleteChildAssociation(childAssocRef);
        return true;
    }

    public Serializable getProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Long nodeId = (Long)this.getNodePairNotNull(nodeRef).getFirst();
        if (qname.equals((Object)ContentModel.PROP_STORE_PROTOCOL)) {
            return nodeRef.getStoreRef().getProtocol();
        }
        if (qname.equals((Object)ContentModel.PROP_STORE_IDENTIFIER)) {
            return nodeRef.getStoreRef().getIdentifier();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_UUID)) {
            return nodeRef.getId();
        }
        if (qname.equals((Object)ContentModel.PROP_NODE_DBID)) {
            return nodeId;
        }
        Serializable property = this.nodeDAO.getNodeProperty(nodeId, qname);
        if (property == null && qname.equals((Object)ContentModel.PROP_NAME)) {
            return nodeRef.getId();
        }
        return property;
    }

    public Map<QName, Serializable> getProperties(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.getPropertiesImpl(nodePair);
    }

    private Map<QName, Serializable> getPropertiesImpl(Pair<Long, NodeRef> nodePair) throws InvalidNodeRefException {
        Long nodeId = (Long)nodePair.getFirst();
        Map<QName, Serializable> nodeProperties = this.nodeDAO.getNodeProperties(nodeId);
        return nodeProperties;
    }

    public Long getNodeAclId(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.getAclIDImpl(nodePair);
    }

    private Long getAclIDImpl(Pair<Long, NodeRef> nodePair) throws InvalidNodeRefException {
        Long nodeId = (Long)nodePair.getFirst();
        Long aclID = this.nodeDAO.getNodeAclId(nodeId);
        return aclID;
    }

    private boolean setPropertiesCommonWork(Pair<Long, NodeRef> nodePair, Map<QName, Serializable> properties) {
        Long nodeId = (Long)nodePair.getFirst();
        boolean changed = false;
        if (properties.containsKey(ContentModel.PROP_NAME)) {
            String name = this.extractNameProperty(properties);
            Pair<Long, ChildAssociationRef> primaryParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
            if (primaryParentAssocPair != null) {
                String oldName = this.extractNameProperty(this.nodeDAO.getNodeProperties(nodeId));
                String newName = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)name);
                changed = this.setChildNameUnique(nodePair, newName, oldName);
            }
        }
        return changed;
    }

    public void setProperty(NodeRef nodeRef, QName qname, Serializable value) throws InvalidNodeRefException {
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"qname", (Object)qname);
        if (qname.equals((Object)ContentModel.PROP_NODE_UUID)) {
            throw new IllegalArgumentException("The node UUID cannot be changed.");
        }
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, Collections.singletonMap(qname, value));
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, Collections.singletonMap(qname, value), false);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void setProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, properties);
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, properties, true);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void addProperties(NodeRef nodeRef, Map<QName, Serializable> properties) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        this.invokeBeforeUpdateNode(nodeRef);
        this.setPropertiesCommonWork(nodePair, properties);
        boolean changed = this.addAspectsAndProperties(nodePair, null, null, null, null, properties, false);
        if (changed) {
            this.invokeOnUpdateNode(nodeRef);
            this.nodeIndexer.indexUpdateNode(nodeRef);
        }
    }

    public void removeProperty(NodeRef nodeRef, QName qname) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        this.invokeBeforeUpdateNode(nodeRef);
        Map<QName, Serializable> propertiesBefore = this.getPropertiesImpl(nodePair);
        if (qname.equals((Object)ContentModel.PROP_NAME)) {
            String oldName = this.extractNameProperty(this.nodeDAO.getNodeProperties(nodeId));
            String newName = null;
            this.setChildNameUnique(nodePair, newName, oldName);
        }
        this.nodeDAO.removeNodeProperties(nodeId, Collections.singleton(qname));
        Map<QName, Serializable> propertiesAfter = this.getPropertiesImpl(nodePair);
        this.invokeOnUpdateNode(nodeRef);
        this.invokeOnUpdateProperties(nodeRef, propertiesBefore, propertiesAfter);
        this.nodeIndexer.indexUpdateNode(nodeRef);
    }

    public Collection<NodeRef> getParents(NodeRef nodeRef) throws InvalidNodeRefException {
        List<ChildAssociationRef> parentAssocs = this.getParentAssocs(nodeRef, RegexQNamePattern.MATCH_ALL, RegexQNamePattern.MATCH_ALL);
        HashSet<NodeRef> parentNodeRefs = new HashSet<NodeRef>(parentAssocs.size());
        for (ChildAssociationRef parentAssoc : parentAssocs) {
            NodeRef parentNodeRef = parentAssoc.getParentRef();
            parentNodeRefs.add(parentNodeRef);
        }
        return new ArrayList<NodeRef>(parentNodeRefs);
    }

    public List<ChildAssociationRef> getParentAssocs(NodeRef nodeRef, final QNamePattern typeQNamePattern, final QNamePattern qnamePattern) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (!typeQNamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getTypeQName())) {
                    return true;
                }
                if (!qnamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getQName())) {
                    return true;
                }
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        QName typeQName = typeQNamePattern instanceof QName ? (QName)typeQNamePattern : null;
        QName qname = qnamePattern instanceof QName ? (QName)qnamePattern : null;
        this.nodeDAO.getParentAssocs(nodeId, typeQName, qname, null, callback);
        return results;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern) {
        return this.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, true);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, QNamePattern typeQNamePattern, QNamePattern qnamePattern, boolean preload) {
        return this.getChildAssocs(nodeRef, typeQNamePattern, qnamePattern, Integer.MAX_VALUE, preload);
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, final QNamePattern typeQNamePattern, final QNamePattern qnamePattern, int maxResults, final boolean preload) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return preload;
            }

            @Override
            public boolean orderResults() {
                return true;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                if (typeQNamePattern != null && !typeQNamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getTypeQName())) {
                    return true;
                }
                if (qnamePattern != null && !qnamePattern.isMatch(((ChildAssociationRef)childAssocPair.getSecond()).getQName())) {
                    return true;
                }
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        QName typeQName = typeQNamePattern instanceof QName ? (QName)typeQNamePattern : null;
        QName qname = qnamePattern instanceof QName ? (QName)qnamePattern : null;
        this.nodeDAO.getChildAssocs((Long)nodePair.getFirst(), typeQName, qname, maxResults, callback);
        return results;
    }

    public List<ChildAssociationRef> getChildAssocs(NodeRef nodeRef, Set<QName> childNodeTypeQNames) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public boolean orderResults() {
                return true;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsByChildTypes(nodeId, childNodeTypeQNames, callback);
        return results;
    }

    public NodeRef getChildByName(NodeRef nodeRef, QName assocTypeQName, String childName) {
        ParameterCheck.mandatory((String)"childName", (Object)childName);
        ParameterCheck.mandatory((String)"nodeRef", (Object)nodeRef);
        ParameterCheck.mandatory((String)"assocTypeQName", (Object)assocTypeQName);
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Pair<Long, ChildAssociationRef> childAssocPair = this.nodeDAO.getChildAssoc(nodeId, assocTypeQName, childName);
        if (childAssocPair != null) {
            return ((ChildAssociationRef)childAssocPair.getSecond()).getChildRef();
        }
        return null;
    }

    public List<ChildAssociationRef> getChildrenByName(NodeRef nodeRef, QName assocTypeQName, Collection<String> childNames) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public boolean orderResults() {
                return true;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, assocTypeQName, childNames, callback);
        return results;
    }

    public ChildAssociationRef getPrimaryParent(NodeRef nodeRef) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        Pair<Long, ChildAssociationRef> assocPair = this.nodeDAO.getPrimaryParentAssoc(nodeId);
        ChildAssociationRef assocRef = null;
        assocRef = assocPair == null ? new ChildAssociationRef(null, null, null, nodeRef) : (ChildAssociationRef)assocPair.getSecond();
        return assocRef;
    }

    public AssociationRef createAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException, AssociationExistsException {
        this.checkPendingDelete(sourceRef);
        this.checkPendingDelete(targetRef);
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        long sourceNodeId = (Long)sourceNodePair.getFirst();
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        long targetNodeId = (Long)targetNodePair.getFirst();
        Long assocId = this.nodeDAO.newNodeAssoc(sourceNodeId, targetNodeId, assocTypeQName, -1);
        AssociationRef assocRef = new AssociationRef(assocId, sourceRef, assocTypeQName, targetRef);
        this.invokeOnCreateAssociation(assocRef);
        this.addAspectsAndPropertiesAssoc(sourceNodePair, assocTypeQName, null, null, null, null, false);
        return assocRef;
    }

    public void setAssociations(NodeRef sourceRef, QName assocTypeQName, List<NodeRef> targetRefs) {
        this.checkPendingDelete(sourceRef);
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        Long sourceNodeId = (Long)sourceNodePair.getFirst();
        Collection<Pair<Long, AssociationRef>> assocsBefore = this.nodeDAO.getTargetNodeAssocs(sourceNodeId, assocTypeQName);
        HashMap<NodeRef, Long> targetRefsBefore = new HashMap<NodeRef, Long>(assocsBefore.size());
        HashMap<NodeRef, Long> toRemoveMap = new HashMap<NodeRef, Long>(assocsBefore.size());
        for (Pair<Long, AssociationRef> assocBeforePair : assocsBefore) {
            Long id = (Long)assocBeforePair.getFirst();
            NodeRef nodeRef = ((AssociationRef)assocBeforePair.getSecond()).getTargetRef();
            targetRefsBefore.put(nodeRef, id);
            toRemoveMap.put(nodeRef, id);
        }
        toRemoveMap.keySet().removeAll(targetRefs);
        for (NodeRef targetRef : toRemoveMap.keySet()) {
            AssociationRef assocRef = new AssociationRef(sourceRef, assocTypeQName, targetRef);
            this.invokeBeforeDeleteAssociation(assocRef);
        }
        ArrayList<Long> toRemoveIds = new ArrayList<Long>(toRemoveMap.values());
        this.nodeDAO.removeNodeAssocs(toRemoveIds);
        HashSet<NodeRef> toAdd = new HashSet<NodeRef>(targetRefs);
        toAdd.removeAll(targetRefsBefore.keySet());
        int assocIndex = 1;
        for (NodeRef targetNodeRef : targetRefs) {
            this.checkPendingDelete(targetNodeRef);
            Long id = (Long)targetRefsBefore.get(targetNodeRef);
            if (id != null) {
                this.nodeDAO.setNodeAssocIndex(id, assocIndex);
            } else {
                Long targetNodeId = (Long)this.getNodePairNotNull(targetNodeRef).getFirst();
                this.nodeDAO.newNodeAssoc(sourceNodeId, targetNodeId, assocTypeQName, assocIndex);
            }
            ++assocIndex;
        }
        for (NodeRef targetNodeRef : toAdd) {
            AssociationRef assocRef = new AssociationRef(sourceRef, assocTypeQName, targetNodeRef);
            this.invokeOnCreateAssociation(assocRef);
        }
    }

    public Collection<ChildAssociationRef> getChildAssocsWithoutParentAssocsOfType(NodeRef parent, QName assocTypeQName) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(parent);
        Long parentNodeId = (Long)nodePair.getFirst();
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(100);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsWithoutParentAssocsOfType(parentNodeId, assocTypeQName, callback);
        return results;
    }

    public List<ChildAssociationRef> getChildAssocsByPropertyValue(NodeRef nodeRef, QName propertyQName, Serializable value) {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        Long nodeId = (Long)nodePair.getFirst();
        if (getChildAssocsByPropertyValueBannedProps.contains(propertyQName)) {
            throw new IllegalArgumentException("getChildAssocsByPropertyValue does not allow search of system maintained properties: " + propertyQName);
        }
        final ArrayList<ChildAssociationRef> results = new ArrayList<ChildAssociationRef>(10);
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return false;
            }

            @Override
            public boolean orderResults() {
                return true;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                results.add(childAssocPair.getSecond());
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocsByPropertyValue(nodeId, propertyQName, value, callback);
        return results;
    }

    public void removeAssociation(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) throws InvalidNodeRefException {
        this.checkPendingDelete(sourceRef);
        this.checkPendingDelete(targetRef);
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        Long sourceNodeId = (Long)sourceNodePair.getFirst();
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        Long targetNodeId = (Long)targetNodePair.getFirst();
        AssociationRef assocRef = new AssociationRef(sourceRef, assocTypeQName, targetRef);
        this.invokeBeforeDeleteAssociation(assocRef);
        int assocsDeleted = this.nodeDAO.removeNodeAssoc(sourceNodeId, targetNodeId, assocTypeQName);
        if (assocsDeleted > 0) {
            this.invokeOnDeleteAssociation(assocRef);
        }
    }

    public AssociationRef getAssoc(Long id) {
        Pair<Long, AssociationRef> nodeAssocPair = this.nodeDAO.getNodeAssocOrNull(id);
        return nodeAssocPair == null ? null : (AssociationRef)nodeAssocPair.getSecond();
    }

    public List<AssociationRef> getTargetAssocs(NodeRef sourceRef, QNamePattern qnamePattern) {
        Pair<Long, NodeRef> sourceNodePair = this.getNodePairNotNull(sourceRef);
        Long sourceNodeId = (Long)sourceNodePair.getFirst();
        QName qnameFilter = null;
        if (qnamePattern instanceof QName) {
            qnameFilter = (QName)qnamePattern;
        }
        Collection<Pair<Long, AssociationRef>> assocPairs = this.nodeDAO.getTargetNodeAssocs(sourceNodeId, qnameFilter);
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocPairs.size());
        for (Pair<Long, AssociationRef> assocPair : assocPairs) {
            AssociationRef assocRef = (AssociationRef)assocPair.getSecond();
            if (qnameFilter == null && !qnamePattern.isMatch(assocRef.getTypeQName())) continue;
            nodeAssocRefs.add(assocRef);
        }
        return nodeAssocRefs;
    }

    public List<AssociationRef> getSourceAssocs(NodeRef targetRef, QNamePattern qnamePattern) {
        Pair<Long, NodeRef> targetNodePair = this.getNodePairNotNull(targetRef);
        Long targetNodeId = (Long)targetNodePair.getFirst();
        QName qnameFilter = null;
        if (qnamePattern instanceof QName) {
            qnameFilter = (QName)qnamePattern;
        }
        Collection<Pair<Long, AssociationRef>> assocPairs = this.nodeDAO.getSourceNodeAssocs(targetNodeId, qnameFilter);
        ArrayList<AssociationRef> nodeAssocRefs = new ArrayList<AssociationRef>(assocPairs.size());
        for (Pair<Long, AssociationRef> assocPair : assocPairs) {
            AssociationRef assocRef = (AssociationRef)assocPair.getSecond();
            if (qnameFilter == null && !qnamePattern.isMatch(assocRef.getTypeQName())) continue;
            nodeAssocRefs.add(assocRef);
        }
        return nodeAssocRefs;
    }

    public Path getPath(NodeRef nodeRef) throws InvalidNodeRefException {
        List<Path> paths = this.getPaths(nodeRef, true);
        if (paths.size() == 1) {
            return paths.get(0);
        }
        throw new RuntimeException("Primary path count not checked");
    }

    public List<Path> getPaths(NodeRef nodeRef, boolean primaryOnly) throws InvalidNodeRefException {
        Pair<Long, NodeRef> nodePair = this.getNodePairNotNull(nodeRef);
        return this.nodeDAO.getPaths(nodePair, primaryOnly);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void archiveHierarchy(NodeHierarchyWalker walker, StoreRef archiveStoreRef) {
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        try {
            this.archiveHierarchyImpl(walker, archiveStoreRef);
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
    }

    private void archiveHierarchyImpl(NodeHierarchyWalker walker, StoreRef archiveStoreRef) {
        Pair<Long, NodeRef> archiveStoreRootNodePair = this.nodeDAO.getRootNode(archiveStoreRef);
        boolean firstNode = true;
        HashMap<Long, Pair<Long, NodeRef>> archiveRecord = new HashMap<Long, Pair<Long, NodeRef>>(walker.getNodes(false).size() * 2);
        for (NodeHierarchyWalker.VisitedNode node : walker.getNodes(false)) {
            Pair<Long, NodeRef> archiveParentNodePair;
            ChildAssociationRef primaryParentAssocRef;
            Map<QName, Serializable> archiveProperties = this.nodeDAO.getNodeProperties(node.id);
            Set<QName> archiveAspects = this.nodeDAO.getNodeAspects(node.id);
            ChildAssociationRef archivePrimaryParentAssocRef = null;
            if (firstNode) {
                primaryParentAssocRef = (ChildAssociationRef)node.primaryParentAssocPair.getSecond();
                archiveAspects.add(ContentModel.ASPECT_ARCHIVED);
                archiveProperties.put(ContentModel.PROP_ARCHIVED_BY, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                archiveProperties.put(ContentModel.PROP_ARCHIVED_DATE, new Date());
                archiveProperties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC, (Serializable)primaryParentAssocRef);
                Serializable originalOwner = archiveProperties.get(ContentModel.PROP_OWNER);
                archiveProperties.put(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER, (Serializable)(originalOwner != null ? originalOwner : ""));
                archiveAspects.add(ContentModel.ASPECT_OWNABLE);
                archiveProperties.put(ContentModel.PROP_OWNER, (Serializable)((Object)AuthenticationUtil.getFullyAuthenticatedUser()));
                archivePrimaryParentAssocRef = new ChildAssociationRef(ContentModel.ASSOC_CHILDREN, (NodeRef)archiveStoreRootNodePair.getSecond(), NodeArchiveService.QNAME_ARCHIVED_ITEM, new NodeRef(archiveStoreRef, node.nodeRef.getId()), true, -1);
                archiveParentNodePair = archiveStoreRootNodePair;
            } else {
                primaryParentAssocRef = (ChildAssociationRef)node.primaryParentAssocPair.getSecond();
                NodeRef parentNodeRef = primaryParentAssocRef.getParentRef();
                NodeHierarchyWalker.VisitedNode parentNode = walker.getNode(parentNodeRef);
                if (parentNode == null) {
                    throw new IllegalStateException("Expected that a child has a visited primary parent: " + primaryParentAssocRef);
                }
                archiveParentNodePair = (Pair<Long, NodeRef>)archiveRecord.get(parentNode.id);
                if (archiveParentNodePair == null) {
                    throw new IllegalStateException("Expected to have archived primary parent: " + primaryParentAssocRef);
                }
                archivePrimaryParentAssocRef = new ChildAssociationRef(primaryParentAssocRef.getTypeQName(), (NodeRef)archiveParentNodePair.getSecond(), primaryParentAssocRef.getQName(), new NodeRef(archiveStoreRef, node.nodeRef.getId()), true, primaryParentAssocRef.getNthSibling());
            }
            this.invokeBeforeCreateNode(archivePrimaryParentAssocRef.getParentRef(), archivePrimaryParentAssocRef.getTypeQName(), archivePrimaryParentAssocRef.getQName(), node.nodeType);
            boolean attempted = false;
            NodeEntity archiveNode = null;
            while (true) {
                try {
                    ChildAssocEntity archiveChildAssocEntity = this.nodeDAO.newNode((Long)archiveParentNodePair.getFirst(), archivePrimaryParentAssocRef.getTypeQName(), archivePrimaryParentAssocRef.getQName(), archiveStoreRef, node.nodeRef.getId(), node.nodeType, (Locale)archiveProperties.get(ContentModel.PROP_LOCALE), (String)((Object)archiveProperties.get(ContentModel.PROP_NAME)), archiveProperties);
                    archiveNode = archiveChildAssocEntity.getChildNode();
                    archiveRecord.put(node.id, archiveNode.getNodePair());
                }
                catch (NodeExistsException e) {
                    if (!attempted) {
                        NodeRef conflictingNodeRef = (NodeRef)e.getNodePair().getSecond();
                        this.deleteNode(conflictingNodeRef);
                        attempted = true;
                        continue;
                    }
                    throw e;
                }
                break;
            }
            Set originalNodePermissions = this.permissionService.getAllSetPermissions(node.nodeRef);
            for (AccessPermission originalPermission : originalNodePermissions) {
                if (originalPermission.isInherited()) continue;
                NodeRef archiveNodeRef = archiveNode.getNodeRef();
                this.permissionService.setPermission(archiveNodeRef, originalPermission.getAuthority(), originalPermission.getPermission(), originalPermission.getAccessStatus() == AccessStatus.ALLOWED);
            }
            if (!this.permissionService.getInheritParentPermissions(node.nodeRef)) {
                this.permissionService.setInheritParentPermissions(archiveNode.getNodeRef(), false);
            }
            Long archiveNodeId = archiveNode.getId();
            NodeRef archiveNodeRef = archiveNode.getNodeRef();
            this.nodeDAO.addNodeAspects(archiveNodeId, archiveAspects);
            this.nodeDAO.addNodeProperties(archiveNodeId, archiveProperties);
            if (firstNode) {
                String username;
                Long archiveStoreRootNodeId = (Long)archiveStoreRootNodePair.getFirst();
                NodeRef archiveStoreRootNodeRef = (NodeRef)archiveStoreRootNodePair.getSecond();
                if (!this.nodeDAO.hasNodeAspect(archiveStoreRootNodeId, ContentModel.ASPECT_ARCHIVE_ROOT)) {
                    this.addAspect(archiveStoreRootNodeRef, ContentModel.ASPECT_ARCHIVE_ROOT, null);
                }
                if ((username = AuthenticationUtil.getFullyAuthenticatedUser()) == null) {
                    username = AuthenticationUtil.getAdminUserName();
                }
                Pair<Long, ChildAssociationRef> userArchiveAssocPair = this.nodeDAO.getChildAssoc(archiveStoreRootNodeId, ContentModel.ASSOC_ARCHIVE_USER_LINK, username);
                NodeRef userArchiveNodeRef = null;
                if (userArchiveAssocPair == null) {
                    QName archiveUserAssocQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)QName.createValidLocalName((String)username));
                    Map<QName, String> userArchiveNodeProps = Collections.singletonMap(ContentModel.PROP_NAME, username);
                    userArchiveNodeRef = this.createNode(archiveStoreRootNodeRef, ContentModel.ASSOC_ARCHIVE_USER_LINK, archiveUserAssocQName, ContentModel.TYPE_ARCHIVE_USER, userArchiveNodeProps).getChildRef();
                } else {
                    userArchiveNodeRef = ((ChildAssociationRef)userArchiveAssocPair.getSecond()).getChildRef();
                }
                String archiveNodeName = (String)((Object)archiveProperties.get(ContentModel.PROP_NAME));
                if (archiveNodeName == null) {
                    archiveNodeName = archiveNodeRef.getId();
                }
                QName archiveAssocQName = QName.createQNameWithValidLocalName((String)"http://www.alfresco.org/model/system/1.0", (String)archiveNodeName);
                this.addChild(userArchiveNodeRef, archiveNodeRef, ContentModel.ASSOC_ARCHIVED_LINK, archiveAssocQName);
            }
            this.nodeIndexer.indexCreateNode(archivePrimaryParentAssocRef);
            this.invokeOnCreateNode(archivePrimaryParentAssocRef);
            firstNode = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeRef restoreNode(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        this.policyBehaviourFilter.disableBehaviour(ContentModel.ASPECT_AUDITABLE);
        try {
            NodeRef nodeRef = this.restoreNodeImpl(archivedNodeRef, destinationParentNodeRef, assocTypeQName, assocQName);
            return nodeRef;
        }
        finally {
            this.policyBehaviourFilter.enableBehaviour(ContentModel.ASPECT_AUDITABLE);
        }
    }

    private NodeRef restoreNodeImpl(NodeRef archivedNodeRef, NodeRef destinationParentNodeRef, QName assocTypeQName, QName assocQName) {
        Pair<Long, NodeRef> archivedNodePair = this.getNodePairNotNull(archivedNodeRef);
        Long archivedNodeId = (Long)archivedNodePair.getFirst();
        Set<QName> existingAspects = this.nodeDAO.getNodeAspects(archivedNodeId);
        HashSet<QName> newAspects = new HashSet<QName>(5);
        Map<QName, Serializable> existingProperties = this.nodeDAO.getNodeProperties(archivedNodeId);
        HashMap<QName, Serializable> newProperties = new HashMap<QName, Serializable>(11);
        if (!existingAspects.contains(ContentModel.ASPECT_ARCHIVED)) {
            throw new AlfrescoRuntimeException("The node to restore is not an archive node");
        }
        List<ChildAssociationRef> parentAssocsToRemove = this.getParentAssocs(archivedNodeRef, (QNamePattern)ContentModel.ASSOC_ARCHIVED_LINK, RegexQNamePattern.MATCH_ALL);
        for (ChildAssociationRef parentAssocToRemove : parentAssocsToRemove) {
            this.removeSecondaryChildAssociation(parentAssocToRemove);
        }
        ChildAssociationRef originalPrimaryParentAssocRef = (ChildAssociationRef)existingProperties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        Serializable originalOwner = existingProperties.get(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        HashSet<QName> removePropertyQNames = new HashSet<QName>(11);
        HashSet<QName> removeAspectQNames = new HashSet<QName>(3);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_ORIGINAL_PARENT_ASSOC);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_BY);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_DATE);
        removePropertyQNames.add(ContentModel.PROP_ARCHIVED_ORIGINAL_OWNER);
        removeAspectQNames.add(ContentModel.ASPECT_ARCHIVED);
        if (originalOwner == null || originalOwner.equals("")) {
            removeAspectQNames.add(ContentModel.ASPECT_OWNABLE);
            removePropertyQNames.add(ContentModel.PROP_OWNER);
        } else {
            newAspects.add(ContentModel.ASPECT_OWNABLE);
            newProperties.put(ContentModel.PROP_OWNER, originalOwner);
        }
        this.nodeDAO.removeNodeProperties(archivedNodeId, removePropertyQNames);
        this.nodeDAO.removeNodeAspects(archivedNodeId, removeAspectQNames);
        this.nodeDAO.addNodeProperties(archivedNodeId, newProperties);
        this.nodeDAO.addNodeAspects(archivedNodeId, newAspects);
        if (destinationParentNodeRef == null) {
            destinationParentNodeRef = originalPrimaryParentAssocRef.getParentRef();
        }
        if (assocTypeQName == null) {
            assocTypeQName = originalPrimaryParentAssocRef.getTypeQName();
        }
        if (assocQName == null) {
            assocQName = originalPrimaryParentAssocRef.getQName();
        }
        ChildAssociationRef newChildAssocRef = this.moveNode(archivedNodeRef, destinationParentNodeRef, assocTypeQName, assocQName);
        NodeRef restoredNodeRef = newChildAssocRef.getChildRef();
        this.invokeOnRestoreNode(newChildAssocRef);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Restored node: \n   original noderef: " + archivedNodeRef + "\n" + "   restored noderef: " + restoredNodeRef + "\n" + "   new parent: " + destinationParentNodeRef));
        }
        return restoredNodeRef;
    }

    public ChildAssociationRef moveNode(NodeRef nodeToMoveRef, NodeRef newParentRef, QName assocTypeQName, QName assocQName) {
        boolean movingStore;
        this.checkPendingDelete(nodeToMoveRef);
        this.checkPendingDelete(newParentRef);
        Pair<Long, NodeRef> nodeToMovePair = this.getNodePairNotNull(nodeToMoveRef);
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(newParentRef);
        Long nodeToMoveId = (Long)nodeToMovePair.getFirst();
        NodeRef oldNodeToMoveRef = (NodeRef)nodeToMovePair.getSecond();
        Long parentNodeId = (Long)parentNodePair.getFirst();
        NodeRef parentNodeRef = (NodeRef)parentNodePair.getSecond();
        StoreRef oldStoreRef = oldNodeToMoveRef.getStoreRef();
        StoreRef newStoreRef = parentNodeRef.getStoreRef();
        Pair<Long, ChildAssociationRef> oldParentAssocPair = this.nodeDAO.getPrimaryParentAssoc(nodeToMoveId);
        if (oldParentAssocPair == null) {
            throw new IllegalArgumentException("Node " + nodeToMoveId + " doesn't have a parent.  Use 'addChild' instead of move.");
        }
        ChildAssociationRef oldParentAssocRef = (ChildAssociationRef)oldParentAssocPair.getSecond();
        boolean bl = movingStore = !oldStoreRef.equals((Object)newStoreRef);
        if (movingStore) {
            LinkedList<ChildAssociationRef> childAssocs = new LinkedList<ChildAssociationRef>();
            HashMap<NodeRef, Long> oldChildNodeIds = new HashMap<NodeRef, Long>(97);
            this.findNodeChildrenToMove(nodeToMoveId, newStoreRef, childAssocs, oldChildNodeIds);
            this.invokeBeforeDeleteNode(nodeToMoveRef);
            for (ChildAssociationRef oldChildAssoc : childAssocs) {
                this.invokeBeforeDeleteNode(oldChildAssoc.getChildRef());
            }
            HashMap<NodeRef, Object> movedNodePairs = new HashMap<NodeRef, Object>(childAssocs.size() * 2 + 2);
            QName childNodeTypeQName = this.nodeDAO.getNodeType(nodeToMoveId);
            Set<QName> childNodeAspectQNames = this.nodeDAO.getNodeAspects(nodeToMoveId);
            this.invokeBeforeCreateNode(newParentRef, assocTypeQName, assocQName, childNodeTypeQName);
            Pair<Pair<Long, ChildAssociationRef>, Pair<Long, NodeRef>> moveNodeResult = this.nodeDAO.moveNode(nodeToMoveId, parentNodeId, assocTypeQName, assocQName);
            Pair newParentAssocPair = (Pair)moveNodeResult.getFirst();
            movedNodePairs.put(nodeToMoveRef, moveNodeResult.getSecond());
            ChildAssociationRef newParentAssocRef = (ChildAssociationRef)newParentAssocPair.getSecond();
            this.nodeIndexer.indexDeleteNode(oldParentAssocRef);
            this.nodeIndexer.indexCreateNode(newParentAssocRef);
            this.propagateTimeStamps(oldParentAssocRef);
            this.propagateTimeStamps(newParentAssocRef);
            this.invokeOnDeleteNode(oldParentAssocRef, childNodeTypeQName, childNodeAspectQNames, true);
            this.invokeOnCreateNode(newParentAssocRef);
            for (ChildAssociationRef oldChildAssoc : childAssocs) {
                NodeRef oldChildNodeRef = oldChildAssoc.getChildRef();
                Long oldChildNodeId = (Long)oldChildNodeIds.get(oldChildNodeRef);
                NodeRef oldParentNodeRef = oldChildAssoc.getParentRef();
                Pair newParentNodePair = (Pair)movedNodePairs.get(oldParentNodeRef);
                Long newParentNodeId = (Long)newParentNodePair.getFirst();
                childNodeTypeQName = this.nodeDAO.getNodeType(oldChildNodeId);
                childNodeAspectQNames = this.nodeDAO.getNodeAspects(oldChildNodeId);
                this.invokeBeforeCreateNode((NodeRef)newParentNodePair.getSecond(), oldChildAssoc.getTypeQName(), oldChildAssoc.getQName(), childNodeTypeQName);
                try {
                    moveNodeResult = this.nodeDAO.moveNode(oldChildNodeId, newParentNodeId, null, null);
                }
                catch (NodeExistsException e) {
                    this.deleteNode((NodeRef)e.getNodePair().getSecond());
                    moveNodeResult = this.nodeDAO.moveNode(oldChildNodeId, newParentNodeId, null, null);
                }
                newParentAssocPair = (Pair)moveNodeResult.getFirst();
                movedNodePairs.put(oldChildNodeRef, moveNodeResult.getSecond());
                ChildAssociationRef newChildAssoc = (ChildAssociationRef)newParentAssocPair.getSecond();
                this.nodeIndexer.indexDeleteNode(oldChildAssoc);
                this.nodeIndexer.indexCreateNode(newChildAssoc);
                this.propagateTimeStamps(newChildAssoc);
                this.invokeOnDeleteNode(oldChildAssoc, childNodeTypeQName, childNodeAspectQNames, true);
                this.invokeOnCreateNode(newChildAssoc);
            }
            return newParentAssocRef;
        }
        this.invokeBeforeMoveNode(oldParentAssocRef, newParentRef);
        this.invokeBeforeDeleteChildAssociation(oldParentAssocRef);
        Pair<Pair<Long, ChildAssociationRef>, Pair<Long, NodeRef>> moveNodeResult = this.nodeDAO.moveNode(nodeToMoveId, parentNodeId, assocTypeQName, assocQName);
        Pair newParentAssocPair = (Pair)moveNodeResult.getFirst();
        ChildAssociationRef newParentAssocRef = (ChildAssociationRef)newParentAssocPair.getSecond();
        this.nodeIndexer.indexUpdateChildAssociation(oldParentAssocRef, newParentAssocRef);
        if (!oldParentAssocRef.getParentRef().equals((Object)newParentAssocRef.getParentRef())) {
            this.propagateTimeStamps(oldParentAssocRef);
            this.propagateTimeStamps(newParentAssocRef);
        } else {
            this.propagateTimeStamps(newParentAssocRef);
        }
        this.invokeOnCreateChildAssociation(newParentAssocRef, false);
        this.invokeOnDeleteChildAssociation(oldParentAssocRef);
        this.invokeOnMoveNode(oldParentAssocRef, newParentAssocRef);
        return newParentAssocRef;
    }

    private void findNodeChildrenToMove(Long nodeId, final StoreRef storeRef, List<ChildAssociationRef> childAssocsToMove, final Map<NodeRef, Long> nodeIds) {
        final LinkedList childAssocs = new LinkedList();
        NodeDAO.ChildAssocRefQueryCallback callback = new NodeDAO.ChildAssocRefQueryCallback(){

            @Override
            public boolean preLoadNodes() {
                return true;
            }

            @Override
            public boolean orderResults() {
                return false;
            }

            @Override
            public boolean handle(Pair<Long, ChildAssociationRef> childAssocPair, Pair<Long, NodeRef> parentNodePair, Pair<Long, NodeRef> childNodePair) {
                NodeRef childNodeRef = (NodeRef)childNodePair.getSecond();
                if (!childNodeRef.getStoreRef().equals((Object)storeRef)) {
                    childAssocs.add(childAssocPair.getSecond());
                    nodeIds.put(childNodeRef, childNodePair.getFirst());
                }
                return true;
            }

            @Override
            public void done() {
            }
        };
        this.nodeDAO.getChildAssocs(nodeId, null, null, null, Boolean.TRUE, null, callback);
        for (ChildAssociationRef oldChildAssoc : childAssocs) {
            NodeRef childNodeRef = oldChildAssoc.getChildRef();
            Long childNodeId = nodeIds.get(childNodeRef);
            NodeRef.Status childNodeStatus = this.nodeDAO.getNodeRefStatus(childNodeRef);
            if (childNodeStatus == null || childNodeStatus.isDeleted()) continue;
            childAssocsToMove.add(oldChildAssoc);
            this.findNodeChildrenToMove(childNodeId, storeRef, childAssocsToMove, nodeIds);
        }
    }

    public NodeRef getStoreArchiveNode(StoreRef storeRef) {
        StoreRef archiveStoreRef = this.storeArchiveMap.get(storeRef);
        if (archiveStoreRef == null) {
            return null;
        }
        return this.getRootNode(archiveStoreRef);
    }

    private String extractNameProperty(Map<QName, Serializable> properties) {
        Serializable nameValue = properties.get(ContentModel.PROP_NAME);
        String name = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)nameValue);
        return name;
    }

    private boolean setChildNameUnique(Pair<Long, NodeRef> childNodePair, String newName, String oldName) {
        if (newName == null) {
            newName = ((NodeRef)childNodePair.getSecond()).getId();
        }
        Long childNodeId = (Long)childNodePair.getFirst();
        if (EqualsHelper.nullSafeEquals((Object)newName, (Object)oldName)) {
            return false;
        }
        this.nodeDAO.setChildAssocsUniqueName(childNodeId, newName);
        return true;
    }

    private void propagateTimeStamps(ChildAssociationRef assocRef) {
        if (!this.enableTimestampPropagation) {
            return;
        }
        AssociationDefinition assocDef = this.dictionaryService.getAssociation(assocRef.getTypeQName());
        if (assocDef == null || !assocDef.isChild()) {
            return;
        }
        ChildAssociationDefinition childAssocDef = (ChildAssociationDefinition)assocDef;
        if (!childAssocDef.getPropagateTimestamps()) {
            return;
        }
        NodeRef parentNodeRef = assocRef.getParentRef();
        if (!this.policyBehaviourFilter.isEnabled(parentNodeRef, ContentModel.ASPECT_AUDITABLE)) {
            return;
        }
        Pair<Long, NodeRef> parentNodePair = this.getNodePairNotNull(parentNodeRef);
        Long parentNodeId = (Long)parentNodePair.getFirst();
        if (TransactionalResourceHelper.getSet(KEY_AUDITABLE_PROPAGATION_PRE).contains(parentNodeId)) {
            return;
        }
        if (this.nodeDAO.isInCurrentTxn(parentNodeId)) {
            TransactionalResourceHelper.getSet(KEY_AUDITABLE_PROPAGATION_PRE).add(parentNodeId);
            TransactionalResourceHelper.getSet(KEY_AUDITABLE_PROPAGATION_POST).remove(parentNodeId);
        } else {
            TransactionalResourceHelper.getSet(KEY_AUDITABLE_PROPAGATION_POST).add(parentNodeId);
        }
        AlfrescoTransactionSupport.bindListener(this.auditableTransactionListener);
    }

    static {
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NODE_DBID);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NODE_UUID);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_NAME);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_MODIFIED);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_MODIFIER);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_CREATED);
        getChildAssocsByPropertyValueBannedProps.add(ContentModel.PROP_CREATOR);
    }

    private class AuditableTransactionListener
    extends TransactionListenerAdapter {
        private AuditableTransactionListener() {
        }

        @Override
        public void beforeCommit(boolean readOnly) {
            if (readOnly) {
                throw new IllegalStateException("Attempting to modify parent cm:modified in read-only txn.");
            }
            Set<Long> parentNodeIds = TransactionalResourceHelper.getSet(DbNodeServiceImpl.KEY_AUDITABLE_PROPAGATION_PRE);
            if (parentNodeIds.size() == 0) {
                return;
            }
            Date modifiedDate = new Date();
            this.process(parentNodeIds, modifiedDate, true);
        }

        @Override
        public void afterCommit() {
            Set<Long> parentNodeIds = TransactionalResourceHelper.getSet(DbNodeServiceImpl.KEY_AUDITABLE_PROPAGATION_POST);
            if (parentNodeIds.size() == 0) {
                return;
            }
            Date modifiedDate = new Date();
            this.process(parentNodeIds, modifiedDate, false);
        }

        private void process(Set<Long> parentNodeIds, Date modifiedDate, boolean useCurrentTxn) {
            for (Long parentNodeId : parentNodeIds) {
                this.processSingle(parentNodeId, modifiedDate, useCurrentTxn);
            }
        }

        private void processSingle(final Long parentNodeId, final Date modifiedDate, boolean useCurrentTxn) {
            RetryingTransactionHelper txnHelper = DbNodeServiceImpl.this.transactionService.getRetryingTransactionHelper();
            txnHelper.setMaxRetries(1);
            RetryingTransactionHelper.RetryingTransactionCallback<Void> callback = new RetryingTransactionHelper.RetryingTransactionCallback<Void>(){

                @Override
                public Void execute() throws Throwable {
                    Pair<Long, NodeRef> parentNodePair = DbNodeServiceImpl.this.nodeDAO.getNodePair(parentNodeId);
                    if (parentNodePair == null) {
                        return null;
                    }
                    if (!DbNodeServiceImpl.this.nodeDAO.hasNodeAspect(parentNodeId, ContentModel.ASPECT_AUDITABLE)) {
                        return null;
                    }
                    NodeRef parentNodeRef = (NodeRef)parentNodePair.getSecond();
                    DbNodeServiceImpl.this.invokeBeforeUpdateNode(parentNodeRef);
                    boolean changed = DbNodeServiceImpl.this.nodeDAO.setModifiedDate(parentNodeId, modifiedDate);
                    if (changed) {
                        DbNodeServiceImpl.this.invokeOnUpdateNode(parentNodeRef);
                        DbNodeServiceImpl.this.nodeIndexer.indexUpdateNode(parentNodeRef);
                    }
                    return null;
                }
            };
            try {
                txnHelper.doInTransaction(callback, false, !useCurrentTxn);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Touched cm:modified date for node " + parentNodeId + " (" + modifiedDate + ")" + (useCurrentTxn ? " in txn " : " in new txn ") + DbNodeServiceImpl.this.nodeDAO.getCurrentTransactionId(false)));
                }
            }
            catch (Throwable e) {
                logger.info((Object)("Failed to update cm:modified date for node: " + parentNodeId));
            }
        }
    }
}

