/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.policy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourBinding;
import org.alfresco.repo.policy.BehaviourChangeObserver;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.BehaviourIndex;
import org.alfresco.repo.policy.Policy;
import org.alfresco.repo.policy.PolicyComponentImpl;
import org.alfresco.repo.policy.PolicyFactory;
import org.alfresco.util.LockHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@AlfrescoPublicApi
class CachedPolicyFactory<B extends BehaviourBinding, P extends Policy>
extends PolicyFactory<B, P> {
    private static final Log logger = LogFactory.getLog(PolicyComponentImpl.class);
    private BehaviourFilter behaviourFilter = null;
    private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
    private Map<B, P> singleCache = new HashMap<B, P>();
    private Map<B, Collection<P>> listCache = new HashMap<B, Collection<P>>();

    CachedPolicyFactory(Class<P> policyClass, BehaviourIndex<B> index) {
        super(policyClass, index);
        this.behaviourFilter = index.getFilter();
        index.addChangeObserver(new BehaviourChangeObserver<B>(){

            @Override
            public void addition(B binding, Behaviour behaviour) {
                CachedPolicyFactory.this.clearCache("aggregate delegate", CachedPolicyFactory.this.singleCache, binding);
                CachedPolicyFactory.this.clearCache("delegate collection", CachedPolicyFactory.this.listCache, binding);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public P create(B binding) {
        Policy policyInterface;
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.create(binding);
        }
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)100L);
        try {
            policyInterface = (Policy)this.singleCache.get(binding);
            if (policyInterface != null) {
                Policy policy = policyInterface;
                return (P)policy;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)100L);
        try {
            policyInterface = (Policy)this.singleCache.get(binding);
            if (policyInterface != null) {
                Policy policy = policyInterface;
                return (P)policy;
            }
            policyInterface = super.create(binding);
            this.singleCache.put(binding, policyInterface);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cached delegate interface " + policyInterface + " for " + binding + " and policy " + this.getPolicyClass()));
            }
            Policy policy = policyInterface;
            return (P)policy;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Collection<P> createList(B binding) {
        Collection<P> policyInterfaces;
        if (this.behaviourFilter != null && this.behaviourFilter.isActivated()) {
            return super.createList(binding);
        }
        LockHelper.tryLock((Lock)this.lock.readLock(), (long)100L);
        try {
            policyInterfaces = this.listCache.get(binding);
            if (policyInterfaces != null) {
                Collection<P> collection = policyInterfaces;
                return collection;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)100L);
        try {
            policyInterfaces = this.listCache.get(binding);
            if (policyInterfaces != null) {
                Collection<P> collection = policyInterfaces;
                return collection;
            }
            policyInterfaces = super.createList(binding);
            this.listCache.put(binding, policyInterfaces);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Cached delegate interface collection " + policyInterfaces + " for " + binding + " and policy " + this.getPolicyClass()));
            }
            Collection<P> collection = policyInterfaces;
            return collection;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void clearCache(String cacheDescription, Map<B, ?> cache, B binding) {
        if (binding == null) {
            LockHelper.tryLock((Lock)this.lock.writeLock(), (long)100L);
            try {
                cache.clear();
                if (!logger.isDebugEnabled() || cache.isEmpty()) return;
                logger.debug((Object)("Cleared " + cacheDescription + " cache (all class bindings) for policy " + this.getPolicyClass()));
                return;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }
        ArrayList<BehaviourBinding> invalidBindings = new ArrayList<BehaviourBinding>();
        Iterator<Object> i$ = cache.keySet().iterator();
        block6: while (i$.hasNext()) {
            BehaviourBinding cachedBinding;
            for (BehaviourBinding generalisedBinding = cachedBinding = (BehaviourBinding)i$.next(); generalisedBinding != null; generalisedBinding = generalisedBinding.generaliseBinding()) {
                if (!generalisedBinding.equals(binding)) continue;
                invalidBindings.add(cachedBinding);
                continue block6;
            }
        }
        if (invalidBindings.size() <= 0) return;
        LockHelper.tryLock((Lock)this.lock.writeLock(), (long)100L);
        try {
            for (BehaviourBinding invalidBinding : invalidBindings) {
                cache.remove(invalidBinding);
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Cleared " + cacheDescription + " cache for " + invalidBinding + " and policy " + this.getPolicyClass()));
            }
            return;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

