/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.springframework.social.connect.Connection;
import org.springframework.social.connect.support.OAuth1ConnectionFactory;
import org.springframework.social.oauth1.AuthorizedRequestToken;
import org.springframework.social.oauth1.OAuth1Operations;
import org.springframework.social.oauth1.OAuth1Parameters;
import org.springframework.social.oauth1.OAuthToken;

public abstract class AbstractOAuth1ChannelType<A>
extends AbstractChannelType {
    private OAuth1ConnectionFactory<A> connectionFactory;

    protected Connection<A> getConnectionForChannel(NodeRef channelNode) {
        NodeService nodeService = this.getNodeService();
        Connection connection = null;
        if (nodeService.exists(channelNode) && nodeService.hasAspect(channelNode, PublishingModel.ASPECT_OAUTH1_DELIVERY_CHANNEL)) {
            String tokenValue = (String)((Object)this.getEncryptor().decrypt(PublishingModel.PROP_OAUTH1_TOKEN_VALUE, nodeService.getProperty(channelNode, PublishingModel.PROP_OAUTH1_TOKEN_VALUE)));
            String tokenSecret = (String)((Object)this.getEncryptor().decrypt(PublishingModel.PROP_OAUTH1_TOKEN_SECRET, nodeService.getProperty(channelNode, PublishingModel.PROP_OAUTH1_TOKEN_SECRET)));
            Boolean danceComplete = (Boolean)nodeService.getProperty(channelNode, PublishingModel.PROP_AUTHORISATION_COMPLETE);
            if (danceComplete.booleanValue()) {
                OAuthToken token = new OAuthToken(tokenValue, tokenSecret);
                connection = this.connectionFactory.createConnection(token);
            }
        }
        return connection;
    }

    @Override
    public ChannelType.AuthUrlPair getAuthorisationUrls(Channel channel, String callbackUrl) {
        ParameterCheck.mandatory((String)"channel", (Object)channel);
        ParameterCheck.mandatory((String)"callbackUrl", (Object)callbackUrl);
        if (!this.getId().equals(channel.getChannelType().getId())) {
            throw new IllegalArgumentException("Invalid channel type: " + channel.getChannelType().getId());
        }
        NodeService nodeService = this.getNodeService();
        OAuth1Operations oauthOperations = this.getOAuth1Operations();
        OAuthToken requestToken = oauthOperations.fetchRequestToken(callbackUrl, null);
        NodeRef channelNodeRef = channel.getNodeRef();
        nodeService.setProperty(channelNodeRef, PublishingModel.PROP_OAUTH1_TOKEN_SECRET, this.getEncryptor().encrypt(PublishingModel.PROP_OAUTH1_TOKEN_SECRET, (Serializable)((Object)requestToken.getSecret())));
        nodeService.setProperty(channelNodeRef, PublishingModel.PROP_OAUTH1_TOKEN_VALUE, this.getEncryptor().encrypt(PublishingModel.PROP_OAUTH1_TOKEN_VALUE, (Serializable)((Object)requestToken.getValue())));
        String authUrl = oauthOperations.buildAuthorizeUrl(requestToken.getValue(), this.getOAuth1Parameters(callbackUrl));
        return new ChannelType.AuthUrlPair(authUrl, callbackUrl);
    }

    @Override
    protected ChannelType.AuthStatus internalAcceptAuthorisation(Channel channel, Map<String, String[]> callbackHeaders, Map<String, String[]> callbackParams) {
        NodeService nodeService = this.getNodeService();
        ChannelType.AuthStatus authorised = ChannelType.AuthStatus.UNAUTHORISED;
        String[] verifier = callbackParams.get(this.getOAuthVerifierParamName());
        if (verifier != null) {
            OAuth1Operations oauthOperations = this.getOAuth1Operations();
            NodeRef channelNodeRef = channel.getNodeRef();
            Map currentProps = nodeService.getProperties(channelNodeRef);
            String tokenValue = (String)((Object)this.getEncryptor().decrypt(PublishingModel.PROP_OAUTH1_TOKEN_VALUE, (Serializable)currentProps.get(PublishingModel.PROP_OAUTH1_TOKEN_VALUE)));
            String tokenSecret = (String)((Object)this.getEncryptor().decrypt(PublishingModel.PROP_OAUTH1_TOKEN_SECRET, (Serializable)currentProps.get(PublishingModel.PROP_OAUTH1_TOKEN_SECRET)));
            OAuthToken token = new OAuthToken(tokenValue, tokenSecret);
            OAuthToken accessToken = oauthOperations.exchangeForAccessToken(new AuthorizedRequestToken(token, verifier[0]), null);
            Map<QName, Serializable> newProps = new HashMap<QName, Serializable>();
            newProps.put(PublishingModel.PROP_OAUTH1_TOKEN_VALUE, (Serializable)((Object)accessToken.getValue()));
            newProps.put(PublishingModel.PROP_OAUTH1_TOKEN_SECRET, (Serializable)((Object)accessToken.getSecret()));
            newProps = this.getEncryptor().encrypt(newProps);
            this.getChannelService().updateChannel(channel, newProps);
            authorised = ChannelType.AuthStatus.AUTHORISED;
        }
        return authorised;
    }

    protected OAuth1Parameters getOAuth1Parameters(String callbackUrl) {
        return OAuth1Parameters.NONE;
    }

    protected String getOAuthVerifierParamName() {
        return "oauth_verifier";
    }

    private OAuth1Operations getOAuth1Operations() {
        return this.connectionFactory.getOAuthOperations();
    }

    public void setConnectionFactory(OAuth1ConnectionFactory<A> connectionFactory) {
        this.connectionFactory = connectionFactory;
    }
}

