/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.publishing;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.node.encryption.MetadataEncryptor;
import org.alfresco.repo.publishing.AbstractChannelType;
import org.alfresco.repo.publishing.ChannelHelper;
import org.alfresco.repo.publishing.PublishingModel;
import org.alfresco.repo.publishing.PublishingRootObject;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.publishing.channels.Channel;
import org.alfresco.service.cmr.publishing.channels.ChannelService;
import org.alfresco.service.cmr.publishing.channels.ChannelType;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.ParameterCheck;
import org.alfresco.util.collections.CollectionUtils;
import org.alfresco.util.collections.Filter;
import org.alfresco.util.collections.Function;

public class ChannelServiceImpl
implements ChannelService {
    public static final String NAME = "ChannelService";
    private final Map<String, ChannelType> channelTypes = new TreeMap<String, ChannelType>();
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private ChannelHelper channelHelper;
    private PublishingRootObject rootObject;
    private MetadataEncryptor encryptor;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setPublishingRootObject(PublishingRootObject rootObject) {
        this.rootObject = rootObject;
    }

    public void setChannelHelper(ChannelHelper channelHelper) {
        this.channelHelper = channelHelper;
    }

    public void setEncryptor(MetadataEncryptor encryptor) {
        this.encryptor = encryptor;
    }

    @Override
    public void register(AbstractChannelType channelType) {
        ParameterCheck.mandatory((String)"channelType", (Object)channelType);
        String id = channelType.getId();
        if (this.channelTypes.containsKey(id)) {
            throw new IllegalArgumentException("Channel type " + id + " is already registered!");
        }
        this.channelTypes.put(id, channelType);
    }

    @Override
    public List<ChannelType> getChannelTypes() {
        return new ArrayList<ChannelType>(this.channelTypes.values());
    }

    @Override
    public Channel createChannel(String channelTypeId, String name, Map<QName, Serializable> properties) {
        NodeRef channelContainer = this.getChannelContainer();
        ChannelType channelType = this.channelTypes.get(channelTypeId);
        if (channelType == null) {
            String message = "Channel Type: " + channelTypeId + " does not exist!";
            throw new IllegalArgumentException(message);
        }
        Map<QName, Serializable> actualProps = new HashMap<QName, Serializable>();
        if (properties != null) {
            actualProps.putAll(properties);
        }
        actualProps.put(ContentModel.PROP_NAME, (Serializable)((Object)name));
        actualProps.put(PublishingModel.PROP_CHANNEL_TYPE_ID, (Serializable)((Object)channelType.getId()));
        actualProps.put(PublishingModel.PROP_AUTHORISATION_COMPLETE, Boolean.FALSE);
        actualProps = this.encryptor.encrypt(actualProps);
        NodeRef channelNode = this.channelHelper.createChannelNode(channelContainer, channelType, name, actualProps);
        return this.channelHelper.buildChannelObject(channelNode, this);
    }

    @Override
    public void deleteChannel(Channel channel) {
        this.nodeService.deleteNode(channel.getNodeRef());
    }

    @Override
    public List<Channel> getChannels() {
        NodeRef channelContainer = this.getChannelContainer();
        return this.channelHelper.getAllChannels(channelContainer, this);
    }

    @Override
    public Channel getChannelByName(String channelName) {
        NodeRef node = this.getChannelNodeByName(channelName);
        return this.channelHelper.buildChannelObject(node, this);
    }

    private NodeRef getChannelNodeByName(String channelName) {
        QName type;
        ParameterCheck.mandatory((String)"channelName", (Object)channelName);
        NodeRef channelContainer = this.getChannelContainer();
        if (channelContainer == null) {
            return null;
        }
        NodeRef child = this.nodeService.getChildByName(channelContainer, ContentModel.ASSOC_CONTAINS, channelName);
        if (child != null && this.dictionaryService.isSubClass(type = this.nodeService.getType(child), PublishingModel.TYPE_DELIVERY_CHANNEL)) {
            return child;
        }
        return null;
    }

    @Override
    public List<Channel> getRelevantPublishingChannels(NodeRef nodeToPublish) {
        NodeRef containerNode = this.getChannelContainer();
        List<ChannelType> types = this.channelHelper.getReleventChannelTypes(nodeToPublish, this.channelTypes.values());
        List<Channel> channels = this.channelHelper.getChannelsForTypes(containerNode, types, this, true);
        return this.channelHelper.filterAuthorisedChannels(channels);
    }

    @Override
    public List<Channel> getPublishingChannels(boolean filterByPublishPermission) {
        NodeRef containerNode = this.getChannelContainer();
        if (containerNode != null) {
            List types = CollectionUtils.filter(this.channelTypes.values(), (Function)new Filter<ChannelType>(){

                public Boolean apply(ChannelType type) {
                    return type.canPublish();
                }
            });
            return this.channelHelper.getChannelsForTypes(containerNode, types, this, filterByPublishPermission);
        }
        return Collections.emptyList();
    }

    @Override
    public List<Channel> getStatusUpdateChannels(boolean filterByPublishPermission) {
        NodeRef containerNode = this.getChannelContainer();
        if (containerNode != null) {
            List<ChannelType> types = this.channelHelper.getStatusUpdateChannelTypes(this.channelTypes.values());
            return this.channelHelper.getChannelsForTypes(containerNode, types, this, filterByPublishPermission);
        }
        return Collections.emptyList();
    }

    public List<Channel> getAuthorisedStatusUpdateChannels() {
        return this.channelHelper.filterAuthorisedChannels(this.getStatusUpdateChannels(false));
    }

    private NodeRef getChannelContainer() {
        return this.rootObject.getChannelContainer();
    }

    @Override
    public ChannelType getChannelType(String id) {
        return this.channelTypes.get(id);
    }

    @Override
    public void renameChannel(Channel channel, String newName) {
        NodeRef channelNode = channel.getNodeRef();
        if (channelNode != null && this.nodeService.exists(channelNode)) {
            NodeRef channelContainer = this.getChannelContainer();
            this.nodeService.setProperty(channelNode, ContentModel.PROP_NAME, (Serializable)((Object)newName));
            this.nodeService.moveNode(channelNode, channelContainer, ContentModel.ASSOC_CONTAINS, QName.createQName((String)"http://www.alfresco.org/model/application/1.0", (String)newName));
        }
    }

    @Override
    public void updateChannel(Channel channel, Map<QName, Serializable> properties) {
        Map<QName, Serializable> actualProps = new HashMap<QName, Serializable>(properties);
        actualProps.remove(ContentModel.PROP_NODE_UUID);
        NodeRef editorialNode = new NodeRef(channel.getId());
        actualProps = this.encryptor.encrypt(actualProps);
        for (Map.Entry<QName, Serializable> entry : actualProps.entrySet()) {
            this.nodeService.setProperty(editorialNode, entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Channel getChannelById(String id) {
        if (id != null && NodeRef.isNodeRef((String)id)) {
            NodeRef node = new NodeRef(id);
            return this.channelHelper.buildChannelObject(node, this);
        }
        return null;
    }
}

