/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.rendition.executer;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import org.alfresco.repo.action.ParameterDefinitionImpl;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.rendition.executer.AbstractRenderingEngine;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.action.ActionServiceException;
import org.alfresco.service.cmr.action.ExecutionDetails;
import org.alfresco.service.cmr.action.ExecutionSummary;
import org.alfresco.service.cmr.action.ParameterDefinition;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.rendition.RenditionCancelledException;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.TransformationSourceOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractTransformationRenderingEngine
extends AbstractRenderingEngine {
    private static Log logger = LogFactory.getLog(AbstractTransformationRenderingEngine.class);
    public static final String PARAM_TIMEOUT_MS = "timeoutMs";
    public static final String PARAM_READ_LIMIT_TIME_MS = "readLimitTimeMs";
    public static final String PARAM_MAX_SOURCE_SIZE_K_BYTES = "maxSourceSizeKBytes";
    public static final String PARAM_READ_LIMIT_K_BYTES = "readLimitKBytes";
    public static final String PARAM_MAX_PAGES = "maxPages";
    public static final String PARAM_PAGE_LIMIT = "pageLimit";
    protected static final int CANCELLED_ACTION_POLLING_INTERVAL = 200;
    public static final String PARAM_USE = ".use.".replaceAll("\\.", "");
    private static final String TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN = "Transformer for '%s' source mime type and '%s' target mime type was not found. Operation can't be performed";
    private static final String NOT_TRANSFORMABLE_MESSAGE_PATTERN = "Content not transformable for '%s' source mime type and '%s' target mime type. Operation can't be performed";
    private static final String TRANSFORMING_ERROR_MESSAGE = "Some error occurred during document transforming. Error message: ";
    private Collection<TransformationSourceOptions.TransformationSourceOptionsSerializer> sourceOptionsSerializers;
    private ExecutorService executorService;

    public Collection<TransformationSourceOptions.TransformationSourceOptionsSerializer> getSourceOptionsSerializers() {
        return this.sourceOptionsSerializers;
    }

    public void setSourceOptionsSerializers(Collection<TransformationSourceOptions.TransformationSourceOptionsSerializer> sourceOptionsSerializers) {
        this.sourceOptionsSerializers = sourceOptionsSerializers;
    }

    protected ExecutorService getExecutorService() {
        return this.executorService;
    }

    @Override
    public void init() {
        super.init();
        if (this.executorService == null) {
            this.executorService = Executors.newCachedThreadPool();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void render(AbstractRenderingEngine.RenderingContext context) {
        FutureTask<ContentWriter> transformTask;
        boolean actionCompleted;
        boolean actionCancelled;
        block24: {
            ExecutionSummary executionSummary;
            long startTime;
            TransformationOptions options;
            String targetMimeType;
            ContentReader contentReader;
            block23: {
                ContentTransformer transformer;
                contentReader = context.makeContentReader();
                String sourceUrl = contentReader.getContentUrl();
                String sourceMimeType = contentReader.getMimetype();
                targetMimeType = this.getTargetMimeType(context);
                options = this.getTransformOptions(context);
                boolean orig = TransformerDebug.setDebugOutput(false);
                try {
                    transformer = this.contentService.getTransformer(sourceUrl, sourceMimeType, contentReader.getSize(), targetMimeType, options);
                }
                finally {
                    TransformerDebug.setDebugOutput(orig);
                }
                if (null == transformer) {
                    throw new RenditionServiceException(String.format(TRANSFORMER_NOT_EXISTS_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
                }
                if (!transformer.isTransformable(sourceMimeType, contentReader.getSize(), targetMimeType, options)) {
                    throw new RenditionServiceException(String.format(NOT_TRANSFORMABLE_MESSAGE_PATTERN, sourceMimeType, targetMimeType));
                }
                startTime = new Date().getTime();
                actionCancelled = false;
                actionCompleted = false;
                executionSummary = null;
                try {
                    executionSummary = this.getExecutionSummary(context);
                }
                catch (ActionServiceException e) {
                    if (!logger.isInfoEnabled()) break block23;
                    logger.info((Object)"Cancelling of multiple concurrent action instances currently unsupported, this action can't be cancelled");
                }
            }
            transformTask = new FutureTask<ContentWriter>(new TransformationCallable(contentReader, targetMimeType, options, context));
            this.getExecutorService().execute(transformTask);
            try {
                ExecutionDetails executionDetails;
                do {
                    Thread.sleep(200L);
                    if (transformTask.isDone()) {
                        actionCompleted = true;
                    } else {
                        if (options.getTimeoutMs() <= 0L || new Date().getTime() - startTime <= options.getTimeoutMs() + 200L) continue;
                        if (logger.isDebugEnabled()) {
                            logger.debug((Object)"Transformation did not obey timeout limit, rendition action is moving on");
                        }
                    }
                    break block24;
                } while (executionSummary == null || (executionDetails = this.actionTrackingService.getExecutionDetails(executionSummary)) == null || !(actionCancelled = executionDetails.isCancelRequested()));
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)"Cancelling transformation");
                }
                transformTask.cancel(true);
            }
            catch (InterruptedException e) {
                actionCancelled = true;
                transformTask.cancel(true);
            }
        }
        if (actionCancelled) {
            throw new RenditionCancelledException("Rendition action cancelled");
        }
        if (!actionCompleted && !actionCancelled) {
            throw new RenditionServiceException("Transformation failed to obey timeout limit");
        }
        if (actionCompleted) {
            ContentWriter writer = context.makeContentWriter();
            try {
                ContentWriter tempTarget = transformTask.get();
                if (tempTarget == null) {
                    throw new RenditionServiceException("Target of transformation not present");
                }
                writer.putContent(tempTarget.getReader().getContentInputStream());
            }
            catch (ExecutionException e) {
                Throwable transformException = e.getCause();
                if (transformException instanceof RuntimeException) {
                    throw (RuntimeException)e.getCause();
                }
                throw new RenditionServiceException(TRANSFORMING_ERROR_MESSAGE + e.getCause().getMessage(), e.getCause());
            }
            catch (InterruptedException e) {
                transformTask.cancel(true);
            }
        }
    }

    protected abstract TransformationOptions getTransformOptions(AbstractRenderingEngine.RenderingContext var1);

    protected TransformationOptions getTransformOptionsImpl(TransformationOptions options, AbstractRenderingEngine.RenderingContext context) {
        String use;
        Integer pageLimit;
        Integer maxPages;
        Long readLimitKBytes;
        Long maxSourceSizeKBytes;
        Long readLimitTimeMs;
        Long timeoutMs = context.getCheckedParam(PARAM_TIMEOUT_MS, Long.class);
        if (timeoutMs != null) {
            options.setTimeoutMs(timeoutMs);
        }
        if ((readLimitTimeMs = context.getCheckedParam(PARAM_READ_LIMIT_TIME_MS, Long.class)) != null) {
            options.setReadLimitTimeMs(readLimitTimeMs);
        }
        if ((maxSourceSizeKBytes = context.getCheckedParam(PARAM_MAX_SOURCE_SIZE_K_BYTES, Long.class)) != null) {
            options.setMaxSourceSizeKBytes(maxSourceSizeKBytes);
        }
        if ((readLimitKBytes = context.getCheckedParam(PARAM_READ_LIMIT_K_BYTES, Long.class)) != null) {
            options.setReadLimitKBytes(readLimitKBytes);
        }
        if ((maxPages = context.getCheckedParam(PARAM_MAX_PAGES, Integer.class)) != null) {
            options.setMaxPages(maxPages);
        }
        if ((pageLimit = context.getCheckedParam(PARAM_PAGE_LIMIT, Integer.class)) != null) {
            options.setPageLimit(pageLimit);
        }
        if ((use = context.getCheckedParam(PARAM_USE, String.class)) != null) {
            options.setUse(use);
        }
        if (this.getSourceOptionsSerializers() != null) {
            for (TransformationSourceOptions.TransformationSourceOptionsSerializer sourceSerializer : this.getSourceOptionsSerializers()) {
                TransformationSourceOptions sourceOptions = sourceSerializer.deserialize(context);
                if (sourceOptions == null) continue;
                options.addSourceOptions(sourceOptions);
            }
        }
        return options;
    }

    @Override
    protected Collection<ParameterDefinition> getParameterDefinitions() {
        Collection<ParameterDefinition> paramList = super.getParameterDefinitions();
        paramList.add(new ParameterDefinitionImpl(PARAM_TIMEOUT_MS, DataTypeDefinition.LONG, false, this.getParamDisplayLabel(PARAM_TIMEOUT_MS)));
        paramList.add(new ParameterDefinitionImpl(PARAM_READ_LIMIT_TIME_MS, DataTypeDefinition.LONG, false, this.getParamDisplayLabel(PARAM_READ_LIMIT_TIME_MS)));
        paramList.add(new ParameterDefinitionImpl(PARAM_MAX_SOURCE_SIZE_K_BYTES, DataTypeDefinition.LONG, false, this.getParamDisplayLabel(PARAM_MAX_SOURCE_SIZE_K_BYTES)));
        paramList.add(new ParameterDefinitionImpl(PARAM_READ_LIMIT_K_BYTES, DataTypeDefinition.LONG, false, this.getParamDisplayLabel(PARAM_READ_LIMIT_K_BYTES)));
        paramList.add(new ParameterDefinitionImpl(PARAM_MAX_PAGES, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_MAX_PAGES)));
        paramList.add(new ParameterDefinitionImpl(PARAM_PAGE_LIMIT, DataTypeDefinition.INT, false, this.getParamDisplayLabel(PARAM_PAGE_LIMIT)));
        paramList.add(new ParameterDefinitionImpl(PARAM_USE, DataTypeDefinition.TEXT, false, this.getParamDisplayLabel(PARAM_USE)));
        return paramList;
    }

    protected class TransformationCallable
    implements Callable<ContentWriter> {
        private ContentReader contentReader;
        private String targetMimeType;
        private TransformationOptions options;
        private AbstractRenderingEngine.RenderingContext context;

        public TransformationCallable(ContentReader contentReader, String targetMimeType, TransformationOptions options, AbstractRenderingEngine.RenderingContext context) {
            this.contentReader = contentReader;
            this.targetMimeType = targetMimeType;
            this.options = options;
            this.context = context;
        }

        @Override
        public ContentWriter call() throws Exception {
            Serializable runAsParam = this.context.getDefinition().getParameterValue("runAs");
            String runAsName = runAsParam == null ? AbstractRenderingEngine.DEFAULT_RUN_AS_NAME : (String)((Object)runAsParam);
            return (ContentWriter)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<ContentWriter>(){

                public ContentWriter doWork() throws Exception {
                    ContentWriter tempContentWriter = AbstractTransformationRenderingEngine.this.contentService.getTempWriter();
                    tempContentWriter.setMimetype(TransformationCallable.this.targetMimeType);
                    try {
                        AbstractTransformationRenderingEngine.this.contentService.transform(TransformationCallable.this.contentReader, tempContentWriter, TransformationCallable.this.options);
                        return tempContentWriter;
                    }
                    catch (NoTransformerException ntx) {
                        logger.debug((Object)("No transformer found to execute rule: \n   reader: " + TransformationCallable.this.contentReader + "\n" + "   writer: " + tempContentWriter + "\n" + "   action: " + this));
                        throw new RenditionServiceException(AbstractTransformationRenderingEngine.TRANSFORMING_ERROR_MESSAGE + ntx.getMessage(), (Throwable)((Object)ntx));
                    }
                }
            }, (String)runAsName);
        }
    }
}

