/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.replication;

import java.util.List;
import org.alfresco.repo.replication.ReplicationDefinitionImpl;
import org.alfresco.repo.replication.ReplicationDefinitionPersister;
import org.alfresco.repo.replication.ReplicationDefinitionPersisterImpl;
import org.alfresco.repo.replication.ReplicationParams;
import org.alfresco.service.cmr.action.ActionService;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedAction;
import org.alfresco.service.cmr.action.scheduled.ScheduledPersistedActionService;
import org.alfresco.service.cmr.replication.ReplicationDefinition;
import org.alfresco.service.cmr.replication.ReplicationService;
import org.alfresco.service.cmr.replication.ReplicationServiceException;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ReplicationServiceImpl
implements ReplicationService,
ReplicationDefinitionPersister {
    private static final Log log = LogFactory.getLog(ReplicationServiceImpl.class);
    private ActionService actionService;
    private ScheduledPersistedActionService scheduledPersistedActionService;
    private ReplicationParams replicationParams;
    private ReplicationDefinitionPersisterImpl replicationDefinitionPersister;

    public void setReplicationDefinitionPersister(ReplicationDefinitionPersisterImpl replicationDefinitionPersister) {
        this.replicationDefinitionPersister = replicationDefinitionPersister;
    }

    public void setActionService(ActionService actionService) {
        this.actionService = actionService;
    }

    public void setScheduledPersistedActionService(ScheduledPersistedActionService scheduledPersistedActionService) {
        this.scheduledPersistedActionService = scheduledPersistedActionService;
    }

    @Override
    public ReplicationDefinition createReplicationDefinition(String replicationDefinitionName, String description) {
        if (log.isDebugEnabled()) {
            StringBuilder msg = new StringBuilder();
            msg.append("Creating replication definition ").append(replicationDefinitionName);
            log.debug((Object)msg.toString());
        }
        return new ReplicationDefinitionImpl(GUID.generate(), replicationDefinitionName, description);
    }

    @Override
    public ReplicationDefinition loadReplicationDefinition(String replicationDefinitionName) {
        ReplicationDefinitionImpl rd = (ReplicationDefinitionImpl)this.replicationDefinitionPersister.loadReplicationDefinition(replicationDefinitionName);
        if (rd != null) {
            rd.setSchedule(this.scheduledPersistedActionService.getSchedule(rd));
        }
        return rd;
    }

    private List<ReplicationDefinition> attachSchedules(List<ReplicationDefinition> definitions) {
        for (ReplicationDefinition rd : definitions) {
            if (rd == null) continue;
            ReplicationDefinitionImpl rdi = (ReplicationDefinitionImpl)rd;
            rdi.setSchedule(this.scheduledPersistedActionService.getSchedule(rdi));
        }
        return definitions;
    }

    @Override
    public List<ReplicationDefinition> loadReplicationDefinitions() {
        return this.attachSchedules(this.replicationDefinitionPersister.loadReplicationDefinitions());
    }

    @Override
    public List<ReplicationDefinition> loadReplicationDefinitions(String target) {
        return this.attachSchedules(this.replicationDefinitionPersister.loadReplicationDefinitions(target));
    }

    @Override
    public void renameReplicationDefinition(String oldReplicationName, String newReplicationName) {
        this.replicationDefinitionPersister.renameReplicationDefinition(oldReplicationName, newReplicationName);
    }

    @Override
    public void saveReplicationDefinition(ReplicationDefinition replicationDefinition) {
        this.replicationDefinitionPersister.saveReplicationDefinition(replicationDefinition);
        if (replicationDefinition.isSchedulingEnabled()) {
            this.scheduledPersistedActionService.saveSchedule(((ReplicationDefinitionImpl)replicationDefinition).getSchedule());
        }
    }

    @Override
    public void deleteReplicationDefinition(ReplicationDefinition replicationDefinition) {
        if (replicationDefinition.isSchedulingEnabled()) {
            this.scheduledPersistedActionService.deleteSchedule(((ReplicationDefinitionImpl)replicationDefinition).getSchedule());
        }
        this.replicationDefinitionPersister.deleteReplicationDefinition(replicationDefinition);
    }

    @Override
    public void replicate(ReplicationDefinition replicationDefinition) {
        if (!this.isEnabled()) {
            throw new ReplicationServiceException("Unable to replicate. The replication service is not enabled");
        }
        this.actionService.executeAction(replicationDefinition, ReplicationDefinitionPersisterImpl.REPLICATION_ACTION_ROOT_NODE_REF);
    }

    @Override
    public void disableScheduling(ReplicationDefinition replicationDefinition) {
        ReplicationDefinitionImpl definition = (ReplicationDefinitionImpl)replicationDefinition;
        if (replicationDefinition.isSchedulingEnabled()) {
            this.scheduledPersistedActionService.deleteSchedule(definition.getSchedule());
        }
        definition.setSchedule(null);
    }

    @Override
    public void enableScheduling(ReplicationDefinition replicationDefinition) {
        if (!replicationDefinition.isSchedulingEnabled()) {
            ScheduledPersistedAction schedule = this.scheduledPersistedActionService.createSchedule(replicationDefinition);
            ((ReplicationDefinitionImpl)replicationDefinition).setSchedule(schedule);
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.replicationParams != null) {
            return this.replicationParams.isEnabled();
        }
        return true;
    }

    public void setReplicationParams(ReplicationParams replicationParams) {
        this.replicationParams = replicationParams;
    }
}

