/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.lucene;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.model.WCMModel;
import org.alfresco.repo.avm.AVMDAOs;
import org.alfresco.repo.avm.AVMNode;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.avm.util.SimplePath;
import org.alfresco.repo.content.ContentStore;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.repo.content.transform.TransformerDebug;
import org.alfresco.repo.dictionary.IndexTokenisationMode;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.search.IndexMode;
import org.alfresco.repo.search.MLAnalysisMode;
import org.alfresco.repo.search.impl.lucene.AVMLuceneIndexer;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneIndexerImpl;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneConfig;
import org.alfresco.repo.search.impl.lucene.LuceneIndexException;
import org.alfresco.repo.search.impl.lucene.MultiReader;
import org.alfresco.repo.search.impl.lucene.analysis.DateTimeAnalyser;
import org.alfresco.repo.search.impl.lucene.analysis.MLTokenDuplicator;
import org.alfresco.repo.search.impl.lucene.analysis.VerbatimAnalyser;
import org.alfresco.repo.search.impl.lucene.fts.FTSIndexerAware;
import org.alfresco.repo.search.impl.lucene.fts.FullTextSearchIndexer;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMException;
import org.alfresco.service.cmr.avm.AVMNodeDescriptor;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avmsync.AVMDifference;
import org.alfresco.service.cmr.avmsync.AVMSyncException;
import org.alfresco.service.cmr.avmsync.AVMSyncService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.MLText;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.repository.datatype.DefaultTypeConverter;
import org.alfresco.service.cmr.repository.datatype.TypeConversionException;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.CachingDateFormat;
import org.alfresco.util.EqualsHelper;
import org.alfresco.util.GUID;
import org.alfresco.util.ISO9075;
import org.alfresco.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermDocs;
import org.apache.lucene.index.TermEnum;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.PrefixQuery;
import org.apache.lucene.search.Query;
import org.springframework.extensions.surf.util.I18NUtil;

public class AVMLuceneIndexerImpl
extends AbstractLuceneIndexerImpl<String>
implements AVMLuceneIndexer {
    private static String SNAP_SHOT_ID = "SnapShot";
    static Log s_logger = LogFactory.getLog(AVMLuceneIndexerImpl.class);
    private AVMService avmService;
    private AVMSyncService avmSyncService;
    private ContentStore contentStore;
    private ContentService contentService;
    private TransformerDebug transformerDebug;
    private FTSIndexerAware callBack;
    private FullTextSearchIndexer fullTextSearchIndexer;
    private int remainingCount;
    private int startVersion = -1;
    private int endVersion = -1;
    protected Set<String> deletionsSinceFlush = new HashSet<String>();
    private long indexedDocCount = 0L;

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setAvmSyncService(AVMSyncService avmSyncService) {
        this.avmSyncService = avmSyncService;
    }

    public void setContentStore(ContentStore contentStore) {
        this.contentStore = contentStore;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setTransformerDebug(TransformerDebug transformerDebug) {
        this.transformerDebug = transformerDebug;
    }

    @Override
    public boolean getDeleteOnlyNodes() {
        return this.indexUpdateStatus == AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS;
    }

    public static AVMLuceneIndexerImpl getUpdateIndexer(StoreRef storeRef, String deltaId, LuceneConfig config) throws LuceneIndexException {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)"Creating indexer");
        }
        AVMLuceneIndexerImpl indexer = new AVMLuceneIndexerImpl();
        indexer.setLuceneConfig(config);
        indexer.initialise(storeRef, deltaId);
        return indexer;
    }

    @Override
    public void index(String store, int srcVersion, int dstVersion, IndexMode mode) {
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            switch (mode) {
                case ASYNCHRONOUS: {
                    this.asynchronousIndex(store, srcVersion, dstVersion);
                    break;
                }
                case SYNCHRONOUS: {
                    this.synchronousIndex(store, srcVersion, dstVersion);
                    break;
                }
            }
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("snapshot index failed", (Throwable)((Object)e));
        }
    }

    private void asynchronousIndex(String store, int srcVersion, int dstVersion) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Async index for " + store + " from " + srcVersion + " to " + dstVersion));
        }
        this.index("\u0000BG:STORE:" + store + ":" + srcVersion + ":" + dstVersion + ":" + GUID.generate());
        this.fullTextSearchIndexer.requiresIndex(AVMNodeConverter.ToStoreRef(store));
    }

    private void synchronousIndex(String store, int srcVersion, int dstVersion) {
        if (this.startVersion == -1) {
            this.startVersion = srcVersion;
        }
        this.endVersion = dstVersion;
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Sync index for " + store + " from " + srcVersion + " to " + dstVersion));
        }
        String path = store + ":/";
        List<AVMDifference> changeList = null;
        try {
            changeList = this.avmSyncService.compare(srcVersion, path, dstVersion, path, null);
        }
        catch (AVMSyncException e) {
            s_logger.warn((Object)("\nUnable to generate change list for synchronous indexing: \n   Store:         " + store + "\n" + "   Start version: " + srcVersion + "\n" + "   End version:   " + this.endVersion));
            return;
        }
        for (AVMDifference difference : changeList) {
            switch (difference.getDifferenceCode()) {
                case 0: 
                case 1: 
                case 2: {
                    AVMNodeDescriptor srcDesc = this.avmService.lookup(difference.getSourceVersion(), difference.getSourcePath(), true);
                    AVMNodeDescriptor dstDesc = this.avmService.lookup(difference.getDestinationVersion(), difference.getDestinationPath(), true);
                    if (srcDesc == null) {
                        if (dstDesc == null) {
                            if (!s_logger.isDebugEnabled()) break;
                            s_logger.debug((Object)("Skipped - src & dst deleted / not there: " + difference));
                            break;
                        }
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("new: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                        }
                        this.reindex(difference.getDestinationPath(), dstDesc.isDirectory());
                        if (dstDesc.isDirectory()) {
                            this.indexDirectory(dstDesc);
                        }
                        this.reindexAllAncestors(difference.getDestinationPath());
                        break;
                    }
                    if (srcDesc.isDeleted()) {
                        if (dstDesc == null || dstDesc.isDeleted()) {
                            if (!s_logger.isDebugEnabled()) break;
                            s_logger.debug((Object)("Skipped - src & dst deleted / not there: " + difference));
                            break;
                        }
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("back: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                        }
                        this.reindex(difference.getDestinationPath(), dstDesc.isDirectory());
                        if (dstDesc.isDirectory()) {
                            this.indexDirectory(dstDesc);
                        }
                        this.reindexAllAncestors(difference.getDestinationPath());
                        break;
                    }
                    if (dstDesc == null) {
                        if (!s_logger.isDebugEnabled()) break;
                        s_logger.debug((Object)("unknown: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                        break;
                    }
                    if (dstDesc.isDeleted()) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("delete: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                        }
                        this.delete(difference.getSourcePath());
                        this.reindexAllAncestors(difference.getSourcePath());
                        this.delete(difference.getDestinationPath());
                        this.reindexAllAncestors(difference.getDestinationPath());
                        break;
                    }
                    if (!difference.getSourcePath().equals(difference.getDestinationPath())) {
                        if (s_logger.isDebugEnabled()) {
                            s_logger.debug((Object)("move: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                        }
                        this.reindex(difference.getSourcePath(), srcDesc.isDirectory());
                        this.reindex(difference.getDestinationPath(), dstDesc.isDirectory());
                        this.reindexAllAncestors(difference.getSourcePath());
                        this.reindexAllAncestors(difference.getDestinationPath());
                        break;
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("update: (" + srcVersion + ", " + dstVersion + ") " + difference.getDestinationPath()));
                    }
                    this.reindex(difference.getDestinationPath(), false);
                    this.reindexAllAncestors(difference.getDestinationPath());
                    break;
                }
                case 3: {
                    break;
                }
            }
        }
        this.reindex(SNAP_SHOT_ID + ":" + store + ":" + srcVersion + ":" + dstVersion, false);
    }

    private void reindexAllAncestors(String destinationPath) {
        String[] splitPath = this.splitPath(destinationPath);
        String store = splitPath[0];
        String pathInStore = splitPath[1];
        SimplePath simplePath = new SimplePath(pathInStore);
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append(store).append(":/");
        this.reindex(pathBuilder.toString(), false);
        boolean requiresSep = false;
        for (int i = 0; i < simplePath.size() - 1; ++i) {
            if (requiresSep) {
                pathBuilder.append("/");
            } else {
                requiresSep = true;
            }
            pathBuilder.append(simplePath.get(i));
            this.reindex(pathBuilder.toString(), false);
        }
    }

    private void indexDirectory(AVMNodeDescriptor dir) {
        SortedMap<String, AVMNodeDescriptor> children = this.avmService.getDirectoryListing(dir, false);
        for (AVMNodeDescriptor child : children.values()) {
            this.reindex(child.getPath(), child.isDirectory());
            this.reindexAllAncestors(child.getPath());
            if (!child.isDirectory()) continue;
            this.indexDirectory(child);
        }
    }

    protected Set<String> deleteImpl(String nodeRef, IndexDeleteMode mode, boolean cascade, IndexReader mainReader) throws LuceneIndexException, IOException {
        LinkedHashSet<String> leafrefs = new LinkedHashSet<String>();
        IndexReader deltaReader = null;
        this.getDeltaReader();
        LinkedHashSet<String> refs = new LinkedHashSet<String>();
        LinkedHashSet<String> containerRefs = new LinkedHashSet<String>();
        Set<String> temp = null;
        switch (mode) {
            case REINDEX: {
                temp = AVMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade);
                this.closeDeltaReader();
                refs.addAll(temp);
                this.deletions.addAll(temp);
                temp = AVMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, cascade);
                refs.addAll(temp);
                this.deletions.addAll(temp);
                break;
            }
            case DELETE: {
                if (this.deletionsSinceFlush.contains(nodeRef)) break;
                temp = AVMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, this.getDeltaReader(), true, cascade);
                this.closeDeltaReader();
                containerRefs.addAll(temp);
                refs.addAll(temp);
                temp = AVMLuceneIndexerImpl.deleteContainerAndBelow(nodeRef, mainReader, false, cascade);
                containerRefs.addAll(temp);
                temp = AVMLuceneIndexerImpl.deletePrimary(containerRefs, this.getDeltaReader(), true);
                leafrefs.addAll(temp);
                this.closeDeltaReader();
                temp = AVMLuceneIndexerImpl.deletePrimary(containerRefs, mainReader, false);
                leafrefs.addAll(temp);
                temp = AVMLuceneIndexerImpl.deleteReference(containerRefs, this.getDeltaReader(), true);
                leafrefs.addAll(temp);
                this.closeDeltaReader();
                temp = AVMLuceneIndexerImpl.deleteReference(containerRefs, mainReader, false);
                leafrefs.addAll(temp);
                refs.addAll(containerRefs);
                refs.addAll(leafrefs);
                this.deletions.addAll(refs);
                this.deletionsSinceFlush.addAll(refs);
                deltaReader = this.getDeltaReader();
                for (String id : leafrefs) {
                    deltaReader.deleteDocuments(new Term("ID", id));
                }
                this.closeDeltaReader();
            }
        }
        return refs;
    }

    protected List<Document> createDocuments(String stringNodeRef, AbstractLuceneIndexerImpl.FTSStatus ftsStatus, boolean indexAllProperties, boolean includeDirectoryDocuments) {
        ArrayList<Document> docs = new ArrayList<Document>();
        if (stringNodeRef.startsWith("\u0000")) {
            Document idoc = new Document();
            idoc.add((Fieldable)new Field("ID", stringNodeRef, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            docs.add(idoc);
            return docs;
        }
        if (stringNodeRef.startsWith(SNAP_SHOT_ID)) {
            Document sdoc = new Document();
            sdoc.add((Fieldable)new Field("ID", stringNodeRef, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            docs.add(sdoc);
            return docs;
        }
        AVMNodeDescriptor desc = this.avmService.lookup(this.endVersion, stringNodeRef);
        if (desc == null) {
            return docs;
        }
        if (desc.isLayeredDirectory() || desc.isLayeredFile()) {
            this.incrementDocCount();
            return docs;
        }
        AVMNode node = AVMDAOs.Instance().fAVMNodeDAO.getByID(desc.getId());
        if (desc != null) {
            Boolean isIndexed;
            Serializable sValue;
            Boolean isIndexed2;
            Serializable sValue2;
            NodeRef nodeRef = AVMNodeConverter.ToNodeRef(this.endVersion, stringNodeRef);
            Document xdoc = new Document();
            xdoc.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("ID", stringNodeRef, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            xdoc.add((Fieldable)new Field("TX", AlfrescoTransactionSupport.getTransactionId(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
            boolean isAtomic = true;
            Map<QName, Serializable> properties = this.getIndexableProperties(desc, nodeRef, this.endVersion, stringNodeRef);
            if (properties.containsKey(ContentModel.PROP_IS_INDEXED) && (sValue2 = properties.get(ContentModel.PROP_IS_INDEXED)) != null && (isIndexed2 = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue2)) != null && !isIndexed2.booleanValue()) {
                return docs;
            }
            boolean isContentIndexedForNode = true;
            if (properties.containsKey(ContentModel.PROP_IS_CONTENT_INDEXED) && (sValue = properties.get(ContentModel.PROP_IS_CONTENT_INDEXED)) != null && (isIndexed = (Boolean)DefaultTypeConverter.INSTANCE.convert(Boolean.class, (Object)sValue)) != null && !isIndexed.booleanValue()) {
                isContentIndexedForNode = false;
            }
            for (QName propertyName : properties.keySet()) {
                Serializable value = properties.get(propertyName);
                if (indexAllProperties) {
                    this.indexProperty(nodeRef, propertyName, value, xdoc, false, properties, isContentIndexedForNode);
                    continue;
                }
                isAtomic &= this.indexProperty(nodeRef, propertyName, value, xdoc, true, properties, isContentIndexedForNode);
            }
            StringBuilder qNameBuffer = new StringBuilder(64);
            if (!node.getIsRoot()) {
                String[] splitPath = this.splitPath(stringNodeRef);
                String store = splitPath[0];
                String pathInStore = splitPath[1];
                SimplePath simplePath = new SimplePath(pathInStore);
                StringBuilder xpathBuilder = new StringBuilder();
                for (int i = 0; i < simplePath.size(); ++i) {
                    xpathBuilder.append("/{}").append(ISO9075.encode((String)simplePath.get(i)));
                }
                String xpath = xpathBuilder.toString();
                if (qNameBuffer.length() > 0) {
                    qNameBuffer.append(";/");
                }
                ArrayList<String> ancestors = new ArrayList<String>();
                StringBuilder pathBuilder = new StringBuilder();
                pathBuilder.append(store).append(":/");
                ancestors.add(pathBuilder.toString());
                boolean requiresSep = false;
                for (int i = 0; i < simplePath.size() - 1; ++i) {
                    if (requiresSep) {
                        pathBuilder.append("/");
                    } else {
                        requiresSep = true;
                    }
                    pathBuilder.append(simplePath.get(i));
                    ancestors.add(pathBuilder.toString());
                }
                qNameBuffer.append(ISO9075.getXPathName((QName)QName.createQName((String)"", (String)simplePath.get(simplePath.size() - 1))));
                xdoc.add((Fieldable)new Field("PARENT", (String)ancestors.get(ancestors.size() - 1), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                if (includeDirectoryDocuments && desc.isDirectory()) {
                    Document directoryEntry = new Document();
                    directoryEntry.add((Fieldable)new Field("ID", nodeRef.toString(), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    directoryEntry.add((Fieldable)new Field("ID", stringNodeRef, Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    directoryEntry.add((Fieldable)new Field("PATH", xpath, Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
                    for (String toAdd : ancestors) {
                        directoryEntry.add((Fieldable)new Field("ANCESTOR", toAdd, Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    }
                    directoryEntry.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                    docs.add(directoryEntry);
                }
            }
            if (node.getIsRoot()) {
                xdoc.add((Fieldable)new Field("ISCONTAINER", "T", Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("PATH", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("QNAME", "", Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("ISROOT", "T", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                docs.add(xdoc);
            } else {
                xdoc.add((Fieldable)new Field("QNAME", qNameBuffer.toString(), Field.Store.YES, Field.Index.TOKENIZED, Field.TermVector.NO));
                QName typeQName = this.getType(desc);
                xdoc.add((Fieldable)new Field("TYPE", ISO9075.getXPathName((QName)typeQName), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                for (QName classRef : this.avmService.getAspects(desc)) {
                    xdoc.add((Fieldable)new Field("ASPECT", ISO9075.getXPathName((QName)classRef), Field.Store.YES, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                }
                xdoc.add((Fieldable)new Field("ISROOT", "F", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                xdoc.add((Fieldable)new Field("ISNODE", "T", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                docs.add(xdoc);
            }
        } else {
            boolean root = node.getIsRoot();
            boolean deleted = desc.isDeleted();
            System.out.println("Is Root " + root);
            System.out.println("Is deleted " + deleted);
        }
        this.incrementDocCount();
        return docs;
    }

    protected List<Document> readDocuments(final String stringNodeRef, final AbstractLuceneIndexerImpl.FTSStatus ftsStatus, final boolean indexAllProperties, final boolean includeDirectoryDocuments) {
        return this.doInReadthroughTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<List<Document>>(){

            @Override
            public List<Document> execute() throws Throwable {
                return AVMLuceneIndexerImpl.this.createDocuments(stringNodeRef, ftsStatus, indexAllProperties, includeDirectoryDocuments);
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void indexImpl(String nodeRef, boolean isNew) throws LuceneIndexException, IOException {
        IndexWriter writer = this.getDeltaWriter();
        try {
            List<Document> docs = this.readDocuments(nodeRef, isNew ? AbstractLuceneIndexerImpl.FTSStatus.New : AbstractLuceneIndexerImpl.FTSStatus.Dirty, false, true);
            for (Document doc : docs) {
                try {
                    writer.addDocument(doc);
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to add document to index", e);
                    return;
                }
            }
        }
        catch (InvalidNodeRefException e) {
            return;
        }
    }

    void indexImpl(Set<String> refs, boolean isNew) throws LuceneIndexException, IOException {
        for (String ref : refs) {
            this.indexImpl(ref, isNew);
        }
    }

    @Override
    public void flushPending() throws LuceneIndexException {
        IndexReader mainReader = null;
        try {
            this.saveDelta();
            this.deletionsSinceFlush.clear();
            if (this.commandList.isEmpty()) {
                return;
            }
            mainReader = this.getReader();
            LinkedHashSet<String> forIndex = new LinkedHashSet<String>();
            for (AbstractLuceneIndexerImpl.Command command : this.commandList) {
                Set<String> set;
                if (command.action == AbstractLuceneIndexerImpl.Action.INDEX) {
                    forIndex.add(((String)command.ref).toString());
                    continue;
                }
                if (command.action == AbstractLuceneIndexerImpl.Action.REINDEX) {
                    set = this.deleteImpl(((String)command.ref).toString(), IndexDeleteMode.REINDEX, false, mainReader);
                    forIndex.removeAll(set);
                    forIndex.addAll(set);
                    continue;
                }
                if (command.action == AbstractLuceneIndexerImpl.Action.CASCADEREINDEX) {
                    set = this.deleteImpl(((String)command.ref).toString(), IndexDeleteMode.REINDEX, true, mainReader);
                    forIndex.removeAll(set);
                    forIndex.addAll(set);
                    continue;
                }
                if (command.action != AbstractLuceneIndexerImpl.Action.DELETE) continue;
                set = this.deleteImpl(((String)command.ref).toString(), IndexDeleteMode.DELETE, true, mainReader);
                forIndex.removeAll(set);
                forIndex.addAll(set);
            }
            this.commandList.clear();
            this.indexImpl(forIndex, false);
            this.docs = this.getDeltaWriter().docCount();
            this.deletionsSinceFlush.clear();
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to flush index", e);
        }
        finally {
            if (mainReader != null) {
                try {
                    mainReader.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
            }
            try {
                this.closeDeltaReader();
            }
            catch (IOException e) {}
            try {
                this.closeDeltaWriter();
            }
            catch (IOException e) {}
        }
    }

    private String[] splitPath(String path) {
        String[] pathParts = path.split(":");
        if (pathParts.length != 2) {
            throw new AVMException("Invalid path: " + path);
        }
        return pathParts;
    }

    private QName getType(AVMNodeDescriptor desc) {
        if (desc.isPlainDirectory()) {
            return WCMModel.TYPE_AVM_PLAIN_FOLDER;
        }
        if (desc.isPlainFile()) {
            return WCMModel.TYPE_AVM_PLAIN_CONTENT;
        }
        if (desc.isLayeredDirectory()) {
            return WCMModel.TYPE_AVM_LAYERED_FOLDER;
        }
        return WCMModel.TYPE_AVM_LAYERED_CONTENT;
    }

    private Map<QName, Serializable> getIndexableProperties(AVMNodeDescriptor desc, NodeRef nodeRef, Integer version, String path) {
        Map<QName, PropertyValue> properties = this.avmService.getNodeProperties(desc);
        HashMap<QName, Serializable> result = new HashMap<QName, Serializable>();
        for (QName qName : properties.keySet()) {
            PropertyValue value = properties.get(qName);
            PropertyDefinition def = this.getDictionaryService().getProperty(qName);
            result.put(qName, this.makeSerializableValue(def, value));
        }
        result.put(ContentModel.PROP_CREATED, new Date(desc.getCreateDate()));
        result.put(ContentModel.PROP_CREATOR, (Serializable)((Object)desc.getCreator()));
        result.put(ContentModel.PROP_MODIFIED, new Date(desc.getModDate()));
        result.put(ContentModel.PROP_MODIFIER, (Serializable)((Object)desc.getLastModifier()));
        result.put(ContentModel.PROP_OWNER, (Serializable)((Object)desc.getOwner()));
        result.put(ContentModel.PROP_NAME, (Serializable)((Object)desc.getName()));
        result.put(ContentModel.PROP_NODE_UUID, (Serializable)((Object)"UNKNOWN"));
        result.put(ContentModel.PROP_NODE_DBID, new Long(desc.getId()));
        result.put(ContentModel.PROP_STORE_PROTOCOL, (Serializable)((Object)"avm"));
        result.put(ContentModel.PROP_STORE_IDENTIFIER, (Serializable)((Object)nodeRef.getStoreRef().getIdentifier()));
        if (desc.isLayeredDirectory()) {
            result.put(WCMModel.PROP_AVM_DIR_INDIRECTION, (Serializable)AVMNodeConverter.ToNodeRef(this.endVersion, desc.getIndirection()));
        }
        if (desc.isLayeredFile()) {
            result.put(WCMModel.PROP_AVM_FILE_INDIRECTION, (Serializable)AVMNodeConverter.ToNodeRef(this.endVersion, desc.getIndirection()));
        }
        if (desc.isFile()) {
            try {
                ContentData contentData = null;
                contentData = desc.isPlainFile() ? this.avmService.getContentDataForRead(desc) : this.avmService.getContentDataForRead(this.endVersion, path);
                result.put(ContentModel.PROP_CONTENT, (Serializable)contentData);
            }
            catch (AVMException e) {
                // empty catch block
            }
        }
        return result;
    }

    protected Serializable makeSerializableValue(PropertyDefinition propertyDef, PropertyValue propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        QName propertyTypeQName = null;
        propertyTypeQName = propertyDef == null ? DataTypeDefinition.ANY : propertyDef.getDataType().getName();
        try {
            Serializable value = propertyValue.getValue(propertyTypeQName);
            return value;
        }
        catch (TypeConversionException e) {
            throw new TypeConversionException("The property value is not compatible with the type defined for the property: \n   property: " + (propertyDef == null ? "unknown" : propertyDef) + "\n" + "   property value: " + propertyValue, (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean indexProperty(NodeRef banana, QName propertyName, Serializable value, Document doc, boolean indexAtomicPropertiesOnly, Map<QName, Serializable> properties, boolean isContentIndexedForNode) {
        String attributeName = "@" + QName.createQName((String)propertyName.getNamespaceURI(), (String)ISO9075.encode((String)propertyName.getLocalName()));
        boolean store = true;
        boolean index = true;
        IndexTokenisationMode tokenise = IndexTokenisationMode.TRUE;
        boolean atomic = true;
        boolean isContent = false;
        boolean isMultiLingual = false;
        boolean isText = false;
        boolean isDateTime = false;
        PropertyDefinition propertyDef = this.getDictionaryService().getProperty(propertyName);
        if (propertyDef != null) {
            index = propertyDef.isIndexed();
            store = propertyDef.isStoredInIndex();
            tokenise = propertyDef.getIndexTokenisationMode();
            atomic = propertyDef.isIndexedAtomically();
            isContent = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.CONTENT);
            isMultiLingual = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.MLTEXT);
            isText = propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.TEXT);
            if (propertyDef.getDataType().getName().equals((Object)DataTypeDefinition.DATETIME)) {
                String analyserClassName = propertyDef.resolveAnalyserClassName();
                isDateTime = analyserClassName.equals(DateTimeAnalyser.class.getCanonicalName());
            }
        }
        if (value == null) {
            return true;
        }
        if (!indexAtomicPropertiesOnly) {
            doc.removeFields(propertyName.toString());
        }
        block39: for (Serializable serializableValue : DefaultTypeConverter.INSTANCE.getCollection(Serializable.class, (Object)value)) {
            Field.Index fieldIndex;
            Field.Store fieldStore;
            StringBuilder builder;
            String strValue = null;
            try {
                strValue = (String)DefaultTypeConverter.INSTANCE.convert(String.class, (Object)serializableValue);
            }
            catch (TypeConversionException e) {
                doc.add((Fieldable)new Field(attributeName, "nintc", Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                continue;
            }
            if (strValue == null) continue;
            if (isContent) {
                ContentData contentData = (ContentData)DefaultTypeConverter.INSTANCE.convert(ContentData.class, (Object)serializableValue);
                if (!index || contentData == null || contentData.getMimetype() == null) continue;
                doc.add((Fieldable)new Field(attributeName + ".mimetype", contentData.getMimetype(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                doc.add((Fieldable)new Field(attributeName + ".size", Long.toString(contentData.getSize()), Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                Locale locale = contentData.getLocale();
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                doc.add((Fieldable)new Field(attributeName + ".locale", locale.toString().toLowerCase(), Field.Store.NO, Field.Index.UN_TOKENIZED, Field.TermVector.NO));
                if (isContentIndexedForNode) {
                    ContentReader reader = null;
                    try {
                        reader = this.contentService.getRawReader(contentData.getContentUrl());
                        reader.setEncoding(contentData.getEncoding());
                        reader.setLocale(contentData.getLocale());
                        reader.setMimetype(contentData.getMimetype());
                    }
                    catch (Exception e) {
                        reader = null;
                    }
                    if (reader != null && reader.exists()) {
                        boolean readerReady;
                        block73: {
                            readerReady = true;
                            if (!EqualsHelper.nullSafeEquals((Object)reader.getMimetype(), (Object)"text/plain") || !EqualsHelper.nullSafeEquals((Object)reader.getEncoding(), (Object)"UTF-8")) {
                                try {
                                    TransformationOptions options = new TransformationOptions();
                                    options.setUse("index");
                                    options.setSourceNodeRef(banana);
                                    this.transformerDebug.pushAvailable(reader.getContentUrl(), reader.getMimetype(), "text/plain", options);
                                    long sourceSize = reader.getSize();
                                    List<ContentTransformer> transformers = this.contentService.getActiveTransformers(reader.getMimetype(), sourceSize, "text/plain", options);
                                    this.transformerDebug.availableTransformers(transformers, sourceSize, options, "AVMLuceneIndexer");
                                    if (transformers.isEmpty()) {
                                        if (s_logger.isDebugEnabled()) {
                                            s_logger.debug((Object)("Not indexed: No transformation: \n   source: " + reader + "\n" + "   target: " + "text/plain"));
                                        }
                                        readerReady = false;
                                        doc.add((Fieldable)new Field(attributeName, "nint", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                                        break block73;
                                    }
                                    ContentTransformer transformer = transformers.get(0);
                                    ContentWriter writer = this.contentService.getTempWriter();
                                    writer.setMimetype("text/plain");
                                    writer.setEncoding("UTF-8");
                                    try {
                                        transformer.transform(reader, writer, options);
                                        reader = writer.getReader();
                                        if (!reader.exists()) {
                                            throw new ContentIOException("The transformation did not write any content, yet: \n   transformer:     " + transformer + "\n" + "   temp writer:     " + writer);
                                        }
                                    }
                                    catch (ContentIOException e) {
                                        if (s_logger.isDebugEnabled()) {
                                            s_logger.debug((Object)"Not indexed: Transformation failed", (Throwable)e);
                                        }
                                        readerReady = false;
                                        doc.add((Fieldable)new Field(attributeName, "nitf", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                                    }
                                }
                                finally {
                                    this.transformerDebug.popAvailable();
                                }
                            }
                        }
                        if (!readerReady) continue;
                        InputStreamReader isr = null;
                        InputStream ris = reader.getReader().getContentInputStream();
                        try {
                            isr = new InputStreamReader(ris, "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            isr = new InputStreamReader(ris);
                        }
                        builder = new StringBuilder();
                        builder.append("\u0000").append(locale.toString()).append("\u0000");
                        StringReader prefix = new StringReader(builder.toString());
                        MultiReader multiReader = new MultiReader((Reader)prefix, (Reader)isr);
                        doc.add((Fieldable)new Field(attributeName, (Reader)multiReader, Field.TermVector.NO));
                        continue;
                    }
                    if (s_logger.isDebugEnabled()) {
                        s_logger.debug((Object)("Not indexed: Content Missing \n   node: " + banana + "\n" + "   reader: " + reader + "\n" + "   content exists: " + (reader == null ? " --- " : Boolean.toString(reader.exists()))));
                    }
                    doc.add((Fieldable)new Field(attributeName, "nicm", Field.Store.NO, Field.Index.TOKENIZED, Field.TermVector.NO));
                    continue;
                }
                return true;
            }
            Field.Store store2 = fieldStore = store ? Field.Store.YES : Field.Store.NO;
            if (index) {
                switch (tokenise) {
                    default: {
                        fieldIndex = Field.Index.TOKENIZED;
                        break;
                    }
                    case FALSE: {
                        fieldIndex = Field.Index.UN_TOKENIZED;
                        break;
                    }
                }
            } else {
                fieldIndex = Field.Index.NO;
            }
            if (fieldIndex == Field.Index.NO && fieldStore == Field.Store.NO) continue;
            if (isMultiLingual) {
                MLText mlText = (MLText)DefaultTypeConverter.INSTANCE.convert(MLText.class, (Object)serializableValue);
                block40: for (Locale locale : mlText.getLocales()) {
                    String localeString = mlText.getValue(locale);
                    switch (tokenise) {
                        case TRUE: {
                            builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            break;
                        }
                        case FALSE: {
                            int end;
                            String localeText;
                            Token t;
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() > 0) {
                                        doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                    }
                                    doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block40;
                            }
                            catch (IOException e) {
                                break;
                            }
                        }
                        case BOTH: {
                            int end;
                            String localeText;
                            Token t;
                            builder = new StringBuilder();
                            builder.append("\u0000").append(locale.toString()).append("\u0000").append(localeString);
                            doc.add((Fieldable)new Field(attributeName, builder.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                            MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                            VerbatimAnalyser vba = new VerbatimAnalyser(false);
                            MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(localeString)), locale, null, analysisMode);
                            try {
                                while ((t = duplicator.next()) != null) {
                                    localeText = "";
                                    if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                        localeText = t.termText().substring(1, end);
                                    }
                                    if (localeText.length() <= 0) continue;
                                    doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                continue block40;
                            }
                            catch (IOException e) {
                                // empty catch block
                            }
                        }
                    }
                }
                continue;
            }
            if (isText) {
                if (propertyName.equals((Object)ContentModel.PROP_USER_USERNAME) || propertyName.equals((Object)ContentModel.PROP_USERNAME) || propertyName.equals((Object)ContentModel.PROP_AUTHORITY_NAME)) {
                    doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                }
                Locale locale = null;
                Serializable localeProperty = properties.get(ContentModel.PROP_LOCALE);
                if (localeProperty != null) {
                    locale = (Locale)DefaultTypeConverter.INSTANCE.convert(Locale.class, (Object)localeProperty);
                }
                if (locale == null) {
                    locale = I18NUtil.getLocale();
                }
                switch (tokenise) {
                    default: {
                        StringBuilder builder2 = new StringBuilder();
                        builder2.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder2.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        String localeText;
                        Token t;
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() > 0) {
                                    doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                                }
                                doc.add((Fieldable)new Field(attributeName, t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block39;
                        }
                        catch (IOException e) {
                            break;
                        }
                    }
                    case BOTH: {
                        String localeText;
                        Token t;
                        StringBuilder builder2 = new StringBuilder();
                        builder2.append("\u0000").append(locale.toString()).append("\u0000").append(strValue);
                        doc.add((Fieldable)new Field(attributeName, builder2.toString(), fieldStore, fieldIndex, Field.TermVector.NO));
                        MLAnalysisMode analysisMode = this.getLuceneConfig().getDefaultMLIndexAnalysisMode();
                        VerbatimAnalyser vba = new VerbatimAnalyser(false);
                        MLTokenDuplicator duplicator = new MLTokenDuplicator(vba.tokenStream(attributeName, (Reader)new StringReader(strValue)), locale, null, analysisMode);
                        try {
                            while ((t = duplicator.next()) != null) {
                                int end;
                                localeText = "";
                                if (t.termText().indexOf(123) == 0 && (end = t.termText().indexOf(125, 1)) != -1) {
                                    localeText = t.termText().substring(1, end);
                                }
                                if (localeText.length() <= 0) continue;
                                doc.add((Fieldable)new Field(attributeName + "." + localeText + ".sort", t.termText(), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                            }
                            continue block39;
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                }
                continue;
            }
            if (isDateTime) {
                switch (tokenise) {
                    default: {
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        break;
                    }
                    case FALSE: {
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            Date date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName, df.format(date), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                    case BOTH: {
                        doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
                        SimpleDateFormat df = CachingDateFormat.getDateFormat((String)"yyyy-MM-dd'T'HH:mm:ss.SSS", (boolean)true);
                        try {
                            Date date = df.parse(strValue);
                            doc.add((Fieldable)new Field(attributeName + ".sort", df.format(date), Field.Store.NO, Field.Index.NO_NORMS, Field.TermVector.NO));
                        }
                        catch (ParseException e) {}
                        break;
                    }
                }
                continue;
            }
            doc.add((Fieldable)new Field(attributeName, strValue, fieldStore, fieldIndex, Field.TermVector.NO));
        }
        return true;
    }

    @Override
    protected void doPrepare() throws IOException {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<String>(){

            public String doWork() throws Exception {
                AVMLuceneIndexerImpl.this.flushPending();
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    @Override
    protected void doCommit() throws IOException {
        if (this.indexUpdateStatus == AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS) {
            this.setInfo(this.docs, this.getDeletions(), this.getContainerDeletions(), false);
        } else {
            this.setInfo(this.docs, this.getDeletions(), this.getContainerDeletions(), false);
            this.fullTextSearchIndexer.requiresIndex(this.store);
        }
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, this.remainingCount, null);
        }
        this.setInfo(this.docs, this.deletions, this.containerDeletions, false);
    }

    @Override
    protected void doRollBack() throws IOException {
        if (this.callBack != null) {
            this.callBack.indexCompleted(this.store, 0, null);
        }
    }

    @Override
    protected void doSetRollbackOnly() throws IOException {
    }

    @Override
    public void createNode(ChildAssociationRef relationshipRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
            this.index(versionPath.getSecond());
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Create node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void detectNodeChanges(NodeRef nodeRef, SearchService searcher, Collection<ChildAssociationRef> addedParents, Collection<ChildAssociationRef> deletedParents, Collection<ChildAssociationRef> createdNodes, Collection<NodeRef> updatedNodes) {
        updatedNodes.add(nodeRef);
    }

    @Override
    public void updateNode(NodeRef nodeRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update node " + nodeRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(nodeRef);
            this.reindex(versionPath.getSecond(), false);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Update node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteNode(ChildAssociationRef relationshipRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete node " + relationshipRef.getChildRef()));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
            this.reindex(versionPath.getSecond(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Delete node failed", (Throwable)((Object)e));
        }
    }

    @Override
    public void createChildRelationship(ChildAssociationRef relationshipRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Create child " + relationshipRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
            this.reindex(versionPath.getSecond(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to create child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void updateChildRelationship(ChildAssociationRef relationshipBeforeRef, ChildAssociationRef relationshipAfterRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Update child " + relationshipBeforeRef + " to " + relationshipAfterRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipBeforeRef.getChildRef();
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
            this.reindex(versionPath.getSecond(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to update child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteChildRelationship(ChildAssociationRef relationshipRef) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Delete child " + relationshipRef));
        }
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            NodeRef childRef = relationshipRef.getChildRef();
            Pair<Integer, String> versionPath = AVMNodeConverter.ToAVMVersionPath(childRef);
            this.reindex(versionPath.getSecond(), true);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed to delete child relationship", (Throwable)((Object)e));
        }
    }

    @Override
    public void deleteIndex(String store, IndexMode mode) {
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            switch (mode) {
                case ASYNCHRONOUS: {
                    this.asyncronousDeleteIndex(store);
                    break;
                }
                case SYNCHRONOUS: {
                    this.syncronousDeleteIndex(store);
                    break;
                }
            }
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Delete index failed", (Throwable)((Object)e));
        }
    }

    public void syncronousDeleteIndex(String store) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Sync delete for " + store));
        }
        this.deleteAll();
    }

    public void asyncronousDeleteIndex(String store) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Async delete for " + store));
        }
        this.index("\u0000BG:DELETE:" + store + ":" + GUID.generate());
        this.fullTextSearchIndexer.requiresIndex(AVMNodeConverter.ToStoreRef(store));
    }

    @Override
    public void createIndex(String store, IndexMode mode) {
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.SYNCRONOUS);
        try {
            switch (mode) {
                case ASYNCHRONOUS: {
                    this.asyncronousCreateIndex(store);
                    break;
                }
                case SYNCHRONOUS: {
                    this.syncronousCreateIndex(store);
                    break;
                }
            }
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Create index failed", (Throwable)((Object)e));
        }
    }

    public void syncronousCreateIndex(String store) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Sync create for " + store));
        }
        AVMNodeDescriptor rootDesc = this.avmService.getStoreRoot(-1, store);
        this.index(store + ":/");
    }

    public void asyncronousCreateIndex(String store) {
        if (s_logger.isDebugEnabled()) {
            s_logger.debug((Object)("Async create for " + store));
        }
        this.index("\u0000BG:CREATE:" + store + ":" + GUID.generate());
        this.fullTextSearchIndexer.requiresIndex(AVMNodeConverter.ToStoreRef(store));
    }

    @Override
    public void registerCallBack(FTSIndexerAware callBack) {
        this.callBack = callBack;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int updateFullTextSearch(int size) {
        this.checkAbleToDoWork(AbstractLuceneIndexerImpl.IndexUpdateStatus.ASYNCHRONOUS);
        try {
            PrefixQuery query = new PrefixQuery(new Term("ID", "\u0000BG:"));
            String action = null;
            ClosingIndexSearcher searcher = null;
            try {
                Hits hits;
                searcher = this.getSearcher(null);
                if (searcher == null) {
                    this.remainingCount = size;
                    int n = 0;
                    return n;
                }
                try {
                    hits = searcher.search((Query)query);
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Failed to execute query to find content which needs updating in the index", e);
                }
                if (hits.length() > 0) {
                    Document doc = hits.doc(0);
                    action = doc.getField("ID").stringValue();
                    String[] split = action.split(":");
                    if (split[1].equals("DELETE")) {
                        this.deleteAll("\u0000BG:");
                    } else if (split[1].equals("CREATE")) {
                        this.syncronousCreateIndex(split[2]);
                    } else if (split[1].equals("STORE")) {
                        this.synchronousIndex(split[2], Integer.parseInt(split[3]), Integer.parseInt(split[4]));
                    }
                    this.deletions.add(action);
                    this.remainingCount = hits.length() - 1;
                    int n = 1;
                    return n;
                }
                this.remainingCount = 0;
                int n = 0;
                return n;
            }
            finally {
                if (searcher != null) {
                    try {
                        searcher.close();
                    }
                    catch (IOException e) {
                        throw new LuceneIndexException("Failed to close searcher", e);
                    }
                }
            }
        }
        catch (IOException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", e);
        }
        catch (LuceneIndexException e) {
            this.setRollbackOnly();
            throw new LuceneIndexException("Failed FTS update", (Throwable)((Object)e));
        }
    }

    @Override
    public void setFullTextSearchIndexer(FullTextSearchIndexer fullTextSearchIndexer) {
        this.fullTextSearchIndexer = fullTextSearchIndexer;
    }

    @Override
    public boolean isSnapshotIndexed(String store, int id) {
        if (id == 0) {
            return this.hasIndexBeenCreated(store);
        }
        return this.isSynchronousSnapshotPresent(store, id) || this.isAsynchronousSnapshotPresent(store, id);
    }

    private boolean isSynchronousSnapshotPresent(String store, int id) {
        return this.isSynchronousSnapshotPresent(store, IndexChannel.MAIN, id) || this.isSynchronousSnapshotPresent(store, IndexChannel.DELTA, id);
    }

    private boolean isAsynchronousSnapshotPresent(String store, int id) {
        return this.isAsynchronousSnapshotPresent(store, IndexChannel.MAIN, id) || this.isAsynchronousSnapshotPresent(store, IndexChannel.DELTA, id);
    }

    @Override
    public boolean isSnapshotSearchable(String store, int id) {
        if (id == 0) {
            return this.hasIndexBeenCreated(store);
        }
        return this.isSynchronousSnapshotPresent(store, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isSynchronousSnapshotPresent(String store, IndexChannel channel, int snapshot) {
        String prefix = SNAP_SHOT_ID + ":" + store + ":";
        IndexReader reader = null;
        try {
            block27: {
                if (channel == IndexChannel.DELTA) {
                    this.flushPending();
                    reader = this.getDeltaReader();
                } else {
                    reader = this.getReader();
                }
                try (TermEnum terms = null;){
                    Term term;
                    terms = reader.terms(new Term("ID", prefix));
                    if (terms.term() == null) break block27;
                    while ((term = terms.term()).text().startsWith(prefix)) {
                        try (TermDocs docs = null;){
                            String[] split;
                            int test;
                            docs = reader.termDocs(term);
                            if (docs.next() && (test = Integer.parseInt((split = term.text().split(":"))[3])) == snapshot) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IO error", (Throwable)e);
        }
        finally {
            block29: {
                try {
                    if (reader == null) break block29;
                    if (channel == IndexChannel.DELTA) {
                        this.closeDeltaReader();
                    } else {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean isAsynchronousSnapshotPresent(String store, IndexChannel channel, int snapshot) {
        String prefix = "\u0000BG:STORE:" + store + ":";
        IndexReader reader = null;
        try {
            block27: {
                if (channel == IndexChannel.DELTA) {
                    this.flushPending();
                    reader = this.getDeltaReader();
                } else {
                    reader = this.getReader();
                }
                try (TermEnum terms = null;){
                    Term term;
                    terms = reader.terms(new Term("ID", prefix));
                    if (terms.term() == null) break block27;
                    while ((term = terms.term()).text().startsWith(prefix)) {
                        try (TermDocs docs = null;){
                            String[] split;
                            int test;
                            docs = reader.termDocs(term);
                            if (docs.next() && (test = Integer.parseInt((split = term.text().split(":"))[4])) == snapshot) {
                                boolean bl = true;
                                return bl;
                            }
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
            }
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IO error", (Throwable)e);
        }
        finally {
            block29: {
                try {
                    if (reader == null) break block29;
                    if (channel == IndexChannel.DELTA) {
                        this.closeDeltaReader();
                    } else {
                        reader.close();
                    }
                }
                catch (IOException e) {
                    s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
                }
            }
        }
    }

    @Override
    public boolean hasIndexBeenCreated(String store) {
        return this.hasIndexBeenCreatedimpl(store, IndexChannel.MAIN) || this.hasIndexBeenCreatedimpl(store, IndexChannel.DELTA);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasIndexBeenCreatedimpl(String store, IndexChannel channel) {
        IndexReader reader = null;
        try {
            boolean bl;
            block18: {
                if (channel == IndexChannel.DELTA) {
                    this.flushPending();
                    reader = this.getDeltaReader();
                } else {
                    reader = this.getReader();
                }
                TermDocs termDocs = null;
                try {
                    termDocs = reader.termDocs(new Term("ISROOT", "T"));
                    bl = termDocs.next();
                    if (termDocs == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (termDocs != null) {
                            termDocs.close();
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new AlfrescoRuntimeException("IO error", (Throwable)e);
                    }
                }
                termDocs.close();
            }
            return bl;
        }
        finally {
            try {
                if (reader != null) {
                    if (channel == IndexChannel.DELTA) {
                        this.closeDeltaReader();
                    } else {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
            }
        }
    }

    @Override
    public synchronized long getIndexedDocCount() {
        return this.indexedDocCount;
    }

    private synchronized void incrementDocCount() {
        ++this.indexedDocCount;
    }

    @Override
    public int getLastIndexedSnapshot(String store) {
        int last = this.getLastAsynchronousSnapshot(store);
        if (last > 0) {
            return last;
        }
        last = this.getLastSynchronousSnapshot(store);
        if (last > 0) {
            return last;
        }
        return this.hasIndexBeenCreated(store) ? 0 : -1;
    }

    private int getLastSynchronousSnapshot(String store) {
        int answer = this.getLastSynchronousSnapshot(store, IndexChannel.DELTA);
        if (answer >= 0) {
            return answer;
        }
        answer = this.getLastSynchronousSnapshot(store, IndexChannel.MAIN);
        if (answer >= 0) {
            return answer;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastSynchronousSnapshot(String store, IndexChannel channel) {
        String prefix = SNAP_SHOT_ID + ":" + store + ":";
        IndexReader reader = null;
        int end = -1;
        try {
            block24: {
                if (channel == IndexChannel.DELTA) {
                    this.flushPending();
                    reader = this.getDeltaReader();
                } else {
                    reader = this.getReader();
                }
                try (TermEnum terms = null;){
                    Term term;
                    terms = reader.terms(new Term("ID", prefix));
                    if (terms.term() == null) break block24;
                    while ((term = terms.term()).text().startsWith(prefix)) {
                        try (TermDocs docs = null;){
                            String[] split;
                            int test;
                            docs = reader.termDocs(term);
                            if (docs.next() && (test = Integer.parseInt((split = term.text().split(":"))[3])) > end) {
                                end = test;
                            }
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
            }
            int n = end;
            return n;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IO error", (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    if (channel == IndexChannel.DELTA) {
                        this.closeDeltaReader();
                    } else {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
            }
        }
    }

    private int getLastAsynchronousSnapshot(String store) {
        int answer = this.getLastAsynchronousSnapshot(store, IndexChannel.DELTA);
        if (answer >= 0) {
            return answer;
        }
        answer = this.getLastAsynchronousSnapshot(store, IndexChannel.MAIN);
        if (answer >= 0) {
            return answer;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getLastAsynchronousSnapshot(String store, IndexChannel channel) {
        String prefix = "\u0000BG:STORE:" + store + ":";
        IndexReader reader = null;
        int end = -1;
        try {
            block24: {
                if (channel == IndexChannel.DELTA) {
                    this.flushPending();
                    reader = this.getDeltaReader();
                } else {
                    reader = this.getReader();
                }
                try (TermEnum terms = null;){
                    Term term;
                    terms = reader.terms(new Term("ID", prefix));
                    if (terms.term() == null) break block24;
                    while ((term = terms.term()).text().startsWith(prefix)) {
                        try (TermDocs docs = null;){
                            String[] split;
                            int test;
                            docs = reader.termDocs(term);
                            if (docs.next() && (test = Integer.parseInt((split = term.text().split(":"))[4])) > end) {
                                end = test;
                            }
                        }
                        if (terms.next()) continue;
                        break;
                    }
                }
            }
            int n = end;
            return n;
        }
        catch (IOException e) {
            throw new AlfrescoRuntimeException("IO error", (Throwable)e);
        }
        finally {
            try {
                if (reader != null) {
                    if (channel == IndexChannel.DELTA) {
                        this.closeDeltaReader();
                    } else {
                        reader.close();
                    }
                }
            }
            catch (IOException e) {
                s_logger.warn((Object)"Failed to close main reader", (Throwable)e);
            }
        }
    }

    @Override
    public void deleteIndex(StoreRef storeRef) {
        this.deleteIndex();
    }

    public void deleteAll() {
        this.deleteAll(null);
    }

    public void deleteAll(String prefix) {
        IndexReader mainReader = null;
        try {
            mainReader = this.getReader();
            for (int doc = 0; doc < mainReader.maxDoc(); ++doc) {
                if (mainReader.isDeleted(doc)) continue;
                Document document = mainReader.document(doc);
                String[] ids = document.getValues("ID");
                if (prefix != null && !this.nonStartwWith(ids, prefix)) continue;
                this.deletions.add(ids[ids.length - 1]);
                this.deletionsSinceFlush.add(ids[ids.length - 1]);
            }
        }
        catch (IOException e) {
            throw new LuceneIndexException("Failed to delete all entries from the index", e);
        }
        finally {
            if (mainReader != null) {
                try {
                    mainReader.close();
                }
                catch (IOException e) {
                    throw new LuceneIndexException("Filed to close main reader", e);
                }
            }
        }
    }

    private boolean nonStartwWith(String[] values, String prefix) {
        for (String value : values) {
            if (!value.startsWith(prefix)) continue;
            return false;
        }
        return true;
    }

    protected static enum IndexDeleteMode {
        REINDEX,
        DELETE;

    }

    private static enum IndexChannel {
        MAIN,
        DELTA;

    }
}

