/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.domain.node.Node;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.mybatis.spring.SqlSessionTemplate;

public class DBQueryEngine
implements QueryEngine {
    private static final String SELECT_BY_DYNAMIC_QUERY = "alfresco.metadata.query.select_byDynamicQuery";
    private SqlSessionTemplate template;
    private QNameDAO qnameDAO;
    private NodeDAO nodeDAO;
    private DictionaryService dictionaryService;
    private NamespaceService namespaceService;
    private NodeService nodeService;
    private TenantService tenantService;

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public final void setSqlSessionTemplate(SqlSessionTemplate sqlSessionTemplate) {
        this.template = sqlSessionTemplate;
    }

    public void setQnameDAO(QNameDAO qnameDAO) {
        this.qnameDAO = qnameDAO;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeDAO(NodeDAO nodeDAO) {
        this.nodeDAO = nodeDAO;
    }

    public QueryEngineResults executeQuery(Query query, QueryOptions options, FunctionEvaluationContext functionContext) {
        Set selectorGroup = null;
        if (query.getSource() != null) {
            List selectorGroups = query.getSource().getSelectorGroups(functionContext);
            if (selectorGroups.size() == 0) {
                throw new QueryModelException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new QueryModelException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        HashSet<String> key = new HashSet<String>();
        key.add("");
        HashMap<HashSet<String>, PagingLuceneResultSet> answer = new HashMap<HashSet<String>, PagingLuceneResultSet>();
        DBQuery dbQuery = (DBQuery)query;
        StoreRef storeRef = (StoreRef)options.getStores().get(0);
        storeRef = storeRef != null ? this.tenantService.getName(storeRef) : null;
        dbQuery.setStoreId((Long)this.nodeDAO.getStore(storeRef).getFirst());
        Pair<Long, QName> sysDeletedType = this.qnameDAO.getQName(ContentModel.TYPE_DELETED);
        if (sysDeletedType == null) {
            dbQuery.setSysDeletedType(-1L);
        } else {
            dbQuery.setSysDeletedType((Long)sysDeletedType.getFirst());
        }
        dbQuery.prepare(this.namespaceService, this.dictionaryService, this.qnameDAO, this.nodeDAO, this.tenantService, selectorGroup, null, functionContext);
        List nodes = this.template.selectList(SELECT_BY_DYNAMIC_QUERY, (Object)dbQuery);
        LinkedHashSet<Long> set = new LinkedHashSet<Long>(nodes.size());
        for (Node node : nodes) {
            set.add(node.getId());
        }
        ArrayList<Long> nodeIds = new ArrayList<Long>(set);
        DBResultSet rs = new DBResultSet(options.getAsSearchParmeters(), nodeIds, this.nodeDAO, this.nodeService, Integer.MAX_VALUE);
        PagingLuceneResultSet paged = new PagingLuceneResultSet(rs, options.getAsSearchParmeters(), this.nodeService);
        answer.put(key, paged);
        return new QueryEngineResults(answer);
    }

    public QueryModelFactory getQueryModelFactory() {
        return new DBQueryModelFactory();
    }
}

