/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.BaseSelector;
import org.alfresco.repo.search.impl.querymodel.impl.db.AspectSupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.TypeSupport;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

public class DBSelector
extends BaseSelector
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    public DBSelector(QName type, String alias) {
        super(type, alias);
    }

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        ClassDefinition classDef = dictionaryService.getClass(this.getType());
        ArrayList<Long> qnameIds = new ArrayList<Long>();
        if (classDef.isAspect()) {
            Collection subaspects = dictionaryService.getSubAspects(classDef.getName(), true);
            for (QName qname : subaspects) {
                Pair<Long, QName> pair;
                AspectDefinition current = dictionaryService.getAspect(qname);
                if (!classDef.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (pair = qnameDAO.getQName(qname)) == null) continue;
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
            AspectSupport aspectSupport = new AspectSupport();
            aspectSupport.setQnameIds(qnameIds);
            this.builderSupport = aspectSupport;
        } else {
            Collection subclasses = dictionaryService.getSubTypes(classDef.getName(), true);
            for (QName qname : subclasses) {
                Pair<Long, QName> pair;
                TypeDefinition current = dictionaryService.getType(qname);
                if (!classDef.getName().equals((Object)current.getName()) && !current.getIncludedInSuperTypeQuery().booleanValue() || (pair = qnameDAO.getQName(qname)) == null) continue;
                Long qnameId = (Long)pair.getFirst();
                qnameIds.add(qnameId);
            }
            TypeSupport typeSupport = new TypeSupport();
            typeSupport.setQnameIds(qnameIds);
            typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.IN);
            this.builderSupport = typeSupport;
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

