/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db.functions;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.ParentSupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.PropertySupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.TypeSupport;
import org.alfresco.repo.search.impl.querymodel.impl.db.UUIDSupport;
import org.alfresco.repo.search.impl.querymodel.impl.functions.Equals;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBEquals
extends Equals
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        this.setPropertyAndStaticArguments(functionArgs);
        Serializable staticValue = this.getStaticArgument().getValue(functionContext);
        if (this.getPropertyName().equals("cmis:parentId")) {
            ParentSupport parentSupport = new ParentSupport();
            String id = (String)((Object)staticValue);
            parentSupport.setDbid(DBQuery.getDbid(id, nodeDAO, tenantService));
            parentSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
            this.builderSupport = parentSupport;
        } else if (this.getPropertyName().equals("cmis:objectId")) {
            UUIDSupport uuidSupport = new UUIDSupport();
            uuidSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
            uuidSupport.setUuid(DBQuery.getUUID((String)((Object)staticValue)));
            this.builderSupport = uuidSupport;
        } else if (this.getPropertyName().equals("cmis:objectTypeId")) {
            TypeSupport typeSupport = new TypeSupport();
            String typeName = functionContext.getAlfrescoTypeName((String)((Object)staticValue));
            typeSupport.setQnameIds(DBQuery.findTypeIds(typeName, namespaceService, dictionaryService, qnameDAO, true));
            typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.IN);
            this.builderSupport = typeSupport;
        } else if (this.getPropertyName().equals("cmis:baseTypeId")) {
            TypeSupport typeSupport = new TypeSupport();
            String typeName = functionContext.getAlfrescoTypeName((String)((Object)staticValue));
            typeSupport.setQnameIds(DBQuery.findTypeIds(typeName, namespaceService, dictionaryService, qnameDAO, false));
            typeSupport.setCommandType(DBQueryBuilderPredicatePartCommandType.IN);
            this.builderSupport = typeSupport;
        } else if (this.getPropertyName().equals("cmis:contentStreamMimeType")) {
            PropertySupport propertySupport = new PropertySupport();
            propertySupport.setValue(staticValue.toString());
            QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(this.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(basePropertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, basePropertyQName));
            propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
            propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_MIMETYPE);
            propertySupport.setFieldName("mimetype_str");
            propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
            propertySupport.setLuceneFunction(functionContext.getLuceneFunction(this.getFunctionArgument()));
            this.builderSupport = propertySupport;
        } else if (this.getPropertyName().equals("cmis:contentStreamLength")) {
            PropertySupport propertySupport = new PropertySupport();
            propertySupport.setValue(staticValue.toString());
            QName basePropertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(this.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(basePropertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, basePropertyQName));
            propertySupport.setPair(qnameDAO.getQName(basePropertyQName));
            propertySupport.setJoinCommandType(DBQueryBuilderJoinCommandType.CONTENT_URL);
            propertySupport.setFieldName("content_size");
            propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
            propertySupport.setLuceneFunction(functionContext.getLuceneFunction(this.getFunctionArgument()));
            this.builderSupport = propertySupport;
        } else {
            PropertySupport propertySupport = new PropertySupport();
            propertySupport.setValue(staticValue.toString());
            QName propertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(this.getPropertyName()), (NamespacePrefixResolver)namespaceService));
            propertySupport.setPropertyQName(propertyQName);
            propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, propertyQName));
            propertySupport.setPair(qnameDAO.getQName(propertyQName));
            propertySupport.setJoinCommandType(DBQuery.getJoinCommandType(propertyQName));
            propertySupport.setFieldName(DBQuery.getFieldName(dictionaryService, propertyQName));
            propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.EQUALS);
            propertySupport.setLuceneFunction(functionContext.getLuceneFunction(this.getFunctionArgument()));
            this.builderSupport = propertySupport;
        }
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

