/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.db.functions;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.search.impl.lucene.AnalysisMode;
import org.alfresco.repo.search.impl.querymodel.Argument;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.PropertyArgument;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQuery;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderComponent;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderJoinCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommand;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryBuilderPredicatePartCommandType;
import org.alfresco.repo.search.impl.querymodel.impl.db.PropertySupport;
import org.alfresco.repo.search.impl.querymodel.impl.functions.FTSPrefixTerm;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;

public class DBFTSPrefixTerm
extends FTSPrefixTerm
implements DBQueryBuilderComponent {
    DBQueryBuilderComponent builderSupport;

    @Override
    public boolean isSupported() {
        return true;
    }

    @Override
    public void prepare(NamespaceService namespaceService, DictionaryService dictionaryService, QNameDAO qnameDAO, NodeDAO nodeDAO, TenantService tenantService, Set<String> selectors, Map<String, Argument> functionArgs, FunctionEvaluationContext functionContext) {
        Argument argument = functionArgs.get("Term");
        String term = (String)((Object)argument.getValue(functionContext));
        term = term.substring(0, term.length() - 1);
        PropertyArgument propertyArgument = (PropertyArgument)functionArgs.get("Property");
        argument = functionArgs.get("TokenisationMode");
        AnalysisMode mode = (AnalysisMode)argument.getValue(functionContext);
        if (mode != AnalysisMode.IDENTIFIER) {
            throw new QueryModelException("Analysis mode not supported for DB " + mode);
        }
        PropertySupport propertySupport = new PropertySupport();
        propertySupport.setValue(term + "%");
        QName propertyQName = QName.createQName((String)DBQuery.expandQName(functionContext.getAlfrescoPropertyName(propertyArgument.getPropertyName()), (NamespacePrefixResolver)namespaceService));
        propertySupport.setPropertyQName(propertyQName);
        propertySupport.setPropertyDataType(DBQuery.getDataTypeDefinition(dictionaryService, propertyQName));
        propertySupport.setPair(qnameDAO.getQName(propertyQName));
        propertySupport.setJoinCommandType(DBQuery.getJoinCommandType(propertyQName));
        propertySupport.setFieldName(DBQuery.getFieldName(dictionaryService, propertyQName));
        propertySupport.setCommandType(DBQueryBuilderPredicatePartCommandType.LIKE);
        this.builderSupport = propertySupport;
    }

    @Override
    public void buildJoins(Map<QName, DBQueryBuilderJoinCommand> singleJoins, List<DBQueryBuilderJoinCommand> multiJoins) {
        this.builderSupport.buildJoins(singleJoins, multiJoins);
    }

    @Override
    public void buildPredicateCommands(List<DBQueryBuilderPredicatePartCommand> predicatePartCommands) {
        this.builderSupport.buildPredicateCommands(predicatePartCommands);
    }
}

