/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.querymodel.impl.lucene;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.alfresco.repo.search.SearcherException;
import org.alfresco.repo.search.impl.lucene.ClosingIndexSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneIndexerAndSearcher;
import org.alfresco.repo.search.impl.lucene.LuceneResultSet;
import org.alfresco.repo.search.impl.lucene.LuceneSearcher;
import org.alfresco.repo.search.impl.lucene.PagingLuceneResultSet;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilder;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContext;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryBuilderContextImpl;
import org.alfresco.repo.search.impl.querymodel.impl.lucene.LuceneQueryModelFactory;
import org.alfresco.repo.search.results.SortedResultSet;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.search.LimitBy;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.alfresco.service.cmr.search.SearchService;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.lucene.queryParser.ParseException;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.Searcher;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;

public class LuceneQueryEngine
implements QueryEngine {
    protected static final Log logger = LogFactory.getLog(LuceneQueryEngine.class);
    private DictionaryService dictionaryService;
    private LuceneIndexerAndSearcher indexAndSearcher;
    private NodeService nodeService;
    private TenantService tenantService;
    private NamespaceService namespaceService;
    private boolean useInMemorySort = true;
    private int maxRawResultSetSizeForInMemorySort = 1000;

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setIndexAndSearcher(LuceneIndexerAndSearcher indexAndSearcher) {
        this.indexAndSearcher = indexAndSearcher;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setTenantService(TenantService tenantService) {
        this.tenantService = tenantService;
    }

    public void setNamespaceService(NamespaceService namespaceService) {
        this.namespaceService = namespaceService;
    }

    public QueryModelFactory getQueryModelFactory() {
        return new LuceneQueryModelFactory();
    }

    public boolean isUseInMemorySort() {
        return this.useInMemorySort;
    }

    public void setUseInMemorySort(boolean useInMemorySort) {
        this.useInMemorySort = useInMemorySort;
    }

    public int getMaxRawResultSetSizeForInMemorySort() {
        return this.maxRawResultSetSizeForInMemorySort;
    }

    public void setMaxRawResultSetSizeForInMemorySort(int maxRawResultSetSizeForInMemorySort) {
        this.maxRawResultSetSizeForInMemorySort = maxRawResultSetSizeForInMemorySort;
    }

    public QueryEngineResults executeQuery(Query query, QueryOptions options, FunctionEvaluationContext functionContext) {
        Set selectorGroup = null;
        if (query.getSource() != null) {
            List selectorGroups = query.getSource().getSelectorGroups(functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        SearchParameters searchParameters = new SearchParameters();
        if (options.getLocales().size() > 0) {
            for (Locale locale : options.getLocales()) {
                searchParameters.addLocale(locale);
            }
        }
        searchParameters.excludeDataInTheCurrentTransaction(!options.isIncludeInTransactionData());
        searchParameters.setSkipCount(options.getSkipCount());
        searchParameters.setMaxPermissionChecks(options.getMaxPermissionChecks());
        searchParameters.setMaxPermissionCheckTimeMillis(options.getMaxPermissionCheckTimeMillis());
        searchParameters.setDefaultFieldName(options.getDefaultFieldName());
        searchParameters.setMlAnalaysisMode(options.getMlAnalaysisMode());
        if (options.getMaxItems() >= 0) {
            searchParameters.setLimitBy(LimitBy.FINAL_SIZE);
            searchParameters.setLimit(options.getMaxItems());
            searchParameters.setMaxItems(options.getMaxItems());
        } else {
            searchParameters.setLimitBy(LimitBy.UNLIMITED);
        }
        searchParameters.setUseInMemorySort(options.getUseInMemorySort());
        searchParameters.setMaxRawResultSetSizeForInMemorySort(options.getMaxRawResultSetSizeForInMemorySort());
        searchParameters.setBulkFetchEnabled(options.isBulkFetchEnabled());
        searchParameters.setQueryConsistency(options.getQueryConsistency());
        try {
            StoreRef storeRef = (StoreRef)options.getStores().get(0);
            searchParameters.addStore(storeRef);
            if (query instanceof LuceneQueryBuilder) {
                SearchService searchService = this.indexAndSearcher.getSearcher(storeRef, options.isIncludeInTransactionData());
                if (searchService instanceof LuceneSearcher) {
                    Object answer;
                    LuceneSearcher luceneSearcher = (LuceneSearcher)searchService;
                    ClosingIndexSearcher searcher = luceneSearcher.getClosingIndexSearcher();
                    LuceneQueryBuilderContextImpl luceneContext = new LuceneQueryBuilderContextImpl(this.dictionaryService, (NamespacePrefixResolver)this.namespaceService, this.tenantService, searchParameters, this.indexAndSearcher.getDefaultMLSearchAnalysisMode(), searcher.getIndexReader());
                    LuceneQueryBuilder builder = (LuceneQueryBuilder)query;
                    org.apache.lucene.search.Query luceneQuery = builder.buildQuery(selectorGroup, (LuceneQueryBuilderContext)luceneContext, functionContext);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Executing lucene query: " + luceneQuery));
                    }
                    Sort sort = builder.buildSort(selectorGroup, (LuceneQueryBuilderContext)luceneContext, functionContext);
                    Hits hits = searcher.search(luceneQuery);
                    boolean postSort = false;
                    if (sort != null && !(postSort = searchParameters.usePostSort(hits.length(), this.useInMemorySort, this.maxRawResultSetSizeForInMemorySort))) {
                        hits = searcher.search(luceneQuery, sort);
                    }
                    LuceneResultSet result = new LuceneResultSet(hits, (Searcher)searcher, this.nodeService, this.tenantService, searchParameters, this.indexAndSearcher);
                    if (postSort) {
                        if (sort != null) {
                            for (SortField sf : sort.getSort()) {
                                searchParameters.addSort(sf.getField(), !sf.getReverse());
                            }
                        }
                        SortedResultSet sorted = new SortedResultSet((ResultSet)result, this.nodeService, builder.buildSortDefinitions(selectorGroup, (LuceneQueryBuilderContext)luceneContext, functionContext), (NamespacePrefixResolver)this.namespaceService, this.dictionaryService, searchParameters.getSortLocale());
                        answer = sorted;
                    } else {
                        answer = result;
                    }
                    PagingLuceneResultSet rs = new PagingLuceneResultSet((ResultSet)answer, searchParameters, this.nodeService);
                    HashMap<Set, PagingLuceneResultSet> map = new HashMap<Set, PagingLuceneResultSet>(1);
                    map.put(selectorGroup, rs);
                    return new QueryEngineResults(map);
                }
                throw new UnsupportedOperationException();
            }
            throw new UnsupportedOperationException();
        }
        catch (ParseException e) {
            throw new SearcherException("Failed to parse query: " + (Object)((Object)e));
        }
        catch (IOException e) {
            throw new SearcherException("IO exception during search", e);
        }
    }
}

