/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import java.util.List;
import java.util.Set;
import org.alfresco.opencmis.dictionary.CMISDictionaryService;
import org.alfresco.opencmis.search.CMISQueryOptions;
import org.alfresco.opencmis.search.CMISQueryParser;
import org.alfresco.opencmis.search.CmisFunctionEvaluationContext;
import org.alfresco.repo.admin.patch.OptionalPatchApplicationCheckBootstrapBean;
import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.querymodel.FunctionEvaluationContext;
import org.alfresco.repo.search.impl.querymodel.Query;
import org.alfresco.repo.search.impl.querymodel.QueryEngine;
import org.alfresco.repo.search.impl.querymodel.QueryEngineResults;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.repo.search.impl.querymodel.QueryModelFactory;
import org.alfresco.repo.search.impl.querymodel.QueryOptions;
import org.alfresco.repo.search.impl.querymodel.impl.db.DBQueryModelFactory;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.chemistry.opencmis.commons.enums.BaseTypeId;
import org.apache.chemistry.opencmis.commons.enums.CapabilityJoin;

public class DbCmisQueryLanguage
extends AbstractLuceneQueryLanguage {
    QueryEngine queryEngine;
    private CMISDictionaryService cmisDictionaryService;
    OptionalPatchApplicationCheckBootstrapBean optionalPatchApplicationCheckBootstrapBean;

    public void setOptionalPatchApplicationCheckBootstrapBean(OptionalPatchApplicationCheckBootstrapBean optionalPatchApplicationCheckBootstrapBean) {
        this.optionalPatchApplicationCheckBootstrapBean = optionalPatchApplicationCheckBootstrapBean;
    }

    public void setQueryEngine(QueryEngine queryEngine) {
        this.queryEngine = queryEngine;
    }

    public void setCmisDictionaryService(CMISDictionaryService cmisDictionaryService) {
        this.cmisDictionaryService = cmisDictionaryService;
    }

    public DbCmisQueryLanguage() {
        this.setName("db-cmis");
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        if (this.optionalPatchApplicationCheckBootstrapBean.getPatchApplied()) {
            return this.executeQueryImpl(searchParameters, admLuceneSearcher);
        }
        throw new QueryModelException("The patch to add the indexes to support in-transactional metadata queries has not been applied");
    }

    private ResultSet executeQueryImpl(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        CMISQueryOptions options = CMISQueryOptions.create((SearchParameters)searchParameters);
        options.setQueryMode(CMISQueryOptions.CMISQueryMode.CMS_WITH_ALFRESCO_EXTENSIONS);
        CapabilityJoin joinSupport = CapabilityJoin.INNERONLY;
        BaseTypeId[] validScopes = CmisFunctionEvaluationContext.ALFRESCO_SCOPES;
        CmisFunctionEvaluationContext functionContext = new CmisFunctionEvaluationContext();
        functionContext.setCmisDictionaryService(this.cmisDictionaryService);
        functionContext.setValidScopes(validScopes);
        CMISQueryParser parser = new CMISQueryParser(options, this.cmisDictionaryService, joinSupport);
        Query queryModelQuery = parser.parse((QueryModelFactory)new DBQueryModelFactory(), (FunctionEvaluationContext)functionContext);
        Set selectorGroup = null;
        if (queryModelQuery.getSource() != null) {
            List selectorGroups = queryModelQuery.getSource().getSelectorGroups((FunctionEvaluationContext)functionContext);
            if (selectorGroups.size() == 0) {
                throw new UnsupportedOperationException("No selectors");
            }
            if (selectorGroups.size() > 1) {
                throw new UnsupportedOperationException("Advanced join is not supported");
            }
            selectorGroup = (Set)selectorGroups.get(0);
        }
        QueryEngineResults results = this.queryEngine.executeQuery(queryModelQuery, (QueryOptions)options, (FunctionEvaluationContext)functionContext);
        ResultSet resultSet = (ResultSet)results.getResults().values().iterator().next();
        return resultSet;
    }
}

