/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.search.impl.solr;

import org.alfresco.repo.search.impl.lucene.ADMLuceneSearcherImpl;
import org.alfresco.repo.search.impl.lucene.AbstractLuceneQueryLanguage;
import org.alfresco.repo.search.impl.lucene.LuceneQueryLanguageSPI;
import org.alfresco.repo.search.impl.querymodel.QueryModelException;
import org.alfresco.service.cmr.search.QueryConsistency;
import org.alfresco.service.cmr.search.ResultSet;
import org.alfresco.service.cmr.search.SearchParameters;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class DbOrIndexSwitchingQueryLanguage
extends AbstractLuceneQueryLanguage {
    protected static final Log logger = LogFactory.getLog(DbOrIndexSwitchingQueryLanguage.class);
    LuceneQueryLanguageSPI dbQueryLanguage;
    LuceneQueryLanguageSPI indexQueryLanguage;
    QueryConsistency queryConsistency = QueryConsistency.DEFAULT;

    public void setDbQueryLanguage(LuceneQueryLanguageSPI dbQueryLanguage) {
        this.dbQueryLanguage = dbQueryLanguage;
    }

    public void setIndexQueryLanguage(LuceneQueryLanguageSPI indexQueryLanguage) {
        this.indexQueryLanguage = indexQueryLanguage;
    }

    public void setQueryConsistency(QueryConsistency queryConsistency) {
        this.queryConsistency = queryConsistency;
    }

    @Override
    public ResultSet executeQuery(SearchParameters searchParameters, ADMLuceneSearcherImpl admLuceneSearcher) {
        QueryConsistency consistency = searchParameters.getQueryConsistency();
        if (consistency == QueryConsistency.DEFAULT) {
            consistency = this.queryConsistency;
        }
        switch (consistency) {
            case EVENTUAL: {
                if (this.indexQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using SOLR query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    return this.indexQueryLanguage.executeQuery(searchParameters, admLuceneSearcher);
                }
                throw new QueryModelException("No query language available");
            }
            case TRANSACTIONAL: {
                if (this.dbQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Trying db query for " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    return this.dbQueryLanguage.executeQuery(searchParameters, admLuceneSearcher);
                }
                throw new QueryModelException("No query language available");
            }
        }
        if (this.dbQueryLanguage != null) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Trying db query for " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                }
                return this.dbQueryLanguage.executeQuery(searchParameters, admLuceneSearcher);
            }
            catch (QueryModelException qme) {
                logger.info((Object)("DB query failed for " + this.dbQueryLanguage.getName() + " for " + searchParameters), (Throwable)qme);
                if (this.indexQueryLanguage != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Using SOLR query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
                    }
                    return this.indexQueryLanguage.executeQuery(searchParameters, admLuceneSearcher);
                }
            }
        } else if (this.indexQueryLanguage != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("(No DB QL) Using SOLR query: " + this.dbQueryLanguage.getName() + " for " + searchParameters));
            }
            return this.indexQueryLanguage.executeQuery(searchParameters, admLuceneSearcher);
        }
        throw new QueryModelException("No query language available");
    }
}

