/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authentication;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sf.acegisecurity.Authentication;
import org.alfresco.repo.security.authentication.AbstractChainingAuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationComponent;
import org.alfresco.repo.security.authentication.AuthenticationException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.authentication.NTLMMode;
import org.alfresco.repo.security.authentication.ntlm.NLTMAuthenticator;

public class ChainingAuthenticationComponentImpl
extends AbstractChainingAuthenticationComponent
implements NLTMAuthenticator {
    private NTLMMode ntlmMode = null;
    private List<AuthenticationComponent> authenticationComponents;
    private AuthenticationComponent mutableAuthenticationComponent;

    public List<AuthenticationComponent> getAuthenticationComponents() {
        return this.authenticationComponents;
    }

    public void setAuthenticationComponents(List<AuthenticationComponent> authenticationComponents) {
        this.authenticationComponents = authenticationComponents;
    }

    public AuthenticationComponent getMutableAuthenticationComponent() {
        return this.mutableAuthenticationComponent;
    }

    public void setMutableAuthenticationComponent(AuthenticationComponent mutableAuthenticationComponent) {
        this.mutableAuthenticationComponent = mutableAuthenticationComponent;
    }

    public void setNtlmMode(NTLMMode ntlmMode) {
        this.ntlmMode = ntlmMode;
    }

    @Override
    public Authentication authenticate(Authentication token) throws AuthenticationException {
        if (this.ntlmMode != null) {
            switch (this.ntlmMode) {
                case NONE: {
                    throw new AuthenticationException("NTLM is not supported");
                }
                case MD4_PROVIDER: {
                    throw new AuthenticationException("NTLM passthrough is not supported then configured for MD4 hashing");
                }
                case PASS_THROUGH: {
                    for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
                        NLTMAuthenticator ssoAuthenticator;
                        if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() != NTLMMode.PASS_THROUGH) continue;
                        return ssoAuthenticator.authenticate(token);
                    }
                    throw new AuthenticationException("No NTLM passthrough authentication to use");
                }
            }
            throw new AuthenticationException("No NTLM passthrough authentication to use");
        }
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            NLTMAuthenticator ssoAuthenticator;
            if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() == NTLMMode.NONE) continue;
            if (ssoAuthenticator.getNTLMMode() == NTLMMode.PASS_THROUGH) {
                return ssoAuthenticator.authenticate(token);
            }
            throw new AuthenticationException("The first authentication component to support NTLM supports MD4 hashing");
        }
        throw new AuthenticationException("No NTLM passthrough authentication to use");
    }

    @Override
    public String getGuestUserName() {
        return AuthenticationUtil.getGuestUserName();
    }

    @Override
    public String getMD4HashedPassword(String userName) {
        if (this.ntlmMode != null) {
            switch (this.ntlmMode) {
                case NONE: {
                    throw new AuthenticationException("NTLM is not supported");
                }
                case PASS_THROUGH: {
                    throw new AuthenticationException("NTLM passthrough is not supported then configured for MD4 hashing");
                }
                case MD4_PROVIDER: {
                    for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
                        NLTMAuthenticator ssoAuthenticator;
                        if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() != NTLMMode.MD4_PROVIDER) continue;
                        return ssoAuthenticator.getMD4HashedPassword(userName);
                    }
                    throw new AuthenticationException("No MD4 provider available");
                }
            }
            throw new AuthenticationException("No MD4 provider available");
        }
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            NLTMAuthenticator ssoAuthenticator;
            if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() == NTLMMode.NONE) continue;
            if (ssoAuthenticator.getNTLMMode() == NTLMMode.PASS_THROUGH) {
                throw new AuthenticationException("The first authentication component to support NTLM supports passthrough");
            }
            return ssoAuthenticator.getMD4HashedPassword(userName);
        }
        throw new AuthenticationException("No MD4 provider available");
    }

    @Override
    public NTLMMode getNTLMMode() {
        if (this.ntlmMode != null) {
            switch (this.ntlmMode) {
                case NONE: {
                    return NTLMMode.NONE;
                }
                case PASS_THROUGH: {
                    for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
                        NLTMAuthenticator ssoAuthenticator;
                        if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() != NTLMMode.PASS_THROUGH) continue;
                        return NTLMMode.PASS_THROUGH;
                    }
                    return NTLMMode.NONE;
                }
                case MD4_PROVIDER: {
                    for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
                        NLTMAuthenticator ssoAuthenticator;
                        if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() != NTLMMode.MD4_PROVIDER) continue;
                        return NTLMMode.MD4_PROVIDER;
                    }
                    return NTLMMode.NONE;
                }
            }
            return NTLMMode.NONE;
        }
        for (AuthenticationComponent authComponent : this.getUsableAuthenticationComponents()) {
            NLTMAuthenticator ssoAuthenticator;
            if (!(authComponent instanceof NLTMAuthenticator) || (ssoAuthenticator = (NLTMAuthenticator)authComponent).getNTLMMode() == NTLMMode.NONE) continue;
            return ssoAuthenticator.getNTLMMode();
        }
        return NTLMMode.NONE;
    }

    @Override
    protected Collection<AuthenticationComponent> getUsableAuthenticationComponents() {
        if (this.mutableAuthenticationComponent == null) {
            return this.authenticationComponents;
        }
        ArrayList<AuthenticationComponent> services = new ArrayList<AuthenticationComponent>(this.authenticationComponents == null ? 1 : this.authenticationComponents.size() + 1);
        services.add(this.mutableAuthenticationComponent);
        if (this.authenticationComponents != null) {
            services.addAll(this.authenticationComponents);
        }
        return services;
    }

    @Override
    protected AuthenticationComponent getAuthenticationComponent(String name) {
        return null;
    }
}

