/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.authority;

import java.util.List;
import org.alfresco.repo.cache.AbstractAsynchronouslyRefreshedCache;
import org.alfresco.repo.security.authority.AuthorityBridgeDAO;
import org.alfresco.repo.security.authority.AuthorityBridgeLink;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.util.BridgeTable;
import org.alfresco.util.PropertyCheck;
import org.springframework.beans.factory.InitializingBean;

public class AuthorityBridgeTableAsynchronouslyRefreshedCache
extends AbstractAsynchronouslyRefreshedCache<BridgeTable<String>>
implements InitializingBean {
    private AuthorityBridgeDAO authorityBridgeDAO;
    private RetryingTransactionHelper retryingTransactionHelper;

    public void setAuthorityBridgeDAO(AuthorityBridgeDAO authorityBridgeDAO) {
        this.authorityBridgeDAO = authorityBridgeDAO;
    }

    public void setRetryingTransactionHelper(RetryingTransactionHelper retryingTransactionHelper) {
        this.retryingTransactionHelper = retryingTransactionHelper;
    }

    @Override
    protected BridgeTable<String> buildCache(final String tenantId) {
        return this.retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<BridgeTable<String>>(){

            @Override
            public BridgeTable<String> execute() throws Throwable {
                return AuthorityBridgeTableAsynchronouslyRefreshedCache.this.doBuildCache(tenantId);
            }
        }, true, false);
    }

    private BridgeTable<String> doBuildCache(String tenantId) {
        List<AuthorityBridgeLink> links = this.authorityBridgeDAO.getAuthorityBridgeLinks();
        BridgeTable bridgeTable = new BridgeTable();
        for (AuthorityBridgeLink link : links) {
            bridgeTable.addLink((Object)link.getParentName(), (Object)link.getChildName());
        }
        return bridgeTable;
    }

    @Override
    public void afterPropertiesSet() throws Exception {
        PropertyCheck.mandatory((Object)this, (String)"authorityBridgeDAO", (Object)this.authorityBridgeDAO);
        PropertyCheck.mandatory((Object)this, (String)"retryingTransactionHelper", (Object)this.retryingTransactionHelper);
        super.afterPropertiesSet();
    }
}

