/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.permissions.impl.model;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.security.permissions.PermissionEntry;
import org.alfresco.repo.security.permissions.PermissionReference;
import org.alfresco.repo.security.permissions.impl.ModelDAO;
import org.alfresco.repo.security.permissions.impl.RequiredPermission;
import org.alfresco.repo.security.permissions.impl.SimplePermissionReference;
import org.alfresco.repo.security.permissions.impl.model.GlobalPermissionEntry;
import org.alfresco.repo.security.permissions.impl.model.Permission;
import org.alfresco.repo.security.permissions.impl.model.PermissionGroup;
import org.alfresco.repo.security.permissions.impl.model.PermissionModelException;
import org.alfresco.repo.security.permissions.impl.model.PermissionSet;
import org.alfresco.service.cmr.dictionary.AspectDefinition;
import org.alfresco.service.cmr.dictionary.ClassDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.AccessStatus;
import org.alfresco.service.namespace.DynamicNamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentType;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.dom4j.tree.DefaultDocumentType;

public class PermissionModel
implements ModelDAO {
    private NodeService nodeService;
    private DictionaryService dictionaryService;
    private static final String NAMESPACES = "namespaces";
    private static final String NAMESPACE = "namespace";
    private static final String NAMESPACE_URI = "uri";
    private static final String NAMESPACE_PREFIX = "prefix";
    private static final String PERMISSION_SET = "permissionSet";
    private static final String GLOBAL_PERMISSION = "globalPermission";
    private static final String DENY = "deny";
    private static final String ALLOW = "allow";
    private static final String DEFAULT_PERMISSION = "defaultPermission";
    private String model;
    private String dtdSchema;
    private boolean validate = true;
    private static PermissionReference ALL = SimplePermissionReference.getPermissionReference(QName.createQName((String)"http://www.alfresco.org/model/security/1.0", (String)"All"), "All");
    private MutableState mutableState;

    public void setModel(String model) {
        this.model = model;
    }

    public void setDtdSchema(String dtdSchema) {
        this.dtdSchema = dtdSchema;
    }

    public void setValidate(boolean validate) {
        this.validate = validate;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void init() {
        this.mutableState = new MutableState(this.dictionaryService);
        this.addPermissionModel(this.model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void addPermissionModel(String model) {
        Document document = this.createDocument(model);
        Element root = document.getRootElement();
        this.mutableState.lock.writeLock().lock();
        try {
            Attribute defaultPermissionAttribute = root.attribute(DEFAULT_PERMISSION);
            if (defaultPermissionAttribute != null) {
                if (defaultPermissionAttribute.getStringValue().equalsIgnoreCase(ALLOW)) {
                    this.mutableState.defaultPermission = AccessStatus.ALLOWED;
                } else {
                    if (!defaultPermissionAttribute.getStringValue().equalsIgnoreCase(DENY)) throw new PermissionModelException("The default permission must be deny or allow");
                    this.mutableState.defaultPermission = AccessStatus.DENIED;
                }
            } else {
                this.mutableState.defaultPermission = AccessStatus.DENIED;
            }
            DynamicNamespacePrefixResolver nspr = new DynamicNamespacePrefixResolver();
            Iterator nsit = root.elementIterator(NAMESPACES);
            while (nsit.hasNext()) {
                Element namespacesElement = (Element)nsit.next();
                Iterator it = namespacesElement.elementIterator(NAMESPACE);
                while (it.hasNext()) {
                    Element nameSpaceElement = (Element)it.next();
                    nspr.registerNamespace(nameSpaceElement.attributeValue(NAMESPACE_PREFIX), nameSpaceElement.attributeValue(NAMESPACE_URI));
                }
            }
            Iterator psit = root.elementIterator(PERMISSION_SET);
            while (psit.hasNext()) {
                Element permissionSetElement = (Element)psit.next();
                PermissionSet permissionSet = new PermissionSet();
                permissionSet.initialise(permissionSetElement, (NamespacePrefixResolver)nspr, this);
                this.mutableState.permissionSets.put(permissionSet.getQName(), permissionSet);
            }
            this.mutableState.buildUniquePermissionMap();
            Iterator npit = root.elementIterator(GLOBAL_PERMISSION);
            while (npit.hasNext()) {
                Element globalPermissionElement = (Element)npit.next();
                GlobalPermissionEntry globalPermission = new GlobalPermissionEntry();
                globalPermission.initialise(globalPermissionElement, (NamespacePrefixResolver)nspr, this);
                this.mutableState.globalPermissions.add(globalPermission);
            }
            this.mutableState.allAspects = this.dictionaryService.getAllAspects();
            return;
        }
        finally {
            this.mutableState.lock.writeLock().unlock();
        }
    }

    private Document createDocument(String model) {
        URL dtdSchemaUrl;
        InputStream is = this.getClass().getClassLoader().getResourceAsStream(model);
        URL uRL = dtdSchemaUrl = this.dtdSchema == null ? null : this.getClass().getClassLoader().getResource(this.dtdSchema);
        if (is == null) {
            throw new PermissionModelException("File not found: " + model);
        }
        SAXReader reader = new SAXReader();
        try {
            if (this.validate) {
                if (dtdSchemaUrl != null) {
                    is = this.processModelDocType(is, dtdSchemaUrl.toString());
                    reader.setValidation(true);
                } else {
                    throw new PermissionModelException("Couldn't obtain DTD schema to validate permission model.");
                }
            }
            Document document = reader.read(is);
            is.close();
            return document;
        }
        catch (DocumentException e) {
            throw new PermissionModelException("Failed to create permission model document: " + model, e);
        }
        catch (IOException e) {
            throw new PermissionModelException("Failed to close permission model document: " + model, e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InputStream processModelDocType(InputStream is, String dtdSchemaUrl) throws DocumentException, IOException {
        SAXReader reader = new SAXReader();
        Document doc = reader.read(is);
        DocumentType docType = doc.getDocType();
        if (docType != null) {
            docType.setSystemID(dtdSchemaUrl);
        } else {
            docType = new DefaultDocumentType(doc.getRootElement().getName(), dtdSchemaUrl);
            doc.setDocType(docType);
        }
        try (ByteArrayOutputStream fos = new ByteArrayOutputStream();){
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter((OutputStream)fos, format);
            writer.write(doc);
            writer.flush();
        }
        return new ByteArrayInputStream(fos.toByteArray());
    }

    public AccessStatus getDefaultPermission() {
        this.mutableState.lock.readLock().lock();
        AccessStatus defaultPermission = this.mutableState.defaultPermission;
        this.mutableState.lock.readLock().unlock();
        return defaultPermission;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessStatus getDefaultPermission(PermissionReference pr) {
        this.mutableState.lock.readLock().lock();
        try {
            Permission p = (Permission)this.mutableState.permissionMap.get(pr);
            if (p == null) {
                AccessStatus accessStatus = this.mutableState.defaultPermission;
                return accessStatus;
            }
            AccessStatus accessStatus = p.getDefaultPermission();
            return accessStatus;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<? extends PermissionEntry> getGlobalPermissionEntries() {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = Collections.unmodifiableSet(new HashSet(this.mutableState.globalPermissions));
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<QName, PermissionSet> getPermissionSets() {
        this.mutableState.lock.readLock().lock();
        try {
            Map<QName, PermissionSet> map = Collections.unmodifiableMap(new HashMap(this.mutableState.permissionSets));
            return map;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    @Override
    public Set<PermissionReference> getAllPermissions(QName type) {
        return this.getAllPermissionsImpl(type, null, false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(QName type) {
        return this.getAllPermissionsImpl(type, null, true);
    }

    @Override
    public Set<PermissionReference> getAllPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(this.nodeService.getType(nodeRef), this.nodeService.getAspects(nodeRef), false);
    }

    @Override
    public Set<PermissionReference> getExposedPermissions(NodeRef nodeRef) {
        return this.getAllPermissionsImpl(this.nodeService.getType(nodeRef), this.nodeService.getAspects(nodeRef), true);
    }

    @Override
    public Set<PermissionReference> getAllPermissions(QName typeName, Set<QName> aspects) {
        return this.getAllPermissionsImpl(typeName, aspects, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<PermissionReference> getAllPermissionsImpl(QName typeName, Set<QName> aspects, boolean exposedOnly) {
        LinkedHashSet<PermissionReference> permissions = new LinkedHashSet<PermissionReference>(128, 1.0f);
        ClassDefinition cd = this.dictionaryService.getClass(typeName);
        this.mutableState.lock.readLock().lock();
        try {
            permissions.addAll(this.mutableState.getAllPermissionsImpl(typeName, exposedOnly));
            if (cd != null && aspects != null) {
                Set defaultAspects = cd.getDefaultAspectNames();
                for (QName aspect : aspects) {
                    if (defaultAspects.contains(aspect)) continue;
                    this.mutableState.addAspectPermissions(aspect, permissions, exposedOnly);
                }
            }
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
        return permissions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Set<PermissionReference> getGrantingPermissions(PermissionReference permissionReference) {
        if (permissionReference == null) {
            return Collections.emptySet();
        }
        this.mutableState.lock.readLock().lock();
        Set<SimplePermissionReference> granters = (HashSet)this.mutableState.grantingPermissions.get(permissionReference);
        if (granters == null) {
            this.mutableState.lock.readLock().unlock();
            this.mutableState.lock.writeLock().lock();
            try {
                granters = (Set)this.mutableState.grantingPermissions.get(permissionReference);
                if (granters != null) return granters;
                Set internal = this.mutableState.getGrantingPermissionsImpl(permissionReference);
                granters = new HashSet();
                for (PermissionReference grantee : internal) {
                    granters.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
                }
                granters = Collections.unmodifiableSet(granters);
                this.mutableState.grantingPermissions.put(permissionReference, granters);
                return granters;
            }
            finally {
                this.mutableState.lock.writeLock().unlock();
            }
        } else {
            this.mutableState.lock.readLock().unlock();
        }
        return granters;
    }

    static RequiredKey generateKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
        return RequiredKey.getRequiredKey(required, qName, aspectQNames, on);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean checkPermission(PermissionReference required) {
        this.mutableState.lock.readLock().lock();
        try {
            boolean bl = this.mutableState.checkPermission(required);
            return bl;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getGranteePermissions(PermissionReference permissionReference) {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = this.mutableState.getGranteePermissions(permissionReference);
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getImmediateGranteePermissions(PermissionReference permissionReference) {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = this.mutableState.getImmediateGranteePermissions(permissionReference);
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PermissionReference getPermissionReference(QName qname, String permissionName) {
        this.mutableState.lock.readLock().lock();
        try {
            PermissionReference permissionReference = this.mutableState.getPermissionReference(qname, permissionName);
            return permissionReference;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getRequiredPermissions(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = this.mutableState.getRequiredPermissions(required, qName, aspectQNames, on);
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getUnconditionalRequiredPermissions(PermissionReference required, RequiredPermission.On on) {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = this.mutableState.getUnconditionalRequiredPermissions(required, on);
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isUnique(PermissionReference permissionReference) {
        this.mutableState.lock.readLock().lock();
        try {
            boolean bl = this.mutableState.isUnique(permissionReference);
            return bl;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getAllExposedPermissions() {
        HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256);
        this.mutableState.lock.readLock().lock();
        try {
            for (PermissionSet ps : this.mutableState.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    if (!pg.isExposed()) continue;
                    permissions.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
                }
                for (Permission p : ps.getPermissions()) {
                    if (!p.isExposed()) continue;
                    permissions.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                }
            }
            HashSet<PermissionReference> hashSet = permissions;
            return hashSet;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean hasFull(PermissionReference permissionReference) {
        this.mutableState.lock.readLock().lock();
        try {
            boolean bl = this.mutableState.hasFull(permissionReference);
            return bl;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<PermissionReference> getAllPermissions() {
        this.mutableState.lock.readLock().lock();
        try {
            Set set = this.mutableState.getAllPermissions();
            return set;
        }
        finally {
            this.mutableState.lock.readLock().unlock();
        }
    }

    public static class RequiredKey {
        PermissionReference required;
        QName qName;
        Set<QName> aspectQNames;
        RequiredPermission.On on;
        int hashCode = 0;
        private static ReadWriteLock lock = new ReentrantReadWriteLock();
        private static Map<PermissionReference, Map<QName, Map<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>>> instances = new HashMap<PermissionReference, Map<QName, Map<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>>>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static RequiredKey getRequiredKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
            RequiredKey instance;
            EnumMap<RequiredPermission.On, RequiredKey> byAspects;
            Map<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>> byType;
            Map<QName, Map<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>> byPermRef;
            lock.readLock().lock();
            try {
                byPermRef = instances.get(required);
                if (byPermRef != null && (byType = byPermRef.get(qName)) != null && (byAspects = byType.get(aspectQNames)) != null && (instance = byAspects.get((Object)on)) != null) {
                    RequiredKey requiredKey = instance;
                    return requiredKey;
                }
            }
            finally {
                lock.readLock().unlock();
            }
            lock.writeLock().lock();
            try {
                byPermRef = instances.get(required);
                if (byPermRef == null) {
                    byPermRef = new HashMap<QName, Map<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>>();
                    instances.put(required, byPermRef);
                }
                if ((byType = byPermRef.get(qName)) == null) {
                    byType = new HashMap<Set<QName>, EnumMap<RequiredPermission.On, RequiredKey>>();
                    byPermRef.put(qName, byType);
                }
                if ((byAspects = byType.get(aspectQNames)) == null) {
                    byAspects = new EnumMap(RequiredPermission.On.class);
                    byType.put(aspectQNames, byAspects);
                }
                if ((instance = byAspects.get((Object)on)) == null) {
                    instance = new RequiredKey(required, qName, aspectQNames, on);
                    byAspects.put(on, instance);
                }
                RequiredKey requiredKey = instance;
                return requiredKey;
            }
            finally {
                lock.writeLock().unlock();
            }
        }

        RequiredKey(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
            this.required = required;
            this.qName = qName;
            this.aspectQNames = aspectQNames;
            this.on = on;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int PRIME = 1000003;
                int result = 1;
                result = 1000003 * result + (this.aspectQNames == null ? 0 : this.aspectQNames.hashCode());
                result = 1000003 * result + (this.on == null ? 0 : this.on.ordinal());
                result = 1000003 * result + (this.qName == null ? 0 : this.qName.hashCode());
                this.hashCode = result = 1000003 * result + (this.required == null ? 0 : this.required.hashCode());
            }
            return this.hashCode;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RequiredKey other = (RequiredKey)obj;
            if (this.required == null ? other.required != null : !this.required.equals(other.required)) {
                return false;
            }
            if (this.qName == null ? other.qName != null : !this.qName.equals((Object)other.qName)) {
                return false;
            }
            if (this.on == null ? other.on != null : !this.on.equals((Object)other.on)) {
                return false;
            }
            return !(this.aspectQNames == null ? other.aspectQNames != null : !this.aspectQNames.equals(other.aspectQNames));
        }
    }

    private static class MutableState {
        private final DictionaryService dictionaryService;
        private Map<QName, PermissionSet> permissionSets = new HashMap<QName, PermissionSet>(128);
        private Set<GlobalPermissionEntry> globalPermissions = new HashSet<GlobalPermissionEntry>();
        private AccessStatus defaultPermission;
        private Collection<QName> allAspects;
        private Map<String, PermissionReference> uniqueMap;
        private Map<PermissionReference, Permission> permissionMap;
        private Map<PermissionReference, PermissionGroup> permissionGroupMap;
        private Map<String, PermissionReference> permissionReferenceMap;
        private Map<PermissionReference, Set<PermissionReference>> grantingPermissions = new HashMap<PermissionReference, Set<PermissionReference>>(256);
        private Map<PermissionReference, Set<PermissionReference>> granteePermissions = new HashMap<PermissionReference, Set<PermissionReference>>(256);
        private Map<PermissionGroup, PermissionGroup> groupsToBaseGroup = new HashMap<PermissionGroup, PermissionGroup>(256);
        private Map<RequiredKey, Set<PermissionReference>> requiredPermissionsCache = new HashMap<RequiredKey, Set<PermissionReference>>(1024);
        private Map<Pair<PermissionReference, RequiredPermission.On>, Set<PermissionReference>> unconditionalRequiredPermissionsCache = new HashMap<Pair<PermissionReference, RequiredPermission.On>, Set<PermissionReference>>(1024);
        private Map<QName, Set<PermissionReference>> cachedTypePermissionsExposed = new HashMap<QName, Set<PermissionReference>>(256);
        private Map<QName, Set<PermissionReference>> cachedTypePermissionsUnexposed = new HashMap<QName, Set<PermissionReference>>(256);
        private ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

        public MutableState(DictionaryService dictionaryService) {
            this.dictionaryService = dictionaryService;
        }

        public boolean checkPermission(PermissionReference required) {
            Permission permission = this.getPermissionOrNull(required);
            if (permission != null) {
                return true;
            }
            PermissionGroup pg = this.getPermissionGroupOrNull(required);
            if (pg != null) {
                if (pg.isExtends()) {
                    QName parent;
                    if (pg.getTypeQName() != null) {
                        return this.checkPermission(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName()));
                    }
                    ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                    while ((parent = classDefinition.getParentName()) != null) {
                        classDefinition = this.dictionaryService.getClass(parent);
                        PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                        if (attempt == null || !attempt.isAllowFullControl()) continue;
                        return true;
                    }
                    return false;
                }
                return pg.isAllowFullControl();
            }
            return false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<PermissionReference> getAllPermissionsImpl(QName type, boolean exposedOnly) {
            Map<QName, Set<PermissionReference>> cache = exposedOnly ? this.cachedTypePermissionsExposed : this.cachedTypePermissionsUnexposed;
            Set<PermissionReference> permissions = cache.get(type);
            if (permissions == null) {
                boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                try {
                    permissions = cache.get(type);
                    if (permissions == null) {
                        permissions = new LinkedHashSet<PermissionReference>(256, 1.0f);
                        ClassDefinition cd = this.dictionaryService.getClass(type);
                        if (cd != null) {
                            if (cd.isAspect()) {
                                this.addAspectPermissions(type, permissions, exposedOnly);
                            } else {
                                this.mergeGeneralAspectPermissions(permissions, exposedOnly);
                                this.addTypePermissions(type, permissions, exposedOnly);
                            }
                        }
                        permissions = Collections.unmodifiableSet(permissions);
                        cache.put(type, permissions);
                    }
                }
                finally {
                    if (!hadWriteLock) {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                }
            }
            return permissions;
        }

        private void addTypePermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
            TypeDefinition typeDef = this.dictionaryService.getType(type);
            if (typeDef == null) {
                return;
            }
            if (typeDef.getParentName() != null) {
                PermissionSet permissionSet = this.permissionSets.get(type);
                if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                    this.addTypePermissions(typeDef.getParentName(), permissions, exposedOnly);
                }
            }
            for (AspectDefinition ad : typeDef.getDefaultAspects()) {
                this.addAspectPermissions(ad.getName(), permissions, exposedOnly);
            }
            this.mergePermissions(permissions, type, exposedOnly, true);
        }

        private void addAspectPermissions(QName type, Set<PermissionReference> permissions, boolean exposedOnly) {
            AspectDefinition aspectDef = this.dictionaryService.getAspect(type);
            if (aspectDef == null) {
                return;
            }
            if (aspectDef.getParentName() != null) {
                PermissionSet permissionSet = this.permissionSets.get(type);
                if (!exposedOnly || permissionSet == null || permissionSet.exposeAll()) {
                    this.addAspectPermissions(aspectDef.getParentName(), permissions, exposedOnly);
                }
            }
            this.mergePermissions(permissions, type, exposedOnly, true);
        }

        private void mergePermissions(Set<PermissionReference> target, QName type, boolean exposedOnly, boolean typeRequired) {
            PermissionSet permissionSet = this.permissionSets.get(type);
            if (permissionSet != null) {
                for (PermissionGroup pg : permissionSet.getPermissionGroups()) {
                    if (exposedOnly && !permissionSet.exposeAll() && !pg.isExposed()) continue;
                    if (!pg.isExtends()) {
                        if (pg.isTypeRequired() != typeRequired) continue;
                        target.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
                        continue;
                    }
                    if (!exposedOnly || pg.isTypeRequired() != typeRequired) continue;
                    PermissionGroup base = this.getBasePermissionGroup(pg);
                    target.add(SimplePermissionReference.getPermissionReference(base.getQName(), base.getName()));
                }
                for (Permission p : permissionSet.getPermissions()) {
                    if (exposedOnly && !permissionSet.exposeAll() && !p.isExposed() || p.isTypeRequired() != typeRequired) continue;
                    target.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                }
            }
        }

        private void mergeGeneralAspectPermissions(Set<PermissionReference> target, boolean exposedOnly) {
            for (QName aspect : this.allAspects) {
                this.mergePermissions(target, aspect, exposedOnly, false);
            }
        }

        private PermissionGroup getPermissionGroupOrNull(PermissionReference target) {
            PermissionGroup pg = this.permissionGroupMap.get(target);
            return pg == null ? null : pg;
        }

        private PermissionGroup getPermissionGroup(PermissionReference target) {
            PermissionGroup pg = this.getPermissionGroupOrNull(target);
            if (pg == null) {
                throw new PermissionModelException("There is no permission group :" + target.getQName() + " " + target.getName());
            }
            return pg;
        }

        private PermissionGroup getBasePermissionGroupOrNull(PermissionGroup pg) {
            if (pg == null) {
                return null;
            }
            PermissionGroup permissionGroup = this.groupsToBaseGroup.get(pg);
            if (permissionGroup == null) {
                boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                if ((permissionGroup = this.groupsToBaseGroup.get(pg)) == null) {
                    permissionGroup = this.getBasePermissionGroupOrNullImpl(pg);
                    this.groupsToBaseGroup.put(pg, permissionGroup);
                }
                if (!hadWriteLock) {
                    this.lock.readLock().lock();
                    this.lock.writeLock().unlock();
                }
            }
            return permissionGroup;
        }

        private PermissionGroup getBasePermissionGroupOrNullImpl(PermissionGroup pg) {
            if (pg == null) {
                return null;
            }
            if (pg.isExtends()) {
                QName parent;
                if (pg.getTypeQName() != null) {
                    return this.getPermissionGroup(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName()));
                }
                ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                while ((parent = classDefinition.getParentName()) != null) {
                    classDefinition = this.dictionaryService.getClass(parent);
                    PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                    if (attempt == null || attempt.isExtends()) continue;
                    return attempt;
                }
                return null;
            }
            return pg;
        }

        private PermissionGroup getBasePermissionGroup(PermissionGroup target) {
            PermissionGroup pg = this.getBasePermissionGroupOrNull(target);
            if (pg == null) {
                throw new PermissionModelException("There is no parent for permission group :" + target.getQName() + " " + target.getName());
            }
            return pg;
        }

        private Set<PermissionReference> getGrantingPermissionsImpl(PermissionReference permissionReference) {
            HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
            permissions.add(permissionReference);
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    if (this.grants(pg, permissionReference)) {
                        permissions.add(this.getBasePermissionGroup(pg));
                    }
                    if (!pg.isAllowFullControl()) continue;
                    permissions.add(pg);
                }
                block2: for (Permission p : ps.getPermissions()) {
                    if (p.equals(permissionReference)) {
                        for (PermissionReference pg : p.getGrantedToGroups()) {
                            permissions.add(this.getBasePermissionGroup(this.getPermissionGroup(pg)));
                        }
                    }
                    for (RequiredPermission rp : p.getRequiredPermissions()) {
                        if (!rp.equals(permissionReference) || !rp.isImplies()) continue;
                        permissions.add(p);
                        continue block2;
                    }
                }
            }
            return permissions;
        }

        private boolean grants(PermissionGroup pg, PermissionReference permissionReference) {
            if (pg.getIncludedPermissionGroups().contains(permissionReference)) {
                return true;
            }
            if (this.getGranteePermissions(pg).contains(permissionReference)) {
                return true;
            }
            for (PermissionReference nested : pg.getIncludedPermissionGroups()) {
                if (!this.grants(this.getPermissionGroup(nested), permissionReference)) continue;
                return true;
            }
            return false;
        }

        private Set<PermissionReference> getGranteePermissionsImpl(PermissionReference permissionReference) {
            HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
            permissions.add(permissionReference);
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    if (!pg.equals(permissionReference)) continue;
                    for (PermissionReference included : pg.getIncludedPermissionGroups()) {
                        permissions.addAll(this.getGranteePermissions(included));
                    }
                    if (pg.isExtends()) {
                        if (pg.getTypeQName() != null) {
                            permissions.addAll(this.getGranteePermissions(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName())));
                        } else {
                            ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                            QName parent = classDefinition.getParentName();
                            if (parent != null) {
                                classDefinition = this.dictionaryService.getClass(parent);
                                PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                                if (attempt != null) {
                                    permissions.addAll(this.getGranteePermissions(attempt));
                                }
                            }
                        }
                    }
                    if (!pg.isAllowFullControl()) continue;
                    permissions.addAll(this.getAllPermissions());
                }
                PermissionGroup baseGroup = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(permissionReference));
                if (baseGroup == null) continue;
                for (Permission p : ps.getPermissions()) {
                    for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                        PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                        if (!baseGroup.equals(base)) continue;
                        permissions.add(p);
                    }
                }
            }
            return permissions;
        }

        private Set<PermissionReference> getImmediateGranteePermissionsImpl(PermissionReference permissionReference) {
            HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256);
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    if (!pg.equals(permissionReference)) continue;
                    for (PermissionReference included : pg.getIncludedPermissionGroups()) {
                        permissions.add(included);
                    }
                    if (pg.isExtends()) {
                        if (pg.getTypeQName() != null) {
                            permissions.addAll(this.getImmediateGranteePermissions(SimplePermissionReference.getPermissionReference(pg.getTypeQName(), pg.getName())));
                        } else {
                            ClassDefinition classDefinition = this.dictionaryService.getClass(pg.getQName());
                            QName parent = classDefinition.getParentName();
                            if (parent != null) {
                                classDefinition = this.dictionaryService.getClass(parent);
                                PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, pg.getName()));
                                if (attempt != null) {
                                    permissions.addAll(this.getImmediateGranteePermissions(attempt));
                                }
                            }
                        }
                    }
                    if (!pg.isAllowFullControl()) continue;
                    permissions.addAll(this.getAllPermissions());
                }
                PermissionGroup baseGroup = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(permissionReference));
                if (baseGroup == null) continue;
                for (Permission p : ps.getPermissions()) {
                    for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                        PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                        if (!baseGroup.equals(base)) continue;
                        permissions.add(p);
                    }
                }
            }
            return permissions;
        }

        private Set<PermissionReference> getAllPermissions() {
            HashSet<PermissionReference> permissions = new HashSet<PermissionReference>(256, 1.0f);
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    permissions.add(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
                }
                for (Permission p : ps.getPermissions()) {
                    permissions.add(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                }
            }
            return permissions;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<PermissionReference> getGranteePermissions(PermissionReference permissionReference) {
            if (permissionReference == null) {
                return Collections.emptySet();
            }
            Set<PermissionReference> grantees = this.granteePermissions.get(permissionReference);
            if (grantees == null) {
                boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                try {
                    grantees = this.granteePermissions.get(permissionReference);
                    if (grantees == null) {
                        Set<PermissionReference> internal = this.getGranteePermissionsImpl(permissionReference);
                        grantees = new HashSet<PermissionReference>();
                        for (PermissionReference grantee : internal) {
                            grantees.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
                        }
                        grantees = Collections.unmodifiableSet(grantees);
                        this.granteePermissions.put(permissionReference, grantees);
                    }
                }
                finally {
                    if (!hadWriteLock) {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                }
            }
            return grantees;
        }

        private Set<PermissionReference> getImmediateGranteePermissions(PermissionReference permissionReference) {
            Set<PermissionReference> internal = this.getImmediateGranteePermissionsImpl(permissionReference);
            HashSet<PermissionReference> grantees = new HashSet();
            for (PermissionReference grantee : internal) {
                grantees.add(SimplePermissionReference.getPermissionReference(grantee.getQName(), grantee.getName()));
            }
            grantees = Collections.unmodifiableSet(grantees);
            return grantees;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<PermissionReference> getRequiredPermissions(PermissionReference required, QName qName, Set<QName> aspectQNames, RequiredPermission.On on) {
            if (required == null || qName == null) {
                return Collections.emptySet();
            }
            RequiredKey key = PermissionModel.generateKey(required, qName, aspectQNames, on);
            Set<PermissionReference> answer = this.requiredPermissionsCache.get(key);
            if (answer == null) {
                boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                try {
                    answer = this.requiredPermissionsCache.get(key);
                    if (answer == null) {
                        PermissionGroup pg = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(required));
                        answer = pg == null ? this.getRequirementsForPermission(required, on) : this.getRequirementsForPermissionGroup(pg, on, qName, aspectQNames);
                        answer = Collections.unmodifiableSet(answer);
                        this.requiredPermissionsCache.put(key, answer);
                    }
                }
                finally {
                    if (!hadWriteLock) {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                }
            }
            return answer;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Set<PermissionReference> getUnconditionalRequiredPermissions(PermissionReference required, RequiredPermission.On on) {
            if (required == null) {
                return Collections.emptySet();
            }
            Pair key = new Pair((Object)required, (Object)on);
            Set<PermissionReference> answer = this.unconditionalRequiredPermissionsCache.get(key);
            if (answer == null) {
                boolean hadWriteLock = this.lock.isWriteLockedByCurrentThread();
                if (!hadWriteLock) {
                    this.lock.readLock().unlock();
                    this.lock.writeLock().lock();
                }
                try {
                    answer = this.unconditionalRequiredPermissionsCache.get(key);
                    if (answer == null) {
                        PermissionGroup pg = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(required));
                        answer = pg == null ? this.getRequirementsForPermission(required, on) : this.getUnconditionalRequirementsForPermissionGroup(pg, on);
                        answer = Collections.unmodifiableSet(answer);
                        this.unconditionalRequiredPermissionsCache.put((Pair<PermissionReference, RequiredPermission.On>)key, answer);
                    }
                }
                finally {
                    if (!hadWriteLock) {
                        this.lock.readLock().lock();
                        this.lock.writeLock().unlock();
                    }
                }
            }
            return answer;
        }

        private Set<PermissionReference> getRequirementsForPermission(PermissionReference required, RequiredPermission.On on) {
            HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>();
            Permission p = this.getPermissionOrNull(required);
            if (p != null) {
                for (RequiredPermission rp : p.getRequiredPermissions()) {
                    if (rp.isImplies() || !rp.getOn().equals((Object)on)) continue;
                    requiredPermissions.add(rp);
                }
            }
            return requiredPermissions;
        }

        private Set<PermissionReference> getRequirementsForPermissionGroup(PermissionGroup target, RequiredPermission.On on, QName qName, Set<QName> aspectQNames) {
            HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>(16, 1.0f);
            if (target == null) {
                return requiredPermissions;
            }
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(pg);
                    if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() && !this.isPartOfDynamicPermissionGroup(pg, qName, aspectQNames)) continue;
                    for (PermissionReference pr : pg.getIncludedPermissionGroups()) {
                        requiredPermissions.addAll(this.getRequirementsForPermissionGroup(this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(pr)), on, qName, aspectQNames));
                    }
                }
                for (Permission p : ps.getPermissions()) {
                    for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                        PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                        if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() && !this.isPartOfDynamicPermissionGroup(grantedTo, qName, aspectQNames) || on != RequiredPermission.On.NODE) continue;
                        requiredPermissions.add(p);
                    }
                }
            }
            return requiredPermissions;
        }

        private Set<PermissionReference> getUnconditionalRequirementsForPermissionGroup(PermissionGroup target, RequiredPermission.On on) {
            HashSet<PermissionReference> requiredPermissions = new HashSet<PermissionReference>(16, 1.0f);
            if (target == null) {
                return requiredPermissions;
            }
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    PermissionGroup base = this.getBasePermissionGroupOrNull(pg);
                    if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired()) continue;
                    for (PermissionReference pr : pg.getIncludedPermissionGroups()) {
                        requiredPermissions.addAll(this.getUnconditionalRequirementsForPermissionGroup(this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(pr)), on));
                    }
                }
                for (Permission p : ps.getPermissions()) {
                    for (PermissionReference grantedTo : p.getGrantedToGroups()) {
                        PermissionGroup base = this.getBasePermissionGroupOrNull(this.getPermissionGroupOrNull(grantedTo));
                        if (!target.equals(base) && !target.isAllowFullControl() || base.isTypeRequired() || on != RequiredPermission.On.NODE) continue;
                        requiredPermissions.add(p);
                    }
                }
            }
            return requiredPermissions;
        }

        private Permission getPermissionOrNull(PermissionReference perm) {
            Permission p = this.permissionMap.get(perm);
            return p == null ? null : p;
        }

        private boolean isPartOfDynamicPermissionGroup(PermissionReference pr, QName typeQname, Set<QName> aspects) {
            if (this.dictionaryService.isSubClass(typeQname, pr.getQName())) {
                return true;
            }
            for (QName aspect : aspects) {
                if (!this.dictionaryService.isSubClass(aspect, pr.getQName())) continue;
                return true;
            }
            return false;
        }

        public PermissionReference getPermissionReference(QName qname, String permissionName) {
            if (permissionName == null) {
                return null;
            }
            PermissionReference pr = this.uniqueMap.get(permissionName);
            if (pr == null && (pr = this.permissionReferenceMap.get(permissionName)) == null) {
                throw new UnsupportedOperationException("Can not find " + permissionName);
            }
            return pr;
        }

        public boolean isUnique(PermissionReference permissionReference) {
            return this.uniqueMap.containsKey(permissionReference.getName());
        }

        private void buildUniquePermissionMap() {
            HashSet<String> excluded = new HashSet<String>(128, 1.0f);
            this.uniqueMap = new HashMap<String, PermissionReference>(256);
            this.permissionReferenceMap = new HashMap<String, PermissionReference>(256);
            this.permissionGroupMap = new HashMap<PermissionReference, PermissionGroup>(128);
            this.permissionMap = new HashMap<PermissionReference, Permission>(64);
            for (PermissionSet ps : this.permissionSets.values()) {
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    this.permissionGroupMap.put(SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()), pg);
                    this.permissionReferenceMap.put(pg.toString(), SimplePermissionReference.getPermissionReference(pg.getQName(), pg.getName()));
                }
                for (Permission p : ps.getPermissions()) {
                    this.permissionReferenceMap.put(p.toString(), SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                    this.permissionMap.put(SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()), p);
                }
            }
            for (PermissionSet ps : this.permissionSets.values()) {
                PermissionReference value;
                for (PermissionGroup pg : ps.getPermissionGroups()) {
                    if (this.uniqueMap.containsKey(pg.getName()) && !excluded.contains(pg.getName())) {
                        value = this.uniqueMap.get(pg.getName());
                        if (value.equals(this.getBasePermissionGroup(pg))) continue;
                        this.uniqueMap.remove(pg.getName());
                        excluded.add(pg.getName());
                        continue;
                    }
                    PermissionGroup base = this.getBasePermissionGroup(pg);
                    this.uniqueMap.put(pg.getName(), SimplePermissionReference.getPermissionReference(base.getQName(), base.getName()));
                }
                for (Permission p : ps.getPermissions()) {
                    if (this.uniqueMap.containsKey(p.getName()) && !excluded.contains(p.getName())) {
                        value = this.uniqueMap.get(p.getName());
                        if (value.equals(p)) continue;
                        this.uniqueMap.remove(p.getName());
                        excluded.add(p.getName());
                        continue;
                    }
                    this.uniqueMap.put(p.getName(), SimplePermissionReference.getPermissionReference(p.getQName(), p.getName()));
                }
            }
            if (this.uniqueMap.containsKey("All")) {
                throw new IllegalStateException("There must not be a permission with the same name as the ALL_PERMISSION constant: All");
            }
            this.uniqueMap.put("All", SimplePermissionReference.getPermissionReference(QName.createQName((String)"http://www.alfresco.org/model/security/1.0", (String)"All"), "All"));
        }

        private boolean hasFull(PermissionReference permissionReference) {
            if (permissionReference == null) {
                return false;
            }
            if (permissionReference.equals(ALL)) {
                return true;
            }
            PermissionGroup group = this.getPermissionGroupOrNull(permissionReference);
            if (group == null) {
                return false;
            }
            if (group.isAllowFullControl()) {
                return true;
            }
            if (group.isExtends()) {
                QName parent;
                if (group.getTypeQName() != null) {
                    return this.hasFull(SimplePermissionReference.getPermissionReference(group.getTypeQName(), group.getName()));
                }
                ClassDefinition classDefinition = this.dictionaryService.getClass(group.getQName());
                while ((parent = classDefinition.getParentName()) != null) {
                    classDefinition = this.dictionaryService.getClass(parent);
                    PermissionGroup attempt = this.getPermissionGroupOrNull(SimplePermissionReference.getPermissionReference(parent, group.getName()));
                    if (attempt == null || !attempt.isAllowFullControl()) continue;
                    return true;
                }
                return false;
            }
            return false;
        }
    }
}

