/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.security.person;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.model.ContentModel;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.domain.node.NodeDAO;
import org.alfresco.repo.domain.qname.QNameDAO;
import org.alfresco.repo.domain.query.CannedQueryDAO;
import org.alfresco.repo.security.person.FilterSortPersonEntity;
import org.alfresco.repo.security.person.GetPeopleCannedQueryParams;
import org.alfresco.repo.tenant.TenantService;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GetPeopleCannedQuery
extends AbstractCannedQuery<NodeRef> {
    private Log logger = LogFactory.getLog(((Object)((Object)this)).getClass());
    private static final String QUERY_NAMESPACE = "alfresco.query.people";
    private static final String QUERY_SELECT_GET_PEOPLE = "select_GetPeopleCannedQuery";
    public static final int MAX_FILTER_SORT_PROPS = 3;
    private static final int MAX_EXPECTED_ADMINS = 5;
    private NodeDAO nodeDAO;
    private QNameDAO qnameDAO;
    private CannedQueryDAO cannedQueryDAO;
    private TenantService tenantService;
    private NodeService nodeService;
    private AuthorityService authorityService;

    public GetPeopleCannedQuery(NodeDAO nodeDAO, QNameDAO qnameDAO, CannedQueryDAO cannedQueryDAO, TenantService tenantService, NodeService nodeService, AuthorityService authorityService, CannedQueryParameters params) {
        super(params);
        this.nodeDAO = nodeDAO;
        this.qnameDAO = qnameDAO;
        this.cannedQueryDAO = cannedQueryDAO;
        this.tenantService = tenantService;
        this.nodeService = nodeService;
        this.authorityService = authorityService;
    }

    protected List<NodeRef> queryAndFilter(CannedQueryParameters parameters) {
        boolean excludeAdmins;
        Set<Long> qnamesIds;
        Long start = this.logger.isDebugEnabled() ? Long.valueOf(System.currentTimeMillis()) : null;
        GetPeopleCannedQueryParams paramBean = (GetPeopleCannedQueryParams)parameters.getParameterBean();
        NodeRef parentRef = paramBean.getParentRef();
        ParameterCheck.mandatory((String)"nodeRef", (Object)parentRef);
        Pair<Long, NodeRef> nodePair = this.nodeDAO.getNodePair(parentRef);
        if (nodePair == null) {
            throw new InvalidNodeRefException("Parent node does not exist: " + parentRef, parentRef);
        }
        Long parentNodeId = (Long)nodePair.getFirst();
        FilterSortPersonEntity params = new FilterSortPersonEntity();
        params.setParentNodeId(parentNodeId);
        List<QName> filterProps = paramBean.getFilterProps();
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        List sortPairs = sortDetails.getSortPairs();
        String pattern = paramBean.getPattern();
        if (pattern == null || pattern.equals("")) {
            pattern = "%";
        } else if (!pattern.endsWith("%") && !pattern.endsWith("*")) {
            pattern = pattern + "%";
        }
        params.setPattern(pattern);
        if (paramBean.getExclusiveAspects() != null) {
            qnamesIds = this.qnameDAO.convertQNamesToIds(paramBean.getExclusiveAspects(), false);
            params.setExcludeAspectIds(new ArrayList<Long>(qnamesIds));
        }
        if (paramBean.getInclusiveAspects() != null) {
            qnamesIds = this.qnameDAO.convertQNamesToIds(paramBean.getInclusiveAspects(), false);
            params.setIncludeAspectIds(new ArrayList<Long>(qnamesIds));
        }
        ArrayList<QName> sortFilterProps = new ArrayList<QName>(3);
        HashMap<QName, Boolean> sortAsc = new HashMap<QName, Boolean>(3);
        for (Pair sort : sortPairs) {
            QName sortQName = (QName)sort.getFirst();
            if (filterProps.size() > 0 && !filterProps.contains(sortQName)) {
                throw new AlfrescoRuntimeException("GetPeople: cannot sort by a non-filter property: " + sortQName + " (filterStringProps=" + filterProps + ")");
            }
            if (sortFilterProps.contains(sortQName)) continue;
            sortFilterProps.add(sortQName);
            sortAsc.put(sortQName, ((CannedQuerySortDetails.SortOrder)sort.getSecond()).equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING));
        }
        for (QName filterQName : filterProps) {
            if (sortFilterProps.contains(filterQName)) continue;
            sortFilterProps.add(filterQName);
            sortAsc.put(filterQName, null);
        }
        int filterSortPropCnt = sortFilterProps.size();
        if (filterSortPropCnt > 3) {
            throw new AlfrescoRuntimeException("GetPeople: exceeded maximum number filter/sort properties: (max=3, actual=" + filterSortPropCnt);
        }
        filterSortPropCnt = this.setFilterSortParams(sortFilterProps, sortAsc, params);
        List<Object> result = new ArrayList<NodeRef>(100);
        DefaultPersonQueryCallback c = new DefaultPersonQueryCallback(result, paramBean.getIncludeAdministrators());
        PersonResultHandler resultHandler = new PersonResultHandler(c);
        int offset = parameters.getPageDetails().getSkipResults();
        int totalResultCountMax = parameters.getTotalResultCountMax();
        int origOffset = offset;
        int origLimit = totalResultCountMax > 0 ? totalResultCountMax : parameters.getPageDetails().getPageSize();
        long newLimit = origLimit;
        ++newLimit;
        boolean bl = excludeAdmins = !paramBean.getIncludeAdministrators();
        if (excludeAdmins) {
            offset = 0;
            newLimit = (long)offset + newLimit + 5L;
        }
        if (newLimit > Integer.MAX_VALUE) {
            newLimit = Integer.MAX_VALUE;
        }
        this.cannedQueryDAO.executeQuery(QUERY_NAMESPACE, QUERY_SELECT_GET_PEOPLE, params, offset, (int)newLimit, resultHandler);
        resultHandler.done();
        if (start != null) {
            this.logger.debug((Object)("Base query: " + result.size() + " in " + (System.currentTimeMillis() - start) + " msecs"));
        }
        if (excludeAdmins) {
            long max = (long)origOffset + (long)origLimit;
            if (max > (long)result.size()) {
                max = result.size();
            }
            result = result.subList(origOffset, (int)max);
        }
        return result;
    }

    private int setFilterSortParams(List<QName> filterSortProps, Map<QName, Boolean> sortAsc, FilterSortPersonEntity params) {
        int cnt = 0;
        int propCnt = 0;
        for (QName filterSortProp : filterSortProps) {
            Long sortQNameId = this.getQNameId(filterSortProp);
            Boolean sortOrder = sortAsc.get(filterSortProp);
            if (sortQNameId != null) {
                if (propCnt == 0) {
                    params.setProp1qnameId(sortQNameId);
                    params.setSort1asc(sortOrder);
                } else if (propCnt == 1) {
                    params.setProp2qnameId(sortQNameId);
                    params.setSort2asc(sortOrder);
                } else if (propCnt == 2) {
                    params.setProp3qnameId(sortQNameId);
                    params.setSort3asc(sortOrder);
                } else {
                    throw new AlfrescoRuntimeException("GetPeople: unexpected - cannot set sort parameter: " + cnt);
                }
                ++propCnt;
            } else {
                this.logger.warn((Object)("Skipping filter/sort param - cannot find: " + filterSortProp));
                break;
            }
            ++cnt;
        }
        return cnt;
    }

    private Long getQNameId(QName sortPropQName) {
        Pair<Long, QName> qnamePair = this.qnameDAO.getQName(sortPropQName);
        return qnamePair == null ? null : (Long)qnamePair.getFirst();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    protected boolean isApplyPostQueryPermissions() {
        return false;
    }

    protected boolean isApplyPostQueryPaging() {
        return false;
    }

    protected Pair<Integer, Integer> getTotalResultCount(List<NodeRef> results) {
        int offset = super.getParameters().getPageDetails().getSkipResults();
        Integer size = offset + results.size();
        return new Pair((Object)size, (Object)size);
    }

    protected class PersonResultHandler
    implements CannedQueryDAO.ResultHandler<String> {
        private final PersonQueryCallback resultsCallback;

        private PersonResultHandler(PersonQueryCallback resultsCallback) {
            this.resultsCallback = resultsCallback;
        }

        @Override
        public boolean handleResult(String uuid) {
            return this.resultsCallback.handle(new NodeRef(StoreRef.STORE_REF_WORKSPACE_SPACESSTORE, uuid));
        }

        public void done() {
        }
    }

    protected class DefaultPersonQueryCallback
    implements PersonQueryCallback {
        private List<NodeRef> children;
        private boolean includeAdministrators;

        public DefaultPersonQueryCallback(List<NodeRef> children, boolean includeAdministrators) {
            this.children = children;
            this.includeAdministrators = includeAdministrators;
        }

        @Override
        public boolean handle(NodeRef personRef) {
            if (!this.includeAdministrators) {
                String userName = (String)((Object)GetPeopleCannedQuery.this.nodeService.getProperty(personRef, ContentModel.PROP_USERNAME));
                if (GetPeopleCannedQuery.this.authorityService.isAdminAuthority(userName)) {
                    return true;
                }
            }
            this.children.add(GetPeopleCannedQuery.this.tenantService.getBaseName(personRef));
            return true;
        }
    }

    protected static interface PersonQueryCallback {
        public boolean handle(NodeRef var1);
    }
}

