/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.site;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.alfresco.query.AbstractCannedQuery;
import org.alfresco.query.CannedQueryParameters;
import org.alfresco.query.CannedQuerySortDetails;
import org.alfresco.repo.site.SiteMembership;
import org.alfresco.repo.site.SitesCannedQueryParams;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.site.SiteInfo;
import org.alfresco.service.cmr.site.SiteRole;
import org.alfresco.service.cmr.site.SiteService;
import org.alfresco.util.Pair;

public class SitesCannedQuery
extends AbstractCannedQuery<SiteMembership> {
    private AuthorityService authorityService;
    private SiteService siteService;

    protected SitesCannedQuery(AuthorityService authorityService, SiteService siteService, CannedQueryParameters parameters) {
        super(parameters);
        this.authorityService = authorityService;
        this.siteService = siteService;
    }

    protected List<SiteMembership> queryAndFilter(CannedQueryParameters parameters) {
        SitesCannedQueryParams paramBean = (SitesCannedQueryParams)parameters.getParameterBean();
        String userName = paramBean.getUsername();
        int size = Integer.MAX_VALUE;
        CannedQuerySortDetails sortDetails = parameters.getSortDetails();
        List sortPairs = sortDetails.getSortPairs();
        CQAuthorityFilter filter = new CQAuthorityFilter(userName, sortPairs);
        this.authorityService.getContainingAuthoritiesInZone(AuthorityType.GROUP, userName, "APP.SHARE", filter, Integer.MAX_VALUE);
        return filter.getSiteMemberships();
    }

    protected boolean isApplyPostQuerySorting() {
        return false;
    }

    private static class SiteMembershipComparator
    implements Comparator<SiteMembership> {
        private List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs;
        private static Collator collator = Collator.getInstance();

        public SiteMembershipComparator(List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            if (sortPairs.size() < 1) {
                throw new IllegalArgumentException("Must provide at least one sort criterion");
            }
            this.sortPairs = sortPairs;
        }

        private <T> int safeCompare(Comparable<T> o1, T o2) {
            int ret = 0;
            ret = o1 == null ? (o2 == null ? 0 : -1) : (o2 == null ? 1 : o1.compareTo(o2));
            return ret;
        }

        private int safeCompare(String s1, String s2) {
            int ret = 0;
            ret = s1 == null ? (s2 == null ? 0 : -1) : (s2 == null ? 1 : collator.compare(s1, s2));
            return ret;
        }

        @Override
        public int compare(SiteMembership o1, SiteMembership o2) {
            String personId1 = o1.getPersonId();
            String personId2 = o2.getPersonId();
            SiteInfo siteInfo1 = o1.getSiteInfo();
            SiteInfo siteInfo2 = o2.getSiteInfo();
            String shortName1 = siteInfo1.getShortName();
            String shortName2 = siteInfo2.getShortName();
            String firstName1 = o1.getFirstName();
            String firstName2 = o2.getFirstName();
            String lastName1 = o1.getLastName();
            String lastName2 = o2.getLastName();
            SiteRole siteRole1 = o1.getRole();
            SiteRole siteRole2 = o2.getRole();
            String siteTitle1 = siteInfo1.getTitle();
            String siteTitle2 = siteInfo2.getTitle();
            int personId = this.safeCompare(personId1, personId2);
            int firstName = this.safeCompare(firstName1, firstName2);
            int siteShortName = this.safeCompare(shortName1, shortName2);
            int lastName = this.safeCompare(lastName1, lastName2);
            int siteRole = this.safeCompare((Comparable)((Object)siteRole1), (Object)((Object)siteRole2));
            int siteTitle = this.safeCompare(siteTitle1, siteTitle2);
            if (siteRole == 0 && siteShortName == 0 && personId == 0) {
                return 0;
            }
            int ret = 0;
            for (Pair<? extends Object, CannedQuerySortDetails.SortOrder> pair : this.sortPairs) {
                int multiplier;
                Object name = pair.getFirst();
                CannedQuerySortDetails.SortOrder sortOrder = (CannedQuerySortDetails.SortOrder)pair.getSecond();
                int n = multiplier = sortOrder.equals((Object)CannedQuerySortDetails.SortOrder.ASCENDING) ? 1 : -1;
                if (name.equals((Object)SiteService.SortFields.SiteShortName)) {
                    if (shortName1 == null || shortName2 == null) continue;
                    ret = siteShortName * multiplier;
                } else if (name.equals((Object)SiteService.SortFields.SiteTitle)) {
                    if (siteTitle1 == null || siteTitle2 == null) continue;
                    ret = siteTitle * multiplier;
                } else if (name.equals((Object)SiteService.SortFields.Role)) {
                    if (siteRole1 == null || siteRole2 == null) continue;
                    ret = siteRole * multiplier;
                }
                if (ret == 0) continue;
                break;
            }
            return ret;
        }
    }

    private class CQAuthorityFilter
    implements AuthorityService.AuthorityFilter {
        private String userName;
        private Set<SiteMembership> siteMembers;

        CQAuthorityFilter(String userName, List<Pair<? extends Object, CannedQuerySortDetails.SortOrder>> sortPairs) {
            this.userName = userName;
            this.siteMembers = sortPairs != null && sortPairs.size() > 0 ? new TreeSet<SiteMembership>(new SiteMembershipComparator(sortPairs)) : new HashSet<SiteMembership>();
        }

        @Override
        public boolean includeAuthority(String authority) {
            String role;
            SiteInfo siteInfo;
            String siteName = SitesCannedQuery.this.siteService.resolveSite(authority);
            if (siteName != null && (siteInfo = SitesCannedQuery.this.siteService.getSite(siteName)) != null && (role = SitesCannedQuery.this.siteService.getMembersRole(siteName, this.userName)) != null) {
                this.siteMembers.add(new SiteMembership(siteInfo, authority, SiteRole.valueOf(role)));
            }
            return true;
        }

        List<SiteMembership> getSiteMemberships() {
            ArrayList<SiteMembership> siteMemberships = new ArrayList<SiteMembership>(this.siteMembers.size());
            Iterator<SiteMembership> it = this.siteMembers.iterator();
            while (it.hasNext()) {
                siteMemberships.add(it.next());
                it.remove();
            }
            return siteMemberships;
        }
    }
}

