/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.solr;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.HttpClientFactory;
import org.alfresco.repo.solr.SOLRWatcherJob;
import org.alfresco.repo.solr.SolrActiveEvent;
import org.alfresco.repo.solr.SolrInactiveEvent;
import org.alfresco.util.ParameterCheck;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.CommonsHttpSolrServer;
import org.apache.solr.client.solrj.response.QueryResponse;
import org.apache.solr.common.params.ModifiableSolrParams;
import org.apache.solr.common.params.SolrParams;
import org.apache.solr.common.util.NamedList;
import org.quartz.CronTrigger;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.quartz.Trigger;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;

public class SOLRAdminClient
implements ApplicationEventPublisherAware,
DisposableBean {
    private String solrHost;
    private int solrPort;
    private int solrSSLPort;
    private String solrUrl;
    private String solrUser;
    private String solrPassword;
    private String solrPingCronExpression;
    private CommonsHttpSolrServer server;
    private int solrConnectTimeout = 30000;
    private ApplicationEventPublisher applicationEventPublisher;
    private SolrTracker solrTracker;
    private HttpClientFactory httpClientFactory;
    private Scheduler scheduler;

    public void setSolrHost(String solrHost) {
        this.solrHost = solrHost;
    }

    public void setSolrPort(String solrPort) {
        this.solrPort = Integer.parseInt(solrPort);
    }

    public void setSolrsslPort(int solrSSLPort) {
        this.solrSSLPort = solrSSLPort;
    }

    public void setSolrUser(String solrUser) {
        this.solrUser = solrUser;
    }

    public void setSolrPassword(String solrPassword) {
        this.solrPassword = solrPassword;
    }

    public void setSolrConnectTimeout(String solrConnectTimeout) {
        this.solrConnectTimeout = Integer.parseInt(solrConnectTimeout);
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    public void setSolrPingCronExpression(String solrPingCronExpression) {
        this.solrPingCronExpression = solrPingCronExpression;
    }

    public void setHttpClientFactory(HttpClientFactory httpClientFactory) {
        this.httpClientFactory = httpClientFactory;
    }

    public void setScheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
    }

    public void init() {
        ParameterCheck.mandatory((String)"solrHost", (Object)this.solrHost);
        ParameterCheck.mandatory((String)"solrPort", (Object)this.solrPort);
        ParameterCheck.mandatory((String)"solrUser", (Object)this.solrUser);
        ParameterCheck.mandatory((String)"solrPassword", (Object)this.solrPassword);
        ParameterCheck.mandatory((String)"solrPingCronExpression", (Object)this.solrPingCronExpression);
        ParameterCheck.mandatory((String)"solrConnectTimeout", (Object)this.solrConnectTimeout);
        try {
            StringBuilder sb = new StringBuilder();
            sb.append(this.httpClientFactory.isSSL() ? "https://" : "http://");
            sb.append(this.solrHost);
            sb.append(":");
            sb.append(this.httpClientFactory.isSSL() ? this.solrSSLPort : this.solrPort);
            sb.append("/solr");
            this.solrUrl = sb.toString();
            HttpClient httpClient = this.httpClientFactory.getHttpClient();
            this.server = new CommonsHttpSolrServer(this.solrUrl, httpClient);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(this.solrUser, this.solrPassword);
            this.server.getHttpClient().getState().setCredentials(new AuthScope(this.solrHost, this.solrPort, AuthScope.ANY_REALM), (Credentials)defaultcreds);
            this.server.setConnectionTimeout(this.solrConnectTimeout);
            this.server.setSoTimeout(20000);
            this.solrTracker = new SolrTracker(this.scheduler);
        }
        catch (MalformedURLException e) {
            throw new AlfrescoRuntimeException("Cannot initialise Solr admin http client", (Throwable)e);
        }
    }

    public QueryResponse basicQuery(ModifiableSolrParams params) {
        try {
            QueryResponse response = this.server.query((SolrParams)params);
            return response;
        }
        catch (SolrServerException e) {
            return null;
        }
    }

    public QueryResponse query(ModifiableSolrParams params) throws SolrServerException {
        try {
            QueryResponse response = this.server.query((SolrParams)params);
            if (response.getStatus() != 0) {
                this.solrTracker.setSolrActive(false);
            }
            return response;
        }
        catch (SolrServerException e) {
            this.solrTracker.setSolrActive(false);
            throw e;
        }
    }

    public List<String> getRegisteredCores() {
        return this.solrTracker.getRegisteredCores();
    }

    public void destroy() throws Exception {
        this.solrTracker.stopTimer();
    }

    class SolrTracker {
        private final ReentrantReadWriteLock.WriteLock writeLock;
        private boolean solrActive = false;
        private Scheduler scheduler = null;
        private Trigger trigger;
        private List<String> cores;

        SolrTracker(Scheduler scheduler) {
            this.scheduler = scheduler;
            ReentrantReadWriteLock lock = new ReentrantReadWriteLock();
            this.writeLock = lock.writeLock();
            this.cores = new ArrayList<String>(5);
            this.setupTimer();
        }

        protected void pingSolr() {
            ModifiableSolrParams params = new ModifiableSolrParams();
            params.set("qt", new String[]{"/admin/cores"});
            params.set("action", new String[]{"STATUS"});
            QueryResponse response = SOLRAdminClient.this.basicQuery(params);
            if (response != null && response.getStatus() == 0) {
                NamedList results = response.getResponse();
                NamedList report = (NamedList)results.get("status");
                Iterator coreIterator = report.iterator();
                ArrayList<String> cores = new ArrayList<String>(report.size());
                while (coreIterator.hasNext()) {
                    Map.Entry core = (Map.Entry)coreIterator.next();
                    cores.add((String)core.getKey());
                }
                this.registerCores(cores);
                this.setSolrActive(true);
            } else {
                this.setSolrActive(false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void setSolrActive(boolean active) {
            boolean statusChanged = false;
            try {
                this.writeLock.lock();
                try {
                    if (this.solrActive != active) {
                        this.solrActive = active;
                        statusChanged = true;
                    }
                }
                finally {
                    this.writeLock.unlock();
                }
                if (statusChanged) {
                    if (this.solrActive) {
                        this.stopTimer();
                        SOLRAdminClient.this.applicationEventPublisher.publishEvent((ApplicationEvent)new SolrActiveEvent(this));
                    } else {
                        this.startTimer();
                        SOLRAdminClient.this.applicationEventPublisher.publishEvent((ApplicationEvent)new SolrInactiveEvent(this));
                    }
                }
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("", (Throwable)e);
            }
        }

        boolean isSolrActive() {
            return this.solrActive;
        }

        protected void setupTimer() {
            try {
                String jobName = "SolrWatcher";
                String jobGroup = "Solr";
                JobDetail existingJob = this.scheduler.getJobDetail("SolrWatcher", "Solr");
                if (existingJob != null) {
                    this.scheduler.deleteJob("SolrWatcher", "Solr");
                }
                JobDetail job = new JobDetail("SolrWatcher", "Solr", SOLRWatcherJob.class);
                JobDataMap jobDataMap = new JobDataMap();
                jobDataMap.put((Object)"SOLR_TRACKER", (Object)this);
                job.setJobDataMap(jobDataMap);
                this.trigger = new CronTrigger("SolrWatcherTrigger", "Solr", SOLRAdminClient.this.solrPingCronExpression);
                this.scheduler.scheduleJob(job, this.trigger);
            }
            catch (Exception e) {
                throw new AlfrescoRuntimeException("Unable to set up SOLRTracker timer", (Throwable)e);
            }
        }

        protected void startTimer() throws SchedulerException {
            this.scheduler.resumeTrigger(this.trigger.getName(), this.trigger.getGroup());
        }

        protected void stopTimer() throws SchedulerException {
            this.scheduler.pauseTrigger(this.trigger.getName(), this.trigger.getGroup());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void registerCores(List<String> cores) {
            this.writeLock.lock();
            try {
                this.cores = cores;
            }
            finally {
                this.writeLock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<String> getRegisteredCores() {
            this.writeLock.lock();
            try {
                List<String> list = this.cores != null ? this.cores : Collections.EMPTY_LIST;
                return list;
            }
            finally {
                this.writeLock.unlock();
            }
        }
    }
}

