/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.template;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.template.AVMTemplateNode;
import org.alfresco.repo.template.BaseTemplateProcessorExtension;
import org.alfresco.repo.template.PropertyConverter;
import org.alfresco.repo.template.TemplateContent;
import org.alfresco.repo.template.TemplateNode;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TemplateImageResolver;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNameMap;
import org.alfresco.util.Pair;

public class Workflow
extends BaseTemplateProcessorExtension {
    private static final String WCM_WF_MODEL_1_0_URI = "http://www.alfresco.org/model/wcmworkflow/1.0";
    private static final QName PROP_FROM_PATH = QName.createQName((String)"http://www.alfresco.org/model/wcmworkflow/1.0", (String)"fromPath");
    private ServiceRegistry services;

    public void setServiceRegistry(ServiceRegistry services) {
        this.services = services;
    }

    public List<WorkflowTaskItem> getAssignedTasks() {
        List<WorkflowTask> tasks = this.getWorkflowService().getAssignedTasks(this.services.getAuthenticationService().getCurrentUserName(), WorkflowTaskState.IN_PROGRESS);
        return this.convertTasks(tasks);
    }

    public List<WorkflowTaskItem> getPooledTasks() {
        List<WorkflowTask> tasks = this.getWorkflowService().getPooledTasks(this.services.getAuthenticationService().getCurrentUserName());
        return this.convertTasks(tasks);
    }

    public List<WorkflowTaskItem> getCompletedTasks() {
        List<WorkflowTask> tasks = this.getWorkflowService().getAssignedTasks(this.services.getAuthenticationService().getCurrentUserName(), WorkflowTaskState.COMPLETED);
        return this.convertTasks(tasks);
    }

    public WorkflowTaskItem getTaskById(String taskId) {
        WorkflowTask task = this.getWorkflowService().getTaskById(taskId);
        return new WorkflowTaskItem(this.services, this.getTemplateImageResolver(), task);
    }

    private List<WorkflowTaskItem> convertTasks(List<WorkflowTask> tasks) {
        ArrayList<WorkflowTaskItem> items = new ArrayList<WorkflowTaskItem>(tasks.size());
        for (WorkflowTask task : tasks) {
            items.add(new WorkflowTaskItem(this.services, this.getTemplateImageResolver(), task));
        }
        return items;
    }

    private WorkflowService getWorkflowService() {
        return this.services.getWorkflowService();
    }

    public static class WorkflowTaskItem
    implements NamespacePrefixResolverProvider {
        private WorkflowTask task;
        private QNameMap<String, Serializable> properties = null;
        private ServiceRegistry services;
        private TemplateImageResolver resolver;

        public WorkflowTaskItem(ServiceRegistry services, TemplateImageResolver resolver, WorkflowTask task) {
            this.task = task;
            this.services = services;
            this.resolver = resolver;
        }

        public String getType() {
            return this.task.title;
        }

        public String getQnameType() {
            return this.task.definition.metadata.getName().toString();
        }

        public String getName() {
            return this.task.description;
        }

        public String getDescription() {
            return this.task.path.instance.description;
        }

        public String getId() {
            return this.task.id;
        }

        public boolean getIsCompleted() {
            return this.task.state == WorkflowTaskState.COMPLETED;
        }

        public Date getStartDate() {
            return this.task.path.instance.startDate;
        }

        public Map<String, String>[] getTransitions() {
            HashMap[] tranMaps = null;
            WorkflowTransition[] transitions = this.task.definition.node.transitions;
            if (transitions != null) {
                tranMaps = new HashMap[transitions.length];
                for (int i = 0; i < transitions.length; ++i) {
                    tranMaps[i] = new HashMap(2, 1.0f);
                    tranMaps[i].put("label", transitions[i].title);
                    tranMaps[i].put("id", transitions[i].id);
                }
            }
            return tranMaps != null ? tranMaps : new HashMap[]{};
        }

        public TemplateNode getInitiator() {
            return new TemplateNode(this.task.path.instance.initiator, this.services, this.resolver);
        }

        public NodeRef getPackage() {
            return (NodeRef)this.task.properties.get(WorkflowModel.ASSOC_PACKAGE);
        }

        public TemplateNode getPackageTemplateNode() {
            NodeRef nodeRef = this.getPackage();
            if (nodeRef != null) {
                return new TemplateNode(nodeRef, this.services, this.resolver);
            }
            return null;
        }

        public List<TemplateContent> getPackageResources() {
            ArrayList<TemplateContent> resources = new ArrayList<TemplateContent>();
            List<NodeRef> contents = this.services.getWorkflowService().getPackageContents(this.task.id);
            NodeService nodeService = this.services.getNodeService();
            DictionaryService ddService = this.services.getDictionaryService();
            for (NodeRef nodeRef : contents) {
                if (nodeRef.getStoreRef().getProtocol().equals("avm")) {
                    Pair<Integer, String> vp = AVMNodeConverter.ToAVMVersionPath(nodeRef);
                    resources.add(new AVMTemplateNode((String)vp.getSecond(), (Integer)vp.getFirst(), this.services, this.resolver));
                    continue;
                }
                QName type = nodeService.getType(nodeRef);
                if (ddService.getType(type) == null || !ddService.isSubClass(type, ContentModel.TYPE_CONTENT) && !ApplicationModel.TYPE_FILELINK.equals((Object)type)) continue;
                resources.add(new TemplateNode(nodeRef, this.services, this.resolver));
            }
            return resources;
        }

        public String getOutcome() {
            String transition;
            String outcome = null;
            if (this.task.state.equals((Object)WorkflowTaskState.COMPLETED) && (transition = (String)((Object)this.task.properties.get(WorkflowModel.PROP_OUTCOME))) != null) {
                WorkflowTransition[] transitions;
                for (WorkflowTransition trans : transitions = this.task.definition.node.transitions) {
                    if (!trans.id.equals(transition)) continue;
                    outcome = trans.title;
                    break;
                }
            }
            return outcome;
        }

        public Map<String, Serializable> getProperties() {
            if (this.properties == null) {
                PropertyConverter converter = new PropertyConverter();
                this.properties = new QNameMap((NamespacePrefixResolverProvider)this);
                for (QName qname : this.task.properties.keySet()) {
                    Serializable value = converter.convertProperty(this.task.properties.get(qname), qname, this.services, this.resolver);
                    this.properties.put((Object)qname.toString(), (Object)value);
                }
            }
            return this.properties;
        }

        public NamespacePrefixResolver getNamespacePrefixResolver() {
            return this.services.getNamespaceService();
        }
    }
}

