/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import org.alfresco.repo.thumbnail.FailureHandlingOptions;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ThumbnailDefinition {
    private static final Log logger = LogFactory.getLog(ThumbnailDefinition.class);
    private String name;
    private String mimetype;
    private TransformationOptions options;
    private FailureHandlingOptions failureOptions;
    private String placeHolderResourcePath;
    private String mimeAwarePlaceHolderResourcePath;
    private String runAs;
    private ThumbnailRegistry thumbnailRegistry;

    public ThumbnailDefinition() {
    }

    public ThumbnailDefinition(String destinationMimetype, TransformationOptions options) {
        this.mimetype = destinationMimetype;
        this.options = options;
    }

    public ThumbnailDefinition(String mimetype, TransformationOptions options, String thumbnailName) {
        this(mimetype, options);
        this.name = thumbnailName;
        options.setUse(thumbnailName);
    }

    public ThumbnailDefinition(String mimetype, TransformationOptions options, String thumbnailName, String placeHolderResourcePath) {
        this(mimetype, options, thumbnailName);
        this.placeHolderResourcePath = placeHolderResourcePath;
        options.setUse(thumbnailName);
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setTransformationOptions(TransformationOptions options) {
        this.options = options;
    }

    public TransformationOptions getTransformationOptions() {
        return this.options;
    }

    public void setFailureHandlingOptions(FailureHandlingOptions failureOptions) {
        this.failureOptions = failureOptions;
    }

    public FailureHandlingOptions getFailureHandlingOptions() {
        return this.failureOptions;
    }

    public void setName(String thumbnailName) {
        this.name = thumbnailName;
    }

    public String getName() {
        return this.name;
    }

    public void setRunAs(String runAs) {
        this.runAs = runAs;
    }

    public String getRunAs() {
        return this.runAs;
    }

    public void setPlaceHolderResourcePath(String placeHolderResourcePath) {
        this.placeHolderResourcePath = placeHolderResourcePath;
    }

    public String getPlaceHolderResourcePath() {
        return this.placeHolderResourcePath;
    }

    public void setMimeAwarePlaceHolderResourcePath(String mimeAwarePlaceHolderResourcePath) {
        this.mimeAwarePlaceHolderResourcePath = mimeAwarePlaceHolderResourcePath;
    }

    public String getMimeAwarePlaceHolderResourcePath() {
        return this.mimeAwarePlaceHolderResourcePath;
    }

    public ThumbnailRegistry getThumbnailRegistry() {
        return this.thumbnailRegistry;
    }

    public void setThumbnailRegistry(ThumbnailRegistry thumbnailRegistry) {
        this.thumbnailRegistry = thumbnailRegistry;
    }

    public void register() {
        if (this.thumbnailRegistry == null) {
            logger.warn((Object)("Property 'thumbnailRegistry' has not been set.  Ignoring auto-registration: \n   extracter: " + this));
            return;
        }
        this.thumbnailRegistry.addThumbnailDefinition(this);
    }
}

