/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.thumbnail;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.content.transform.RuntimeExecutableContentTransformerOptions;
import org.alfresco.repo.content.transform.magick.ImageTransformationOptions;
import org.alfresco.repo.content.transform.swf.SWFTransformationOptions;
import org.alfresco.repo.node.NodeServicePolicies;
import org.alfresco.repo.policy.Behaviour;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.policy.JavaBehaviour;
import org.alfresco.repo.policy.PolicyComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.thumbnail.ThumbnailRegistry;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.rendition.RenditionDefinition;
import org.alfresco.service.cmr.rendition.RenditionService;
import org.alfresco.service.cmr.rendition.RenditionServiceException;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.cmr.rule.RuleService;
import org.alfresco.service.cmr.thumbnail.FailedThumbnailInfo;
import org.alfresco.service.cmr.thumbnail.ThumbnailException;
import org.alfresco.service.cmr.thumbnail.ThumbnailParentAssociationDetails;
import org.alfresco.service.cmr.thumbnail.ThumbnailService;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.QNamePattern;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.service.transaction.TransactionService;
import org.alfresco.util.GUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.extensions.surf.util.ParameterCheck;

public class ThumbnailServiceImpl
implements ThumbnailService,
NodeServicePolicies.BeforeCreateNodePolicy,
NodeServicePolicies.OnCreateNodePolicy {
    private static Log logger = LogFactory.getLog(ThumbnailServiceImpl.class);
    private static final String ERR_NO_PARENT = "Thumbnail has no parent so update cannot take place.";
    private static final String SUBTYPES_POSTFIX = "/*";
    private NodeService nodeService;
    private ThumbnailRegistry thumbnailRegistry;
    private RenditionService renditionService;
    private BehaviourFilter behaviourFilter;
    private RuleService ruleService;
    private PolicyComponent policyComponent;
    private TransactionService transactionService;

    public void setBehaviourFilter(BehaviourFilter behaviourFilter) {
        this.behaviourFilter = behaviourFilter;
    }

    public void setRenditionService(RenditionService renditionService) {
        this.renditionService = renditionService;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setThumbnailRegistry(ThumbnailRegistry thumbnailRegistry) {
        this.thumbnailRegistry = thumbnailRegistry;
    }

    public void setPolicyComponent(PolicyComponent policyComponent) {
        this.policyComponent = policyComponent;
    }

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setRuleService(RuleService ruleService) {
        this.ruleService = ruleService;
    }

    public void init() {
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.OnCreateNodePolicy.QNAME, ContentModel.TYPE_THUMBNAIL, (Behaviour)new JavaBehaviour(this, "onCreateNode", Behaviour.NotificationFrequency.EVERY_EVENT));
        this.policyComponent.bindClassBehaviour(NodeServicePolicies.BeforeCreateNodePolicy.QNAME, ContentModel.TYPE_FAILED_THUMBNAIL, (Behaviour)new JavaBehaviour(this, "beforeCreateNode", Behaviour.NotificationFrequency.EVERY_EVENT));
    }

    @Override
    public void beforeCreateNode(NodeRef parentRef, QName assocTypeQName, QName assocQName, QName nodeTypeQName) {
        if (ContentModel.TYPE_FAILED_THUMBNAIL.equals((Object)nodeTypeQName)) {
            HashSet<QName> childNodeTypes = new HashSet<QName>();
            childNodeTypes.add(ContentModel.TYPE_THUMBNAIL);
            List existingThumbnails = this.nodeService.getChildAssocs(parentRef, childNodeTypes);
            for (ChildAssociationRef chAssRef : existingThumbnails) {
                if (!chAssRef.getQName().equals((Object)assocQName)) continue;
                if (logger.isDebugEnabled()) {
                    StringBuilder msg = new StringBuilder();
                    msg.append("Deleting thumbnail node ").append(chAssRef.getChildRef());
                    logger.debug((Object)msg.toString());
                }
                this.nodeService.deleteNode(chAssRef.getChildRef());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCreateNode(ChildAssociationRef childAssoc) {
        NodeRef thumbnailNodeRef = childAssoc.getChildRef();
        NodeRef sourceNodeRef = childAssoc.getParentRef();
        String thumbnailName = (String)((Object)this.nodeService.getProperty(thumbnailNodeRef, ContentModel.PROP_NAME));
        try {
            this.behaviourFilter.disableBehaviour(sourceNodeRef, ContentModel.ASPECT_VERSIONABLE);
            this.addThumbnailModificationData(thumbnailNodeRef, thumbnailName);
        }
        finally {
            this.behaviourFilter.enableBehaviour(sourceNodeRef, ContentModel.ASPECT_VERSIONABLE);
        }
        Map<String, FailedThumbnailInfo> failures = this.getFailedThumbnails(sourceNodeRef);
        FailedThumbnailInfo existingFailedThumbnail = failures.get(thumbnailName);
        if (existingFailedThumbnail != null) {
            if (logger.isDebugEnabled()) {
                StringBuilder msg = new StringBuilder();
                msg.append("Deleting failedThumbnail node ").append(existingFailedThumbnail.getFailedThumbnailNode());
                logger.debug((Object)msg.toString());
            }
            this.nodeService.deleteNode(existingFailedThumbnail.getFailedThumbnailNode());
        }
    }

    @Override
    public ThumbnailRegistry getThumbnailRegistry() {
        return this.thumbnailRegistry;
    }

    @Override
    public NodeRef createThumbnail(NodeRef node, QName contentProperty, String mimetype, TransformationOptions transformationOptions, String thumbnailName) {
        return this.createThumbnail(node, contentProperty, mimetype, transformationOptions, thumbnailName, null);
    }

    @Override
    public NodeRef createThumbnail(final NodeRef node, final QName contentProperty, final String mimetype, final TransformationOptions transformationOptions, final String thumbnailName, final ThumbnailParentAssociationDetails assocDetails) {
        NodeRef existingThumbnail;
        ParameterCheck.mandatory((String)"node", (Object)node);
        ParameterCheck.mandatory((String)"contentProperty", (Object)contentProperty);
        ParameterCheck.mandatoryString((String)"mimetype", (String)mimetype);
        ParameterCheck.mandatory((String)"transformationOptions", (Object)transformationOptions);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating thumbnail (node=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype));
        }
        if (thumbnailName != null && (existingThumbnail = this.getThumbnailByName(node, contentProperty, thumbnailName)) != null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Creating thumbnail: There is already a thumbnail with the name '" + thumbnailName + "' (node=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype));
            }
            return existingThumbnail;
        }
        RetryingTransactionHelper txnHelper = this.transactionService.getRetryingTransactionHelper();
        txnHelper.setForceWritable(true);
        boolean requiresNew = false;
        if (AlfrescoTransactionSupport.getTransactionReadState() != AlfrescoTransactionSupport.TxnReadState.TXN_READ_WRITE) {
            requiresNew = true;
        }
        return txnHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<NodeRef>(){

            @Override
            public NodeRef execute() throws Throwable {
                return (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<NodeRef>(){

                    public NodeRef doWork() throws Exception {
                        return ThumbnailServiceImpl.this.createThumbnailNode(node, contentProperty, mimetype, transformationOptions, thumbnailName, assocDetails);
                    }
                }, (String)AuthenticationUtil.getSystemUserName());
            }
        }, false, requiresNew);
    }

    private QName getThumbnailQName(String localThumbnailName) {
        if (localThumbnailName == null || localThumbnailName.length() == 0) {
            localThumbnailName = GUID.generate();
        }
        QName thumbnailQName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)localThumbnailName);
        return thumbnailQName;
    }

    private String getRenderingEngineNameFor(TransformationOptions options) {
        if (options instanceof ImageTransformationOptions) {
            return "imageRenderingEngine";
        }
        if (options instanceof SWFTransformationOptions) {
            return "reformat";
        }
        if (options instanceof RuntimeExecutableContentTransformerOptions) {
            return "reformat";
        }
        return "";
    }

    public NodeRef getThumbnailNode(ChildAssociationRef thumbnailRef) {
        return thumbnailRef.getChildRef();
    }

    @Override
    public void updateThumbnail(NodeRef thumbnail, TransformationOptions transformationOptions) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating thumbnail (thumbnail=" + thumbnail.toString() + ")"));
        }
        if (this.renditionService.isRendition(thumbnail)) {
            ChildAssociationRef parentAssoc = this.renditionService.getSourceNode(thumbnail);
            if (parentAssoc == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Updating thumbnail: The thumbnails parent cannot be found (thumbnail=" + thumbnail.toString() + ")"));
                }
                throw new ThumbnailException(ERR_NO_PARENT);
            }
            final QName renditionAssociationName = parentAssoc.getQName();
            NodeRef sourceNode = parentAssoc.getParentRef();
            QName contentProperty = (QName)this.nodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT_PROPERTY_NAME);
            transformationOptions.setSourceNodeRef(sourceNode);
            transformationOptions.setSourceContentProperty(contentProperty);
            transformationOptions.setTargetContentProperty(ContentModel.PROP_CONTENT);
            RenditionDefinition rendDefn = (RenditionDefinition)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<RenditionDefinition>(){

                public RenditionDefinition doWork() throws Exception {
                    return ThumbnailServiceImpl.this.renditionService.loadRenditionDefinition(renditionAssociationName);
                }
            }, (String)AuthenticationUtil.getSystemUserName());
            if (rendDefn == null) {
                String renderingEngineName = this.getRenderingEngineNameFor(transformationOptions);
                rendDefn = this.renditionService.createRenditionDefinition(parentAssoc.getQName(), renderingEngineName);
            }
            Map<String, Serializable> params = this.thumbnailRegistry.getThumbnailRenditionConvertor().convert(transformationOptions, null);
            for (String key : params.keySet()) {
                rendDefn.setParameterValue(key, params.get(key));
            }
            this.renditionService.render(sourceNode, rendDefn);
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Updating thumbnail: cannot update a thumbnail node that isn't the correct thumbnail type (thumbnail=" + thumbnail.toString() + ")"));
        }
    }

    @Override
    public NodeRef getThumbnailByName(NodeRef node, QName contentProperty, String thumbnailName) {
        NodeRef child;
        Serializable contentPropertyName;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting thumbnail by name (nodeRef=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; thumbnailName=" + thumbnailName + ")"));
        }
        QName namespacedThumbnailName = QName.createQName((String)"http://www.alfresco.org/model/content/1.0", (String)thumbnailName);
        ChildAssociationRef existingRendition = this.renditionService.getRenditionByName(node, namespacedThumbnailName);
        NodeRef thumbnail = null;
        if (existingRendition != null && contentProperty.equals((Object)(contentPropertyName = this.nodeService.getProperty(child = existingRendition.getChildRef(), ContentModel.PROP_CONTENT_PROPERTY_NAME)))) {
            thumbnail = child;
        }
        return thumbnail;
    }

    @Override
    public List<NodeRef> getThumbnails(NodeRef node, QName contentProperty, String mimetype, TransformationOptions options) {
        ArrayList<NodeRef> thumbnails = new ArrayList<NodeRef>(5);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Getting thumbnails (nodeRef=" + node.toString() + "; contentProperty=" + contentProperty.toString() + "; mimetype=" + mimetype + ")"));
        }
        List<ChildAssociationRef> renditions = this.renditionService.getRenditions(node);
        for (ChildAssociationRef assoc : renditions) {
            NodeRef child = assoc.getChildRef();
            if (!contentProperty.equals((Object)this.nodeService.getProperty(child, ContentModel.PROP_CONTENT_PROPERTY_NAME)) || !this.matchMimetypeOptions(child, mimetype, options)) continue;
            thumbnails.add(child);
        }
        return thumbnails;
    }

    @Override
    public Map<String, FailedThumbnailInfo> getFailedThumbnails(NodeRef sourceNode) {
        Map<String, FailedThumbnailInfo> result = Collections.emptyMap();
        if (this.nodeService.hasAspect(sourceNode, ContentModel.ASPECT_FAILED_THUMBNAIL_SOURCE)) {
            List failedThumbnailChildren = this.nodeService.getChildAssocs(sourceNode, (QNamePattern)ContentModel.ASSOC_FAILED_THUMBNAIL, RegexQNamePattern.MATCH_ALL);
            result = new HashMap<String, FailedThumbnailInfo>();
            for (ChildAssociationRef chAssRef : failedThumbnailChildren) {
                QName failedThumbnailName = chAssRef.getQName();
                NodeRef failedThumbnailNode = chAssRef.getChildRef();
                Map props = this.nodeService.getProperties(failedThumbnailNode);
                Date failureDateTime = (Date)props.get(ContentModel.PROP_FAILED_THUMBNAIL_TIME);
                int failureCount = (Integer)props.get(ContentModel.PROP_FAILURE_COUNT);
                FailedThumbnailInfo failedThumbnailInfo = new FailedThumbnailInfo(failedThumbnailName.getLocalName(), failureDateTime, failureCount, failedThumbnailNode);
                result.put(failedThumbnailName.getLocalName(), failedThumbnailInfo);
            }
        }
        return result;
    }

    private boolean matchMimetypeOptions(NodeRef thumbnail, String mimetype, TransformationOptions options) {
        boolean result = true;
        if (mimetype != null) {
            String thumbnailMimetype = ((ContentData)this.nodeService.getProperty(thumbnail, ContentModel.PROP_CONTENT)).getMimetype();
            if (mimetype.endsWith(SUBTYPES_POSTFIX)) {
                String baseMimetype = mimetype.substring(0, mimetype.length() - SUBTYPES_POSTFIX.length());
                if (thumbnailMimetype == null || !thumbnailMimetype.startsWith(baseMimetype)) {
                    result = false;
                }
            } else if (!mimetype.equals(thumbnailMimetype)) {
                result = false;
            }
        }
        if (!result || options != null) {
            // empty if block
        }
        return result;
    }

    private RenditionDefinition createRawRenditionDefinition(QName thumbnailQName, TransformationOptions transformationOptions) {
        String renderingEngineName = this.getRenderingEngineNameFor(transformationOptions);
        RenditionDefinition definition = this.renditionService.createRenditionDefinition(thumbnailQName, renderingEngineName);
        definition.setTrackStatus(true);
        return definition;
    }

    private RenditionDefinition createRenditionDefinition(QName contentProperty, String mimetype, TransformationOptions transformationOptions, QName thumbnailQName, ThumbnailParentAssociationDetails assocDetails) {
        RenditionDefinition definition = this.createRawRenditionDefinition(thumbnailQName, transformationOptions);
        Map<String, Serializable> params = this.thumbnailRegistry.getThumbnailRenditionConvertor().convert(transformationOptions, assocDetails);
        params.put("sourceContentProperty", (Serializable)contentProperty);
        params.put("mime-type", (Serializable)((Object)mimetype));
        definition.addParameterValues(params);
        return definition;
    }

    private NodeRef createThumbnailNode(NodeRef node, QName contentProperty, String mimetype, TransformationOptions transformationOptions, String thumbnailName, ThumbnailParentAssociationDetails assocDetails) {
        QName thumbnailQName = this.getThumbnailQName(thumbnailName);
        RenditionDefinition definition = this.createRenditionDefinition(contentProperty, mimetype, transformationOptions, thumbnailQName, assocDetails);
        try {
            ChildAssociationRef thumbnailAssoc = this.renditionService.render(node, definition);
            NodeRef thumbnail = this.getThumbnailNode(thumbnailAssoc);
            this.setThumbnailNameProperty(thumbnail, thumbnailName);
            return thumbnail;
        }
        catch (RenditionServiceException rsx) {
            throw new ThumbnailException(rsx.getMessage(), (Throwable)((Object)rsx));
        }
    }

    private void setThumbnailNameProperty(NodeRef thumbnail, String thumbnailName) {
        if (thumbnailName != null && thumbnailName.length() > 0 && ContentModel.TYPE_THUMBNAIL.equals((Object)this.nodeService.getType(thumbnail))) {
            this.nodeService.setProperty(thumbnail, ContentModel.PROP_THUMBNAIL_NAME, (Serializable)((Object)thumbnailName));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addThumbnailModificationData(NodeRef nodeRef, String thumbnailName) {
        Date modified;
        if (this.nodeService.exists(nodeRef) && thumbnailName != null && !nodeRef.toString().endsWith(thumbnailName) && (modified = (Date)this.nodeService.getProperty(nodeRef, ContentModel.PROP_MODIFIED)) != null) {
            Long timestamp = modified.getTime();
            String lastModifiedValue = thumbnailName + ":" + timestamp;
            for (ChildAssociationRef parent : this.nodeService.getParentAssocs(nodeRef)) {
                List<String> thumbnailMods = null;
                NodeRef parentNode = parent.getParentRef();
                if (this.nodeService.hasAspect(parentNode, ContentModel.ASPECT_THUMBNAIL_MODIFICATION)) {
                    thumbnailMods = (List)((Object)this.nodeService.getProperty(parentNode, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA));
                    String target = null;
                    for (String currThumbnailMod : thumbnailMods) {
                        if (!currThumbnailMod.startsWith(thumbnailName)) continue;
                        target = currThumbnailMod;
                    }
                    if (target != null) {
                        thumbnailMods.remove(target);
                    }
                    thumbnailMods.add(lastModifiedValue);
                    this.ruleService.disableRuleType("update");
                    try {
                        this.nodeService.setProperty(parentNode, ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA, (Serializable)((Object)thumbnailMods));
                        continue;
                    }
                    finally {
                        this.ruleService.enableRuleType("update");
                        continue;
                    }
                }
                thumbnailMods = new ArrayList<String>();
                thumbnailMods.add(lastModifiedValue);
                HashMap<QName, Serializable> properties = new HashMap<QName, Serializable>();
                properties.put(ContentModel.PROP_LAST_THUMBNAIL_MODIFICATION_DATA, (Serializable)((Object)thumbnailMods));
                this.ruleService.disableRuleType("update");
                try {
                    this.nodeService.addAspect(parentNode, ContentModel.ASPECT_THUMBNAIL_MODIFICATION, properties);
                }
                finally {
                    this.ruleService.enableRuleType("update");
                }
            }
        }
    }
}

