/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.lang.reflect.Method;
import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.transaction.TransactionService;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.interceptor.TransactionAspectSupport;
import org.springframework.transaction.interceptor.TransactionAttribute;

public class RetryingTransactionInterceptor
extends TransactionAspectSupport
implements MethodInterceptor {
    private TransactionService transactionService;
    private List<Class<?>> extraExceptions;

    public void setTransactionService(TransactionService transactionService) {
        this.transactionService = transactionService;
    }

    public void setExtraExceptions(List<Class<?>> extraExceptions) {
        this.extraExceptions = extraExceptions;
    }

    public Object invoke(final MethodInvocation invocation) throws Throwable {
        if (null != invocation && null != invocation.getThis() && null != invocation.getMethod()) {
            Method method = invocation.getMethod();
            final TransactionAttribute txnAttr = this.getTransactionAttributeSource().getTransactionAttribute(method, invocation.getThis().getClass());
            final PlatformTransactionManager tm = this.determineTransactionManager(txnAttr);
            final String joinpointIdentification = this.methodIdentification(invocation.getMethod());
            int propagationBehaviour = txnAttr.getPropagationBehavior();
            try {
                if (null != txnAttr && propagationBehaviour != 1) {
                    RetryingTransactionHelper retryingTransactionHelper = this.transactionService.getRetryingTransactionHelper();
                    retryingTransactionHelper.setExtraExceptions(this.extraExceptions);
                    return retryingTransactionHelper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<Object>(){

                        @Override
                        public Object execute() {
                            TransactionAspectSupport.TransactionInfo txInfo = RetryingTransactionInterceptor.this.createTransactionIfNecessary(tm, 3 == txnAttr.getPropagationBehavior() ? null : txnAttr, joinpointIdentification);
                            try {
                                Object object = invocation.proceed();
                                return object;
                            }
                            catch (RuntimeException e) {
                                RetryingTransactionInterceptor.this.completeTransactionAfterThrowing(txInfo, e);
                                throw e;
                            }
                            catch (Throwable e) {
                                RetryingTransactionInterceptor.this.completeTransactionAfterThrowing(txInfo, e);
                                throw new WrapperException(e);
                            }
                            finally {
                                RetryingTransactionInterceptor.this.cleanupTransactionInfo(txInfo);
                            }
                        }
                    }, txnAttr.isReadOnly(), 3 == propagationBehaviour);
                }
                return invocation.proceed();
            }
            catch (WrapperException e) {
                throw e.getCause();
            }
        }
        throw new AlfrescoRuntimeException("Invalid undefined MethodInvocation instance");
    }

    public static class WrapperException
    extends RuntimeException {
        private static final long serialVersionUID = 1L;

        public WrapperException(Throwable cause) {
            super(cause);
        }
    }
}

