/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transaction;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.transaction.AlfrescoTransactionSupport;
import org.alfresco.repo.transaction.TransactionListenerAdapter;
import org.alfresco.util.GUID;

public class TransactionAwareSingleton<T>
extends TransactionListenerAdapter {
    private final String txnKey;
    private final ReentrantReadWriteLock.ReadLock singletonReadLock;
    private final ReentrantReadWriteLock.WriteLock singletonWriteLock;
    private Map<String, Object> tenantSingletonValue = new HashMap<String, Object>(1);

    public TransactionAwareSingleton() {
        this.txnKey = GUID.generate();
        ReentrantReadWriteLock serverReadWriteLock = new ReentrantReadWriteLock();
        this.singletonReadLock = serverReadWriteLock.readLock();
        this.singletonWriteLock = serverReadWriteLock.writeLock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setValue(Object value) {
        this.singletonWriteLock.lock();
        try {
            this.tenantSingletonValue.put(TenantUtil.getCurrentDomain(), value);
        }
        finally {
            this.singletonWriteLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getValue() {
        this.singletonReadLock.lock();
        try {
            Object object = this.tenantSingletonValue.get(TenantUtil.getCurrentDomain());
            return object;
        }
        finally {
            this.singletonReadLock.unlock();
        }
    }

    public T get() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            return (T)storage.newValue;
        }
        return (T)this.getValue();
    }

    public void put(T value) {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage == null) {
            storage = new TransactionStorage();
            AlfrescoTransactionSupport.bindResource(this.txnKey, storage);
            AlfrescoTransactionSupport.bindListener(this);
        }
        storage.newValue = value;
    }

    @Override
    public void afterCommit() {
        TransactionStorage storage = (TransactionStorage)AlfrescoTransactionSupport.getResource(this.txnKey);
        if (storage != null) {
            this.setValue(storage.newValue);
        }
    }

    private static class TransactionStorage {
        public Object newValue;

        private TransactionStorage() {
        }
    }
}

