/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.List;
import org.alfresco.repo.transfer.AlienProcessor;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.CorrespondingNodeResolverFactory;
import org.alfresco.repo.transfer.ManifestProcessorFactory;
import org.alfresco.repo.transfer.RepoPrimaryManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoRequisiteManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoSecondaryManifestProcessorImpl;
import org.alfresco.repo.transfer.RepoTertiaryManifestProcessorImpl;
import org.alfresco.repo.transfer.manifest.TransferManifestProcessor;
import org.alfresco.repo.transfer.requisite.TransferRequsiteWriter;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.cmr.transfer.TransferReceiver;

public class DefaultManifestProcessorFactoryImpl
implements ManifestProcessorFactory {
    private NodeService nodeService;
    private ContentService contentService;
    private DictionaryService dictionaryService;
    private PermissionService permissionService;
    private CorrespondingNodeResolverFactory nodeResolverFactory;
    private AlienProcessor alienProcessor;

    @Override
    public List<TransferManifestProcessor> getCommitProcessors(TransferReceiver receiver, String transferId) {
        ArrayList<TransferManifestProcessor> processors = new ArrayList<TransferManifestProcessor>();
        CorrespondingNodeResolver nodeResolver = this.nodeResolverFactory.getResolver();
        RepoPrimaryManifestProcessorImpl primaryProcessor = new RepoPrimaryManifestProcessorImpl(receiver, transferId);
        primaryProcessor.setContentService(this.contentService);
        primaryProcessor.setNodeResolver(nodeResolver);
        primaryProcessor.setNodeService(this.nodeService);
        primaryProcessor.setDictionaryService(this.dictionaryService);
        primaryProcessor.setPermissionService(this.getPermissionService());
        primaryProcessor.setAlienProcessor(this.getAlienProcessor());
        processors.add(primaryProcessor);
        RepoSecondaryManifestProcessorImpl secondaryProcessor = new RepoSecondaryManifestProcessorImpl(receiver, transferId);
        secondaryProcessor.setNodeResolver(nodeResolver);
        secondaryProcessor.setNodeService(this.nodeService);
        processors.add(secondaryProcessor);
        RepoTertiaryManifestProcessorImpl tertiaryProcessor = new RepoTertiaryManifestProcessorImpl(receiver, transferId);
        tertiaryProcessor.setNodeService(this.nodeService);
        tertiaryProcessor.setAlienProcessor(this.getAlienProcessor());
        tertiaryProcessor.setNodeResolver(nodeResolver);
        processors.add(tertiaryProcessor);
        return processors;
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setContentService(ContentService contentService) {
        this.contentService = contentService;
    }

    public void setDictionaryService(DictionaryService dictionaryService) {
        this.dictionaryService = dictionaryService;
    }

    public void setNodeResolverFactory(CorrespondingNodeResolverFactory nodeResolverFactory) {
        this.nodeResolverFactory = nodeResolverFactory;
    }

    @Override
    public TransferManifestProcessor getRequsiteProcessor(TransferReceiver receiver, String transferId, TransferRequsiteWriter out) {
        RepoRequisiteManifestProcessorImpl processor = new RepoRequisiteManifestProcessorImpl(receiver, transferId, out);
        CorrespondingNodeResolver nodeResolver = this.nodeResolverFactory.getResolver();
        processor.setNodeResolver(nodeResolver);
        processor.setNodeService(this.nodeService);
        return processor;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public PermissionService getPermissionService() {
        return this.permissionService;
    }

    public void setAlienProcessor(AlienProcessor alienProcessor) {
        this.alienProcessor = alienProcessor;
    }

    public AlienProcessor getAlienProcessor() {
        return this.alienProcessor;
    }
}

