/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.transfer;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.alfresco.repo.transfer.AbstractManifestProcessorBase;
import org.alfresco.repo.transfer.CorrespondingNodeResolver;
import org.alfresco.repo.transfer.manifest.TransferManifestDeletedNode;
import org.alfresco.repo.transfer.manifest.TransferManifestHeader;
import org.alfresco.repo.transfer.manifest.TransferManifestNodeHelper;
import org.alfresco.repo.transfer.manifest.TransferManifestNormalNode;
import org.alfresco.service.cmr.repository.AssociationRef;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.Path;
import org.alfresco.service.cmr.transfer.TransferReceiver;
import org.alfresco.service.namespace.QName;
import org.alfresco.service.namespace.RegexQNamePattern;
import org.alfresco.util.EqualsHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class RepoSecondaryManifestProcessorImpl
extends AbstractManifestProcessorBase {
    private NodeService nodeService;
    private CorrespondingNodeResolver nodeResolver;
    private static final Log log = LogFactory.getLog(RepoSecondaryManifestProcessorImpl.class);

    public RepoSecondaryManifestProcessorImpl(TransferReceiver receiver, String transferId) {
        super(receiver, transferId);
    }

    @Override
    protected void endManifest() {
    }

    @Override
    protected void processNode(TransferManifestDeletedNode node) {
    }

    @Override
    protected void processNode(TransferManifestNormalNode node) {
        this.logComment("Seconday Processing incoming node: " + node.getNodeRef());
        log.debug((Object)("Seconday Processing incoming node: " + node.getNodeRef()));
        NodeRef correspondingNodeRef = this.nodeResolver.resolveCorrespondingNode((NodeRef)node.getNodeRef(), (ChildAssociationRef)TransferManifestNodeHelper.getPrimaryParentAssoc((TransferManifestNormalNode)node), (Path)node.getParentPath()).resolvedChild;
        if (correspondingNodeRef == null) {
            correspondingNodeRef = node.getNodeRef();
        }
        List<ChildAssociationRef> requiredAssocs = node.getParentAssocs();
        List currentAssocs = this.nodeService.getParentAssocs(correspondingNodeRef);
        this.processParentChildAssociations(requiredAssocs, currentAssocs, correspondingNodeRef, false);
        requiredAssocs = node.getChildAssocs();
        currentAssocs = this.nodeService.getChildAssocs(correspondingNodeRef);
        this.processParentChildAssociations(requiredAssocs, currentAssocs, correspondingNodeRef, true);
        List<AssociationRef> requiredTargetAssocs = node.getTargetAssocs();
        List currentTargetAssocs = this.nodeService.getTargetAssocs(correspondingNodeRef, RegexQNamePattern.MATCH_ALL);
        this.processPeerAssociations(requiredTargetAssocs, currentTargetAssocs, correspondingNodeRef, true);
        List<AssociationRef> requiredSourceAssocs = node.getSourceAssocs();
        List currentSourceAssocs = this.nodeService.getSourceAssocs(correspondingNodeRef, RegexQNamePattern.MATCH_ALL);
        this.processPeerAssociations(requiredSourceAssocs, currentSourceAssocs, correspondingNodeRef, false);
    }

    private void processPeerAssociations(List<AssociationRef> requiredAssocs, List<AssociationRef> currentAssocs, NodeRef nodeRef, boolean isSource) {
        if (requiredAssocs == null) {
            requiredAssocs = new ArrayList<AssociationRef>();
        }
        if (currentAssocs == null) {
            currentAssocs = new ArrayList<AssociationRef>();
        }
        ArrayList<AssociationRefKey> keysRequired = new ArrayList<AssociationRefKey>();
        ArrayList<AssociationRefKey> keysCurrent = new ArrayList<AssociationRefKey>();
        for (AssociationRef associationRef : requiredAssocs) {
            keysRequired.add(new AssociationRefKey(associationRef));
        }
        for (AssociationRef associationRef : currentAssocs) {
            keysCurrent.add(new AssociationRefKey(associationRef));
        }
        for (AssociationRefKey associationRefKey : keysRequired) {
            NodeRef otherNode;
            if (keysCurrent.contains(associationRefKey) || !this.nodeService.exists(otherNode = isSource ? associationRefKey.targetRef : associationRefKey.sourceRef)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("need to add peer assoc from:" + associationRefKey.sourceRef + ", to:" + associationRefKey.targetRef + ", qname:" + associationRefKey.assocTypeQName));
            }
            this.nodeService.createAssociation(associationRefKey.sourceRef, associationRefKey.targetRef, associationRefKey.assocTypeQName);
        }
        for (AssociationRefKey associationRefKey : keysCurrent) {
            if (keysRequired.contains(associationRefKey)) continue;
            if (log.isDebugEnabled()) {
                log.debug((Object)("need to remove peer assoc from:" + associationRefKey.sourceRef + ", to:" + associationRefKey.targetRef + ", qname:" + associationRefKey.assocTypeQName));
            }
            this.nodeService.removeAssociation(associationRefKey.sourceRef, associationRefKey.targetRef, associationRefKey.assocTypeQName);
        }
    }

    private void processParentChildAssociations(List<ChildAssociationRef> requiredAssocs, List<ChildAssociationRef> currentAssocs, NodeRef nodeRef, boolean isParent) {
        if (requiredAssocs == null) {
            requiredAssocs = new ArrayList<ChildAssociationRef>();
        }
        if (currentAssocs == null) {
            currentAssocs = new ArrayList<ChildAssociationRef>();
        }
        ArrayList<ChildAssociationRef> assocsToAdd = new ArrayList<ChildAssociationRef>();
        ArrayList<Object> assocsToRemove = new ArrayList<Object>();
        HashMap<NodeRef, ChildAssociationRef> currentAssocMap = new HashMap<NodeRef, ChildAssociationRef>();
        for (ChildAssociationRef childAssociationRef : currentAssocs) {
            if (childAssociationRef.isPrimary()) continue;
            NodeRef key = isParent ? childAssociationRef.getChildRef() : childAssociationRef.getParentRef();
            currentAssocMap.put(key, childAssociationRef);
        }
        for (ChildAssociationRef childAssociationRef : requiredAssocs) {
            if (childAssociationRef.isPrimary()) continue;
            NodeRef otherNode = isParent ? childAssociationRef.getChildRef() : childAssociationRef.getParentRef();
            ChildAssociationRef existingAssociation = (ChildAssociationRef)currentAssocMap.remove(otherNode);
            if (existingAssociation != null) {
                if (existingAssociation.getQName().equals((Object)childAssociationRef.getQName()) && existingAssociation.getTypeQName().equals((Object)childAssociationRef.getTypeQName())) continue;
                assocsToRemove.add(existingAssociation);
                assocsToAdd.add(childAssociationRef);
                continue;
            }
            if (!this.nodeService.exists(otherNode)) continue;
            assocsToAdd.add(childAssociationRef);
        }
        assocsToRemove.addAll(currentAssocMap.values());
        for (ChildAssociationRef childAssociationRef : assocsToRemove) {
            this.nodeService.removeChildAssociation(childAssociationRef);
        }
        for (ChildAssociationRef childAssociationRef : assocsToAdd) {
            NodeRef parent = isParent ? nodeRef : childAssociationRef.getParentRef();
            NodeRef child = isParent ? childAssociationRef.getChildRef() : nodeRef;
            this.nodeService.addChild(parent, child, childAssociationRef.getTypeQName(), childAssociationRef.getQName());
        }
    }

    @Override
    protected void processHeader(TransferManifestHeader header) {
    }

    @Override
    protected void startManifest() {
    }

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setNodeResolver(CorrespondingNodeResolver nodeResolver) {
        this.nodeResolver = nodeResolver;
    }

    private class AssociationRefKey {
        NodeRef sourceRef;
        NodeRef targetRef;
        QName assocTypeQName;

        public AssociationRefKey(NodeRef sourceRef, NodeRef targetRef, QName assocTypeQName) {
            this.sourceRef = sourceRef;
            this.targetRef = targetRef;
            this.assocTypeQName = assocTypeQName;
        }

        public AssociationRefKey(AssociationRef ref) {
            this.sourceRef = ref.getSourceRef();
            this.targetRef = ref.getTargetRef();
            this.assocTypeQName = ref.getTypeQName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AssociationRefKey)) {
                return false;
            }
            AssociationRefKey other = (AssociationRefKey)o;
            return EqualsHelper.nullSafeEquals((Object)this.sourceRef, (Object)other.sourceRef) && EqualsHelper.nullSafeEquals((Object)this.assocTypeQName, (Object)other.assocTypeQName) && EqualsHelper.nullSafeEquals((Object)this.targetRef, (Object)other.targetRef);
        }

        public int hashCode() {
            int hashCode = this.targetRef.hashCode();
            hashCode = 37 * hashCode + (this.sourceRef == null ? 0 : this.sourceRef.hashCode());
            hashCode = 37 * hashCode + (this.assocTypeQName == null ? 0 : this.assocTypeQName.hashCode());
            return hashCode;
        }
    }
}

