/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.version;

import java.util.List;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.tenant.Tenant;
import org.alfresco.repo.tenant.TenantAdminService;
import org.alfresco.repo.tenant.TenantUtil;
import org.alfresco.repo.version.VersionMigrator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;

public class MigrationCleanupJob
implements Job {
    private static Log logger = LogFactory.getLog(MigrationCleanupJob.class);
    private static final String KEY_VERSION_MIGRATOR = "versionMigrator";
    private static final String KEY_TENANT_ADMIN_SERVICE = "tenantAdminService";
    private static final String KEY_BATCH_SIZE = "batchSize";
    private static final String KEY_THREAD_COUNT = "threadCount";
    private static final String KEY_ONLY_USE_DEPRECATED_V1 = "onlyUseDeprecatedV1";
    private static final String KEY_MIGRATE_RUN_AS_JOB = "migrateRunAsScheduledJob";
    private int batchSize = 1;
    private int threadCount = 2;
    private boolean useDeprecatedV1 = false;
    private boolean migrateRunAsJob = false;

    public void execute(JobExecutionContext context) throws JobExecutionException {
        JobDataMap jobData = context.getJobDetail().getJobDataMap();
        String migrateRunAsJobStr = (String)jobData.get((Object)KEY_MIGRATE_RUN_AS_JOB);
        if (migrateRunAsJobStr != null) {
            try {
                this.migrateRunAsJob = new Boolean(migrateRunAsJobStr);
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid 'migrateRunAsJob' value, using default: " + this.migrateRunAsJob), (Throwable)e);
            }
        }
        if (this.migrateRunAsJob) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Skipping migration cleanup since migration is running as a job (which walso performs the delete)");
            }
            return;
        }
        String onlyUseDeprecatedV1Str = (String)jobData.get((Object)KEY_ONLY_USE_DEPRECATED_V1);
        if (onlyUseDeprecatedV1Str != null) {
            try {
                this.useDeprecatedV1 = new Boolean(onlyUseDeprecatedV1Str);
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid 'onlyUseDeprecatedV1' value, using default: " + this.useDeprecatedV1), (Throwable)e);
            }
        }
        if (this.useDeprecatedV1) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Skipping migration cleanup since only using deprecated version1 store");
            }
            return;
        }
        final VersionMigrator migrationCleanup = (VersionMigrator)jobData.get((Object)KEY_VERSION_MIGRATOR);
        TenantAdminService tenantAdminService = (TenantAdminService)jobData.get((Object)KEY_TENANT_ADMIN_SERVICE);
        if (migrationCleanup == null) {
            throw new JobExecutionException("Missing job data: versionMigrator");
        }
        String batchSizeStr = (String)jobData.get((Object)KEY_BATCH_SIZE);
        if (batchSizeStr != null) {
            try {
                this.batchSize = new Integer(batchSizeStr);
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid 'batchSize' value, using default: " + this.batchSize), (Throwable)e);
            }
        }
        if (this.batchSize < 1) {
            String errorMessage = "batchSize (" + this.batchSize + ") cannot be less than 1";
            logger.error((Object)errorMessage);
            throw new AlfrescoRuntimeException(errorMessage);
        }
        String threadCountStr = (String)jobData.get((Object)KEY_THREAD_COUNT);
        if (threadCountStr != null) {
            try {
                this.threadCount = new Integer(threadCountStr);
            }
            catch (Exception e) {
                logger.warn((Object)("Invalid 'threadCount' value, using default: " + this.threadCount), (Throwable)e);
            }
        }
        if (this.threadCount < 1) {
            String errorMessage = "threadCount (" + this.threadCount + ") cannot be less than 1";
            logger.error((Object)errorMessage);
            throw new AlfrescoRuntimeException(errorMessage);
        }
        if (AuthenticationUtil.getRunAsUser() == null) {
            logger.info((Object)"Set system user");
            AuthenticationUtil.setRunAsUser((String)AuthenticationUtil.getSystemUserName());
        }
        migrationCleanup.executeCleanup(this.batchSize, this.threadCount);
        if (tenantAdminService != null && tenantAdminService.isEnabled()) {
            List<Tenant> tenants = tenantAdminService.getAllTenants();
            for (Tenant tenant : tenants) {
                TenantUtil.runAsSystemTenant((TenantUtil.TenantRunAsWork)new TenantUtil.TenantRunAsWork<Object>(){

                    public Object doWork() throws Exception {
                        migrationCleanup.executeCleanup(MigrationCleanupJob.this.batchSize, MigrationCleanupJob.this.threadCount);
                        return null;
                    }
                }, (String)tenant.getTenantDomain());
            }
        }
    }
}

