/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.activiti.tasklistener;

import java.util.ArrayList;
import java.util.List;
import org.activiti.engine.delegate.DelegateTask;
import org.activiti.engine.delegate.TaskListener;
import org.activiti.engine.form.TaskFormData;
import org.activiti.engine.impl.form.TaskFormHandler;
import org.activiti.engine.impl.persistence.entity.ExecutionEntity;
import org.activiti.engine.impl.persistence.entity.IdentityLinkEntity;
import org.activiti.engine.impl.persistence.entity.TaskEntity;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.workflow.WorkflowNotificationUtils;
import org.alfresco.repo.workflow.activiti.ActivitiScriptNode;
import org.alfresco.repo.workflow.activiti.properties.ActivitiPropertyConverter;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;

public class TaskCreateListener
implements TaskListener {
    private static final long serialVersionUID = 1L;
    private ActivitiPropertyConverter propertyConverter;
    private WorkflowNotificationUtils workflowNotificationUtils;

    public void setWorkflowNotification(WorkflowNotificationUtils service) {
        this.workflowNotificationUtils = service;
    }

    public void notify(DelegateTask task) {
        ExecutionEntity executionEntity;
        Boolean value;
        this.propertyConverter.setDefaultTaskProperties(task);
        String taskFormKey = this.getFormKey(task);
        TypeDefinition typeDefinition = this.propertyConverter.getWorkflowObjectFactory().getTaskTypeDefinition(taskFormKey, false);
        taskFormKey = typeDefinition.getName().toPrefixString();
        task.setVariableLocal("taskFormKey", (Object)taskFormKey);
        ActivitiScriptNode initiatorNode = (ActivitiScriptNode)task.getExecution().getVariable("initiator");
        if (initiatorNode != null) {
            task.addUserIdentityLink((String)initiatorNode.getProperties().get(ContentModel.PROP_USERNAME.toPrefixString()), "starter");
        }
        if (Boolean.TRUE.equals(value = (Boolean)(executionEntity = ((ExecutionEntity)task.getExecution()).getProcessInstance()).getVariable("bpm_sendEMailNotifications"))) {
            NodeRef workflowPackage = null;
            ActivitiScriptNode scriptNode = (ActivitiScriptNode)executionEntity.getVariable("bpm_package");
            if (scriptNode != null) {
                workflowPackage = scriptNode.getNodeRef();
            }
            String[] authorities = null;
            boolean isPooled = false;
            if (task.getAssignee() == null) {
                isPooled = true;
                List identities = ((TaskEntity)task).getIdentityLinks();
                ArrayList<String> temp = new ArrayList<String>(identities.size());
                for (IdentityLinkEntity item : identities) {
                    String user;
                    String group = item.getGroupId();
                    if (group != null) {
                        temp.add(group);
                    }
                    if ((user = item.getUserId()) == null) continue;
                    temp.add(user);
                }
                authorities = temp.toArray(new String[temp.size()]);
            } else {
                authorities = new String[]{task.getAssignee()};
            }
            String title = task.getName() != null ? task.getName() : taskFormKey.replace(":", "_");
            this.workflowNotificationUtils.sendWorkflowAssignedNotificationEMail("activiti$" + task.getId(), title, task.getDescription(), task.getDueDate(), task.getPriority(), workflowPackage, authorities, isPooled);
        }
    }

    private String getFormKey(DelegateTask task) {
        TaskFormData formData = null;
        TaskEntity taskEntity = (TaskEntity)task;
        TaskFormHandler taskFormHandler = taskEntity.getTaskDefinition().getTaskFormHandler();
        if (taskFormHandler != null && (formData = taskFormHandler.createTaskForm(taskEntity)) != null) {
            return formData.getFormKey();
        }
        return null;
    }

    public void setPropertyConverter(ActivitiPropertyConverter propertyConverter) {
        this.propertyConverter = propertyConverter;
    }
}

