/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.repo.workflow.jscript;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.alfresco.model.ApplicationModel;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.jscript.BaseScopableProcessorExtension;
import org.alfresco.repo.jscript.ScriptNode;
import org.alfresco.repo.jscript.ScriptableHashMap;
import org.alfresco.repo.jscript.ScriptableQNameMap;
import org.alfresco.service.ServiceRegistry;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.security.MutableAuthenticationService;
import org.alfresco.service.cmr.workflow.WorkflowNode;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskState;
import org.alfresco.service.cmr.workflow.WorkflowTransition;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespacePrefixResolverProvider;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Scriptable;

public class JscriptWorkflowTask
extends BaseScopableProcessorExtension
implements Serializable {
    static final long serialVersionUID = -8285971359421912313L;
    private final ServiceRegistry serviceRegistry;
    private final NodeService nodeService;
    private final WorkflowService workflowService;
    private final DictionaryService dictionaryService;
    private MutableAuthenticationService authenticationService;
    private final DefaultNamespaceProvider namespaceProvider;
    private WorkflowTask task;

    public JscriptWorkflowTask(WorkflowTask task, ServiceRegistry serviceRegistry, Scriptable scope) {
        this.serviceRegistry = serviceRegistry;
        this.namespaceProvider = new DefaultNamespaceProvider(serviceRegistry.getNamespaceService());
        this.workflowService = serviceRegistry.getWorkflowService();
        this.nodeService = serviceRegistry.getNodeService();
        this.dictionaryService = serviceRegistry.getDictionaryService();
        this.authenticationService = serviceRegistry.getAuthenticationService();
        this.task = task;
        this.setScope(scope);
    }

    public String getId() {
        return this.task.getId();
    }

    public String getName() {
        return this.task.getName();
    }

    public String getTitle() {
        return this.task.getTitle();
    }

    public String getDescription() {
        return this.task.getDescription();
    }

    public Scriptable getProperties() {
        ScriptableQNameMap properties = new ScriptableQNameMap(this.namespaceProvider);
        properties.putAll(this.task.getProperties());
        return properties;
    }

    public void setProperties(ScriptableQNameMap<String, Serializable> properties) {
        Map qNameProps = properties.getMapOfQNames();
        this.task = this.workflowService.updateTask(this.task.getId(), qNameProps, null, null);
    }

    public boolean isComplete() {
        return this.task.getState().equals((Object)WorkflowTaskState.COMPLETED);
    }

    public boolean isPooled() {
        String authority = this.authenticationService.getCurrentUserName();
        return this.workflowService.isTaskClaimable(this.task, authority);
    }

    @Deprecated
    public void setPooled(boolean pooled) {
    }

    public void endTask(String transitionId) {
        this.workflowService.endTask(this.task.getId(), transitionId);
    }

    public ScriptableHashMap<String, String> getTransitions() {
        ScriptableHashMap<String, String> transitions = new ScriptableHashMap<String, String>();
        WorkflowNode workflowNode = this.task.getPath().getNode();
        if (workflowNode != null) {
            for (WorkflowTransition transition : workflowNode.getTransitions()) {
                transitions.put(transition.getId(), transition.getTitle());
            }
        }
        return transitions;
    }

    public Scriptable getPackageResources() {
        List<NodeRef> contents = this.workflowService.getPackageContents(this.task.getId());
        ArrayList<ScriptNode> resources = new ArrayList<ScriptNode>(contents.size());
        Collection<QName> allowedTypes = this.getAllowedPackageResourceTypes();
        for (NodeRef node : contents) {
            if (!this.isAvmResource(node, allowedTypes)) continue;
            ScriptNode scriptNode = new ScriptNode(node, this.serviceRegistry, this.getScope());
            resources.add(scriptNode);
        }
        return Context.getCurrentContext().newArray(this.getScope(), resources.toArray());
    }

    private Collection<QName> getAllowedPackageResourceTypes() {
        Collection allowedTypes = this.dictionaryService.getSubTypes(ContentModel.TYPE_CONTENT, true);
        allowedTypes.addAll(this.dictionaryService.getSubTypes(ApplicationModel.TYPE_FILELINK, true));
        return allowedTypes;
    }

    private boolean isAvmResource(NodeRef node, Collection<QName> allowedTypes) {
        if (this.isAvmNode(node)) {
            return true;
        }
        if (this.nodeService.exists(node)) {
            return allowedTypes.contains(this.nodeService.getType(node));
        }
        return false;
    }

    private boolean isAvmNode(NodeRef node) {
        return "avm".equals(node.getStoreRef().getProtocol());
    }

    private static class DefaultNamespaceProvider
    implements NamespacePrefixResolverProvider {
        private static final long serialVersionUID = -7015209142379905617L;
        private final NamespaceService namespaceService;

        public DefaultNamespaceProvider(NamespaceService namespaceService) {
            this.namespaceService = namespaceService;
        }

        public NamespacePrefixResolver getNamespacePrefixResolver() {
            return this.namespaceService;
        }
    }
}

