/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.model;

import java.util.List;
import java.util.Set;
import org.alfresco.repo.policy.BehaviourFilter;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.model.FileFolderService;
import org.alfresco.service.cmr.model.FileFolderServiceType;
import org.alfresco.service.cmr.model.FileInfo;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.namespace.QName;

public class FileFolderUtil {
    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName) {
        return FileFolderUtil.makeFolders(service, parentNodeRef, pathElements, folderTypeQName, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static FileInfo makeFolders(FileFolderService service, NodeRef parentNodeRef, List<String> pathElements, QName folderTypeQName, BehaviourFilter behaviourFilter, Set<QName> parentBehavioursToDisable) {
        boolean isFolder;
        if (pathElements.size() == 0) {
            throw new IllegalArgumentException("Path element list is empty");
        }
        boolean bl = isFolder = service.getType(folderTypeQName) == FileFolderServiceType.FOLDER;
        if (!isFolder) {
            throw new IllegalArgumentException("Type is invalid to make folders with: " + folderTypeQName);
        }
        NodeRef currentParentRef = parentNodeRef;
        for (String pathElement : pathElements) {
            NodeRef nodeRef = (NodeRef)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new SearchAsSystem(service, currentParentRef, pathElement), (String)AuthenticationUtil.getSystemUserName());
            if (nodeRef == null) {
                if (behaviourFilter != null && parentBehavioursToDisable != null) {
                    for (QName parentBehaviourToDisable : parentBehavioursToDisable) {
                        behaviourFilter.disableBehaviour(currentParentRef, parentBehaviourToDisable);
                    }
                }
                try {
                    FileInfo createdFileInfo = service.create(currentParentRef, pathElement, folderTypeQName);
                    currentParentRef = createdFileInfo.getNodeRef();
                    continue;
                }
                finally {
                    if (behaviourFilter != null && parentBehavioursToDisable != null) {
                        for (QName parentBehaviourToDisable : parentBehavioursToDisable) {
                            behaviourFilter.enableBehaviour(currentParentRef, parentBehaviourToDisable);
                        }
                    }
                    continue;
                }
            }
            currentParentRef = nodeRef;
        }
        FileInfo fileInfo = service.getFileInfo(currentParentRef);
        return fileInfo;
    }

    private static class SearchAsSystem
    implements AuthenticationUtil.RunAsWork<NodeRef> {
        FileFolderService service;
        NodeRef node;
        String name;

        SearchAsSystem(FileFolderService service, NodeRef node, String name) {
            this.service = service;
            this.node = node;
            this.name = name;
        }

        public NodeRef doWork() throws Exception {
            return this.service.searchSimple(this.node, this.name);
        }
    }
}

