/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.repository;

import java.util.List;
import java.util.Map;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.repo.content.transform.ContentTransformer;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.dictionary.InvalidTypeException;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.InvalidNodeRefException;
import org.alfresco.service.cmr.repository.NoTransformerException;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.TransformationOptions;
import org.alfresco.service.namespace.QName;

@AlfrescoPublicApi
public interface ContentService {
    public long getStoreTotalSpace();

    public long getStoreFreeSpace();

    @Auditable(parameters={"contentUrl"})
    public ContentReader getRawReader(String var1);

    @Auditable(parameters={"nodeRef", "propertyQName"})
    public ContentReader getReader(NodeRef var1, QName var2) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable(parameters={"nodeRef", "propertyQName", "update"})
    public ContentWriter getWriter(NodeRef var1, QName var2, boolean var3) throws InvalidNodeRefException, InvalidTypeException;

    @Auditable
    public ContentWriter getTempWriter();

    @Auditable(parameters={"reader", "writer"})
    public void transform(ContentReader var1, ContentWriter var2) throws NoTransformerException, ContentIOException;

    @Auditable(parameters={"reader", "writer", "options"})
    @Deprecated
    public void transform(ContentReader var1, ContentWriter var2, Map<String, Object> var3) throws NoTransformerException, ContentIOException;

    @Auditable(parameters={"reader", "writer", "options"})
    public void transform(ContentReader var1, ContentWriter var2, TransformationOptions var3) throws NoTransformerException, ContentIOException;

    @Auditable(parameters={"sourceMimetype", "targetMimetype"})
    public ContentTransformer getTransformer(String var1, String var2);

    @Auditable(parameters={"sourceMimetype", "sourceSize", "targetMimetype", "options"})
    public List<ContentTransformer> getTransformers(String var1, String var2, long var3, String var5, TransformationOptions var6);

    @Auditable(parameters={"sourceMimetype", "sourceSize", "targetMimetype", "options"})
    public ContentTransformer getTransformer(String var1, String var2, long var3, String var5, TransformationOptions var6);

    public ContentTransformer getTransformer(String var1, String var2, TransformationOptions var3);

    @Auditable(parameters={"sourceMimetype", "targetMimetype", "options"})
    public long getMaxSourceSizeBytes(String var1, String var2, TransformationOptions var3);

    @Auditable(parameters={"sourceMimetype", "sourceSize", "targetMimetype", "options"})
    public List<ContentTransformer> getActiveTransformers(String var1, long var2, String var4, TransformationOptions var5);

    public List<ContentTransformer> getActiveTransformers(String var1, String var2, TransformationOptions var3);

    @Auditable
    public ContentTransformer getImageTransformer();

    @Auditable(parameters={"reader", "writer"})
    public boolean isTransformable(ContentReader var1, ContentWriter var2);

    @Auditable(parameters={"reader", "writer", "options"})
    public boolean isTransformable(ContentReader var1, ContentWriter var2, TransformationOptions var3);
}

