/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.search;

import java.util.Collection;
import java.util.List;
import org.alfresco.api.AlfrescoPublicApi;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.service.Auditable;
import org.alfresco.service.cmr.repository.ChildAssociationRef;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.Pair;

@AlfrescoPublicApi
public interface CategoryService {
    @Auditable(parameters={"categoryRef", "mode", "depth"})
    public Collection<ChildAssociationRef> getChildren(NodeRef var1, Mode var2, Depth var3);

    @Auditable(parameters={"storeRef", "aspectQName", "depth"})
    public Collection<ChildAssociationRef> getCategories(StoreRef var1, QName var2, Depth var3);

    @Auditable(parameters={"storeRef"})
    public Collection<ChildAssociationRef> getClassifications(StoreRef var1);

    @Auditable(parameters={"storeRef", "aspectName"})
    public Collection<ChildAssociationRef> getRootCategories(StoreRef var1, QName var2);

    @Auditable(parameters={"storeRef", "aspectName", "pagingRequest", "sortByName"})
    public PagingResults<ChildAssociationRef> getRootCategories(StoreRef var1, QName var2, PagingRequest var3, boolean var4);

    @Auditable(parameters={"storeRef", "aspectName", "name"})
    public ChildAssociationRef getCategory(NodeRef var1, QName var2, String var3);

    @Auditable(parameters={"storeRef", "aspectName", "name", "create"})
    public Collection<ChildAssociationRef> getRootCategories(StoreRef var1, QName var2, String var3, boolean var4);

    @Auditable
    public Collection<QName> getClassificationAspects();

    @Auditable(parameters={"storeRef", "aspectName", "attributeName"})
    public NodeRef createClassification(StoreRef var1, QName var2, String var3);

    @Auditable(parameters={"storeRef", "aspectName", "name"})
    public NodeRef createRootCategory(StoreRef var1, QName var2, String var3);

    @Auditable(parameters={"parent", "name"})
    public NodeRef createCategory(NodeRef var1, String var2);

    @Auditable(parameters={"storeRef", "aspectName"})
    public void deleteClassification(StoreRef var1, QName var2);

    @Auditable(parameters={"nodeRef"})
    public void deleteCategory(NodeRef var1);

    @Auditable(parameters={"storeRef", "aspectName", "count"})
    public List<Pair<NodeRef, Integer>> getTopCategories(StoreRef var1, QName var2, int var3);

    public static enum Depth {
        IMMEDIATE,
        ANY;

    }

    public static enum Mode {
        MEMBERS,
        SUB_CATEGORIES,
        ALL;

    }
}

