/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.tagging;

import java.util.List;
import org.alfresco.query.PagingRequest;
import org.alfresco.query.PagingResults;
import org.alfresco.service.Auditable;
import org.alfresco.service.NotAuditable;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.tagging.TagScope;
import org.alfresco.util.Pair;

public interface TaggingService {
    @NotAuditable
    public boolean isTag(StoreRef var1, String var2);

    public String getTagName(NodeRef var1);

    @NotAuditable
    public List<String> getTags(StoreRef var1);

    @NotAuditable
    public PagingResults<Pair<NodeRef, String>> getTags(StoreRef var1, PagingRequest var2);

    @NotAuditable
    public List<String> getTags(StoreRef var1, String var2);

    @Auditable(parameters={"tag"})
    public NodeRef createTag(StoreRef var1, String var2);

    @Auditable(parameters={"tag"})
    public void deleteTag(StoreRef var1, String var2);

    @Auditable(parameters={"existingTag", "newTag"})
    public NodeRef changeTag(StoreRef var1, String var2, String var3);

    @Auditable(parameters={"tag"})
    public boolean hasTag(NodeRef var1, String var2);

    @Auditable(parameters={"tag"})
    public NodeRef addTag(NodeRef var1, String var2);

    @NotAuditable
    public NodeRef getTagNodeRef(StoreRef var1, String var2);

    @Auditable(parameters={"tags"})
    public List<Pair<String, NodeRef>> addTags(NodeRef var1, List<String> var2);

    @Auditable(parameters={"tag"})
    public void removeTag(NodeRef var1, String var2);

    @Auditable(parameters={"tags"})
    public void removeTags(NodeRef var1, List<String> var2);

    @NotAuditable
    public List<String> getTags(NodeRef var1);

    @NotAuditable
    public PagingResults<Pair<NodeRef, String>> getTags(NodeRef var1, PagingRequest var2);

    @Auditable(parameters={"tags"})
    public void setTags(NodeRef var1, List<String> var2);

    @Auditable
    public void clearTags(NodeRef var1);

    @NotAuditable
    public boolean isTagScope(NodeRef var1);

    @Auditable
    public void addTagScope(NodeRef var1);

    @Auditable
    public void refreshTagScope(NodeRef var1, boolean var2);

    @Auditable
    public void removeTagScope(NodeRef var1);

    @NotAuditable
    public TagScope findTagScope(NodeRef var1);

    @NotAuditable
    public List<TagScope> findAllTagScopes(NodeRef var1);

    @NotAuditable
    public List<NodeRef> findTaggedNodes(StoreRef var1, String var2);

    @NotAuditable
    public List<NodeRef> findTaggedNodes(StoreRef var1, String var2, NodeRef var3);
}

