/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.service.cmr.workflow;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.security.permissions.AccessDeniedException;
import org.alfresco.repo.workflow.WorkflowModel;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.PersonService;
import org.alfresco.service.cmr.workflow.WorkflowService;
import org.alfresco.service.cmr.workflow.WorkflowTask;
import org.alfresco.service.cmr.workflow.WorkflowTaskQuery;
import org.alfresco.service.namespace.QName;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;

public class WorkflowPermissionInterceptor
implements MethodInterceptor {
    private PersonService personService;
    private AuthorityService authorityService;
    private WorkflowService workflowService;

    public Object invoke(MethodInvocation invocation) throws Throwable {
        String currentUser = AuthenticationUtil.getRunAsUser();
        if (currentUser != null && (this.authorityService.isAdminAuthority(currentUser) || AuthenticationUtil.isRunAsUserTheSystemUser())) {
            return invocation.proceed();
        }
        String methodName = invocation.getMethod().getName();
        if (methodName.equals("getTaskById")) {
            Object result = invocation.proceed();
            WorkflowTask wt = (WorkflowTask)result;
            if (this.isInitiatorOrAssignee(wt, currentUser) || this.fromSameParallelReviewWorkflow(wt, currentUser) || this.isStartTaskOfProcessInvolvedIn(wt, currentUser)) {
                return result;
            }
            String taskId = (String)invocation.getArguments()[0];
            throw new AccessDeniedException("Accessing task with id='" + taskId + "' is not allowed for user '" + currentUser + "'");
        }
        if (methodName.equals("getStartTask")) {
            Object result = invocation.proceed();
            WorkflowTask wt = (WorkflowTask)result;
            if (this.isInitiatorOrAssignee(wt, currentUser) || this.isUserPartOfProcess(wt, currentUser)) {
                return result;
            }
            String taskId = (String)invocation.getArguments()[0];
            throw new AccessDeniedException("Accessing task with id='" + taskId + "' is not allowed for user '" + currentUser + "'");
        }
        if (methodName.equals("updateTask") || methodName.equals("endTask")) {
            String taskId = (String)invocation.getArguments()[0];
            WorkflowTask taskToUpdate = this.workflowService.getTaskById(taskId);
            if (this.isInitiatorOrAssignee(taskToUpdate, currentUser)) {
                return invocation.proceed();
            }
            throw new AccessDeniedException("Accessing task with id='" + taskId + "' is not allowed for user '" + currentUser + "'");
        }
        if (methodName.equals("getTasksForWorkflowPath") || methodName.equals("getStartTasks") || methodName.equals("queryTasks")) {
            Object result = invocation.proceed();
            List rawList = (List)result;
            ArrayList<WorkflowTask> resultList = new ArrayList<WorkflowTask>(rawList.size());
            for (WorkflowTask wt : rawList) {
                if (!this.isInitiatorOrAssignee(wt, currentUser) && !this.fromSameParallelReviewWorkflow(wt, currentUser) && !this.isStartTaskOfProcessInvolvedIn(wt, currentUser)) continue;
                resultList.add(wt);
            }
            return resultList;
        }
        return invocation.proceed();
    }

    private boolean isInitiatorOrAssignee(WorkflowTask wt, String userName) {
        if (wt == null) {
            return true;
        }
        NodeRef person = this.personService.getPerson(userName);
        Map<QName, Serializable> props = wt.getProperties();
        String ownerName = (String)((Object)props.get(ContentModel.PROP_OWNER));
        if (userName != null && userName.equalsIgnoreCase(ownerName)) {
            return true;
        }
        ArrayList<NodeRef> accessUseres = new ArrayList<NodeRef>();
        accessUseres.add(this.getUserGroupRef(props.get(WorkflowModel.ASSOC_ASSIGNEE)));
        accessUseres.add(this.getUserGroupRef(props.get(WorkflowModel.ASSOC_GROUP_ASSIGNEE)));
        accessUseres.addAll(this.getUserGroupRefs(props.get(WorkflowModel.ASSOC_GROUP_ASSIGNEES)));
        accessUseres.addAll(this.getUserGroupRefs(props.get(WorkflowModel.ASSOC_ASSIGNEES)));
        accessUseres.addAll(this.getUserGroupRefs(wt.getProperties().get(WorkflowModel.ASSOC_POOLED_ACTORS)));
        accessUseres.add(wt.getPath().getInstance().getInitiator());
        if (accessUseres.contains(person)) {
            return true;
        }
        Set<String> userGroups = this.authorityService.getAuthoritiesForUser(userName);
        for (String groupName : userGroups) {
            NodeRef groupRef = this.authorityService.getAuthorityNodeRef(groupName);
            if (groupRef == null || !accessUseres.contains(groupRef)) continue;
            return true;
        }
        return false;
    }

    private boolean isStartTaskOfProcessInvolvedIn(WorkflowTask wt, String userName) {
        return wt.getId().contains("start") && this.isUserPartOfProcess(wt, userName);
    }

    private boolean fromSameParallelReviewWorkflow(WorkflowTask wt, String userName) {
        if (wt.getPath().getInstance().getDefinition().getName().toLowerCase().contains("parallel")) {
            WorkflowTaskQuery tasksQuery = new WorkflowTaskQuery();
            tasksQuery.setTaskState(null);
            tasksQuery.setActive(null);
            tasksQuery.setProcessId(wt.getPath().getInstance().getId());
            List<WorkflowTask> allWorkflowTasks = this.workflowService.queryTasks(tasksQuery, true);
            for (WorkflowTask task : allWorkflowTasks) {
                if (!this.isInitiatorOrAssignee(task, userName)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isUserPartOfProcess(WorkflowTask wt, String userName) {
        WorkflowTaskQuery tasksQuery = new WorkflowTaskQuery();
        tasksQuery.setTaskState(null);
        tasksQuery.setActive(null);
        tasksQuery.setProcessId(wt.getPath().getInstance().getId());
        List<WorkflowTask> allWorkflowTasks = this.workflowService.queryTasks(tasksQuery, true);
        for (WorkflowTask task : allWorkflowTasks) {
            if (!this.isInitiatorOrAssignee(task, userName)) continue;
            return true;
        }
        return false;
    }

    private NodeRef getUserGroupRef(Object o) {
        NodeRef result = null;
        if (o == null || o instanceof NodeRef) {
            result = (NodeRef)o;
        } else {
            try {
                result = this.personService.getPerson(o.toString());
            }
            catch (Exception e) {
                try {
                    result = this.authorityService.getAuthorityNodeRef(o.toString());
                }
                catch (Exception e1) {
                    // empty catch block
                }
            }
        }
        return result;
    }

    private Collection<NodeRef> getUserGroupRefs(Object o) {
        ArrayList<NodeRef> result = new ArrayList<NodeRef>();
        if (o != null && o instanceof Collection) {
            Iterator it = ((Collection)o).iterator();
            while (it.hasNext()) {
                result.add(this.getUserGroupRef(it.next()));
            }
        }
        return result;
    }

    public void setPersonService(PersonService personService) {
        this.personService = personService;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setWorkflowService(WorkflowService workflowService) {
        this.workflowService = workflowService;
    }
}

