/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util;

import org.alfresco.util.JodConfig;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JodCoordination {
    private static Log logger = LogFactory.getLog(JodCoordination.class);
    private Boolean start;
    private boolean oooEnabled;
    private boolean oooLocalhost;
    private String oooPort;
    private JodConfig jodConfig;

    public void setOooEnabled(boolean oooEnabled) {
        this.oooEnabled = oooEnabled;
    }

    public void setOooHost(String oooHost) {
        this.oooLocalhost = oooHost == null || oooHost.equals("localhost");
    }

    public void setOooPort(String oooPort) {
        this.oooPort = oooPort;
    }

    public void setJodConfig(JodConfig jodConfig) {
        this.jodConfig = jodConfig;
    }

    public boolean startOpenOffice() {
        if (this.start == null) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("OOoJodconverter subsystem will " + (this.jodConfig.isEnabled() ? "" : "NOT ") + "start an OpenOffice process"));
            }
            this.start = this.oooEnabled && this.oooLocalhost;
            if (this.start.booleanValue()) {
                if (this.jodConfig.isEnabled() && this.jodConfig.getPortsCollection().contains(this.oooPort)) {
                    this.start = false;
                    logger.error((Object)"Both OOoDirect and OOoJodconverter subsystems are enabled and have specified the same port number on the localhost.");
                    logger.error((Object)"   ooo.enabled=true");
                    logger.error((Object)"   ooo.host=localhost");
                    logger.error((Object)("   ooo.port=" + this.oooPort));
                    logger.error((Object)("   jodconverter.portNumbers=" + this.jodConfig.getPorts()));
                    logger.error((Object)"   jodconverter.enabled=true");
                    logger.error((Object)"The OOoDirect subsystem will not start its OpenOffice process as a result.");
                } else {
                    logger.debug((Object)"OOoDirect subsystem will start an OpenOffice process");
                }
            } else {
                logger.debug((Object)"OOoDirect subsystem will NOT start an OpenOffice process");
            }
        }
        return this.start;
    }

    public boolean startListener() {
        return this.oooEnabled && !this.oooLocalhost || this.startOpenOffice();
    }
}

