/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.util.schemacomp;

import org.alfresco.util.schemacomp.model.DbObject;
import org.apache.commons.beanutils.PropertyUtils;

public class DbProperty {
    private final DbObject dbObject;
    private final String propertyName;
    private final Object propertyValue;

    protected DbProperty(DbObject dbObject, String propertyName, int index, boolean useSuppliedValue, Object propertyValue) {
        if (dbObject == null) {
            throw new IllegalArgumentException("dbObject cannot be null.");
        }
        this.dbObject = dbObject;
        if (propertyName == null && (index > -1 || useSuppliedValue)) {
            throw new IllegalArgumentException("propertyName cannot be null.");
        }
        this.propertyName = index > -1 ? propertyName + "[" + index + "]" : propertyName;
        if (useSuppliedValue) {
            this.propertyValue = propertyValue;
        } else if (propertyName != null) {
            try {
                this.propertyValue = PropertyUtils.getProperty((Object)dbObject, (String)this.propertyName);
            }
            catch (Throwable error) {
                throw new IllegalArgumentException("Cannot get value for property named \"" + propertyName + "\"", error);
            }
        } else {
            this.propertyValue = null;
        }
    }

    public DbProperty(DbObject dbObject) {
        this(dbObject, null, -1, false, null);
    }

    public DbProperty(DbObject dbObject, String propertyName) {
        this(dbObject, propertyName, -1, false, null);
    }

    public DbProperty(DbObject dbObject, String propertyName, int index) {
        this(dbObject, propertyName, index, false, null);
    }

    public DbObject getDbObject() {
        return this.dbObject;
    }

    public String getPropertyName() {
        return this.propertyName;
    }

    public Object getPropertyValue() {
        return this.propertyValue;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.dbObject == null ? 0 : this.dbObject.hashCode());
        result = 31 * result + (this.propertyName == null ? 0 : this.propertyName.hashCode());
        result = 31 * result + (this.propertyValue == null ? 0 : this.propertyValue.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DbProperty other = (DbProperty)obj;
        if (this.dbObject == null ? other.dbObject != null : !this.dbObject.equals(other.dbObject)) {
            return false;
        }
        if (this.propertyName == null ? other.propertyName != null : !this.propertyName.equals(other.propertyName)) {
            return false;
        }
        return !(this.propertyValue == null ? other.propertyValue != null : !this.propertyValue.equals(other.propertyValue));
    }

    public String toString() {
        return "DbProperty [dbObject=" + this.dbObject + ", propertyName=" + this.propertyName + ", propertyValue=" + this.propertyValue + "]";
    }

    public String getPath() {
        StringBuffer sb = new StringBuffer();
        if (this.getPropertyName() != null) {
            sb.append(".");
            sb.append(this.getPropertyName());
        }
        for (DbObject pathElement = this.dbObject; pathElement != null; pathElement = pathElement.getParent()) {
            sb.insert(0, pathElement.getName());
            if (pathElement.getParent() == null) continue;
            sb.insert(0, ".");
        }
        return sb.toString();
    }
}

