/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.sandbox;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.mbeans.VirtServerRegistry;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.domain.PropertyValue;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.service.cmr.avm.AVMService;
import org.alfresco.service.cmr.avm.AVMStoreDescriptor;
import org.alfresco.service.cmr.avm.locking.AVMLockingService;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.cmr.repository.StoreRef;
import org.alfresco.service.cmr.security.AccessPermission;
import org.alfresco.service.cmr.security.AuthorityService;
import org.alfresco.service.cmr.security.AuthorityType;
import org.alfresco.service.cmr.security.PermissionService;
import org.alfresco.service.namespace.QName;
import org.alfresco.util.DNSNameMangler;
import org.alfresco.util.GUID;
import org.alfresco.wcm.sandbox.SandboxConstants;
import org.alfresco.wcm.sandbox.SandboxInfo;
import org.alfresco.wcm.sandbox.SandboxInfoImpl;
import org.alfresco.wcm.util.WCMUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SandboxFactory
extends WCMUtil {
    private static final Set<String> ZONES;
    public static final String[] PERMISSIONS;
    private static Log logger;
    private NodeService nodeService;
    private PermissionService permissionService;
    private AVMService avmService;
    private VirtServerRegistry virtServerRegistry;
    private AuthorityService authorityService;
    private AVMLockingService avmLockingService;
    private static final QName PROP_SANDBOX_LOCALHOST_DEPLOYED;

    public void setNodeService(NodeService nodeService) {
        this.nodeService = nodeService;
    }

    public void setPermissionService(PermissionService permissionService) {
        this.permissionService = permissionService;
    }

    public void setAvmService(AVMService avmService) {
        this.avmService = avmService;
    }

    public void setVirtServerRegistry(VirtServerRegistry virtServerRegistry) {
        this.virtServerRegistry = virtServerRegistry;
    }

    public void setAuthorityService(AuthorityService authorityService) {
        this.authorityService = authorityService;
    }

    public void setAvmLockingService(AVMLockingService avmLockingService) {
        this.avmLockingService = avmLockingService;
    }

    private SandboxFactory() {
    }

    public SandboxInfo createStagingSandbox(String storeId, NodeRef webProjectNodeRef, String branchStoreId) {
        long start = System.currentTimeMillis();
        String stagingStoreName = WCMUtil.buildStagingStoreName(storeId);
        HashMap<Object, PropertyValue> props = new HashMap<QName, PropertyValue>(3);
        props.put(SandboxConstants.PROP_SANDBOX_STAGING_MAIN, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(SandboxConstants.PROP_WEB_PROJECT_NODE_REF, new PropertyValue(DataTypeDefinition.NODE_REF, (Serializable)webProjectNodeRef));
        SandboxFactory.addStoreDNSPath(stagingStoreName, props, storeId);
        this.avmService.createStore(stagingStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created staging sandbox: " + stagingStoreName));
        }
        if (branchStoreId != null) {
            String branchStorePath = WCMUtil.buildStagingStoreName(branchStoreId) + ":/" + "www";
            this.avmService.createBranch(-1, branchStorePath, stagingStoreName + ":/", "www");
        } else {
            this.avmService.createDirectory(stagingStoreName + ":/", "www");
            this.avmService.createDirectory(WCMUtil.buildStoreRootPath(stagingStoreName), "avm_webapps");
        }
        this.setStagingPermissions(storeId, webProjectNodeRef);
        this.avmService.createSnapshot(stagingStoreName, null, null);
        String previewStoreName = WCMUtil.buildStagingPreviewStoreName(storeId);
        props = new HashMap(3);
        props.put(SandboxConstants.PROP_SANDBOX_STAGING_PREVIEW, new PropertyValue(DataTypeDefinition.TEXT, null));
        SandboxFactory.addStoreDNSPath(previewStoreName, props, storeId, "preview");
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 1);
        this.avmService.createStore(previewStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created staging preview sandbox store: " + previewStoreName + " above " + stagingStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(stagingStoreName), previewStoreName + ":/", "www");
        this.avmService.createSnapshot(previewStoreName, null, null);
        String sandboxGuid = GUID.generate();
        props = new HashMap(2);
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        this.avmService.setStoreProperties(stagingStoreName, props);
        this.avmService.setStoreProperties(previewStoreName, props);
        if (logger.isTraceEnabled()) {
            SandboxFactory.dumpStoreProperties(this.avmService, stagingStoreName);
            SandboxFactory.dumpStoreProperties(this.avmService, previewStoreName);
        }
        SandboxInfo sbInfo = this.getSandbox(stagingStoreName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createStagingSandbox: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return sbInfo;
    }

    SandboxInfo getSandbox(String sandboxId) {
        String wpStoreId = WCMUtil.getWebProjectStoreId(sandboxId);
        return this.getSandbox(wpStoreId, sandboxId, true);
    }

    private SandboxInfo getSandbox(String wpStoreId, String sandboxId, boolean withPreview) {
        AVMStoreDescriptor storeDesc = this.avmService.getStore(sandboxId);
        if (storeDesc == null) {
            return null;
        }
        String[] storeNames = null;
        Map<QName, PropertyValue> props = this.avmService.getStoreProperties(sandboxId);
        QName sandboxType = null;
        String name = null;
        String previewSandboxId = null;
        if (withPreview && !WCMUtil.isPreviewStore(sandboxId)) {
            previewSandboxId = WCMUtil.getCorrespondingPreviewStoreName(sandboxId);
        }
        if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_MAIN)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_STAGING_MAIN;
            name = sandboxId;
            storeNames = new String[]{sandboxId, previewSandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_STAGING_PREVIEW)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_STAGING_PREVIEW;
            storeNames = new String[]{WCMUtil.getCorrespondingMainStoreName(sandboxId), sandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN;
            name = WCMUtil.getUserName(sandboxId);
            storeNames = new String[]{sandboxId, previewSandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_PREVIEW)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_AUTHOR_PREVIEW;
            name = WCMUtil.getUserName(sandboxId);
            storeNames = new String[]{WCMUtil.getCorrespondingMainStoreName(sandboxId), sandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_WORKFLOW_MAIN)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_WORKFLOW_MAIN;
            name = WCMUtil.getWorkflowId(sandboxId);
            storeNames = new String[]{sandboxId, previewSandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_WORKFLOW_PREVIEW)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_WORKFLOW_PREVIEW;
            name = WCMUtil.getWorkflowId(sandboxId);
            storeNames = new String[]{WCMUtil.getCorrespondingMainStoreName(sandboxId), sandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_MAIN)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_MAIN;
            name = WCMUtil.getWorkflowId(sandboxId);
            storeNames = new String[]{sandboxId, previewSandboxId};
        } else if (props.containsKey(SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_PREVIEW)) {
            sandboxType = SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_PREVIEW;
            name = WCMUtil.getWorkflowId(sandboxId);
        } else if (WCMUtil.isLocalhostDeployedStore(wpStoreId, sandboxId)) {
            sandboxType = PROP_SANDBOX_LOCALHOST_DEPLOYED;
            name = sandboxId;
            storeNames = new String[]{sandboxId};
        }
        if (storeNames == null || storeNames.length == 0) {
            throw new AlfrescoRuntimeException("Must have at least one store");
        }
        if (storeNames.length == 1 && !sandboxType.equals((Object)SandboxConstants.PROP_SANDBOX_STAGING_MAIN) && !sandboxType.equals((Object)PROP_SANDBOX_LOCALHOST_DEPLOYED)) {
            throw new AlfrescoRuntimeException("Main store must be of type: " + SandboxConstants.PROP_SANDBOX_STAGING_MAIN);
        }
        return new SandboxInfoImpl(wpStoreId, sandboxId, sandboxType, name, storeNames, new Date(storeDesc.getCreateDate()), storeDesc.getCreator());
    }

    private void setStagingPermissions(String storeId, NodeRef wpNodeRef) {
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, WCMUtil.buildStoreRootPath(storeName));
        this.makeGroupsIfRequired(storeName, dirRef);
        Map<String, String> userRoles = WCMUtil.listWebUsers(this.nodeService, wpNodeRef);
        for (Map.Entry<String, String> userRole : userRoles.entrySet()) {
            String username = userRole.getKey();
            String userrole = userRole.getValue();
            this.addToGroupIfRequired(storeName, username, userrole);
        }
        for (String permission : PERMISSIONS) {
            String cms = this.authorityService.getName(AuthorityType.GROUP, storeName + "-" + permission);
            this.permissionService.setPermission(dirRef, cms, permission, true);
        }
        this.permissionService.setPermission(dirRef, "GROUP_EVERYONE", "Read", true);
    }

    private void makeGroupsIfRequired(final String stagingStoreName, final NodeRef dirRef) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                for (String permission : PERMISSIONS) {
                    String shortName = stagingStoreName + "-" + permission;
                    String group = SandboxFactory.this.authorityService.getName(AuthorityType.GROUP, shortName);
                    if (!SandboxFactory.this.authorityService.authorityExists(group)) {
                        SandboxFactory.this.authorityService.createAuthority(AuthorityType.GROUP, shortName, shortName, ZONES);
                    }
                    if (SandboxFactory.this.isPermissionSet(dirRef, group, permission)) continue;
                    SandboxFactory.this.permissionService.setPermission(dirRef, group, permission, true);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean isPermissionSet(NodeRef nodeRef, String authority, String permission) {
        Set set = this.permissionService.getAllSetPermissions(nodeRef);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals(authority) || !ap.isSetDirectly() || !ap.getPermission().equals(permission)) continue;
            return true;
        }
        return false;
    }

    private void addToGroupIfRequired(final String stagingStoreName, final String user, final String permission) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Set<String> members;
                String shortName = stagingStoreName + "-" + permission;
                String group = SandboxFactory.this.authorityService.getName(AuthorityType.GROUP, shortName);
                if (!SandboxFactory.this.authorityService.authorityExists(group)) {
                    SandboxFactory.this.authorityService.createAuthority(AuthorityType.GROUP, shortName, shortName, ZONES);
                }
                if (!(members = SandboxFactory.this.authorityService.getContainedAuthorities(AuthorityType.USER, group, true)).contains(user)) {
                    SandboxFactory.this.authorityService.addAuthority(group, user);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private void removeFromGroupIfRequired(final String stagingStoreName, final String user, final String permission) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Object>(){

            public Object doWork() throws Exception {
                Set<String> members;
                String shortName = stagingStoreName + "-" + permission;
                String group = SandboxFactory.this.authorityService.getName(AuthorityType.GROUP, shortName);
                if (SandboxFactory.this.authorityService.authorityExists(group) && (members = SandboxFactory.this.authorityService.getContainedAuthorities(AuthorityType.USER, group, true)).contains(user)) {
                    SandboxFactory.this.authorityService.removeAuthority(group, user);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    private boolean isMaskSet(StoreRef storeRef, String authority, String permission) {
        Set set = this.permissionService.getAllSetPermissions(storeRef);
        for (AccessPermission ap : set) {
            if (!ap.getAuthority().equals(authority) || !ap.isSetDirectly() || !ap.getPermission().equals(permission)) continue;
            return true;
        }
        return false;
    }

    public void setStagingPermissionMasks(String storeId) {
        boolean setReadPermissions;
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, WCMUtil.buildStoreRootPath(storeName));
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        this.addToGroupIfRequired(storeName, currentUser, "ContentManager");
        String cms = this.authorityService.getName(AuthorityType.GROUP, storeName + "-" + "ContentManager");
        boolean bl = setReadPermissions = !this.isMaskSet(dirRef.getStoreRef(), cms, "ReadPermissions");
        if (!this.isMaskSet(dirRef.getStoreRef(), cms, "ChangePermissions")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ChangePermissions", true);
        }
        if (setReadPermissions) {
            this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ReadPermissions", true);
        }
        if (!this.isMaskSet(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read")) {
            this.permissionService.setPermission(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read", true);
        }
    }

    private void updateStagingAreaManagers(String storeId, List<String> managers) {
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        String shortName = storeName + "-" + "ContentManager";
        String group = this.authorityService.getName(AuthorityType.GROUP, shortName);
        Set<String> members = this.authorityService.getContainedAuthorities(AuthorityType.USER, group, true);
        HashSet<String> toRemove = new HashSet<String>(members);
        for (String manager : managers) {
            this.addToGroupIfRequired(storeName, manager, "ContentManager");
            toRemove.remove(manager);
        }
        for (String remove : toRemove) {
            this.removeFromGroupIfRequired(storeName, remove, "ContentManager");
        }
    }

    public void addStagingAreaUser(String storeId, String authority, String role) {
        this.addToGroupIfRequired(storeId, authority, role);
    }

    public SandboxInfo createUserSandbox(String storeId, String username, String role) {
        long start = System.currentTimeMillis();
        String userStoreName = WCMUtil.buildUserMainStoreName(storeId, username);
        String previewStoreName = WCMUtil.buildUserPreviewStoreName(storeId, username);
        SandboxInfo userSandboxInfo = this.getSandbox(userStoreName);
        if (userSandboxInfo != null) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Not creating author sandbox as it already exists: " + userStoreName));
            }
            return userSandboxInfo;
        }
        String sandboxGuid = GUID.generate();
        String stagingStoreName = WCMUtil.buildStagingStoreName(storeId);
        HashMap<Object, PropertyValue> props = new HashMap<QName, PropertyValue>(6);
        props.put(SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(SandboxConstants.PROP_WEBSITE_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)storeId)));
        SandboxFactory.addSandboxPrefix(userStoreName, props);
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(userStoreName, props, storeId, WCMUtil.escapeStoreNameComponent(username));
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 1);
        this.avmService.createStore(userStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created user sandbox: " + userStoreName + " above staging store " + stagingStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(stagingStoreName), userStoreName + ":/", "www");
        NodeRef dirRef = AVMNodeConverter.ToNodeRef(-1, WCMUtil.buildStoreRootPath(userStoreName));
        String currentUser = AuthenticationUtil.getFullyAuthenticatedUser();
        this.addToGroupIfRequired(stagingStoreName, currentUser, "ContentManager");
        String cms = this.authorityService.getName(AuthorityType.GROUP, stagingStoreName + "-" + "ContentManager");
        this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ContentManager", true);
        this.permissionService.setPermission(dirRef.getStoreRef(), username, "All", true);
        this.permissionService.setPermission(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read", true);
        this.avmService.createSnapshot(userStoreName, null, null);
        props = new HashMap(6);
        props.put(SandboxConstants.PROP_SANDBOX_AUTHOR_PREVIEW, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(QName.createQName(null, (String)(".sandbox.store." + previewStoreName)), new PropertyValue(DataTypeDefinition.TEXT, null));
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(previewStoreName, props, storeId, username, "preview");
        SandboxFactory.addStoreBackgroundLayer(props, userStoreName, 1);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 2);
        this.avmService.createStore(previewStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created user preview sandbox store: " + previewStoreName + " above " + userStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(userStoreName), previewStoreName + ":/", "www");
        dirRef = AVMNodeConverter.ToNodeRef(-1, WCMUtil.buildStoreRootPath(previewStoreName));
        this.permissionService.setPermission(dirRef.getStoreRef(), cms, "ContentManager", true);
        this.permissionService.setPermission(dirRef.getStoreRef(), username, "All", true);
        this.permissionService.setPermission(dirRef.getStoreRef(), "GROUP_EVERYONE", "Read", true);
        this.avmService.createSnapshot(previewStoreName, null, null);
        if (logger.isTraceEnabled()) {
            SandboxFactory.dumpStoreProperties(this.avmService, userStoreName);
            SandboxFactory.dumpStoreProperties(this.avmService, previewStoreName);
        }
        SandboxInfo sbInfo = this.getSandbox(userStoreName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createUserSandbox: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return sbInfo;
    }

    public SandboxInfo createWorkflowSandbox(String storeId) {
        long start = System.currentTimeMillis();
        String stagingStoreName = WCMUtil.buildStagingStoreName(storeId);
        String packageName = "workflow-" + GUID.generate();
        String mainStoreName = WCMUtil.buildWorkflowMainStoreName(storeId, packageName);
        String sandboxGuid = GUID.generate();
        HashMap<Object, PropertyValue> props = new HashMap<QName, PropertyValue>(6);
        props.put(SandboxConstants.PROP_SANDBOX_WORKFLOW_MAIN, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(SandboxConstants.PROP_WEBSITE_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)storeId)));
        SandboxFactory.addSandboxPrefix(mainStoreName, props);
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(mainStoreName, props, storeId, packageName);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 1);
        this.avmService.createStore(mainStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created workflow sandbox store: " + mainStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(stagingStoreName), mainStoreName + ":/", "www");
        this.avmService.createSnapshot(mainStoreName, null, null);
        String previewStoreName = WCMUtil.buildWorkflowPreviewStoreName(storeId, packageName);
        props = new HashMap(6);
        props.put(SandboxConstants.PROP_SANDBOX_WORKFLOW_PREVIEW, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(QName.createQName(null, (String)(".sandbox.store." + previewStoreName)), new PropertyValue(DataTypeDefinition.TEXT, null));
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(previewStoreName, props, storeId, packageName, "preview");
        SandboxFactory.addStoreBackgroundLayer(props, mainStoreName, 1);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 2);
        this.avmService.createStore(previewStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created workflow sandbox preview store: " + previewStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(mainStoreName), previewStoreName + ":/", "www");
        this.avmService.createSnapshot(previewStoreName, null, null);
        if (logger.isTraceEnabled()) {
            SandboxFactory.dumpStoreProperties(this.avmService, mainStoreName);
            SandboxFactory.dumpStoreProperties(this.avmService, previewStoreName);
        }
        SandboxInfo sbInfo = this.getSandbox(mainStoreName);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createWorkflowSandbox: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return sbInfo;
    }

    public SandboxInfo createReadOnlyWorkflowSandbox(String storeId) {
        long start = System.currentTimeMillis();
        String wpStoreId = WCMUtil.getWebProjectStoreId(storeId);
        String stagingStoreName = WCMUtil.buildStagingStoreName(storeId);
        String packageName = "workflow-" + GUID.generate();
        String mainStoreName = WCMUtil.buildWorkflowMainStoreName(storeId, packageName);
        String sandboxGuid = GUID.generate();
        HashMap<QName, PropertyValue> props = new HashMap<QName, PropertyValue>(6);
        props.put(SandboxConstants.PROP_SANDBOX_WORKFLOW_MAIN, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(SandboxConstants.PROP_WEBSITE_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)storeId)));
        SandboxFactory.addSandboxPrefix(mainStoreName, props);
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(mainStoreName, props, storeId, packageName);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStoreName, 1);
        this.avmService.createStore(mainStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created read-only workflow sandbox store: " + mainStoreName));
        }
        this.avmService.createLayeredDirectory(WCMUtil.buildStoreRootPath(stagingStoreName), mainStoreName + ":/", "www");
        if (logger.isTraceEnabled()) {
            SandboxFactory.dumpStoreProperties(this.avmService, mainStoreName);
        }
        SandboxInfo sbInfo = this.getSandbox(wpStoreId, mainStoreName, false);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createReadOnlyWorkflowSandbox: " + sbInfo.getSandboxId() + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return sbInfo;
    }

    public String createUserWorkflowSandbox(String stagingStore, String userStore) {
        long start = System.currentTimeMillis();
        String packageName = "workflow-" + GUID.generate();
        String workflowStoreName = userStore + "--" + packageName;
        String sandboxGuid = GUID.generate();
        HashMap<Object, PropertyValue> props = new HashMap<QName, PropertyValue>(7);
        props.put(SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_MAIN, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(SandboxConstants.PROP_AUTHOR_NAME, new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)userStore)));
        SandboxFactory.addSandboxPrefix(workflowStoreName, props);
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(workflowStoreName, props, stagingStore, packageName);
        SandboxFactory.addStoreBackgroundLayer(props, userStore, 1);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStore, 2);
        this.avmService.createStore(workflowStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created user workflow sandbox store: " + workflowStoreName));
        }
        this.avmService.createLayeredDirectory(userStore + ":/" + "www", workflowStoreName + ":/", "www");
        this.avmService.createSnapshot(workflowStoreName, null, null);
        String previewStoreName = workflowStoreName + "--" + "preview";
        props = new HashMap(7);
        props.put(SandboxConstants.PROP_SANDBOX_AUTHOR_WORKFLOW_PREVIEW, new PropertyValue(DataTypeDefinition.TEXT, null));
        props.put(QName.createQName(null, (String)(".sandbox.store." + previewStoreName)), new PropertyValue(DataTypeDefinition.TEXT, null));
        SandboxFactory.addSandboxGuid(sandboxGuid, props);
        SandboxFactory.addStoreDNSPath(previewStoreName, props, userStore, packageName, "preview");
        SandboxFactory.addStoreBackgroundLayer(props, workflowStoreName, 1);
        SandboxFactory.addStoreBackgroundLayer(props, userStore, 2);
        SandboxFactory.addStoreBackgroundLayer(props, stagingStore, 3);
        this.avmService.createStore(previewStoreName, props);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Created user workflow sandbox preview store: " + previewStoreName));
        }
        this.avmService.createLayeredDirectory(workflowStoreName + ":/" + "www", previewStoreName + ":/", "www");
        this.avmService.createSnapshot(previewStoreName, null, null);
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("createUserWorkflowSandbox: " + workflowStoreName + " in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return workflowStoreName;
    }

    public List<SandboxInfo> listAllSandboxes(String wpStoreId) {
        return this.listAllSandboxes(wpStoreId, false, false);
    }

    public List<SandboxInfo> listAllSandboxes(String wpStoreId, boolean includeWorkflowSandboxes, boolean includeLocalhostDeployed) {
        long start = System.currentTimeMillis();
        List<AVMStoreDescriptor> stores = this.avmService.getStores();
        ArrayList<SandboxInfo> sbInfos = new ArrayList<SandboxInfo>();
        for (AVMStoreDescriptor store : stores) {
            String storeName = store.getName();
            if (!WCMUtil.getWebProjectStoreId(storeName).equals(wpStoreId) || WCMUtil.isPreviewStore(storeName) || !includeLocalhostDeployed && WCMUtil.isLocalhostDeployedStore(wpStoreId, storeName) || !includeWorkflowSandboxes && WCMUtil.isWorkflowStore(storeName)) continue;
            sbInfos.add(this.getSandbox(wpStoreId, storeName, true));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("listAllSandboxes: " + wpStoreId + "[" + sbInfos.size() + "] in " + (System.currentTimeMillis() - start) + " ms"));
        }
        return sbInfos;
    }

    public void deleteSandbox(String sbStoreId) {
        this.deleteSandbox(sbStoreId, false);
    }

    public void deleteSandbox(String sbStoreId, boolean isSubmitDirectWorkflowSandbox) {
        this.deleteSandbox(this.getSandbox(WCMUtil.getWebProjectStoreId(sbStoreId), sbStoreId, true), isSubmitDirectWorkflowSandbox, true);
    }

    public void deleteSandbox(SandboxInfo sbInfo, boolean isSubmitDirectWorkflowSandbox, boolean removeLocks) {
        if (sbInfo != null) {
            String[] avmStoreNames;
            long start = System.currentTimeMillis();
            String mainSandboxStore = sbInfo.getMainStoreName();
            String wpStoreId = WCMUtil.getWebProjectStoreId(mainSandboxStore);
            String path = WCMUtil.buildSandboxRootPath(mainSandboxStore);
            if (!isSubmitDirectWorkflowSandbox) {
                WCMUtil.removeAllVServerWebapps(this.virtServerRegistry, path, true);
            }
            for (String avmStoreName : avmStoreNames = sbInfo.getStoreNames()) {
                if (this.avmService.getStore(avmStoreName) != null) {
                    this.avmService.purgeStore(avmStoreName);
                }
                if (!removeLocks) continue;
                Map<String, String> lockDataToMatch = Collections.singletonMap("avm-store-name", avmStoreName);
                this.avmLockingService.removeLocks(wpStoreId, lockDataToMatch);
            }
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("deleteSandbox: " + mainSandboxStore + " in " + (System.currentTimeMillis() - start) + " ms"));
            }
        }
    }

    public void updateSandboxManagers(String storeId, List<String> managers) {
        String stagingStoreName = WCMUtil.buildStagingStoreName(storeId);
        this.updateStagingAreaManagers(stagingStoreName, managers);
    }

    public void removeSandboxManagers(String storeId, List<String> managersToRemove) {
        this.removeStagingAreaManagers(storeId, managersToRemove);
    }

    private void removeStagingAreaManagers(String storeId, List<String> managersToRemove) {
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        for (String remove : managersToRemove) {
            this.removeFromGroupIfRequired(storeName, remove, "ContentManager");
        }
    }

    public void updateSandboxRoles(String wpStoreId, List<UserRoleWrapper> usersToUpdate, Set<String> permissionsList) {
        List<SandboxInfo> sbInfos = this.listAllSandboxes(wpStoreId);
        for (SandboxInfo sbInfo : sbInfos) {
            if (!sbInfo.getSandboxType().equals((Object)SandboxConstants.PROP_SANDBOX_AUTHOR_MAIN)) continue;
            String username = sbInfo.getName();
            this.updateUserSandboxRole(wpStoreId, username, usersToUpdate, permissionsList);
        }
        this.updateStagingAreaRole(wpStoreId, usersToUpdate, permissionsList);
    }

    private void updateUserSandboxRole(String storeId, String username, List<UserRoleWrapper> usersToUpdate, Set<String> permissionsList) {
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        if (permissionsList != null && permissionsList.size() != 0) {
            for (UserRoleWrapper user : usersToUpdate) {
                for (String permission : permissionsList) {
                    this.removeFromGroupIfRequired(storeName, user.getUserAuth(), permission);
                }
                this.addToGroupIfRequired(storeName, user.getUserAuth(), user.getNewRole());
            }
        } else {
            for (UserRoleWrapper user : usersToUpdate) {
                this.removeFromGroupIfRequired(storeName, user.getUserAuth(), user.getOldRole());
                this.addToGroupIfRequired(storeName, user.getUserAuth(), user.getNewRole());
            }
        }
    }

    private void updateStagingAreaRole(String storeId, List<UserRoleWrapper> usersToUpdate, Set<String> permissionsList) {
        String storeName = WCMUtil.buildStagingStoreName(storeId);
        if (permissionsList != null && permissionsList.size() != 0) {
            for (UserRoleWrapper user : usersToUpdate) {
                for (String permission : permissionsList) {
                    this.removeFromGroupIfRequired(storeName, user.getUserAuth(), permission);
                }
                this.addToGroupIfRequired(storeName, user.getUserAuth(), user.getNewRole());
            }
        } else {
            for (UserRoleWrapper user : usersToUpdate) {
                this.removeFromGroupIfRequired(storeName, user.getUserAuth(), user.getOldRole());
                this.addToGroupIfRequired(storeName, user.getUserAuth(), user.getNewRole());
            }
        }
    }

    private static void addStoreDNSPath(String store, Map<QName, PropertyValue> props, String ... components) {
        String path = WCMUtil.buildSandboxRootPath(store);
        String dnsName = DNSNameMangler.MakeDNSName((String[])components);
        String dnsProp = ".dns." + dnsName;
        props.put(QName.createQName(null, (String)dnsProp), new PropertyValue(DataTypeDefinition.TEXT, (Serializable)((Object)path)));
    }

    private static void addStoreBackgroundLayer(Map<QName, PropertyValue> props, String backgroundStore, int distance) {
        String prop_key = ".background-layer." + backgroundStore;
        props.put(QName.createQName(null, (String)prop_key), new PropertyValue(DataTypeDefinition.INT, Integer.valueOf(distance)));
    }

    private static void addSandboxGuid(String sandboxGuid, Map<QName, PropertyValue> props) {
        QName sandboxIdProp = QName.createQName((String)(".sandbox-id." + sandboxGuid));
        props.put(sandboxIdProp, new PropertyValue(DataTypeDefinition.TEXT, null));
    }

    private static void addSandboxPrefix(String storeName, Map<QName, PropertyValue> props) {
        props.put(QName.createQName(null, (String)(".sandbox.store." + storeName)), new PropertyValue(DataTypeDefinition.TEXT, null));
    }

    private static void dumpStoreProperties(AVMService avmService, String store) {
        logger.trace((Object)("Store " + store));
        Map<QName, PropertyValue> props = avmService.getStoreProperties(store);
        for (QName name : props.keySet()) {
            logger.trace((Object)("   " + name + ": " + props.get(name)));
        }
    }

    public void removeGroupsForStore(final String storeRoot) {
        AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<Void>(){

            public Void doWork() throws Exception {
                String[] permissions;
                for (String permission : permissions = new String[]{"ContentContributor", "ContentManager", "ContentPublisher", "ContentReviewer"}) {
                    String shortName = storeRoot + "-" + permission;
                    String group = SandboxFactory.this.authorityService.getName(AuthorityType.GROUP, shortName);
                    if (!SandboxFactory.this.authorityService.authorityExists(group)) continue;
                    SandboxFactory.this.authorityService.deleteAuthority(group);
                }
                return null;
            }
        }, (String)AuthenticationUtil.getSystemUserName());
    }

    static {
        PERMISSIONS = new String[]{"ContentManager", "ContentPublisher", "ContentContributor", "ContentReviewer"};
        logger = LogFactory.getLog(SandboxFactory.class);
        HashSet<String> zones = new HashSet<String>(2, 1.0f);
        zones.add("APP.WCM");
        zones.add("AUTH.ALF");
        ZONES = Collections.unmodifiableSet(zones);
        PROP_SANDBOX_LOCALHOST_DEPLOYED = QName.createQName(null, (String)".sandbox.localhost.live");
    }

    public class UserRoleWrapper {
        private String newRole;
        private String oldRole;
        private String userAuth;

        public UserRoleWrapper(String userAuth, String oldRole, String newRole) {
            this.userAuth = userAuth;
            this.oldRole = oldRole;
            this.newRole = newRole;
        }

        public String getNewRole() {
            return this.newRole;
        }

        public void setNewRole(String newRole) {
            this.newRole = newRole;
        }

        public String getOldRole() {
            return this.oldRole;
        }

        public void setOldRole(String oldRole) {
            this.oldRole = oldRole;
        }

        public String getUserAuth() {
            return this.userAuth;
        }

        public void setUserAuth(String userAuth) {
            this.userAuth = userAuth;
        }
    }
}

