/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.wcm.sandbox.script;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.alfresco.model.ContentModel;
import org.alfresco.repo.avm.AVMNodeConverter;
import org.alfresco.repo.dictionary.DictionaryNamespaceComponent;
import org.alfresco.repo.security.authentication.AuthenticationUtil;
import org.alfresco.repo.transaction.RetryingTransactionHelper;
import org.alfresco.service.cmr.avm.AVMBadArgumentException;
import org.alfresco.service.cmr.avm.AVMNotFoundException;
import org.alfresco.service.cmr.dictionary.DataTypeDefinition;
import org.alfresco.service.cmr.dictionary.DictionaryService;
import org.alfresco.service.cmr.dictionary.PropertyDefinition;
import org.alfresco.service.cmr.dictionary.TypeDefinition;
import org.alfresco.service.cmr.repository.ContentData;
import org.alfresco.service.cmr.repository.ContentIOException;
import org.alfresco.service.cmr.repository.ContentReader;
import org.alfresco.service.cmr.repository.ContentService;
import org.alfresco.service.cmr.repository.ContentWriter;
import org.alfresco.service.cmr.repository.NodeRef;
import org.alfresco.service.cmr.repository.NodeService;
import org.alfresco.service.namespace.NamespaceException;
import org.alfresco.service.namespace.NamespacePrefixResolver;
import org.alfresco.service.namespace.NamespaceService;
import org.alfresco.service.namespace.QName;
import org.alfresco.wcm.asset.AssetInfo;
import org.alfresco.wcm.asset.AssetService;
import org.alfresco.wcm.sandbox.SandboxService;
import org.alfresco.wcm.sandbox.script.Sandbox;
import org.json.JSONException;
import org.json.JSONObject;
import org.springframework.extensions.surf.util.Content;
import org.springframework.extensions.surf.util.ISO8601DateFormat;

public class Asset
implements Serializable {
    private static final QName NAMESPACE_SERVICE = QName.createQName((String)"", (String)"namespaceService");
    private static final long serialVersionUID = -5759260478423750966L;
    private AssetInfo asset;
    private Sandbox sandbox;
    private Map<String, String> props;
    private Set<QName> updatedProperties = new HashSet<QName>();

    public Asset(Sandbox sandbox, AssetInfo asset) {
        this.sandbox = sandbox;
        this.asset = asset;
    }

    public String getCreator() {
        return this.asset.getCreator();
    }

    public Date getCreatedDate() {
        return this.asset.getCreatedDate();
    }

    public long getFileSize() {
        return this.asset.getFileSize();
    }

    public String getCreatedDateAsISO8601() {
        return ISO8601DateFormat.format((Date)this.getCreatedDate());
    }

    public String getModifier() {
        return this.asset.getModifier();
    }

    public Date getModifiedDate() {
        return this.asset.getModifiedDate();
    }

    public String getModifiedDateAsISO8601() {
        return ISO8601DateFormat.format((Date)this.getModifiedDate());
    }

    public Asset rename(String newName) {
        if (!newName.equals(this.asset.getName())) {
            AssetInfo newAsset;
            this.asset = newAsset = this.getAssetService().renameAsset(this.asset, newName);
        }
        return this;
    }

    public Asset move(String newPath) {
        if (!newPath.equals(this.asset.getPath())) {
            AssetInfo newAsset;
            this.asset = newAsset = this.getAssetService().moveAsset(this.asset, newPath);
        }
        return this;
    }

    public String getName() {
        return this.asset.getName();
    }

    public String getPath() {
        return this.asset.getPath();
    }

    public boolean isFile() {
        return this.asset.isFile();
    }

    public boolean isFolder() {
        return this.asset.isFolder();
    }

    public boolean isDeleted() {
        return this.asset.isDeleted();
    }

    public boolean isLocked() {
        return this.asset.isLocked();
    }

    public String lockOwner() {
        return this.asset.getLockOwner();
    }

    public int getVersion() {
        return this.asset.getSandboxVersion();
    }

    public Map<String, String> getProperties() {
        if (this.props == null) {
            HashMap<String, String> propsX = new HashMap<String, String>();
            this.props = propsX;
            NamespaceService ns = this.getNamespaceService();
            if (!this.asset.isDeleted()) {
                Map<QName, Serializable> intprops = this.getAssetService().getAssetProperties(this.asset);
                for (QName qname : intprops.keySet()) {
                    QName prefixQname = qname.getPrefixedQName((NamespacePrefixResolver)ns);
                    Serializable propValue = intprops.get(qname);
                    try {
                        propsX.put(prefixQname.toPrefixString(), null == propValue ? null : propValue.toString());
                    }
                    catch (NamespaceException ne) {
                        propsX.put(qname.toString(), propValue.toString());
                    }
                }
            }
        }
        return this.props;
    }

    public void save() {
        if (!this.updatedProperties.isEmpty() && null != this.props) {
            TypeDefinition typeDefinition;
            HashMap<QName, Serializable> newProps = new HashMap<QName, Serializable>(this.props.size());
            QName type = this.getAssetType();
            DictionaryService dictionaryService = this.getDictionaryService();
            TypeDefinition typeDefinition2 = typeDefinition = null != type ? dictionaryService.getType(type) : null;
            if (null != typeDefinition) {
                if (this.updatedProperties.contains(ContentModel.PROP_NAME)) {
                    this.updatedProperties.remove(ContentModel.PROP_NAME);
                    this.rename(this.getPropertyValue(ContentModel.PROP_NAME));
                }
                Map propertyDefinitions = typeDefinition.getProperties();
                for (QName key : this.updatedProperties) {
                    PropertyDefinition propertyDefinition = propertyDefinitions.containsKey(key) ? (PropertyDefinition)propertyDefinitions.get(key) : dictionaryService.getProperty(key);
                    Serializable value = this.convertValueToDataType(key, propertyDefinition.getDataType().getName(), this.getPropertyValue(key));
                    newProps.put(key, value);
                }
                this.getAssetService().setAssetProperties(this.asset, newProps);
                this.updatedProperties.clear();
            } else {
                throw new AVMNotFoundException("The type property of the current Asset not found");
            }
        }
    }

    private String getPropertyValue(QName key) {
        String prefixedQName = this.completeContentModelQName(key).toPrefixString();
        return this.props.containsKey(prefixedQName) ? this.props.get(prefixedQName) : this.props.get(key.toString());
    }

    private Serializable convertValueToDataType(QName propertyName, QName dataType, String textualValue) {
        Object result = null;
        if (null != textualValue) {
            try {
                if (DataTypeDefinition.BOOLEAN.equals((Object)dataType)) {
                    result = Boolean.parseBoolean(textualValue);
                } else if (DataTypeDefinition.DOUBLE.equals((Object)dataType)) {
                    result = Double.parseDouble(textualValue);
                } else if (DataTypeDefinition.FLOAT.equals((Object)dataType)) {
                    result = Float.valueOf(Float.parseFloat(textualValue));
                } else if (DataTypeDefinition.INT.equals((Object)dataType)) {
                    result = Integer.parseInt(textualValue);
                } else if (DataTypeDefinition.LONG.equals((Object)dataType)) {
                    result = Long.parseLong(textualValue);
                } else if (DataTypeDefinition.NODE_REF.equals((Object)dataType)) {
                    result = NodeRef.isNodeRef((String)textualValue) ? new NodeRef(textualValue) : null;
                } else if (DataTypeDefinition.QNAME.equals((Object)dataType)) {
                    result = QName.resolveToQName((NamespacePrefixResolver)this.getNamespaceService(), (String)textualValue);
                } else if (DataTypeDefinition.CONTENT.equals((Object)dataType)) {
                    result = ContentData.createContentProperty((String)textualValue);
                } else if (DataTypeDefinition.TEXT.equals((Object)dataType) || DataTypeDefinition.MLTEXT.equals((Object)dataType)) {
                    result = textualValue;
                }
            }
            catch (NumberFormatException e) {
                throw new AVMBadArgumentException("Value for the '" + propertyName + "' property is invalid! Conversion error: " + e.toString());
            }
        }
        return result;
    }

    public void setProperties(Object nativeProperties) throws JSONException {
        JSONObject properties = (JSONObject)nativeProperties;
        if (null != this.asset && !this.asset.isDeleted()) {
            TypeDefinition typeDefinition;
            Map<String, String> currentProperties = this.getProperties();
            if (null == currentProperties) {
                throw new AVMNotFoundException("No a property found for the current Asset");
            }
            QName type = this.getAssetType();
            DictionaryService dictionaryService = this.getDictionaryService();
            TypeDefinition typeDefinition2 = typeDefinition = null != type ? dictionaryService.getType(type) : null;
            if (null != typeDefinition) {
                Map propertyDefinitions = typeDefinition.getProperties();
                for (String key : JSONObject.getNames((JSONObject)properties)) {
                    PropertyDefinition property;
                    QName qName = QName.resolveToQName((NamespacePrefixResolver)this.getNamespaceService(), (String)key);
                    if (ContentModel.PROP_CONTENT.equals((Object)qName)) {
                        this.updatedProperties.clear();
                        throw new AVMBadArgumentException("The 'Content' property can't be set with the 'setProperties()' method! Use a 'writeContent()' instead");
                    }
                    PropertyDefinition propertyDefinition = property = propertyDefinitions.containsKey(qName) ? (PropertyDefinition)propertyDefinitions.get(qName) : dictionaryService.getProperty(qName);
                    if (null != property) {
                        if (property.isProtected() || property.isMultiValued()) {
                            this.updatedProperties.clear();
                            throw new AVMBadArgumentException("The '" + key + "' property is not updatable");
                        }
                    } else {
                        this.updatedProperties.clear();
                        throw new AVMNotFoundException("The '" + key + "' property definition can't be found");
                    }
                    Object associatedValue = properties.get(key);
                    qName = this.completeContentModelQName(qName);
                    currentProperties.put(qName.toPrefixString(), null != associatedValue ? associatedValue.toString() : null);
                    this.updatedProperties.add(property.getName());
                }
                this.props = currentProperties;
            }
        }
    }

    private QName completeContentModelQName(QName qName) {
        if (qName.getLocalName().equals(qName.getPrefixString()) && "http://www.alfresco.org/model/content/1.0".equals(qName.getNamespaceURI())) {
            DictionaryNamespaceComponent service = (DictionaryNamespaceComponent)this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getService(NAMESPACE_SERVICE);
            return QName.createQName((String)"cm", (String)qName.getLocalName(), (NamespacePrefixResolver)service);
        }
        return qName;
    }

    private QName getAssetType() {
        final NodeRef assetNodeRef = AVMNodeConverter.ToNodeRef(this.asset.getSandboxVersion(), this.asset.getAvmPath());
        final NodeService nodeService = this.getNodeService();
        return (QName)AuthenticationUtil.runAs((AuthenticationUtil.RunAsWork)new AuthenticationUtil.RunAsWork<QName>(){

            public QName doWork() throws Exception {
                RetryingTransactionHelper helper = Asset.this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getTransactionService().getRetryingTransactionHelper();
                return helper.doInTransaction(new RetryingTransactionHelper.RetryingTransactionCallback<QName>(){

                    @Override
                    public QName execute() throws Throwable {
                        return nodeService.getType(assetNodeRef);
                    }
                });
            }
        }, (String)AuthenticationUtil.getFullyAuthenticatedUser());
    }

    public boolean writeContent(String content) {
        NodeRef assetNodeRef = AVMNodeConverter.ToNodeRef(this.asset.getSandboxVersion(), this.asset.getAvmPath());
        ContentService contentService = this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getContentService();
        ContentWriter writer = contentService.getWriter(assetNodeRef, ContentModel.PROP_CONTENT, true);
        if (null != writer && null != content) {
            writer.setMimetype("text/plain");
            writer.setEncoding("UTF-8");
            writer.putContent(content);
            return true;
        }
        return false;
    }

    public boolean writeContent(Content content) {
        NodeRef assetNodeRef = AVMNodeConverter.ToNodeRef(this.asset.getSandboxVersion(), this.asset.getAvmPath());
        ContentService contentService = this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getContentService();
        ContentWriter writer = contentService.getWriter(assetNodeRef, ContentModel.PROP_CONTENT, true);
        if (null != writer && null != content) {
            writer.setMimetype(content.getMimetype());
            writer.setEncoding(content.getEncoding());
            writer.putContent(content.getInputStream());
            return true;
        }
        return false;
    }

    public String getContent() throws ContentIOException, IOException {
        NodeRef assetNodeRef = AVMNodeConverter.ToNodeRef(this.asset.getSandboxVersion(), this.asset.getAvmPath());
        ContentService contentService = this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getContentService();
        ContentReader reader = contentService.getReader(assetNodeRef, ContentModel.PROP_CONTENT);
        return null != reader ? reader.getContentString() : null;
    }

    public void submit(String submitLabel, String submitComment) {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(this.getPath());
        this.getSandboxService().submitList(this.getSandbox().getSandboxRef(), items, submitLabel, submitComment);
    }

    public void deleteAsset() {
        this.getAssetService().deleteAsset(this.asset);
    }

    public void revert() {
        ArrayList<String> items = new ArrayList<String>(1);
        items.add(this.getPath());
        this.getSandboxService().revertList(this.getSandbox().getSandboxRef(), items);
    }

    public Asset[] getChildren() {
        Asset[] ret = new Asset[]{};
        if (this.asset.isFolder()) {
            int i = 0;
            List<AssetInfo> assets = this.getAssetService().listAssets(this.getSandbox().getSandboxRef(), this.asset.getPath(), true);
            ret = new Asset[assets.size()];
            for (AssetInfo asset : assets) {
                ret[i++] = new Asset(this.sandbox, asset);
            }
        }
        return ret;
    }

    public void createFile(String name, String stringContent) {
        ContentWriter writer = this.getAssetService().createFile(this.getSandbox().getSandboxRef(), this.asset.getPath(), name, null);
        if (stringContent != null) {
            writer.putContent(stringContent);
        }
    }

    public void createFolder(String name) {
        this.getAssetService().createFolder(this.getSandbox().getSandboxRef(), this.asset.getPath(), name, null);
    }

    public Sandbox getSandbox() {
        return this.sandbox;
    }

    private SandboxService getSandboxService() {
        return this.getSandbox().getWebproject().getWebProjects().getSandboxService();
    }

    private AssetService getAssetService() {
        return this.getSandbox().getWebproject().getWebProjects().getAssetService();
    }

    private NamespaceService getNamespaceService() {
        return this.getSandbox().getWebproject().getWebProjects().getNamespaceService();
    }

    private NodeService getNodeService() {
        return this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getNodeService();
    }

    private DictionaryService getDictionaryService() {
        return this.getSandbox().getWebproject().getWebProjects().getServiceRegistry().getDictionaryService();
    }
}

