/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.config;

import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.util.Enumeration;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.util.DefaultPropertiesPersister;
import org.springframework.util.StringUtils;

public class AlfrescoPropertiesPersister
extends DefaultPropertiesPersister {
    private static Log logger = LogFactory.getLog(AlfrescoPropertiesPersister.class);

    public void load(Properties props, InputStream is) throws IOException {
        super.load(props, is);
        this.strip(props);
    }

    public void load(Properties props, Reader reader) throws IOException {
        super.load(props, reader);
        this.strip(props);
    }

    public void loadFromXml(Properties props, InputStream is) throws IOException {
        super.loadFromXml(props, is);
        this.strip(props);
    }

    private void strip(Properties props) {
        Enumeration<Object> keys = props.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            String val = StringUtils.trimTrailingWhitespace((String)props.getProperty(key));
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Trimmed trailing whitespace for property " + key + " = " + val));
            }
            props.setProperty(key, val);
        }
    }
}

