/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.config;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SystemPropertiesSetterBean {
    private static Log logger = LogFactory.getLog(SystemPropertiesSetterBean.class);
    private Map<String, String> propertyMap = new HashMap<String, String>(3);

    SystemPropertiesSetterBean() {
    }

    public void setPropertyMap(Map<String, String> propertyMap) {
        this.propertyMap = propertyMap;
    }

    public void init() {
        for (Map.Entry<String, String> entry : this.propertyMap.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            if (value == null || value.length() == 0 || value.startsWith("${") && value.endsWith("}")) continue;
            if (System.getProperty(name) != null) {
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("\nNot pushing up system property: \n   Property:              " + name + "\n" + "   Value already present: " + System.getProperty(name) + "\n" + "   Value provided:        " + value));
                continue;
            }
            System.setProperty(name, value);
        }
    }
}

