/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.hibernate;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.hibernate.HibernateException;
import org.hibernate.dialect.Dialect;
import org.hibernate.util.ReflectHelper;

public class DialectFactory {
    private static final Map<String, VersionInsensitiveMapper> MAPPERS = new HashMap<String, VersionInsensitiveMapper>();

    public static Dialect buildDialect(Properties props, String databaseName, int databaseMajorVersion) throws HibernateException {
        String dialectName = props.getProperty("hibernate.dialect");
        if (dialectName == null || dialectName.length() == 0) {
            return DialectFactory.determineDialect(databaseName, databaseMajorVersion);
        }
        System.setProperty("hibernate.dialect", dialectName);
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect determineDialect(String databaseName, int databaseMajorVersion) {
        if (databaseName == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set");
        }
        DatabaseDialectMapper mapper = MAPPERS.get(databaseName);
        if (mapper == null) {
            throw new HibernateException("Hibernate Dialect must be explicitly set for database: " + databaseName);
        }
        String dialectName = mapper.getDialectClass(databaseMajorVersion);
        System.setProperty("hibernate.dialect", dialectName);
        return DialectFactory.buildDialect(dialectName);
    }

    public static Dialect buildDialect(String dialectName) {
        try {
            return (Dialect)ReflectHelper.classForName((String)dialectName).newInstance();
        }
        catch (ClassNotFoundException cnfe) {
            throw new HibernateException("Dialect class not found: " + dialectName);
        }
        catch (Exception e) {
            throw new HibernateException("Could not instantiate dialect class", (Throwable)e);
        }
    }

    static {
        MAPPERS.put("HSQL Database Engine", new VersionInsensitiveMapper("org.hibernate.dialect.HSQLDialect"));
        MAPPERS.put("H2", new VersionInsensitiveMapper("org.hibernate.dialect.H2Dialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.hibernate.dialect.MySQLDialect"));
        MAPPERS.put("PostgreSQL", new VersionInsensitiveMapper("org.hibernate.dialect.PostgreSQLDialect"));
        MAPPERS.put("Apache Derby", new VersionInsensitiveMapper("org.hibernate.dialect.DerbyDialect"));
        MAPPERS.put("Ingres", new VersionInsensitiveMapper("org.hibernate.dialect.IngresDialect"));
        MAPPERS.put("ingres", new VersionInsensitiveMapper("org.hibernate.dialect.IngresDialect"));
        MAPPERS.put("INGRES", new VersionInsensitiveMapper("org.hibernate.dialect.IngresDialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SQLServerDialect"));
        MAPPERS.put("Sybase SQL Server", new VersionInsensitiveMapper("org.hibernate.dialect.SybaseDialect"));
        MAPPERS.put("Adaptive Server Enterprise", new VersionInsensitiveMapper("org.hibernate.dialect.SybaseDialect"));
        MAPPERS.put("Informix Dynamic Server", new VersionInsensitiveMapper("org.hibernate.dialect.InformixDialect"));
        MAPPERS.put("DB2/NT", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/6000", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/HPUX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/SUN", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUX390", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/AIX64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/NT", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/NT64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2 UDP", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUX390", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUXZ64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/400 SQL", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/6000", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2 UDB iSeries", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/AIX64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/HPUX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/HP64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/SUN", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/SUN64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/PTX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/2", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUXX8664", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("MySQL", new VersionInsensitiveMapper("org.hibernate.dialect.MySQLInnoDBDialect"));
        MAPPERS.put("DB2/NT64", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("DB2/LINUX", new VersionInsensitiveMapper("org.hibernate.dialect.DB2Dialect"));
        MAPPERS.put("Microsoft SQL Server Database", new VersionInsensitiveMapper("org.alfresco.repo.domain.hibernate.dialect.AlfrescoSQLServerDialect"));
        MAPPERS.put("Microsoft SQL Server", new VersionInsensitiveMapper("org.alfresco.repo.domain.hibernate.dialect.AlfrescoSQLServerDialect"));
        MAPPERS.put("Sybase SQL Server", new VersionInsensitiveMapper("org.alfresco.repo.domain.hibernate.dialect.AlfrescoSybaseAnywhereDialect"));
        MAPPERS.put("Oracle", new VersionInsensitiveMapper("org.alfresco.repo.domain.hibernate.dialect.AlfrescoOracle9Dialect"));
    }

    public static class VersionInsensitiveMapper
    implements DatabaseDialectMapper {
        private String dialectClassName;

        public VersionInsensitiveMapper(String dialectClassName) {
            this.dialectClassName = dialectClassName;
        }

        @Override
        public String getDialectClass(int majorVersion) {
            return this.dialectClassName;
        }
    }

    public static interface DatabaseDialectMapper {
        public String getDialectClass(int var1);
    }
}

