/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.httpclient;

import java.io.IOException;
import java.util.Map;
import org.alfresco.error.AlfrescoRuntimeException;
import org.alfresco.httpclient.AlfrescoHttpClient;
import org.alfresco.httpclient.AuthenticationException;
import org.alfresco.httpclient.Request;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.URI;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractHttpClient
implements AlfrescoHttpClient {
    private static final Log logger = LogFactory.getLog(AlfrescoHttpClient.class);
    public static final String ALFRESCO_DEFAULT_BASE_URL = "/alfresco";
    public static final int DEFAULT_SAVEPOST_BUFFER = 4096;
    protected HttpClient httpClient = null;
    private String baseUrl = "/alfresco";

    public AbstractHttpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
    }

    protected HttpClient getHttpClient() {
        return this.httpClient;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }

    @Override
    public void setBaseUrl(String baseUrl) {
        this.baseUrl = baseUrl;
    }

    private boolean isRedirect(HttpMethod method) {
        switch (method.getStatusCode()) {
            case 301: 
            case 302: 
            case 303: 
            case 307: {
                return method.getFollowRedirects();
            }
        }
        return false;
    }

    protected HttpMethod sendRemoteRequest(Request req) throws AuthenticationException, IOException {
        Header locationHeader;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"");
            logger.debug((Object)("* Request: " + req.getMethod() + " " + req.getFullUri() + (req.getBody() == null ? "" : "\n" + new String(req.getBody(), "UTF-8"))));
        }
        HttpMethod method = this.createMethod(req);
        this.executeMethod(method);
        if (this.isRedirect(method) && (locationHeader = method.getResponseHeader("location")) != null) {
            String redirectLocation = locationHeader.getValue();
            method.setURI(new URI(redirectLocation, true));
            this.httpClient.executeMethod(method);
        }
        return method;
    }

    protected long executeMethod(HttpMethod method) throws HttpException, IOException {
        long startTime = System.currentTimeMillis();
        this.getHttpClient().executeMethod(method);
        return System.currentTimeMillis() - startTime;
    }

    protected HttpMethod createMethod(Request req) throws IOException {
        StringBuilder url = new StringBuilder();
        url.append(this.baseUrl);
        url.append("/service/");
        url.append(req.getFullUri());
        GetMethod httpMethod = null;
        String method = req.getMethod();
        if (method.equalsIgnoreCase("GET")) {
            GetMethod get;
            httpMethod = get = new GetMethod(url.toString());
            httpMethod.setFollowRedirects(true);
        } else if (method.equalsIgnoreCase("POST")) {
            PostMethod post = new PostMethod(url.toString());
            httpMethod = post;
            ByteArrayRequestEntity requestEntity = new ByteArrayRequestEntity(req.getBody(), req.getType());
            if (req.getBody().length > 4096) {
                post.getParams().setBooleanParameter("http.protocol.expect-continue", true);
            }
            post.setRequestEntity((RequestEntity)requestEntity);
        } else if (method.equalsIgnoreCase("HEAD")) {
            HeadMethod head = new HeadMethod(url.toString());
            httpMethod = head;
            httpMethod.setFollowRedirects(true);
        } else {
            throw new AlfrescoRuntimeException("Http Method " + method + " not supported");
        }
        if (req.getHeaders() != null) {
            for (Map.Entry<String, String> header : req.getHeaders().entrySet()) {
                httpMethod.setRequestHeader(header.getKey(), header.getValue());
            }
        }
        return httpMethod;
    }

    @Override
    public void close() {
        HttpConnectionManager connectionManager;
        if (this.httpClient != null && (connectionManager = this.httpClient.getHttpConnectionManager()) instanceof MultiThreadedHttpConnectionManager) {
            ((MultiThreadedHttpConnectionManager)connectionManager).shutdown();
        }
    }
}

