/*
 * Decompiled with CFR 0.152.
 */
package org.alfresco.deployment.util;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.SortedSet;
import org.alfresco.deployment.FileDescriptor;
import org.alfresco.deployment.impl.DeploymentException;
import org.alfresco.deployment.impl.server.DirectoryMetaData;

public class MetaTool {
    public static void main(String[] args) {
        try {
            if (args.length != 1) {
                System.out.println("Usage: MetaTool filename");
            }
            DirectoryMetaData meta = MetaTool.getDirectory(args[0]);
            SortedSet<FileDescriptor> metaList = meta.getListing();
            for (FileDescriptor file : metaList) {
                System.out.println("fileDescriptor : " + file);
            }
        }
        catch (Exception e) {
            System.out.println(e);
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static DirectoryMetaData getDirectory(String path) {
        DirectoryMetaData directoryMetaData;
        ObjectInputStream in = new ObjectInputStream(new FileInputStream(path));
        try {
            DirectoryMetaData md;
            directoryMetaData = md = (DirectoryMetaData)in.readObject();
        }
        catch (Throwable throwable) {
            try {
                in.close();
                throw throwable;
            }
            catch (IOException ioe) {
                throw new DeploymentException("Could not read metadata file " + path, ioe);
            }
            catch (ClassNotFoundException nfe) {
                throw new DeploymentException("Configuration error: could not instantiate DirectoryMetaData.");
            }
        }
        in.close();
        return directoryMetaData;
    }
}

