/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.extensions.config.source;

import java.io.IOException;
import java.io.InputStream;
import java.net.JarURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.io.Resource;
import org.springframework.extensions.config.ConfigException;
import org.springframework.extensions.config.source.BaseConfigSource;
import org.springframework.extensions.config.source.ClassPathConfigSource;
import org.springframework.extensions.config.source.FileConfigSource;
import org.springframework.extensions.config.source.HTTPConfigSource;
import org.springframework.extensions.config.source.JarConfigSource;
import org.springframework.util.ResourceUtils;
import org.springframework.web.context.ServletContextAware;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UrlConfigSource
extends BaseConfigSource
implements ServletContextAware,
ApplicationContextAware,
InitializingBean {
    public static final String PREFIX_JAR = "jar:";
    public static final String PREFIX_FILE = "file:";
    public static final String PREFIX_HTTP = "http:";
    public static final String PREFIX_CLASSPATH = "classpath:";
    public static final String PREFIX_CLASSPATH_ALL = "classpath*:";
    public static final String PREFIX_WEBAPP = "webapp:";
    private static final String WILDCARD = "*";
    private static final String META_INF = "META-INF";
    private static final String VFSJAR_URL_SEPARATOR = ".jar/";
    private static final Log logger = LogFactory.getLog(UrlConfigSource.class);
    private ServletContext servletContext;
    private ApplicationContext applicationContext;
    private List<String> sourceLocations = new ArrayList<String>();

    public void setServletContext(ServletContext servletContext) {
        this.servletContext = servletContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void afterPropertiesSet() throws Exception {
        for (String location : this.sourceLocations) {
            this.processSourceString(location);
        }
    }

    public UrlConfigSource(String sourceLocation) {
        this(sourceLocation, false);
    }

    public UrlConfigSource(String sourceLocation, boolean init) {
        if (init) {
            this.processSourceString(sourceLocation);
        } else {
            this.sourceLocations.add(sourceLocation);
        }
    }

    public UrlConfigSource(List<String> sourceLocations) {
        this(sourceLocations, false);
    }

    public UrlConfigSource(List<String> sourceLocations, boolean init) {
        if (init) {
            for (String location : sourceLocations) {
                this.processSourceString(location);
            }
        } else {
            this.sourceLocations.addAll(sourceLocations);
        }
    }

    @Override
    public InputStream getInputStream(String sourceUrl) {
        InputStream inputStream = null;
        BaseConfigSource configSource = null;
        String sourceString = null;
        if (sourceUrl.startsWith(PREFIX_FILE)) {
            sourceString = sourceUrl.substring(5);
            configSource = new FileConfigSource(sourceString);
        } else if (sourceUrl.startsWith(PREFIX_HTTP)) {
            sourceString = sourceUrl;
            configSource = new HTTPConfigSource(sourceString);
        } else if (sourceUrl.startsWith(PREFIX_CLASSPATH)) {
            sourceString = sourceUrl.substring(10);
            configSource = new ClassPathConfigSource(sourceString);
        } else if (sourceUrl.startsWith(PREFIX_JAR)) {
            sourceString = sourceUrl;
            configSource = new JarConfigSource(sourceString);
        } else if (sourceUrl.startsWith(PREFIX_WEBAPP)) {
            if (this.servletContext != null) {
                sourceString = sourceUrl.substring(PREFIX_WEBAPP.length());
                if (!sourceString.startsWith("/")) {
                    sourceString = "/" + sourceString;
                }
                try {
                    if (this.servletContext.getResource(sourceString) != null && (sourceString = this.servletContext.getRealPath(sourceString)) != null) {
                        configSource = new FileConfigSource(sourceString);
                    }
                }
                catch (Exception ex) {
                    if (logger.isInfoEnabled()) {
                        logger.info((Object)("Unable to locate web application resource: " + sourceString));
                    }
                }
            }
        } else {
            if (sourceUrl.indexOf(58) > -1) {
                throw new ConfigException("Config source cannot be determined: " + sourceUrl);
            }
            sourceString = sourceUrl;
            configSource = new ClassPathConfigSource(sourceString);
        }
        if (sourceString != null && configSource != null) {
            inputStream = configSource.getInputStream(sourceString);
        }
        return inputStream;
    }

    protected void processSourceString(String sourceString) {
        if (sourceString != null && sourceString.startsWith(PREFIX_JAR) && sourceString.indexOf("*!/") != -1) {
            this.processWildcardJarSource(sourceString);
        } else {
            super.addSourceString(sourceString);
        }
    }

    protected void processWildcardJarSource(String sourcePattern) {
        block9: {
            String file = sourcePattern.substring(7);
            if (!file.startsWith(META_INF)) {
                throw new UnsupportedOperationException("Only JAR file wildcard searches within the META-INF folder are currently supported");
            }
            try {
                if (this.applicationContext == null) {
                    Enumeration<URL> urls = this.getClass().getClassLoader().getResources(META_INF);
                    while (urls.hasMoreElements()) {
                        URLConnection conn;
                        URL url = urls.nextElement();
                        if (!url.getProtocol().equals("jar") || !((conn = url.openConnection()) instanceof JarURLConnection)) continue;
                        JarURLConnection jarConn = (JarURLConnection)conn;
                        JarFile jar = ((JarURLConnection)conn).getJarFile();
                        ZipEntry entry = jar.getEntry(file);
                        if (entry != null) {
                            if (logger.isInfoEnabled()) {
                                logger.info((Object)("Found " + file + " in " + jarConn.getJarFileURL()));
                            }
                            String sourceString = PREFIX_JAR + jarConn.getJarFileURL().toExternalForm() + "!/" + file;
                            super.addSourceString(sourceString);
                            continue;
                        }
                        if (!logger.isDebugEnabled()) continue;
                        logger.debug((Object)("Did not find " + file + " in " + jarConn.getJarFileURL()));
                    }
                } else {
                    Resource[] resources;
                    for (Resource resource : resources = this.applicationContext.getResources(PREFIX_CLASSPATH_ALL + file)) {
                        URL resourceUrl = resource.getURL();
                        if (!ResourceUtils.isJarURL((URL)resourceUrl) && !"vfszip".equals(resourceUrl.getProtocol())) continue;
                        URL jarURL = this.extractJarFileURL(resourceUrl);
                        String sourceString = PREFIX_JAR + jarURL.toString() + "!/" + file;
                        super.addSourceString(sourceString);
                    }
                }
            }
            catch (IOException ioe) {
                if (!logger.isDebugEnabled()) break block9;
                logger.debug((Object)("Failed to process JAR file wildcard: " + sourcePattern), (Throwable)ioe);
            }
        }
    }

    private URL extractJarFileURL(URL jarUrl) {
        String urlFile = jarUrl.getFile();
        int separatorIndex = urlFile.indexOf("!/");
        if (separatorIndex == -1 && (separatorIndex = (urlFile = jarUrl.toString()).indexOf(VFSJAR_URL_SEPARATOR)) != -1) {
            separatorIndex += 4;
        }
        if (separatorIndex != -1) {
            String jarFile = urlFile.substring(0, separatorIndex);
            try {
                return new URL(jarFile);
            }
            catch (MalformedURLException ex) {
                return jarUrl;
            }
        }
        return jarUrl;
    }
}

