/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11NioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SecureNioChannel;
import org.apache.tomcat.util.net.SocketStatus;

public class Http11NioProtocol
extends AbstractHttp11JsseProtocol {
    private static final Log log = LogFactory.getLog(Http11NioProtocol.class);
    private int socketCloseDelay = -1;
    private Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11NioProtocol() {
        this.endpoint = new NioEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public NioEndpoint getEndpoint() {
        return (NioEndpoint)this.endpoint;
    }

    public void setPollerThreadCount(int count) {
        ((NioEndpoint)this.endpoint).setPollerThreadCount(count);
    }

    public int getPollerThreadCount() {
        return ((NioEndpoint)this.endpoint).getPollerThreadCount();
    }

    public void setSelectorTimeout(long timeout) {
        ((NioEndpoint)this.endpoint).setSelectorTimeout(timeout);
    }

    public long getSelectorTimeout() {
        return ((NioEndpoint)this.endpoint).getSelectorTimeout();
    }

    public void setAcceptorThreadPriority(int threadPriority) {
        ((NioEndpoint)this.endpoint).setAcceptorThreadPriority(threadPriority);
    }

    public void setPollerThreadPriority(int threadPriority) {
        ((NioEndpoint)this.endpoint).setPollerThreadPriority(threadPriority);
    }

    public int getAcceptorThreadPriority() {
        return ((NioEndpoint)this.endpoint).getAcceptorThreadPriority();
    }

    public int getPollerThreadPriority() {
        return ((NioEndpoint)this.endpoint).getThreadPriority();
    }

    public boolean getUseSendfile() {
        return ((NioEndpoint)this.endpoint).getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((NioEndpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public int getSocketCloseDelay() {
        return this.socketCloseDelay;
    }

    public void setSocketCloseDelay(int d) {
        this.socketCloseDelay = d;
    }

    public void setOomParachute(int oomParachute) {
        ((NioEndpoint)this.endpoint).setOomParachute(oomParachute);
    }

    @Override
    protected String getNamePrefix() {
        return "http-nio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler
    implements NioEndpoint.Handler {
        protected Http11NioProtocol proto;
        protected ConcurrentHashMap<NioChannel, Http11NioProcessor> connections = new ConcurrentHashMap();
        protected AbstractProtocol.RecycledProcessors<Http11NioProcessor> recycledProcessors = new AbstractProtocol.RecycledProcessors(this);

        Http11ConnectionHandler(Http11NioProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public void release(SocketChannel socket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Iterating through our connections to release a socket channel:" + socket));
            }
            boolean released = false;
            Iterator<Map.Entry<NioChannel, Http11NioProcessor>> it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<NioChannel, Http11NioProcessor> entry = it.next();
                if (entry.getKey().getIOChannel() != socket) continue;
                it.remove();
                Http11NioProcessor result = entry.getValue();
                result.recycle();
                this.unregister(result);
                released = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done iterating through our connections to release a socket channel:" + socket + " released:" + released));
            }
        }

        @Override
        public void release(NioChannel socket) {
            Http11NioProcessor processor = this.connections.remove(socket);
            if (processor != null) {
                processor.recycle();
                this.recycledProcessors.offer(processor);
            }
        }

        public void release(NioChannel socket, Http11NioProcessor processor) {
            this.connections.remove(socket);
            processor.recycle();
            this.recycledProcessors.offer(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState event(NioChannel socket, SocketStatus status) {
            Http11NioProcessor processor = this.connections.get(socket);
            NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
            att.setAsync(false);
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (processor != null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Http11NioProcessor.error=" + processor.error));
                }
                try {
                    state = processor.comet ? processor.event(status) : processor.asyncDispatch(status);
                }
                catch (SocketException e) {
                    log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
                }
                catch (IOException e) {
                    log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    log.error((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.error"), e);
                }
                finally {
                    if (processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN || state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.release(socket, processor);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            socket.getPoller().add(socket);
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        if (processor.isAsync()) {
                            att.setAsync(true);
                        } else {
                            if (log.isDebugEnabled()) {
                                log.debug((Object)("Keeping processor[" + processor));
                            }
                            SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
                            key.interestOps(1);
                            att.interestOps(1);
                        }
                    }
                }
            }
            return state;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(NioChannel socket) {
            Http11NioProcessor processor = this.connections.remove(socket);
            try {
                if (processor == null) {
                    processor = (Http11NioProcessor)this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null && socket instanceof SecureNioChannel) {
                    SecureNioChannel ch = (SecureNioChannel)socket;
                    processor.setSslSupport(this.proto.sslImplementation.getSSLSupport(ch.getSslEngine().getSession()));
                } else {
                    processor.setSslSupport(null);
                }
                AbstractEndpoint.Handler.SocketState state = processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    if (processor.isAsync()) {
                        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
                        att.setAsync(true);
                        state = processor.asyncPostProcess();
                    } else {
                        SelectionKey key = socket.getIOChannel().keyFor(socket.getPoller().getSelector());
                        NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
                        key.interestOps(1);
                        att.interestOps(1);
                    }
                }
                if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        this.release(socket, processor);
                        socket.getPoller().add(socket);
                    } else {
                        this.release(socket, processor);
                    }
                }
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.error"), e);
            }
            this.release(socket, processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        public Http11NioProcessor createProcessor() {
            Http11NioProcessor processor = new Http11NioProcessor(this.proto.getMaxHttpHeaderSize(), (NioEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            this.register(processor);
            return processor;
        }
    }
}

