/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import java.net.Socket;
import java.net.SocketException;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.http11.AbstractHttp11JsseProtocol;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11Processor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.JIoEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11Protocol
extends AbstractHttp11JsseProtocol {
    private static final Log log = LogFactory.getLog(Http11Protocol.class);
    protected Http11ConnectionHandler cHandler;
    private int disableKeepAlivePercentage = 75;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public Http11Protocol() {
        this.endpoint = new JIoEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((JIoEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public int getDisableKeepAlivePercentage() {
        return this.disableKeepAlivePercentage;
    }

    public void setDisableKeepAlivePercentage(int disableKeepAlivePercentage) {
        this.disableKeepAlivePercentage = disableKeepAlivePercentage < 0 ? 0 : (disableKeepAlivePercentage > 100 ? 100 : disableKeepAlivePercentage);
    }

    @Override
    protected String getNamePrefix() {
        return "http-bio";
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler
    implements JIoEndpoint.Handler {
        protected Http11Protocol proto;
        protected ConcurrentHashMap<SocketWrapper<Socket>, Http11Processor> connections = new ConcurrentHashMap();
        protected AbstractProtocol.RecycledProcessors<Http11Processor> recycledProcessors = new AbstractProtocol.RecycledProcessors(this);

        Http11ConnectionHandler(Http11Protocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return this.proto.sslImplementation;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket) {
            return this.process(socket, SocketStatus.OPEN);
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Socket> socket, SocketStatus status) {
            Http11Processor processor = this.connections.remove(socket);
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = (Http11Processor)this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if (this.proto.isSSLEnabled() && this.proto.sslImplementation != null) {
                    processor.setSSLSupport(this.proto.sslImplementation.getSSLSupport(socket.getSocket()));
                } else {
                    processor.setSSLSupport(null);
                }
                AbstractEndpoint.Handler.SocketState socketState = state = socket.isAsync() ? processor.asyncDispatch(status) : processor.process(socket);
                if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    socket.setAsync(true);
                    return processor.asyncPostProcess();
                }
                socket.setAsync(false);
                processor.recycle();
                this.recycledProcessors.offer(processor);
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error((Object)AbstractHttp11Protocol.sm.getString("http11protocol.proto.error"), e);
            }
            processor.recycle();
            this.recycledProcessors.offer(processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected Http11Processor createProcessor() {
            Http11Processor processor = new Http11Processor(this.proto.getMaxHttpHeaderSize(), (JIoEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize());
            processor.setAdapter(this.proto.adapter);
            processor.setMaxKeepAliveRequests(this.proto.getMaxKeepAliveRequests());
            processor.setKeepAliveTimeout(this.proto.getKeepAliveTimeout());
            processor.setConnectionUploadTimeout(this.proto.getConnectionUploadTimeout());
            processor.setDisableUploadTimeout(this.proto.getDisableUploadTimeout());
            processor.setCompressionMinSize(this.proto.getCompressionMinSize());
            processor.setCompression(this.proto.getCompression());
            processor.setNoCompressionUserAgents(this.proto.getNoCompressionUserAgents());
            processor.setCompressableMimeTypes(this.proto.getCompressableMimeTypes());
            processor.setRestrictedUserAgents(this.proto.getRestrictedUserAgents());
            processor.setSocketBuffer(this.proto.getSocketBuffer());
            processor.setMaxSavePostSize(this.proto.getMaxSavePostSize());
            processor.setServer(this.proto.getServer());
            processor.setDisableKeepAlivePercentage(this.proto.getDisableKeepAlivePercentage());
            this.register(processor);
            return processor;
        }
    }
}

