/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.ajp;

import java.io.IOException;
import java.net.SocketException;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.ajp.AbstractAjpProtocol;
import org.apache.coyote.ajp.AjpNioProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.ExceptionUtils;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.NioChannel;
import org.apache.tomcat.util.net.NioEndpoint;
import org.apache.tomcat.util.net.SSLImplementation;
import org.apache.tomcat.util.net.SocketStatus;

public class AjpNioProtocol
extends AbstractAjpProtocol {
    private static final Log log = LogFactory.getLog(AjpNioProtocol.class);
    private AjpConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    public AjpNioProtocol() {
        this.endpoint = new NioEndpoint();
        this.cHandler = new AjpConnectionHandler(this);
        ((NioEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(-1);
        this.setTcpNoDelay(true);
        ((NioEndpoint)this.endpoint).setUseSendfile(false);
    }

    @Override
    protected String getNamePrefix() {
        return "ajp-nio";
    }

    protected static class AjpConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler
    implements NioEndpoint.Handler {
        protected AjpNioProtocol proto;
        protected ConcurrentHashMap<NioChannel, AjpNioProcessor> connections = new ConcurrentHashMap();
        protected AbstractProtocol.RecycledProcessors<AjpNioProcessor> recycledProcessors = new AbstractProtocol.RecycledProcessors(this);

        public AjpConnectionHandler(AjpNioProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void recycle() {
            this.recycledProcessors.clear();
        }

        @Override
        public SSLImplementation getSslImplementation() {
            return null;
        }

        @Override
        public void release(SocketChannel socket) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Iterating through our connections to release a socket channel:" + socket));
            }
            boolean released = false;
            Iterator<Map.Entry<NioChannel, AjpNioProcessor>> it = this.connections.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<NioChannel, AjpNioProcessor> entry = it.next();
                if (entry.getKey().getIOChannel() != socket) continue;
                it.remove();
                AjpNioProcessor result = entry.getValue();
                result.recycle();
                this.unregister(result);
                released = true;
                break;
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Done iterating through our connections to release a socket channel:" + socket + " released:" + released));
            }
        }

        @Override
        public void release(NioChannel socket) {
            AjpNioProcessor processor = this.connections.remove(socket);
            if (processor != null) {
                processor.recycle();
                this.recycledProcessors.offer(processor);
            }
        }

        public void release(NioChannel socket, AjpNioProcessor processor) {
            this.connections.remove(socket);
            processor.recycle();
            this.recycledProcessors.offer(processor);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public AbstractEndpoint.Handler.SocketState event(NioChannel socket, SocketStatus status) {
            AjpNioProcessor processor = this.connections.get(socket);
            NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
            att.setAsync(false);
            AbstractEndpoint.Handler.SocketState state = AbstractEndpoint.Handler.SocketState.CLOSED;
            if (processor != null) {
                try {
                    state = processor.asyncDispatch(status);
                }
                catch (Throwable e) {
                    ExceptionUtils.handleThrowable(e);
                    log.error((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
                }
                finally {
                    if (processor.isAsync()) {
                        state = processor.asyncPostProcess();
                    }
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN || state == AbstractEndpoint.Handler.SocketState.CLOSED) {
                        this.release(socket, processor);
                        if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                            socket.getPoller().add(socket);
                        }
                    } else if (state == AbstractEndpoint.Handler.SocketState.LONG) {
                        att.setAsync(true);
                    }
                }
            }
            return state;
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(NioChannel socket) {
            AjpNioProcessor processor = this.connections.remove(socket);
            try {
                AbstractEndpoint.Handler.SocketState state;
                if (processor == null) {
                    processor = (AjpNioProcessor)this.recycledProcessors.poll();
                }
                if (processor == null) {
                    processor = this.createProcessor();
                }
                if ((state = processor.process(socket)) == AbstractEndpoint.Handler.SocketState.LONG) {
                    this.connections.put(socket, processor);
                    NioEndpoint.KeyAttachment att = (NioEndpoint.KeyAttachment)socket.getAttachment(false);
                    att.setAsync(true);
                    state = processor.asyncPostProcess();
                }
                if (state != AbstractEndpoint.Handler.SocketState.LONG && state != AbstractEndpoint.Handler.SocketState.ASYNC_END) {
                    if (state == AbstractEndpoint.Handler.SocketState.OPEN) {
                        this.release(socket, processor);
                        socket.getPoller().add(socket);
                    } else {
                        this.release(socket, processor);
                    }
                }
                return state;
            }
            catch (SocketException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.socketexception.debug"), (Throwable)e);
            }
            catch (IOException e) {
                log.debug((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.ioexception.debug"), (Throwable)e);
            }
            catch (Throwable e) {
                ExceptionUtils.handleThrowable(e);
                log.error((Object)AbstractAjpProtocol.sm.getString("ajpprotocol.proto.error"), e);
            }
            this.release(socket, processor);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }

        protected AjpNioProcessor createProcessor() {
            AjpNioProcessor processor = new AjpNioProcessor(this.proto.packetSize, (NioEndpoint)this.proto.endpoint);
            processor.setAdapter(this.proto.adapter);
            processor.setTomcatAuthentication(this.proto.tomcatAuthentication);
            processor.setRequiredSecret(this.proto.requiredSecret);
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }
    }
}

